 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane create
   >>>> 
   >>>>  Private: 
   >>>> 	create_action_button
   >>>> 	create_routine_button
   >>>> 	create_help_button
   >>>> 	create_quit_button
   >>>> 	create_infile_sel
   >>>> 	create_outfile_sel
   >>>> 	create_stdin_sel
   >>>> 	create_stdout_sel
   >>>> 	create_ansinfile_sel
   >>>> 	create_ansoutfile_sel
   >>>> 	create_int_sel
   >>>> 	create_float_sel
   >>>> 	create_string_sel
   >>>> 	create_strlist_sel
   >>>> 	create_logic_sel
   >>>> 	create_flag_sel
   >>>> 	create_list_sel
   >>>> 	create_displaylist_sel
   >>>> 	create_cycle_sel
   >>>> 	create_wksp_sel
   >>>> 	create_blank_sel
   >>>> 	create_control_dest
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "guise.h"


/*-----------------------------------------------------------
| 
|  Routine Name: create_action_button
| 
|       Purpose: Called when pane action button action_button is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/

void create_action_button(
   options_create *create_info)
{
	char         *line = NULL;
	char         temp[KLENGTH];
	kselection   *selection;
	static int   action_num = 1;
	Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 *  set default values for action button
	 */
	display_control = find_displayed_control("create_action_button",
                                "action button", create_info->control_dest_val,
				&display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;

	kvf_clear_line_info(&line_info);
	ksprintf(temp, "action%d", action_num++);
	line_info.typeflag    = KUIS_PANEACTION;
	line_info.variable    = kstrdup(temp);
	line_info.title       = kstrdup("ACTION");
	line_info.description = kstrdup("action button");
	line_info.activate    = 1;
	line_info.selected    = 0;
	line_info.width       = 8.0;
	line_info.height      = 1.5;
	line_info.x           = 1.0;
	line_info.y           = xvf_calculate_y_position(display_control);
	kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
	if (selection == NULL)
	    kerror(NULL, "create_action_button", 
		   "Unable to create action button");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_routine_button
| 
|       Purpose: Called when pane action button routine_button is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_routine_button(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   routine_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the routine button is going
	 */
	display_control = find_displayed_control("create_routine_button",
                              "routine button", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;

        /*
         *  check for existing routine button - only one per pane supported
         */
        if (kvf_gui_item_exists(display_control->sel_list, KUIS_ROUTINE))
        {
            kerror(NULL, "create_routine_button",
                  "Only one routine button per pane is supported (as of yet).");
            return;
        }

        /*
         *  set default values for routine button
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "program%d", routine_num++);
        line_info.routine     = kstrdup(temp);
        line_info.typeflag    = KUIS_ROUTINE;
        line_info.title       = kstrdup("EXECUTE");
        line_info.description = kstrdup("execute your program");
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.exec_type   = 1;
        line_info.width       = 8.0;
        line_info.height      = 1.5;
        line_info.x           = 1.0;
	line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
	if (selection == NULL)
	    kerror(NULL, "create_routine_button", 
		   "Unable to create routine button");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_help_button
| 
|       Purpose: Called when pane action button help_button is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_help_button(
   options_create *create_info)
{
	char         *line = NULL;
        kselection   *selection;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the help button is going
	 */
	display_control = find_displayed_control("create_help_button",
                              "help button", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;


        /*
         *  set default values for help button
         */
        kvf_clear_line_info(&line_info);
        line_info.typeflag    = KUIS_HELP;
        line_info.title       = kstrdup("HELP");
        line_info.description = kstrdup("display online help");
        line_info.help_file   = kstrdup("$DESIGN/objects/library/xvforms/help/Empty.doc");
        line_info.variable    = kstrdup("help");
        line_info.activate    = 1;
        line_info.width       = 8.0;
	if (create_info->control_dest_val == KPANE)
	{
            line_info.x = 1.0;
	    line_info.y = xvf_calculate_y_position(display_control);
	    line_info.height = 1.5;
	}
	else
	{
            line_info.x = 48.0;
	    line_info.y = 0.0;
	    line_info.height = 1.0;
	}
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
	if (selection == NULL)
	    kerror(NULL, "create_help_button", 
		   "Unable to create help button");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_quit_button
| 
|       Purpose: Called when pane action button quit_button is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_quit_button(
   options_create *create_info)
{
	char         *line = NULL;
        kselection   *selection;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the quit button is going
	 */
	display_control = find_displayed_control("create_quit_button",
                              "quit button", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;


	/*
	 *  check for existing quit button - only one per pane allowed
	 */
	if (kvf_gui_item_exists(display_control->sel_list, KUIS_QUIT))
	{
	    kerror(NULL, "create_quit_button",
		  "Only one quit button per pane is allowed.");
	    return;
	}

        /*
         *  set default values for quit button
         */
        kvf_clear_line_info(&line_info);
        line_info.typeflag    = KUIS_QUIT;
        line_info.title       = kstrdup("QUIT");
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.width       = 8.0;
	if (create_info->control_dest_val == KPANE)
	{
            line_info.x = 1.0;
	    line_info.y = xvf_calculate_y_position(display_control);
	    line_info.height = 1.5;
	}
	else
	{
            line_info.x = 58.0;
	    line_info.y = 0.0;
	    line_info.height = 1.0;
	}
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_quit_button",
                   "Unable to create quit button");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_infile_sel
| 
|       Purpose: Called when pane action button infile_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_infile_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   infile_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the input file selection is going
	 */
	display_control = find_displayed_control("create_infile_sel",
                               "input file selection", 
				create_info->control_dest_val,
                               &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;


        /*
         *  set default values for input file selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "i%d", infile_num++);
        line_info.typeflag    = KUIS_INPUTFILE;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("Input File");
        line_info.description = kstrdup("input file");
        line_info.file_def    = NULL;
        line_info.filename    = NULL;
        line_info.literal     = NULL;
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.live        = 0;
        line_info.file_check  = 1;
        line_info.width       = 45.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
	line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_infile_sel",
                   "Unable to create input file selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_outfile_sel
| 
|       Purpose: Called when pane action button outfile_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_outfile_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   outfile_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the output file selection is going
	 */
	display_control = find_displayed_control("create_outfile_sel",
                              "output file selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;


        /*
         *  set default values for output file selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "o%d", outfile_num++);
        line_info.typeflag    = KUIS_OUTPUTFILE;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("Output File");
        line_info.description = kstrdup("output file");
        line_info.file_def    = NULL;
        line_info.filename    = NULL;
        line_info.literal     = NULL;
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.live        = 0;
        line_info.file_check  = 1;
        line_info.width       = 45.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
	line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_outfile_sel",
                   "Unable to create output file selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
|
|  Routine Name: create_stdin_sel
|
|       Purpose: Do routine which is called when
|                  pane action button stdin_sel is used
|
|         Input: create_info - ptr to PaneInfo struct for create pane
|
|        Output: None
|    Written By:
|          Date: Apr 27, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void create_stdin_sel(
     options_create *create_info)
{
	char         *line = NULL;
        kselection   *selection;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the stdin selection is going
	 */
	display_control = find_displayed_control("create_stdin_sel",
                               "stdin selection", 
				create_info->control_dest_val,
                               &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;

        /*
         *  check for existing stdin selection - only one per pane supported
         */
        if (kvf_gui_item_exists(display_control->sel_list, KUIS_STDIN))
        {
            kerror(NULL, "create_stdin_sel",
                  "Only one stdin selection per pane is allowed.");
            return;
        }

        /*
         *  set default values for stdin selection
         */
        kvf_clear_line_info(&line_info);
        line_info.typeflag    = KUIS_STDIN;
        line_info.variable    = kstrdup("stdin");
        line_info.title       = kstrdup("stdin");
        line_info.activate    = 1;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.x           = 1.0;
	line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_stdin_sel",
                   "Unable to create stdin selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);
}


/*-----------------------------------------------------------
|
|  Routine Name: create_stdout_sel
|
|       Purpose: Do routine which is called when
|                  pane action button stdout_sel is used
|
|         Input: create_info - ptr to PaneInfo struct for create pane
|
|        Output: None
|    Written By:
|          Date: Apr 27, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void create_stdout_sel(
     options_create *create_info)
{
        char         *line = NULL;
        kselection   *selection;
        Line_Info    line_info;
        kcontrol     *display_control;
        ksubform     *display_subform;
        kguide       *display_guide;
        kcontrol     *display_pane;

        /*
         * determine where the stdin selection is going
         */
        display_control = find_displayed_control("create_stdout_sel",
                               "stdout selection",
                                create_info->control_dest_val,
                               &display_subform, &display_guide, &display_pane);
        if (display_control == NULL) return;

        /*
         *  check for existing stdout selection - only one per pane supported
         */
        if (kvf_gui_item_exists(display_control->sel_list, KUIS_STDOUT))
        {
            kerror(NULL, "create_stdout_sel",
                  "Only one stdout selection per pane is allowed.");
            return;
        }

        /*
         *  set default values for stdout selection
         */
        kvf_clear_line_info(&line_info);
        line_info.typeflag    = KUIS_STDOUT;
        line_info.variable    = kstrdup("stdout");
        line_info.title       = kstrdup("stdout");
        line_info.activate    = 1;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.x           = 1.0;
        line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

        selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_stdout_sel",
                   "Unable to create stdout selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);
}

/*-----------------------------------------------------------
| 
|  Routine Name: create_int_sel
| 
|       Purpose: Called when pane action button int_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_int_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   int_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the integer selection is going
	 */
	display_control = find_displayed_control("create_int_sel",
                               "integer selection", 
			       create_info->control_dest_val, &display_subform,
			       &display_guide, &display_pane);
	if (display_control == NULL) return;

        /*
         *  set default values for integer selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "int%d", int_num++);
        line_info.typeflag    = KUIS_INTEGER;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("Integer");
        line_info.description = kstrdup("integer");
        line_info.literal     = kstrdup("0");
        line_info.int_val     = 0;
        line_info.int_def     = 0;
        line_info.lower_int   = -100;
        line_info.upper_int   = 100;
        line_info.activate    = 1;
        line_info.special     = 1;
        line_info.selected    = 0;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.live        = 0;
        line_info.width       = 45.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
	line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_int_sel",
                   "Unable to create integer selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_float_sel
| 
|       Purpose: Called when pane action button float_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_float_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   float_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the float selection is going
	 */
	display_control = find_displayed_control("create_float_sel",
                              "float selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;

        /*
         *  set default values for float selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "float%d", float_num++);
        line_info.typeflag    = KUIS_FLOAT;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("Float");
        line_info.description = kstrdup("float");
        line_info.literal     = kstrdup("0.0000000");
        line_info.float_val   = 0.0;
        line_info.float_def   = 0.0;
        line_info.lower_float = -100.0;
        line_info.upper_float = 100.0;
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.live        = 0;
        line_info.precision   = 7;
        line_info.special     = 1;
        line_info.width       = 45.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
	line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_float_sel",
                   "Unable to create float selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);


}


/*-----------------------------------------------------------
| 
|  Routine Name: create_double_sel
| 
|       Purpose: Do routine which is called when
|                  pane action button double_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 30, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_double_sel(
     options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   double_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the double selection is going
	 */
	display_control = find_displayed_control("create_double_sel",
                              "double selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;

        /*
         *  set default values for double selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "double%d", double_num++);
        line_info.typeflag     = KUIS_DOUBLE;
        line_info.variable     = kstrdup(temp);
        line_info.title        = kstrdup("Double");
        line_info.description  = kstrdup("double");
        line_info.literal      = kstrdup("0.0000000000");
        line_info.double_val   = 0.0;
        line_info.double_def   = 0.0;
        line_info.lower_double = -100.0;
        line_info.upper_double = 100.0;
        line_info.activate     = 1;
        line_info.selected     = 0;
        line_info.optional     = 0;
        line_info.opt_sel      = 1;
        line_info.live         = 0;
        line_info.precision    = 10;
        line_info.special      = 0;
        line_info.width        = 20.0;
        line_info.height       = 1.0;
        line_info.x            = 1.0;
	line_info.y            = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_double_sel",
                   "Unable to create double selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_string_sel
| 
|       Purpose: Called when pane action button string_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_string_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   string_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the string selection is going
	 */
	display_control = find_displayed_control("create_string_sel",
                              "strings selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;

        /*
         *  set default values for string selection 
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "string%d", string_num++);
        line_info.typeflag    = KUIS_STRING;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("String");
        line_info.description = kstrdup("string");
        line_info.string_def  = NULL;
        line_info.string_val  = NULL;
        line_info.literal     = NULL;
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.live        = 0;
        line_info.width       = 45.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
	line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_string_sel",
                   "Unable to create string selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_strlist_sel
| 
|       Purpose: Called when pane action button strlist_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_strlist_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   strlist_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the routine button is going
	 */
	display_control = find_displayed_control("create_strlist_sel",
                              "stringlist selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;


        /*
         *  set default values for string list selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "strlist%d", strlist_num++);
        line_info.typeflag    = KUIS_STRINGLIST;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("StringList");
        line_info.description = kstrdup("string list");
        line_info.string_def  = NULL;
        line_info.string_val  = NULL;
        line_info.literal     = NULL;
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.live        = 0;
        line_info.width       = 45.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
        line_info.y           = xvf_calculate_y_position(display_control);
	line_info.list_num    = 3;
	line_info.list_val    = 1;

	line_info.val_labels = (char **) kcalloc(1, 3*sizeof(char *));
	line_info.val_labels[0] = kstrdup("One");
	line_info.val_labels[1] = kstrdup("Two");
	line_info.val_labels[2] = kstrdup("Three");
	line_info.val_labelnum  = 3;
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);

        if (selection == NULL)
            kerror(NULL, "create_strlist_sel",
                   "Unable to create stringlist selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_logic_sel
| 
|       Purpose: Called when pane action button logic_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_logic_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   logic_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the routine button is going
	 */
	display_control = find_displayed_control("create_logic_sel",
                              "logic selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;


        /*
         *  set default values for logical selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "logic%d", logic_num++);
        line_info.typeflag    = KUIS_LOGICAL;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("Logical");
        line_info.description = kstrdup("logical");
        line_info.logical_def = 1;
        line_info.logical_val = 1;
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.live        = 0;
        line_info.width       = 15.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
        line_info.y           = xvf_calculate_y_position(display_control);
	line_info.list_num    = 2;
	line_info.list_val    = 1;

	line_info.val_labels = (char **) kcalloc(1, 2*sizeof(char *));
	line_info.val_labels[0] = kstrdup("False");
	line_info.val_labels[1] = kstrdup("True");
	line_info.val_labelnum  = 2;
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_logic_sel",
                   "Unable to create logical selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_flag_sel
| 
|       Purpose: Called when pane action button flag_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_flag_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   flag_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the routine button is going
	 */
	display_control = find_displayed_control("create_flag_sel",
                              "flag selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;


        /*
         *  set default values for flag selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "flag%d", flag_num++);
        line_info.typeflag    = KUIS_FLAG;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("Flag");
        line_info.description = kstrdup("flag");
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.optional    = 1;
        line_info.opt_sel     = 0;
        line_info.live        = 0;
        line_info.width       = 6.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
        line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);


	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_flag_sel",
                   "Unable to create flag selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_list_sel
| 
|       Purpose: Called when pane action button list_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_list_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   list_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the list selection is going
	 */
	display_control = find_displayed_control("create_list_sel",
                              "list selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;

        /*
         *  set default values for list selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "list%d", list_num++);
        line_info.typeflag    = KUIS_LIST;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("List");
        line_info.description = kstrdup("list");
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.live        = 0;
        line_info.width       = 15.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
        line_info.y           = xvf_calculate_y_position(display_control);
	line_info.list_num    = 3;
	line_info.list_val    = 1;
	line_info.int_val     = 1;

	line_info.val_labels = (char **) kcalloc(1, 3*sizeof(char *));
	line_info.val_labels[0] = kstrdup("First");
	line_info.val_labels[1] = kstrdup("Second");
	line_info.val_labels[2] = kstrdup("Third");
	line_info.val_labelnum  = 3;
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_list_sel",
                   "Unable to create list selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}



/*-----------------------------------------------------------
| 
|  Routine Name: create_displaylist_sel
| 
|       Purpose: Do routine which is called when
|                  pane action button displaylist_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Jan 18, 1994
| Modifications: 
| 
------------------------------------------------------------*/
void create_displaylist_sel(
     options_create *create_info)
{
        char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   displaylist_num = 1;
        Line_Info    line_info;
        kcontrol     *display_control;
        ksubform     *display_subform;
        kguide       *display_guide;
        kcontrol     *display_pane;

        /*
         * determine where the displaylist selection is going
         */
        display_control = find_displayed_control("create_displaylist_sel",
                              "displaylist selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
        if (display_control == NULL) return;

        /*
         *  set default values for list selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "displaylist%d", displaylist_num++);
        line_info.typeflag    = KUIS_DISPLAYLIST;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("DisplayList");
        line_info.description = kstrdup("display list");
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.special     = 0;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.live        = 0;
        line_info.width       = 15.0;
        line_info.height      = 5.0;
        line_info.x           = 1.0;
        line_info.y           = xvf_calculate_y_position(display_control);
        line_info.list_num    = 3;
        line_info.list_val    = 1;
        line_info.int_val     = 1;

        line_info.val_labels = (char **) kcalloc(1, 3*sizeof(char *));
        line_info.val_labels[0] = kstrdup("First");
        line_info.val_labels[1] = kstrdup("Second");
        line_info.val_labels[2] = kstrdup("Third");
        line_info.val_labelnum  = 3;
        kvf_gen_deparse(&line_info, &line);

        selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_displaylist_sel",
                   "Unable to create displaylist selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_cycle_sel
| 
|       Purpose: Called when pane action button cycle_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_cycle_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   cycle_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the cycle selection is going
	 */
	display_control = find_displayed_control("create_cycle_sel",
                              "cycle selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;

	/*
	 * set default values for cycle selection
	 */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "cycle%d", cycle_num++);
        line_info.typeflag    = KUIS_CYCLE;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("Cycle");
        line_info.description = kstrdup("cycle");
        line_info.activate    = 1;
        line_info.selected    = 0;
        line_info.optional    = 0;
        line_info.opt_sel     = 1;
        line_info.live        = 0;
        line_info.width       = 12.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
        line_info.y           = xvf_calculate_y_position(display_control);
	line_info.list_num    = 3;
	line_info.list_val    = 1;
	line_info.int_val     = 1;

	line_info.val_labels = (char **) kcalloc(1, 3*sizeof(char *));
	line_info.val_labels[0] = kstrdup("First");
	line_info.val_labels[1] = kstrdup("Second");
	line_info.val_labels[2] = kstrdup("Third");
	line_info.val_labelnum  = 3;
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_cycle_sel",
                   "Unable to create cycle selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_wksp_sel
| 
|       Purpose: Called when pane action button wksp_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_wksp_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   wksp_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the workspace is going
	 */
	display_control = find_displayed_control("create_wksp_sel",
                              "workspace", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;


        /*
         *  set default values for workspace object
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "wksp%d", wksp_num++);
        line_info.typeflag    = KUIS_WORKSPACE;
        line_info.variable    = kstrdup(temp);
        line_info.description = kstrdup("general-purpose workspace");
        line_info.width       = 245.0;
        line_info.height      = 75.0;
        line_info.x           = 1.0;
        line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_wksp_sel",
                   "Unable to create workspace selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}


/*-----------------------------------------------------------
| 
|  Routine Name: create_blank_sel
| 
|       Purpose: Called when pane action button blank_sel is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Tues Dec 8, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_blank_sel(
   options_create *create_info)
{
	char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *selection;
        static int   blank_num = 1;
        Line_Info    line_info;
	kcontrol     *display_control;
	ksubform     *display_subform;
	kguide       *display_guide;
	kcontrol     *display_pane;

	/*
	 * determine where the blank selection is going
	 */
	display_control = find_displayed_control("create_blank_sel",
                              "blank selection", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;


        /*
         *  set default values for blank selection
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "blank%d", blank_num++);
        line_info.typeflag    = KUIS_BLANK;
        line_info.variable    = kstrdup(temp);
        line_info.title       = kstrdup("Your Text Is Here");
        line_info.width       = 1.0;
        line_info.height      = 1.0;
        line_info.xpos        = 1.0;
	line_info.ypos        = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	selection = create_new_selection(display_control, line);
        if (selection == NULL)
            kerror(NULL, "create_blank_sel",
                   "Unable to create blank selection");

        kvf_free_line_info_strings(&line_info);
        kfree(line);

}

/*-----------------------------------------------------------
| 
|  Routine Name: create_control_dest
| 
|       Purpose: Do routine which is called when
|                  toggle selection control_dest is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Mar 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void create_control_dest(
     options_create *create_info)
{
	kcontrol     *display_control;
        ksubform     *display_subform;
        kguide       *display_guide;
        kcontrol     *display_pane;
	char         temp[KLENGTH];

        /*
         * determine where the blank selection is going
         */
        display_control = find_displayed_control("create_control_dest",
                              "any", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL)
	{
	    ksprintf(temp, "%d", save_control_dest);
	    xvf_set_attribute(create_info->control_dest_struct,
			      XVF_TOGGLE_VAL, temp);
	    create_info->control_dest_val = save_control_dest;
	    return;
	}

	/*
	 *  control destination is the pane:
         *  1) edit mode on master OFF
	 *  2) edit mode on guidepane OFF 
         *  3) edit mode on panes ON
	 */
	if (create_info->control_dest_val == KPANE)
	{
	    if (display_control->back_form->master != NULL)
	        xvw_set_attribute(display_control->back_form->master->back, 
		 	          XVW_EDIT_MODE_ON, FALSE);

	    if (display_subform->guidepane != NULL)
	        xvw_set_attribute(display_subform->back, 
		 	          XVW_EDIT_MODE_ON, FALSE);

	    xvw_set_attribute(display_control->back, XVW_EDIT_MODE_ON, TRUE);

	}

	/*
	 *  control destination is the master:
         *  1) edit mode on master ON
	 *  2) edit mode on guidepane OFF 
         *  3) edit mode on panes OFF
	 */
	else if (create_info->control_dest_val == KMASTER)
	{
            if (display_control != NULL)
	    {
                xvw_set_attribute(display_control->back, 
                                  XVW_EDIT_MODE_ON, TRUE);

                if ((display_subform != NULL) && 
		    (display_subform->guidepane != NULL))
                    xvw_set_attribute(display_subform->back,
                                      XVW_EDIT_MODE_ON, FALSE);

                if (display_pane != NULL)
                   xvw_set_attribute(display_pane->back,
                                  XVW_EDIT_MODE_ON, FALSE);
	    }
	}

	/*
	 *  control destination is the guidepane:
         *  1) edit mode on master OFF
	 *  2) edit mode on guidepane ON 
         *  3) edit mode on panes OFF
	 */
	else if (create_info->control_dest_val == KGUIDEPANE)
	{
	    if (display_subform->guidepane != NULL)
	    {
                if (display_control->back_form->master != NULL)
                    xvw_set_attribute(display_control->back_form->master->back, 
                                  XVW_EDIT_MODE_ON, FALSE);

                xvw_set_attribute(display_control->back,
                                  XVW_EDIT_MODE_ON, TRUE);

		if (display_pane != NULL)
                   xvw_set_attribute(display_pane->back,
                                  XVW_EDIT_MODE_ON, FALSE);
	   }
	}

	/*
	 * save new control_dest value in case we need to restore it next time
	 */
	save_control_dest = create_info->control_dest_val;
}
