/* 
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for pane obj_attrs
   >>>> 
   >>>>  Private: 
   >>>>         obj_attrs_apply
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "craftsman.h"

extern AttributeSelection object_attributes[NUM_OBJ_ATTRS];

/*-----------------------------------------------------------
| Routine Name:	obj_attrs_apply - save object attribute changes
| 
| Purpose:	Do routine which is called when
|		pane action button apply is used
| 
| Input:	obj_attrs_info - ptr to PaneInfo struct for obj_attrs pane
| 
| Output:	None
| Written By:	Neil Bowers
| Date:		5-dec-93
------------------------------------------------------------*/
void
obj_attrs_apply(
   obj_attributes_obj_attrs * obj_attrs_info)
{
   kstring        routine = "obj_attrs_apply()";
   kobject        object;
   kstring        attrval;
   int            i;
   int            installed;
   unsigned long  update;


   if (strObject == NULL)
   {
      kerror(NULL, routine, "You have not selected an object.");
      return;
   }

   if ((object = kcms_open_cmobj(cmsToolbox, strObject)) == NULL)
   {
      kerror(NULL, routine,
	     "Unable to open selected software object, "
	     "`%s' in toolbox `%s'.",
	     strObject, strToolbox);
      return;
   }

   for (i = 0; i < NUM_OBJ_ATTRS; i++)
   {
      kcms_get_attribute(object,
			 object_attributes[i].attribute, &attrval);
      if (kstrcmp(*object_attributes[i].selvalue, attrval) != 0)
      {
	 kcms_set_attribute(object,
			    object_attributes[i].attribute,
			    *object_attributes[i].selvalue);

	 /*--------------------------------------------------------------
	 |	if user modified (sub)category, we may need to update
	 |	the global lists which hold them
	 --------------------------------------------------------------*/
	 if (object_attributes[i].attribute == KCMS_CMOBJ_CATEGORY)
	    merge_category_strings(*object_attributes[i].selvalue, NULL);
	 else if (object_attributes[i].attribute == KCMS_CMOBJ_SUBCATEGORY)
	    merge_category_strings(NULL, *object_attributes[i].selvalue);
      }
   }

   /*-- check the toggle for `Installed in Cantata' -------------------*/
   kcms_get_attribute(object, KCMS_CMOBJ_INCANTATA, &installed);
   if (installed != paneObjAttrs->install_in_cantata_val - 1)
      kcms_set_attribute(object, KCMS_CMOBJ_INCANTATA,
			 obj_attrs_info->install_in_cantata_val - 1);

   if (kcms_get_attribute(object, KCMS_CMOBJ_UPDATE_DB, &update)
       && (update & KCMS_UPDATE_REGEN_CODE) == KCMS_UPDATE_REGEN_CODE)
   {
      kgen_generate_object(object);
   }


   kcms_close(object);
}
