/* 
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/* 
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for pane move
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "craftsman.h"


/*-----------------------------------------------------------
| Routine Name:	move_domove - move software object to new toolbox
| 
| Purpose:	Do routine which is called when
|		pane action button domove is used
| 
| Input:	move_info - ptr to PaneInfo struct for move pane
| 
| Output:	None
| Written By:	Neil Bowers
| Date:		May 06, 1994
------------------------------------------------------------*/
/* ARGSUSED */
void
move_domove(
   mvobject_move * move_info)
{
   kstring  routine     = "Move Object";
   kobject  destination = NULL;
   kobject  object      = NULL;
   kobject  newobject   = NULL;
   char     desttbupper[KLENGTH];
   int      otype;


   if (move_info->desttb != NULL)
      kstring_upper(move_info->desttb, desttbupper);

   if (strObject == NULL)
      kerror(NULL, routine,
	     "You have not selected a software object to move.");

   else if (move_info->desttb == NULL)
      kerror(NULL, routine, "You must specify a destination "
	     "toolbox to move the object into.");

   else if (!kprompt(KFORCE, "Yes", "No", FALSE,
		     "Operation: move software object to new toolbox\n\n"
		     "\tToolbox             : %s\n"
		     "\tObject              : %s\n"
		     "\tDestination Toolbox : %s\n\n"
		     "Do you want to continue?",
		     strToolbox, strObject, desttbupper))
      return;

   else if ((object = kcms_open_cmobj(cmsToolbox, strObject)) == NULL)
      kerror(NULL, routine, "Can't open object \"%s\" in "
	     "toolbox \"%s\".", strObject, strToolbox);

   else if (kcms_get_attribute(object, KCMS_CMOBJ_PROGTYPE, &otype))
   {
      if ((destination = kcms_open_toolbox(move_info->desttb)) == NULL)
	 return;

      xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, TRUE);
      xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
		     "Moving object `%s' from toolbox `%s' to toolbox `%s'",
			   strObject, strToolbox, desttbupper);

      if ((newobject = kcms_duplicate(object, destination)) != NULL
	  && kcms_close(newobject)
	  && kcms_sync(cmsToolbox)
	  && kcms_set_bit(object, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE)
	  && kcms_destroy(object))
      {
	 update_categories();

	 if (otype == KCMS_LIBRARY)
	    change_lib_list();
	 update_object_list();
	 select_object(NULL);
      }
      xvw_set_attribute(xvoNotifier,
			XVW_NOTIFYWINDOW_VISIBLE, FALSE);
   }
}
