/* 
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/* 
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for pane infopane
   >>>> 
   >>>>  Private: 
   >>>>         infopane_todo
   >>>>         infopane_bugs
   >>>>         infopane_done
   >>>>         infopane_changelog
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"
#include <kcms/private.h>

extern InfoFile info_files[];

static kbool create_info_file		PROTO((int));
static void  craftsman_delete_info	PROTO((int));
static void  craftsman_edit_info_file	PROTO((int));

/*-----------------------------------------------------------
| Routine Name: infopane_todo - callback for TODO info file button
| 
| Purpose:	Do routine which is called when
|		pane action button todo is used
| 
| Input:	infopane_info - ptr to PaneInfo struct for infopane pane
|
| Written By:	Neil Bowers
| Date:		May 07, 1994
------------------------------------------------------------*/
/* ARGSUSED */
void
infopane_todo(
   objinfo_infopane * infopane_info)
{
   craftsman_edit_info_file(0);
}

/*-----------------------------------------------------------
| Routine Name:	infopane_bugs
| 
| Purpose:	Do routine which is called when
|		pane action button bugs is used
| 
| Input:	infopane_info - ptr to PaneInfo struct for infopane pane
| 
| Written By:	Neil Bowers
| Date:		May 07, 1994
------------------------------------------------------------*/
/* ARGSUSED */
void
infopane_bugs(
   objinfo_infopane * infopane_info)
{
   craftsman_edit_info_file(1);
}

/*-----------------------------------------------------------
| Routine Name:	infopane_done - edit DONE info file
|
| Purpose:	Do routine which is called when
|		pane action button done is used
| 
| Input:	infopane_info - ptr to PaneInfo struct for infopane pane
|
| Written By:	Neil Bowers
| Date:		May 07, 1994
------------------------------------------------------------*/
/* ARGSUSED */
void
infopane_done(
   objinfo_infopane * infopane_info)
{
   craftsman_edit_info_file(2);
}

/*-----------------------------------------------------------
| Routine Name:	infopane_changelog
| 
| Purpose:	Do routine which is called when
|		pane action button changelog is used
| 
| Input:	infopane_info - ptr to PaneInfo struct for infopane pane
|
| Written By:	Neil Bowers
| Date:		May 07, 1994
------------------------------------------------------------*/
/* ARGSUSED */
void
infopane_changelog(
   objinfo_infopane * infopane_info)
{
   craftsman_edit_info_file(3);
}

/*-----------------------------------------------------------
| Routine Name:	craftsman_edit_info_file - edit specified info file
| 
| Purpose:	This function takes an integer identifier for an info
|		file, and spawns a text editor on the specified file.
| 
| Input:	info_number - the number of the info file to act on.
|
| Written By:	Neil Bowers
| Date:		2-april-1995
------------------------------------------------------------*/
static void
craftsman_edit_info_file(
   int info_number)
{
   kstring  routine = "craftsman_edit_info_file()";


   if (strObject == NULL)
      kerror(NULL, routine, "You have not selected a software object.");
   else if (info_files[info_number].present)
      keditfile(info_files[info_number].path, TRUE,
		KEDITOR_GEOMETRY, "80x48",
		KEDITOR_CHDIR,    TRUE,
		NULL);
   else
   {
      errno = KCMS_EINTERNAL;
      kerror(NULL, routine, "Function should not have been called ---\n"
	     "info file is not present!\n");
   }
}

/*-----------------------------------------------------------
| Routine Name:	create_info_file - create template info file object
| 
| Purpose:	This function is used to create an info file object in the
|		currently selected software object.  The appropriate
|		template is copied into the object.
| 
| Input:	info_number -	info file identifier number; effectively
|				an index into the table of information
|				about info files.  Hey, I never claimed
|				it wasn't a kludge!
| Output:	None
|
| Written By:	Neil Bowers
| Date:		May 07, 1994
------------------------------------------------------------*/
static kbool
create_info_file(
   int info_number)
{
   /* UPDATE-------------------------------------------------------------
   | This routine is a kludge -- in the future kcms will
   | provide this type of functionality, but this was the
   | quickest and easiest way to get the info file functionality online.
   \-------------------------------------------------------------------*/
   kstring  routine        = "create_info_file()";
   kobject  object         = NULL;
   kobject  file_object    = NULL;
   kstring  opath          = NULL;
   kstring  typestring     = NULL;
   kbool    status         = TRUE;
   kstring  template       = NULL;
   char     path[KLENGTH];
   int      otype;


   if ((object = kcms_open_cmobj(cmsToolbox, strObject)) == NULL)
   {
      kerror(NULL, routine, "Unable to open object `%s' in "
	     "toolbox `%s'.", strObject, strToolbox);
      return FALSE;
   }

   if (!kcms_get_attribute(object, KCMS_CMOBJ_PROGTYPE, &otype)
       || !kcms_get_attribute(object, KCMS_PATH, &opath)
       || (typestring = kcms_attr_int2string(KCMS_CMOBJ_TYPE, otype)) == NULL)
   {
      kcms_close(object);
      return FALSE;
   }

   if ((template = kcms_query_template(object,
			      info_files[info_number].template_id)) == NULL)
   {
      kcms_close(object);
      return FALSE;
   }

   ksprintf(path, "%s/info/%s.%s", opath, strObject,
	    info_files[info_number].suffix);

   /*-- pop up the notifier, tell 'em we're creating info file --*/
   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, TRUE);
   xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
			"Creating template `%s' file for object `%s' "
			"in toolbox `%s'.", info_files[info_number].suffix,
			strObject, strToolbox);

   if (kaccess(path, R_OK) == 0)
   {
      kwarn(NULL, routine, "Object `%s' already has a `%s' file. "
	    "This will NOT be overwritten, but will be "
	    "added to the object's database.",
	    strObject, info_files[info_number].suffix);
   }
   else if (!ksedfile(template, path, FALSE, KFILE_UPDATE, NULL,
		      "#toolbox-name#", strToolbox,
		      "#object-name#", strObject,
		      "#object-type#", typestring, NULL))
      kwarn(NULL, routine, "Could not copy template "
	    "`%s' file into object `%s' "
	    "-- no file was created.\n"
	    "[Template: %s]",
	    info_files[info_number].suffix, strObject,
	    template);

   file_object = kcms_create_fileobj(object, path, NULL,
				     KCMS_FOBJ_TYPE_INFO,
				     info_files[info_number].subtype,
				     KCMS_FOBJ_GEN_NONE,
				     KCMS_FOBJ_ACCESS_RDWR);
   if (file_object != NULL)
      update_info_files(object);

   if (object != NULL)
      kcms_close(object);

   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
   return status;
}


/*-----------------------------------------------------------
| Routine Name: craftsman_delete_info - delete specified info file
| 
| Purpose:	This function takes an attribute which specifies a file
|		object in the currently selected software object.
|		We open the selected object and try to remove the specified
|		file from it.
| 
| Input:	infopane_info - ptr to PaneInfo struct for infopane pane
| 
| Written By:	Neil Bowers
| Date:		26-feb-1995
------------------------------------------------------------*/
static void
craftsman_delete_info(
   int  info_attribute)
{
   kstring  routine        = "craftsman_delete_info()";
   kobject  object         = NULL;
   kobject  file_object    = NULL;
   kstring  file_basename  = NULL;


   if (strObject == NULL)
   {
      kerror(NULL, routine, "No object currently selected.");
      return;
   }

   if ((object = kcms_open_cmobj(cmsToolbox, strObject)) == NULL)
   {
      kerror(NULL, routine, "Unable to open object `%s' in "
	     "Toolbox `%s'.", strObject, strToolbox);
      return;
   }

   if (!kcms_get_attribute(object, info_attribute, &file_object))
      return;

   if (file_object == NULL)
   {
      errno = KCMS_EINTERNAL;
      kerror(NULL, routine, "Object does not have the specified info file!");
      return;
   }

   if (!kcms_get_attribute(file_object, KCMS_NAME, &file_basename))
      return;

   if (kprompt(KFORCE, NULL, NULL, FALSE,
	       "Operation: delete `info file' from software object\n\n"
	       "\tToolbox:   %s\n"
	       "\tObject:    %s\n"
	       "\tInfo File: %s\n\n"
	       "Are you sure you want to delete this file?",
	       strToolbox, strObject, file_basename))
      if (kcms_destroy(file_object))
	 update_info_files(object);

   kcms_close(object);
}

/*-----------------------------------------------------------
| Routine Name: infopane_crtodo - create/delete TODO file
| 
| Purpose:	Do routine which is called when
|		pane action button crtodo is used
| 
| Input:	infopane_info - ptr to PaneInfo struct for infopane pane
| 
| Written By:	Neil Bowers
| Date:		2-april-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
infopane_crtodo(
   objinfo_infopane *infopane_info)
{
   if (strObject == NULL)
      kerror(NULL, "infopane_crtodo()",
	     "You have not selected a software object.");
   else if (info_files[0].present)
      craftsman_delete_info(info_files[0].attribute);
   else
      create_info_file(0);
}

/*-----------------------------------------------------------
| Routine Name:	infopane_crbugs - create/delete BUGS info file
| 
| Purpose:	Do routine which is called when
|		pane action button crbugs is used
| 
| Input:	infopane_info - ptr to PaneInfo struct for infopane pane
| 
| Written By:	Neil Bowers
| Date:		2-april-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
infopane_crbugs(
   objinfo_infopane *infopane_info)
{
   if (strObject == NULL)
      kerror(NULL, "infopane_crbugs()",
	     "You have not selected a software object.");
   else if (info_files[1].present)
      craftsman_delete_info(info_files[1].attribute);
   else
      create_info_file(1);
}


/*-----------------------------------------------------------
| Routine Name: infopane_crdone
| 
| Purpose: Do routine which is called when
|                  pane action button crdone is used
| 
| Input:	infopane_info - ptr to PaneInfo struct for infopane pane
| 
| Written By:	Neil Bowers
| Date:		2-april-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
infopane_crdone(
   objinfo_infopane *infopane_info)
{
   if (strObject == NULL)
      kerror(NULL, "infopane_crdone()",
	     "You have not selected a software object.");
   else if (info_files[2].present)
      craftsman_delete_info(info_files[2].attribute);
   else
      create_info_file(2);
}

/*-----------------------------------------------------------
| Routine Name:	infopane_crchangelog - create/delete CHANGELOG info file
| 
| Purpose:	Do routine which is called when
|		pane action button crchangelog is used
| 
| Input:	infopane_info - ptr to PaneInfo struct for infopane pane
| 
| Written By:	Neil Bowers
| Date:		2-april-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
infopane_crchangelog(
   objinfo_infopane *infopane_info)
{
   if (strObject == NULL)
      kerror(NULL, "infopane_crchangelog()",
	     "You have not selected a software object.");
   else if (info_files[3].present)
      craftsman_delete_info(info_files[3].attribute);
   else
      create_info_file(3);
}

