/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Initialization Routines
   >>>>
   >>>>  Private:
   >>>>             initialize()
   >>>>
   >>>>   Static:
   >>>>             activate_guide_buttons()
   >>>>             init_utilities()
   >>>>             quit_extra_call()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#define COMPOSER_GLOBALS
#include "composer.h"

static void activate_guide_buttons       PROTO((void));
static void quit_extra_call              PROTO((kaddr));
static void initialize_object_attributes PROTO((obj_attributes_obj_attrs *));
static void attribute_callback           PROTO((kobject, int, void *));


/*-----------------------------------------------------------
| Routine Name:	initialize - Initialize the user interface.
|
| Purpose:	Initialize the user interface.
| Written By:	Becky Bishop and Neil Bowers
| Date:		28-apr-93
------------------------------------------------------------*/
int
initialize(void)
{
   kstring   routine    = "Initialize";
   kobject   paneobject = NULL;
   kobject   libobj     = NULL;
   kobject   libfilobj  = NULL;
   kstring   lpath      = NULL;
   kstring   typestring = NULL;
   kstring   libname    = NULL;
   kstring   libpath    = NULL;
   kstring   panepath   = NULL;
   xvobject  toplevel;
   xvobject  backplane;
   int       cantata_installed;
   kstring   tb_name_upper;
   int       genexec;
   char      label[KLENGTH];
   int       tbstatus;


   /*UPDATE--------------------------------------------------------
   |    This function is UGLY!
   +------------------------------------------------------------- */

   backplane = xvf_get_xvobject(gui_info->filelist_struct,
				XVF_BACKPLANE, TRUE);
   toplevel = xvw_toplevel(backplane);
   xvw_busy(toplevel, TRUE);

   paneAttributes = gui_info->obj_attributes->obj_attrs;

   strToolbox = kstring_upper(clui_info->tb_string, NULL);
   strObject = kstrdup(clui_info->oname_string);
   if (strToolbox == NULL || strObject == NULL)
   {
      kerror(NULL, routine,
	     "Failed to malloc copies of toolbox and object names.");
      return FALSE;
   }

   xvw_format_attribute(toplevel, XVW_SHELL_TITLE,
			"Composer: editing %s in toolbox %s",
			clui_info->oname_string, clui_info->tb_string);
   xvw_format_attribute(toplevel, XVW_SHELL_ICON_NAME, "%s[%s]",
			clui_info->oname_string, clui_info->tb_string);

   /*-- create the notifier popup used to keep user informed --*/
   if ((xvoNotifier = xvw_create_notifywindow(NULL, "notifier")) == NULL)
   {
      kerror(NULL, routine, "Unable to create notifier window.");
      return FALSE;
   }
   xvw_set_attributes(xvoNotifier,
		      XVW_RESIZABLE, TRUE,
		      XVW_WIDTH, 382,
		      XVW_NOTIFYWINDOW_NOTIFYFOR, toplevel,
		      XVW_NOTIFYWINDOW_TITLE, "Working . . .",
		      XVW_NOTIFYWINDOW_LABEL, "Please Wait",
		      XVW_NOTIFYWINDOW_MESSAGE, "Initializing Composer",
		      XVW_NOTIFYWINDOW_VISIBLE, TRUE,
		      NULL);

   /*-- install our info handler, which displays to the notifier --*/
   (void)kset_announcehandler(our_announce_handler);

   tb_name_upper = kstring_upper(clui_info->tb_string, NULL);
   cur_fileobj = NULL;
   xvoHelp = NULL;
   strCwd = kgetcwd(NULL, KLENGTH);

   xvf_set_attribute(paneAttributes->tb_struct,
		     XVF_TITLE, clui_info->tb_string);

   kcms_get_attribute(cmsObject, KCMS_CMOBJ_PROGTYPE, &obj_type);
   if (obj_type == KCMS_PANE)
   {
      kstring  atb;
      kstring  aoname;
      kstring  aargs;

      if (kcms_get_attribute(cmsObject,
			       KCMS_CMOBJ_GENERATE_EXECUTABLE, &genexec))
	 xvf_set_attribute(gui_info->obj_attributes->paneattrs->genexec_struct,
			XVF_TOGGLE_NUM, genexec + 1);
      if (kcms_get_attribute(cmsObject, KCMS_CMOBJ_ASSOCIATED_OBJECT,
			     &atb, &aoname, &aargs))
      {
	 xvf_set_attribute(gui_info->obj_attributes->paneattrs->tbname_struct,
			XVF_STRING_VAL, atb);
	 kfree(gui_info->obj_attributes->paneattrs->tbname);
	 gui_info->obj_attributes->paneattrs->tbname = kstrdup(atb);
	 xvf_set_attribute(gui_info->obj_attributes->paneattrs->oname_struct,
			XVF_STRING_VAL, aoname);
         kfree(gui_info->obj_attributes->paneattrs->oname);
 	 gui_info->obj_attributes->paneattrs->oname = kstrdup(aoname);
	 xvf_set_attribute(gui_info->obj_attributes->paneattrs->args_struct,
			XVF_STRING_VAL, aargs);
	 kfree(gui_info->obj_attributes->paneattrs->args);
	 gui_info->obj_attributes->paneattrs->args = kstrdup(aargs);
      }
   }
#if 0
   else
   {
      xvobject  button;

      button = xvf_get_xvobject(gui_info->obj_attributes->paneattrs_struct,
				XVF_BUTTON_OBJ, TRUE);
      if (button != NULL)
	 xvw_unmap(button);
      else
	 kerror(NULL, routine, "Couldn't get xvobject for pane button!");
   }
#endif

   typestring = kcms_attr_int2string(KCMS_CMOBJ_TYPE, obj_type);
   xvf_set_attribute(paneAttributes->otype_struct, XVF_TITLE, typestring);
   xvf_set_attribute(paneAttributes->oname_struct,
		     XVF_TITLE, clui_info->oname_string);

   if (kcms_get_attribute(cmsObject, KCMS_CMOBJ_GEN_LFILE, &libfilobj)
       && libfilobj != NULL)
      kcms_get_attribute(libfilobj, KCMS_FOBJ_FULLNAME, &lpath);
   if (obj_type != KCMS_KROUTINE || lpath == NULL)
   {
      xvf_unmap_kformstruct(gui_info->logform->logging->make_lib_struct);
      strLibrary = NULL;
      ksprintf(label, "%s::%s (%s)", tb_name_upper, clui_info->oname_string,
	       typestring);
   }
   else
   {
      kcms_get_attribute(cmsObject, KCMS_CMOBJ_GEN_LIBNAME, &libname);
      strLibrary = kstrdup(libname);
      libobj = kcms_open_cmobj(cmsToolbox, libname);
      kcms_get_attribute(libobj, KCMS_CMOBJ_OPATH, &libpath);
      ksprintf(strLibSrc, "%s/src", libpath);
      ksprintf(label, "%s::%s (%s)  [library: %s]",
	       tb_name_upper, clui_info->oname_string, typestring, libname);
   }

   xvf_set_attribute(gui_info->status_struct, XVF_TITLE, label);

   initialize_object_attributes(gui_info->obj_attributes->obj_attrs);

   tb_name_upper = kstring_3cat("$", tb_name_upper, "/", NULL);

   /*-- create text widget for output log; set title and icon --*/
   xvw_set_attribute(gui_info->logform->logging->workspace,
		     XVW_BORDER_WIDTH, 0);
   xvoLog = xvw_create_console(gui_info->logform->logging->workspace,
			       "logText");
   xvw_set_attribute(xvoLog, XVW_TACK_EDGE, KMANAGER_TACK_ALL);
   xvw_format_attribute(xvw_toplevel(gui_info->logform->logging->workspace),
			XVW_SHELL_TITLE, "Commands: %s[%s]",
			clui_info->oname_string, clui_info->tb_string);
   xvw_format_attribute(xvw_toplevel(gui_info->logform->logging->workspace),
			XVW_SHELL_ICON_NAME, "Commands: %s[%s]",
			clui_info->oname_string, clui_info->tb_string);

   /*-- object type-specific initialization of the user interface --*/
   if (kcms_get_attribute(cmsObject, KCMS_CMOBJ_UIS_PANE, &paneobject)
       && paneobject != NULL)
      kcms_get_attribute(paneobject, KCMS_FOBJ_FULLNAME, &panepath);

   if (!kcms_get_attribute(cmsToolbox, KCMS_TB_STATUS, &tbstatus))
      tbstatus = KCMS_STATUS_DEVELOPMENT;

   if (panepath == NULL || tbstatus == KCMS_STATUS_SCRATCH
       || tbstatus == KCMS_STATUS_WORK)
   {
      xvf_unmap_kformstruct(paneAttributes->install_in_cantata_struct);
   }
   else
   {
      xvf_set_attribute(paneAttributes->install_in_cantata_struct,
			XVF_ACTIVATE, 1);
      kcms_get_attribute(cmsObject, KCMS_CMOBJ_CI_INSTALLED,
			 &cantata_installed);
      xvf_set_attribute(paneAttributes->install_in_cantata_struct,
			XVF_TOGGLE_NUM, cantata_installed ? 2 : 1);
   }

   /*-- cur_file_type = COMP_UIS_LIST; --*/
   change_list_contents(COMP_UIS_LIST);

   activate_guide_buttons();

   /*-- callback on Quit button, to close the object --*/
   xvf_add_extra_call(gui_info->quit_struct,
		      (kfunc_void) quit_extra_call, (kaddr) NULL,
		      XVF_CALL_FIRST);

   xvf_set_attribute(gui_info->printfile->printpane->printer_struct,
		     XVF_STRING_VAL, kgetenv("PRINTER"));
   kfree(gui_info->printfile->printpane->printer);
   gui_info->printfile->printpane->printer = kstrdup(kgetenv("PRINTER"));

   update_categories();
   update_keywords(cmsObject, NULL);
   kcms_add_callback(cmsObject, KCMS_CMOBJ_UPDATE_DB, attribute_callback,
		     NULL);

   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
   xvw_busy(toplevel, FALSE);

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	attribute_callback - attribute callback function
|
| Purpose:	This routine is invoked by kcms whenever the
|		KCMS_CMOBJ_UPDATE_DB attribute is modified.
|		We update the "Save" and "Generate Code" buttons according
|		to the value of the attribute.
|
| Written By:	Neil Bowers
| Date:		26-may-93
------------------------------------------------------------*/
static void
attribute_callback(
   kobject   object,
   int       attribute,
   void     *client_data)
{
   unsigned long  update;


   if (!kcms_get_attribute(object, KCMS_CMOBJ_UPDATE_DB, &update))
      return;


   xvf_set_attribute(gui_info->save_struct, XVF_TITLE,
		     ((update & KCMS_UPDATE_SYNC) == KCMS_UPDATE_SYNC
		      ? "Save (needed)"
		      : "    Save     "));

   xvf_set_attribute(gui_info->logform->logging->gen_code_struct, XVF_TITLE,
		     ((update & KCMS_UPDATE_REGEN_CODE)
		      == KCMS_UPDATE_REGEN_CODE
		      ? "Generate Code (needed)"
		      : "    Generate Code     "));
}

/*-----------------------------------------------------------
| Routine Name:	activate_guide_buttons - Routine to (de)activate guides
|
| Purpose:	This routine is called upon startup to activate and
|		deactivate guide pane buttons based on the object type.
|		For example, if the object type is of type KCMS_PANE,
|		then the source code guide pane button should be deactive
|		while the uis and doc panes should be active.
|
| Written By:	Neil Bowers
| Date:		26-may-93
------------------------------------------------------------*/
static void
activate_guide_buttons(void)
{
   /*-- this should be smarter, check if there is a uis	--*/
   /*-- and other checks to see which to default to	--*/

   if (obj_type == KCMS_KROUTINE || obj_type == KCMS_XVROUTINE ||
       obj_type == KCMS_PANE)
   {
      xvf_set_attribute(gui_info->file_type_struct, XVF_TOGGLE_NUM, 1);
      change_list_contents(COMP_UIS_LIST);
   }
   else if (obj_type == KCMS_LIBRARY || obj_type == KCMS_SCRIPT)
   {
      xvf_set_attribute(gui_info->file_type_struct, XVF_TOGGLE_NUM, 2);
      change_list_contents(COMP_SRC_LIST);
   }
}

/*-----------------------------------------------------------
| Routine Name:	quit_extra_call - close down when QUIT is hit
|
| Purpose:	This extra call callback is attached the QUIT button
|		on the master form.  It closes down cleanly when the
|		user quits, closing objects etc.
|
| Input:	client_data	-	user data associated with callback,
|					which is NULL in our case.
| Written By:	Neil Bowers
| Date:		29-oct-93
------------------------------------------------------------*/
/* ARGSUSED */
static void
quit_extra_call(
   kaddr client_data)
{
   kfree(strToolbox);
   kfree(strObject);

   if (cmsObject != NULL)
      kcms_close(cmsObject);
   if (cmsToolbox != NULL)
      kcms_close(cmsToolbox);
   if (xvoHelp != NULL)
      xvw_destroy(xvoHelp);
   if (xvoNotifier != NULL)
      xvw_destroy(xvoNotifier);
}

/*-----------------------------------------------------------
| Routine Name:	initialize_object_attributes - initialize form from attributes
|
| Purpose:	This function gets attributes from the software object
|		and initialize the GUI to reflect the object's attributes.
|
| Input:	pane - pane structure from the form info tree.
| Written By:	Neil Bowers
| Date:		29-oct-93
------------------------------------------------------------*/
static void
initialize_object_attributes(
   obj_attributes_obj_attrs  *pane)
{
   kstring string;


   /*UPDATE:------------------------------------------------------------
   |    The following chunk of code will eventually be table-driven.
   |    It's ugly at the moment, but hey, it works.  I know,
   |    that's no excuse :-(
   +------------------------------------------------------------------ */

   if (kcms_get_attribute(cmsObject, KCMS_CMOBJ_AUTHOR, &string)
       && string != NULL)
   {
      xvf_set_attribute(pane->name_struct, XVF_STRING_VAL, string);
      kfree(pane->name);
      pane->name = kstrdup(string);
   }

   if (kcms_get_attribute(cmsObject, KCMS_CMOBJ_AUTHOR_EMAIL, &string)
       && string != NULL)
   {
      xvf_set_attribute(pane->email_struct, XVF_STRING_VAL, string);
      kfree(pane->email);
      pane->email = kstrdup(string);
   }

   if (kcms_get_attribute(cmsObject, KCMS_CMOBJ_CATEGORY, &string)
       && string != NULL)
   {
      xvf_set_attribute(pane->category_struct, XVF_STRING_VAL, string);
      kfree(pane->category);
      pane->category = kstrdup(string);
   }

   if (kcms_get_attribute(cmsObject, KCMS_CMOBJ_SUBCATEGORY, &string)
       && string != NULL)
   {
      xvf_set_attribute(pane->subcategory_struct, XVF_STRING_VAL, string);
      kfree(pane->subcategory);
      pane->subcategory = kstrdup(string);
   }

   if (kcms_get_attribute(cmsObject, KCMS_CMOBJ_ICON_NAME, &string)
       && string != NULL)
   {
      xvf_set_attribute(pane->icon_name_struct, XVF_STRING_VAL, string);
      kfree(pane->icon_name);
      pane->icon_name = kstrdup(string);
   }

   if (kcms_get_attribute(cmsObject, KCMS_CMOBJ_SHORT_DESC, &string)
       && string != NULL)
   {
      xvf_set_attribute(pane->description_struct, XVF_STRING_VAL, string);
      kfree(pane->description);
      pane->description = kstrdup(string);
   }
}
