/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Initialization Routines
   >>>>
   >>>>  Private:
   >>>>             check_add_ui_file()
   >>>>             check_add_src_file()
   >>>>             check_add_doc_file()
   >>>>             check_add_misc_file()
   >>>>
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "composer.h"
#include <kcms/private.h>

static int copy_template PROTO((kobject, char *, char *, int));

/*-----------------------------------------------------------
| Routine Name:	print_file_object - send a file object to a printer
|
| Purpose:	This routine will print the given file object.
|		It checks to see whether a PRINTER is specified in
|		the Printer selection on the `print' pane (which is
|		part of the Utilities subform), and uses that if so.
|
|		At the moment this routine just does a dumb lpr,
|		in future versions it will support printing commands,
|		and provide default ones, like lpr and enscript
|
| Input:	fileobj	-	the file object for the file to be printed.
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		28-oct-93
------------------------------------------------------------*/
int
print_file_object(
   kobject  fileobj)
{
   kstring  filename;
   kstring  fullpath;
   kstring  printer;
   char     command[KLENGTH];


   kcms_get_attribute(fileobj, KCMS_FOBJ_FULLNAME, &filename);
   printer = gui_info->printfile->printpane->printer;
   fullpath = kfullpath(filename, NULL, NULL);

   if (printer)
      (void)ksprintf(command, "lpr -P%s %s", printer, fullpath);
   else
      (void)ksprintf(command, "lpr %s", fullpath);

   if (xvw_system(command) != 0)
   {
      kinfo(KSTANDARD, "Attempt to print file failed.\n%s.",
	    "You may want to check the print queue.");
      return FALSE;
   }
   kinfo(KSTANDARD, "File printed successfully.");
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	select_file_object - select (make current) a file object
|
| Purpose:	This routine will takes a file object, sets the global
|		which holds the currently selected file object, and updates
|		the user interface to reflect the select file.
|
| Input:	fileobj	-	the file object for the file to be printed.
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		28-oct-93
------------------------------------------------------------*/
int
select_file_object(
   kobject fileobj)
{
   if (fileobj == NULL)
   {
      kerror(NULL, "Select File Object",
	     "Attempt to select a NULL file object.\n%s.",
	     "This shouldn't happen --- please report as a bug.");
      return FALSE;
   }

   if (fileobj == cur_fileobj)
      return TRUE;

   cur_fileobj = fileobj;
   update_file_info(cur_fileobj);

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	add_file_object - add a new file to software object
|
| Purpose:	This function is used to add a file to the software
|		object being edited.
|
| Input:	filename	-	name of the file to add.
|		should be just the filename,
|		with no path --- we assume path
|		from context.
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		19-dec-93
------------------------------------------------------------*/
void
add_file_object(
   char *filename)
{
   kstring   routine            = "add_file_object()";
   int       ftype              = KCMS_FOBJ_TYPE_MISC;
   int       fsubtype           = KCMS_FOBJ_SUBTYPE_NONE;
   kstring   directory          = "misc";
   kstring   template_path      = NULL;
   int       template           = KCMS_TEMPLATE_MISC;
   kstring   extension;
   char      fullpath[KLENGTH];
   char      temp[KLENGTH];
   char      panename[KLENGTH];
   char      formname[KLENGTH];
   kobject   file_obj;
   int       langtype           = KCMS_LANG_NONE;


   if (cur_file_type == COMP_ALL_LIST)
   {
      kerror(NULL, routine, "You can not add a file when ALL files "
	     "is selected.\nThis is a restriction which "
	     "will go away in future versions.");
      return;
   }

   /*UPDATE: memory leak with kstring_cleanup() -----------------------*/
   if (filename == NULL || kstring_cleanup(filename, NULL) == NULL)
   {
      kerror(NULL, routine, "\nPlease give a filename.");
      return;
   }

   if (kstrchr(filename, '/') != NULL)
   {
      kerror(NULL, routine, "\nRestriction for 2.1 release:\n%s.",
	     "Please give a file name only, no path");
      return;
   }

   xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
			"Adding file %s to object.", filename);
   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, TRUE);

   extension = kstrchr(filename, '.');

   /*UPDATE--------------------------------------------------------------
   |    This next block of code is a kludge for 2.1.
   |    This information will be in a table, with mappings from
   |    kcms file object types to file extensions.  *sigh*
   +-------------------------------------------------------------------*/
   switch (cur_file_type)
   {
      case COMP_UIS_LIST:
	 directory = "uis";
	 ftype = KCMS_FOBJ_TYPE_UIS;
	 langtype = KCMS_LANG_KHOROS_UIS;
	 ksprintf(panename, "%s.pane", strObject);
	 ksprintf(formname, "%s.form", strObject);
	 if (!kstrcmp(filename, panename))
	 {
	    fsubtype = KCMS_FOBJ_SUBTYPE_PANE;
            template = KCMS_TEMPLATE_UIS_PANE;
	 }
	 else if (!kstrcmp(filename, formname))
	 {
	    fsubtype = KCMS_FOBJ_SUBTYPE_FORM;
            template = KCMS_TEMPLATE_UIS_FORM;
	 }
	 else
	 {
	    /*-- add the file as a miscellaneous UIS file -------------*/
	    fsubtype = KCMS_FOBJ_SUBTYPE_MISC;
	    template = KCMS_TEMPLATE_UIS_PANE;
	 }
	 break;

      case COMP_SRC_LIST:
	 if (obj_type == KCMS_PANE)
	    kerror(NULL, routine, "Pane objects can not have source.");
	 else
	 {
	    directory = "src";
	    ftype = KCMS_FOBJ_TYPE_SRC;
	    langtype = KCMS_LANG_C;
	    if (!kstrcasecmp(extension, ".c") || !kstrcmp(extension, ".cc"))
	    {
	       template = (obj_type == KCMS_LIBRARY)
                          ? KCMS_TEMPLATE_SRC_LIBRARY
			  : KCMS_TEMPLATE_SRC_PROGRAM;
	       fsubtype = KCMS_FOBJ_SUBTYPE_C;
	    }
	    else if (!kstrcmp(extension, ".h"))
	    {
	       fsubtype = KCMS_FOBJ_SUBTYPE_INCL;
               template = KCMS_TEMPLATE_SRC_INCLUDE;
	    }
	    else if (!kstrcasecmp(extension, ".f"))
	    {
	       langtype = KCMS_LANG_FORTRAN;
	       template = (obj_type == KCMS_LIBRARY)
                          ? KCMS_TEMPLATE_FORTRAN_LIBRARY
			  : KCMS_TEMPLATE_FORTRAN_PROGRAM;
	       fsubtype = KCMS_FOBJ_SUBTYPE_FORTRAN;
	    }
	    else
	    {
	       kerror(NULL, routine, "SRC files must have an "
		      "extension of .c, .cc, .C, or .h");
	    }
	 }
	 break;

      case COMP_MISC_LIST:
	 directory = "misc";
	 ftype     = KCMS_FOBJ_TYPE_MISC;
	 fsubtype  = KCMS_FOBJ_SUBTYPE_NONE;
         template  = KCMS_TEMPLATE_MISC;
	 break;

      case COMP_INFO_LIST:
         directory = "info";
         ftype     = KCMS_FOBJ_TYPE_INFO;
	 if (!kstrcmp(extension, ".todo"))
	 {
	    fsubtype = KCMS_FOBJ_SUBTYPE_TODO;
            template = KCMS_TEMPLATE_TODO;
	 }
	 else if (!kstrcmp(extension, ".bugs"))
	 {
	    fsubtype = KCMS_FOBJ_SUBTYPE_BUGS;
            template = KCMS_TEMPLATE_BUGS;
	 }
	 else if (!kstrcmp(extension, ".done"))
	 {
	    fsubtype = KCMS_FOBJ_SUBTYPE_DONE;
            template = KCMS_TEMPLATE_DONE;
	 }
	 else if (!kstrcmp(extension, ".changelog"))
	 {
	    fsubtype = KCMS_FOBJ_SUBTYPE_CHANGELOG;
            template = KCMS_TEMPLATE_CHANGELOG;
	 }
	 else
	    kerror(NULL, routine, "INFO files must have en extension "
		   "of .todo, .bugs, .done, or .changelog");
         break;

      case COMP_DOC_LIST:
	 ftype     = KCMS_FOBJ_TYPE_HELP;
	 directory = "help";
	 langtype  = KCMS_LANG_ROFF;
	 if (!kstrcmp(extension, ".hlp"))
	 {
	    fsubtype = KCMS_FOBJ_SUBTYPE_HELP;
            template = KCMS_TEMPLATE_HLP;
	 }
	 else if (!kstrcmp(extension, ".doc"))
	 {
	    fsubtype = KCMS_FOBJ_SUBTYPE_DOC;
            template = KCMS_TEMPLATE_DOC;
	 }
	 else
	    kerror(NULL, routine, "DOC files must have en extension "
		   "of .hlp or .doc");
	 break;

      default:
	 kerror(NULL, routine, "Can't add this type of file.");
	 xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
         return;
   }

   ksprintf(fullpath, "%s/%s/%s", cmobj_opath, directory, filename);
   template_path = kcms_query_template(cmsObject, template);

   /*-- Does a file exist with the same path? -------------------------*/
   if (kaccess(fullpath, R_OK) == 0)
   {
      if (!kprompt(KFORCE, "Continue", "Cancel", TRUE,
		   "Operation: add file to software object\n\n"
		   "\tToolbox:  %s\n"
		   "\tObject:   %s\n"
		   "\tFile:     %s\n\n"
		   "A file %s already exists.\n"
		   "Do you want to continue? "
		   "(The old file will be renamed with .bak added).",
		   strToolbox, strObject, filename, fullpath))
      {
         xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
	 return;
      }
      ksprintf(temp, "%s.bak", fullpath);
      if (krename(fullpath, temp) != 0)
      {
	 kerror(NULL, routine, "Rename failed - aborting.");
	 xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
	 return;
      }
   }

   if (copy_template(cmsObject, template_path, fullpath, langtype))
   {
      file_obj = kcms_create_fileobj(cmsObject, fullpath,
				     NULL, ftype, fsubtype,
				     KCMS_FOBJ_GEN_NONE,
				     KCMS_FOBJ_ACCESS_RDWR);
      if (file_obj == NULL)
	 kerror(NULL, routine, "Unable to add the file");
      else
	 reload_object();
   }

   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
}


/*-----------------------------------------------------------
| Routine Name:	_kcms_copy_template - copy template file into object
|
| Purpose:	This function copies a template file into the specified
|		object, performing substitutions for standard KCMS
|		meta-strings, object name, object type, toolbox name etc
|
| Input:	object   - the software object we're copying into.
|		from     - path of template file.
|		to       - path to copy the template file to.
|		langtype - language used for file.
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		1-dec-93
------------------------------------------------------------*/
static int
copy_template(
   kobject  object,
   kstring  from,
   kstring  to,
   int      langtype)
{
   kstring  routine = "Copy Template";
   kobject  toolbox;
   kstring  oname;
   kstring  tbname;
   kstring  opath;
   kstring  typestring;
   kstring  short_copyright;
   kstring  long_copyright;
   char     file_base[KLENGTH];
   kstring  tmp;
   char     file_root[KLENGTH];
   int      otype;


   if (kaccess(from, R_OK) == -1)
      kerror(NULL, routine,
             "Could not access template for new file.\n"
	     "The template expected was:\n"
	     "\t%s\n"
	     "The new file was not created.\n", from);
   else if (!kcms_get_attribute(object, KCMS_CMOBJ_ONAME, &oname)
            || !kcms_get_attribute(object, KCMS_CMOBJ_OPATH, &opath)
	    || !kcms_get_attribute(object, KCMS_CMOBJ_PROGTYPE, &otype)
	    || !kcms_get_attribute(object, KCMS_CMOBJ_PARENTOBJ, &toolbox)
	    || !kcms_get_attribute(toolbox, KCMS_TB_NAME, &tbname))
      return FALSE;

   short_copyright = kcms_get_copyright(toolbox, KCMS_TB_COPYRIGHT_SHORT,
					langtype);
   long_copyright = kcms_get_copyright(toolbox, KCMS_TB_COPYRIGHT_LONG,
				       langtype);
   if (kbasename(to, file_base) == NULL)
   {
      kerror(NULL, routine, "Could not determine basename of destination.\n");
      return FALSE;
   }
   if ((tmp = kstrchr(file_base, '.')) == NULL)
   {
      kstrcpy(file_root, file_base);
   }
   else
   {
      kstrncpy(file_root, file_base, tmp - &file_base[0]);
      file_root[tmp - &file_base[0]] = '\0';
   }

   if ((typestring = kcms_attr_int2string(KCMS_CMOBJ_TYPE, otype)) != NULL)
      return ksedfile(from, to, FALSE, KFILE_UPDATE, NULL,
		      "#object-name#",     oname,
		      "#object-type#",     typestring,
		      "#object-path#",     opath,
		      "#toolbox-name#",    tbname,
		      "#short-copyright#", short_copyright,
		      "#long-copyright#",  long_copyright,
		      "#file-basename#",   file_root,
		      NULL);

   return FALSE;
}
