 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for composer
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _composer_h_
#define _composer_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <design.h>
#include <xvinclude.h>
#include "form_info.h"

/* -include_includes */
#include <kcms/kcms.h>
#include <kcodegen/kcodegen.h>
#include "xvlist.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#ifdef COMPOSER_GLOBALS
#	define _GLOBAL
#else
#	define _GLOBAL  extern
#endif

/*-- initialize the default editor to vi --*/
#define DEFAULT_EDITOR	"vi"

/*
 * Type of list being displayed in composer.  Will be one of src, uis,
 * doc, or misc.
 */
#define	COMP_UIS_LIST		1
#define	COMP_SRC_LIST		2
#define	COMP_DOC_LIST		3
#define COMP_INFO_LIST		4
#define COMP_MISC_LIST		5
#define COMP_CONFIG_LIST	6
#define	COMP_CM_LIST		7
#define	COMP_ALL_LIST		8


/*-- editing categories --*/
#define EDIT_ASCII		1
#define EDIT_VIEW		2
#define EDIT_SPECIAL		3
#define EDIT_DOUBLECLICK	4
/* -include_defines_end */

#define PANEPATH "$DESIGN/objects/xvroutine/composer/uis/composer.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  toolbox name (required string)
 */
char	*tb_string;	/* toolbox name STRING */
int	 tb_flag;   	/* toolbox name FLAG */

/*
 *  object name (required string)
 */
char	*oname_string;	/* object name STRING */
int	 oname_flag;   	/* object name FLAG */

/*
 *  Alternate UIS file (optional infile)
 */
char	*form_file;	/* Alternate UIS file FILENAME */
int	 form_flag;	/* Alternate UIS file FLAG */

/*
 *  (x,y) position for automatic GUI placement */

int	 x_int;		/* x position INT */
int	 x_flag;	/* x position FLAG */

int	 y_int;		/* y position INT */
int	 y_flag;	/* y position FLAG */

} clui_info_struct;

/* -include_typedefs */
	typedef struct _FileInfo
	{
		int		file_type;	/*-- file object type	--*/
		char		*title;		/*-- title string	--*/
		int		attribute;	/*-- cmobj attribute id	--*/
		int		nfiles;		/*-- number of files	--*/
		kobject		*fileobjs;
		char		**paths;	/*-- full path of files	--*/
		char		**basenames;	/*-- basename of files	--*/
		int		*pids[3];	/*-- pid x #files x 3	--*/
		xvlist_context	*context;
	} FileInfo;

	typedef struct _EditorInfo
	{
		char		*name;
		char		*command;
	} EditorInfo;

	typedef struct _EditFileInfo
	{
		int		file_type;
		EditorInfo	ascii;
		EditorInfo	view;
		EditorInfo	edit;
	} EditFileInfo;
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
extern gui_info_struct *gui_info;

/* -include_variables */
	_GLOBAL kobject                 	cmsToolbox;
        _GLOBAL kobject         	        cmsObject;
	_GLOBAL kobject				cur_fileobj;

_GLOBAL kstring   strToolbox;
_GLOBAL kstring   strObject;

	_GLOBAL char *				cmobj_opath;
	_GLOBAL char *				strCwd;
	_GLOBAL char				strLibSrc[KLENGTH];
	_GLOBAL kstring				strLibrary;

	_GLOBAL	xvobject			xvoLog;
	_GLOBAL xvobject			xvoHelp;
	_GLOBAL xvobject			xvoNotifier;

	_GLOBAL int				obj_type;
	_GLOBAL int				cur_file_type;
	
	_GLOBAL FileInfo			*cur_file_info;

	_GLOBAL obj_attributes_obj_attrs	*paneAttributes;
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
#define log_append(string)	xvw_set_attribute(xvoLog, \
						  XVW_TEXTDISPLAY_ADDTEXT, \
						  string)
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void composer_get_args PROTO((kform *));
void composer_usage_additions PROTO((void));
void composer_free_args PROTO((int, kaddr));

/* -include_routines */
/*-- initialize.c */

int	initialize				PROTO((void));
void	subform_button_detect			PROTO((kaddr));
void	init_object_info			PROTO((kaddr));

/*-- files.c --*/
int	check_add_ui_file			PROTO((char *,char **));
int	check_add_src_file			PROTO((char *,int,char **));
int	check_add_doc_file			PROTO((char *,char **));
int	check_add_misc_file			PROTO((char *,char *,char **));
kobject	find_file_in_list			PROTO((char *));
int	copy_file				PROTO((char *,char *,int,int));
int	print_file_object			PROTO((kobject));
int	select_file_object			PROTO((kobject));
void	add_file_object				PROTO((char *));


/*-- list.c --*/

void		initialize_lists		PROTO((void));
void		change_list_contents		PROTO((int));
FileInfo *	get_file_info			PROTO((int));
EditFileInfo *	get_edit_info			PROTO((int, int));
void		clear_file_table		PROTO((void));

/*--| editor.c |--*/

int		edit_file_object		PROTO((kobject,int));
char *		interpolate_editor_string	PROTO((char *,kobject));

/*--| utilities.c |--*/

int		log_command		    PROTO((char *,int));
int		reload_object		    PROTO((void));
void		update_categories	    PROTO((void));
void		update_file_info	    PROTO((kobject));
int		gui_info_handler	    PROTO((char *));
void            update_keywords             PROTO((kobject, kstring));
int             our_announce_handler        PROTO((kstring, kstring, kstring,
						   kstring, kstring));
void            composer_grep_object        PROTO((kobject, kstring));
/* -include_routines_end */

#endif
