/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for composer
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "composer.h"

clui_info_struct *clui_info = NULL;

gui_info_struct *gui_info;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Software object creation and management
|
|       Purpose: main program for composer
|
|         Input:
|		char *clui_info->tb_string; {toolbox name}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {object name}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *form;            /* form tree representing *.form file */
	char   *form_filestring; /* *.form file for composer    */ 
	char   *form_pathname;   /* location of composer.form   */
	char   *form_fullpath;   /* expanded composer.form path */
	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
   char *opath;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DESIGN");
	kexit_handler(composer_free_args, NULL);

/* -main_get_args_call */
   pane = kgen_initialize(PANEPATH, KGEN_XVROUTINE, "DESIGN", "composer",
			  composer_usage_additions);

   composer_get_args(pane);
   kvf_destroy_form(pane);

   if ((cmsToolbox = kcms_open_toolbox(clui_info->tb_string)) == NULL)
   {
      kerror(NULL, "Open Toolbox", "Unable to open toolbox `%s'.",
	     clui_info->tb_string);
      kexit(KEXIT_FAILURE);
   }

   cmsObject = kcms_open_cmobj(cmsToolbox, clui_info->oname_string);
   if (cmsObject == NULL)
   {
      kcms_close(cmsToolbox);
      kerror(NULL, "Open Object",
	     "Unable to open object `%s' in toolbox `%s'.",
	     clui_info->oname_string,
	     clui_info->tb_string);
      kexit(KEXIT_FAILURE);
   }

   kcms_get_attribute(cmsObject, KCMS_CMOBJ_OPATH, &opath);
   cmobj_opath = kstrdup(opath);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

	/*
	 * Set location of composer.form
	 */
	if (clui_info->form_flag)
	{
	    form_filestring = kstrdup(clui_info->form_file);
	    form_pathname   = NULL;
	}
	else
	{
	    form_filestring = kstrdup("composer.form");
	    form_pathname   = kstrdup("$TOOLBOX/objects/xvroutine/composer/uis");
	}
	form_fullpath   = kfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Allocate the GUI Info structure 
	 */
	gui_info = (gui_info_struct *)
				kcalloc (1, sizeof (gui_info_struct));
	/*
	 * Create the forms for composer 
	 */
	form = xvf_create_form(form_fullpath, NONE, run_composer, gui_info,
				clui_info->x_int, clui_info->y_int,
				XVF_PARTIAL_EDIT);
	if (form == NULL)
	   kexit(KEXIT_FAILURE);

	/*
	 * Initialize the GUI Info structure 
	 */
	if (!(_xvf_init_composer(form, gui_info)))
	    kexit(KEXIT_FAILURE);

/* -main_before_lib_call */
   if (!initialize())
      kexit(KEXIT_FAILURE);
/* -main_before_lib_call_end */

/* -main_library_call */
   xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */

	kfree(form_filestring);
	kfree(form_pathname);
	kfree(form_fullpath);

	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: composer_usage_additions
| 
|       Purpose: Prints usage additions in composer_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname composer
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void composer_usage_additions(void)
{
	kfprintf(kstderr, "\tSoftware object creation and management\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: composer_free_args
| 
|       Purpose: Frees CLUI struct allocated in composer_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname composer
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
composer_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
		kfree(clui_info->form_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
