 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_cantata
   >>>> 	_xvf_free_cantata
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_cantata_warning
   >>>> 	_xvf_init_cantata_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "cantata.h"

static void _xvf_init_cantata_warning PROTO((char *));
static void _xvf_init_cantata_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_cantata
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_cantata_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_cantata(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	kcontrol   *master;

	master = form->master;
	/*
	 * initializing 'cantata' Form Info structure
	 */

	forminfo->options_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.options");
	if (forminfo->options_struct == NULL)
	    _xvf_init_cantata_warning("unknown selection 'options' on master form");

	forminfo->bugs_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.bugs");
	if (forminfo->bugs_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'bugs' on master form");

	forminfo->license_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.license");
	if (forminfo->license_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'license' on master form");

	forminfo->help1_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.help1");
	if (forminfo->help1_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help1' on master form");

	forminfo->quit_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.quit");
	if (forminfo->quit_struct == NULL)
		    _xvf_init_cantata_warning("quit button 'quit' on master form");
	forminfo->quit = FALSE;

	forminfo->workspace_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.workspace");
	if (forminfo->workspace_struct == NULL)
	    _xvf_init_cantata_warning("workspace 'workspace' on master form");
	else
	{
	    kvf_get_attribute(forminfo->workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->workspace));

	}
	forminfo->wksp_attributes_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.wksp_attributes");
	if (forminfo->wksp_attributes_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'wksp_attributes' on master form");
	forminfo->wksp_attributes = FALSE;
	selection = forminfo->wksp_attributes_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->workspace_menu_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.workspace_menu");
	if (forminfo->workspace_menu_struct == NULL)
	    _xvf_init_cantata_warning("unknown selection 'workspace_menu' on master form");

	forminfo->run_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.run");
	if (forminfo->run_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'run' on master form");
	forminfo->run = FALSE;
	selection = forminfo->run_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->reset_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.reset");
	if (forminfo->reset_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'reset' on master form");
	forminfo->reset = FALSE;
	selection = forminfo->reset_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->clear_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.clear");
	if (forminfo->clear_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'clear' on master form");
	forminfo->clear = FALSE;
	selection = forminfo->clear_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->check_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.check");
	if (forminfo->check_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'check' on master form");
	forminfo->check = FALSE;
	selection = forminfo->check_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->redraw_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.redraw");
	if (forminfo->redraw_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'redraw' on master form");
	forminfo->redraw = FALSE;
	selection = forminfo->redraw_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->wksp_info_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.wksp_info");
	if (forminfo->wksp_info_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'wksp_info' on master form");
	forminfo->wksp_info = FALSE;
	selection = forminfo->wksp_info_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->b4_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.b4");
	if (forminfo->b4_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'b4' on master form");
	forminfo->panel_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.panel");
	if (forminfo->panel_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'panel' on master form");
	forminfo->panel = FALSE;
	selection = forminfo->panel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->export_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.export");
	if (forminfo->export_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'export' on master form");
	forminfo->export = FALSE;
	selection = forminfo->export_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->b5_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.b5");
	if (forminfo->b5_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'b5' on master form");
	forminfo->create_procedure_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.create_procedure");
	if (forminfo->create_procedure_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'create_procedure' on master form");
	forminfo->create_procedure = FALSE;
	selection = forminfo->create_procedure_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->create_countloop_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.create_countloop");
	if (forminfo->create_countloop_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'create_countloop' on master form");
	forminfo->create_countloop = FALSE;
	selection = forminfo->create_countloop_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->create_whileloop_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.create_whileloop");
	if (forminfo->create_whileloop_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'create_whileloop' on master form");
	forminfo->create_whileloop = FALSE;
	selection = forminfo->create_whileloop_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->b6_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.b6");
	if (forminfo->b6_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'b6' on master form");
	forminfo->b7_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.b7");
	if (forminfo->b7_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'b7' on master form");
	forminfo->help2_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.help2");
	if (forminfo->help2_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help2' on master form");

	forminfo->clipboard_menu_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.clipboard_menu");
	if (forminfo->clipboard_menu_struct == NULL)
	    _xvf_init_cantata_warning("unknown selection 'clipboard_menu' on master form");

	forminfo->copy_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.copy");
	if (forminfo->copy_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'copy' on master form");
	forminfo->copy = FALSE;
	selection = forminfo->copy_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->cut_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.cut");
	if (forminfo->cut_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'cut' on master form");
	forminfo->cut = FALSE;
	selection = forminfo->cut_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->paste_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.paste");
	if (forminfo->paste_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'paste' on master form");
	forminfo->paste = FALSE;
	selection = forminfo->paste_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->duplicate_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.duplicate");
	if (forminfo->duplicate_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'duplicate' on master form");
	forminfo->duplicate = FALSE;
	selection = forminfo->duplicate_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->raise_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.raise");
	if (forminfo->raise_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'raise' on master form");
	forminfo->raise = FALSE;
	selection = forminfo->raise_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->lower_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.lower");
	if (forminfo->lower_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'lower' on master form");
	forminfo->lower = FALSE;
	selection = forminfo->lower_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->delete_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.delete");
	if (forminfo->delete_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'delete' on master form");
	forminfo->delete = FALSE;
	selection = forminfo->delete_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->undo_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.undo");
	if (forminfo->undo_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'undo' on master form");
	forminfo->undo = FALSE;
	selection = forminfo->undo_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->b1_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.b1");
	if (forminfo->b1_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'b1' on master form");
	forminfo->select_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.select");
	if (forminfo->select_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'select' on master form");
	forminfo->select = FALSE;
	selection = forminfo->select_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->unselect_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.unselect");
	if (forminfo->unselect_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'unselect' on master form");
	forminfo->unselect = FALSE;
	selection = forminfo->unselect_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->b2_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.b2");
	if (forminfo->b2_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'b2' on master form");
	forminfo->show_clipboard_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.show_clipboard");
	if (forminfo->show_clipboard_struct == NULL)
	    _xvf_init_cantata_warning("master action button 'show_clipboard' on master form");
	forminfo->show_clipboard = FALSE;
	selection = forminfo->show_clipboard_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->b3_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.b3");
	if (forminfo->b3_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'b3' on master form");
	forminfo->help3_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.help3");
	if (forminfo->help3_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help3' on master form");

	forminfo->b0_struct =
	    kvf_create_struct_from_selname(master->sel_list, "cantata.b0");
	if (forminfo->b0_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'b0' on master form");
	forminfo->consoleform_struct =
	    kvf_create_struct_from_subformname(form, "cantata.consoleform");
	if (forminfo->consoleform_struct == NULL)
	{
	    _xvf_init_cantata_error("subform 'consoleform' on form 'cantata'", 
			    "cantata_consoleform");
	    return(FALSE);
	}

	/*
	 * initializing 'cantata->consoleform' Subform Info structure
	 */

	forminfo->consoleform = (cantata_consoleform *)
				kcalloc(1, sizeof(cantata_consoleform));
	subform = forminfo->consoleform_struct->Subformptr;

	/*
	 * initializing 'cantata->consoleform->console' Pane Info structure
	 */

	forminfo->consoleform->console = (consoleform_console *)
				kcalloc(1, sizeof(consoleform_console));
	forminfo->consoleform->console_struct =
	    kvf_create_struct_from_panename(subform, "cantata.consoleform.console");
	if (forminfo->consoleform->console_struct == NULL)
	{
	    _xvf_init_cantata_error("pane 'console' on subform 'consoleform'", "consoleform_console");
	    return(FALSE);
	}
	pane = forminfo->consoleform->console_struct->Controlptr;
	forminfo->consoleform->console->clear_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.consoleform.console.clear");
	if (forminfo->consoleform->console->clear_struct == NULL)
	    _xvf_init_cantata_warning("pane action button 'clear' on pane 'console' of subform 'consoleform'");
	forminfo->consoleform->console->clear = FALSE;
	selection = forminfo->consoleform->console->clear_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->consoleform->console->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.consoleform.console.help");
	if (forminfo->consoleform->console->help_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help' on pane 'console' of subform 'consoleform'");

	forminfo->consoleform->console->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.consoleform.console.quit");
	if (forminfo->consoleform->console->quit_struct == NULL)
		    _xvf_init_cantata_warning("quit button 'quit' on pane 'console' of subform 'consoleform'");
	forminfo->consoleform->console->quit = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_consoleform(forminfo->consoleform);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_console(forminfo->consoleform->console);
	forminfo->consoleform->console->wksp_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.consoleform.console.wksp");
	if (forminfo->consoleform->console->wksp_struct == NULL)
	    _xvf_init_cantata_warning("workspace 'wksp' on pane 'console' of subform 'consoleform'");
	else
	{
	    kvf_get_attribute(forminfo->consoleform->console->wksp_struct, KVF_WORKSPACE,
	                    &(forminfo->consoleform->console->wksp));

	}
	forminfo->preferences_struct =
	    kvf_create_struct_from_subformname(form, "cantata.preferences");
	if (forminfo->preferences_struct == NULL)
	{
	    _xvf_init_cantata_error("subform 'preferences' on form 'cantata'", 
			    "cantata_preferences");
	    return(FALSE);
	}

	/*
	 * initializing 'cantata->preferences' Subform Info structure
	 */

	forminfo->preferences = (cantata_preferences *)
				kcalloc(1, sizeof(cantata_preferences));
	subform = forminfo->preferences_struct->Subformptr;

	/*
	 * initializing 'cantata->preferences->customize' Pane Info structure
	 */

	forminfo->preferences->customize = (preferences_customize *)
				kcalloc(1, sizeof(preferences_customize));
	forminfo->preferences->customize_struct =
	    kvf_create_struct_from_panename(subform, "cantata.preferences.customize");
	if (forminfo->preferences->customize_struct == NULL)
	{
	    _xvf_init_cantata_error("pane 'customize' on subform 'preferences'", "preferences_customize");
	    return(FALSE);
	}
	pane = forminfo->preferences->customize_struct->Controlptr;
	forminfo->preferences->customize->change_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.preferences.customize.change");
	if (forminfo->preferences->customize->change_struct == NULL)
	    _xvf_init_cantata_warning("pane action button 'change' on pane 'customize' of subform 'preferences'");
	forminfo->preferences->customize->change = FALSE;
	selection = forminfo->preferences->customize->change_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->preferences->customize->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.preferences.customize.help");
	if (forminfo->preferences->customize->help_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help' on pane 'customize' of subform 'preferences'");

	forminfo->preferences->customize->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.preferences.customize.quit");
	if (forminfo->preferences->customize->quit_struct == NULL)
		    _xvf_init_cantata_warning("quit button 'quit' on pane 'customize' of subform 'preferences'");
	forminfo->preferences->customize->quit = FALSE;

	forminfo->preferences->customize->toolboxes_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.preferences.customize.toolboxes");
	if (forminfo->preferences->customize->toolboxes_struct != NULL)
	{
	    selection = forminfo->preferences->customize->toolboxes_struct->Selptr;
	    kvf_get_attribute(forminfo->preferences->customize->toolboxes_struct, KVF_LIST_VAL,
	                    &(forminfo->preferences->customize->toolboxes));
	    kvf_get_attribute(forminfo->preferences->customize->toolboxes_struct, KVF_LIST_LABEL,
	                    &(forminfo->preferences->customize->toolboxes_label));
	}
	else
	    _xvf_init_cantata_warning("displaylist selection 'toolboxes' on pane 'customize' of subform 'preferences'");

	forminfo->preferences->customize->toolboxes_selected = FALSE;

	forminfo->preferences->customize->objects_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.preferences.customize.objects");
	if (forminfo->preferences->customize->objects_struct != NULL)
	{
	    selection = forminfo->preferences->customize->objects_struct->Selptr;
	    kvf_get_attribute(forminfo->preferences->customize->objects_struct, KVF_LIST_VAL,
	                    &(forminfo->preferences->customize->objects));
	    kvf_get_attribute(forminfo->preferences->customize->objects_struct, KVF_LIST_LABEL,
	                    &(forminfo->preferences->customize->objects_label));
	}
	else
	    _xvf_init_cantata_warning("displaylist selection 'objects' on pane 'customize' of subform 'preferences'");

	forminfo->preferences->customize->objects_selected = FALSE;

	forminfo->preferences->customize->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.preferences.customize.tbname");
	if (forminfo->preferences->customize->tbname_struct != NULL)
	{
	    selection = forminfo->preferences->customize->tbname_struct->Selptr;
	    kvf_get_attribute(forminfo->preferences->customize->tbname_struct, KVF_STRING_DEF,
	                    &(forminfo->preferences->customize->tbname));
	}
	else
	    _xvf_init_cantata_warning("string selection 'tbname' on pane 'customize' of subform 'preferences'");

	forminfo->preferences->customize->tbname_selected = FALSE;

	forminfo->preferences->customize->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.preferences.customize.oname");
	if (forminfo->preferences->customize->oname_struct != NULL)
	{
	    selection = forminfo->preferences->customize->oname_struct->Selptr;
	    kvf_get_attribute(forminfo->preferences->customize->oname_struct, KVF_STRING_DEF,
	                    &(forminfo->preferences->customize->oname));
	}
	else
	    _xvf_init_cantata_warning("string selection 'oname' on pane 'customize' of subform 'preferences'");

	forminfo->preferences->customize->oname_selected = FALSE;

	forminfo->preferences->customize->icon_name_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.preferences.customize.icon_name");
	if (forminfo->preferences->customize->icon_name_struct != NULL)
	{
	    selection = forminfo->preferences->customize->icon_name_struct->Selptr;
	    kvf_get_attribute(forminfo->preferences->customize->icon_name_struct, KVF_STRING_DEF,
	                    &(forminfo->preferences->customize->icon_name));
	}
	else
	    _xvf_init_cantata_warning("string selection 'icon_name' on pane 'customize' of subform 'preferences'");

	forminfo->preferences->customize->icon_name_selected = FALSE;

	forminfo->preferences->customize->category_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.preferences.customize.category");
	if (forminfo->preferences->customize->category_struct != NULL)
	{
	    selection = forminfo->preferences->customize->category_struct->Selptr;
	    kvf_get_attribute(forminfo->preferences->customize->category_struct, KVF_STRING_DEF,
	                    &(forminfo->preferences->customize->category));
	}
	else
	    _xvf_init_cantata_warning("string list selection 'category' on pane 'customize' of subform 'preferences'");

	forminfo->preferences->customize->category_selected = FALSE;

	forminfo->preferences->customize->subcategory_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.preferences.customize.subcategory");
	if (forminfo->preferences->customize->subcategory_struct != NULL)
	{
	    selection = forminfo->preferences->customize->subcategory_struct->Selptr;
	    kvf_get_attribute(forminfo->preferences->customize->subcategory_struct, KVF_STRING_DEF,
	                    &(forminfo->preferences->customize->subcategory));
	}
	else
	    _xvf_init_cantata_warning("string list selection 'subcategory' on pane 'customize' of subform 'preferences'");

	forminfo->preferences->customize->subcategory_selected = FALSE;

	forminfo->create_struct =
	    kvf_create_struct_from_subformname(form, "cantata.create");
	if (forminfo->create_struct == NULL)
	{
	    _xvf_init_cantata_error("subform 'create' on form 'cantata'", 
			    "cantata_create");
	    return(FALSE);
	}

	/*
	 * initializing 'cantata->create' Subform Info structure
	 */

	forminfo->create = (cantata_create *)
				kcalloc(1, sizeof(cantata_create));
	subform = forminfo->create_struct->Subformptr;

	/*
	 * initializing 'cantata->create->program' Pane Info structure
	 */

	forminfo->create->program = (create_program *)
				kcalloc(1, sizeof(create_program));
	forminfo->create->program_struct =
	    kvf_create_struct_from_panename(subform, "cantata.create.program");
	if (forminfo->create->program_struct == NULL)
	{
	    _xvf_init_cantata_error("pane 'program' on subform 'create'", "create_program");
	    return(FALSE);
	}
	pane = forminfo->create->program_struct->Controlptr;
	forminfo->create->program->create_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.create.program.create");
	if (forminfo->create->program->create_struct == NULL)
	    _xvf_init_cantata_warning("pane action button 'create' on pane 'program' of subform 'create'");
	forminfo->create->program->create = FALSE;
	selection = forminfo->create->program->create_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->create->program->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.create.program.help");
	if (forminfo->create->program->help_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help' on pane 'program' of subform 'create'");

	forminfo->create->program->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.create.program.quit");
	if (forminfo->create->program->quit_struct == NULL)
		    _xvf_init_cantata_warning("quit button 'quit' on pane 'program' of subform 'create'");
	forminfo->create->program->quit = FALSE;

	forminfo->create->program->toolboxes_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.create.program.toolboxes");
	if (forminfo->create->program->toolboxes_struct != NULL)
	{
	    selection = forminfo->create->program->toolboxes_struct->Selptr;
	    kvf_get_attribute(forminfo->create->program->toolboxes_struct, KVF_LIST_VAL,
	                    &(forminfo->create->program->toolboxes));
	    kvf_get_attribute(forminfo->create->program->toolboxes_struct, KVF_LIST_LABEL,
	                    &(forminfo->create->program->toolboxes_label));
	}
	else
	    _xvf_init_cantata_warning("displaylist selection 'toolboxes' on pane 'program' of subform 'create'");

	forminfo->create->program->toolboxes_selected = FALSE;

	forminfo->create->program->objects_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.create.program.objects");
	if (forminfo->create->program->objects_struct != NULL)
	{
	    selection = forminfo->create->program->objects_struct->Selptr;
	    kvf_get_attribute(forminfo->create->program->objects_struct, KVF_LIST_VAL,
	                    &(forminfo->create->program->objects));
	    kvf_get_attribute(forminfo->create->program->objects_struct, KVF_LIST_LABEL,
	                    &(forminfo->create->program->objects_label));
	}
	else
	    _xvf_init_cantata_warning("displaylist selection 'objects' on pane 'program' of subform 'create'");

	forminfo->create->program->objects_selected = FALSE;

	forminfo->create->program->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.create.program.tbname");
	if (forminfo->create->program->tbname_struct != NULL)
	{
	    selection = forminfo->create->program->tbname_struct->Selptr;
	    kvf_get_attribute(forminfo->create->program->tbname_struct, KVF_STRING_DEF,
	                    &(forminfo->create->program->tbname));
	}
	else
	    _xvf_init_cantata_warning("string selection 'tbname' on pane 'program' of subform 'create'");


	forminfo->create->program->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.create.program.oname");
	if (forminfo->create->program->oname_struct != NULL)
	{
	    selection = forminfo->create->program->oname_struct->Selptr;
	    kvf_get_attribute(forminfo->create->program->oname_struct, KVF_STRING_DEF,
	                    &(forminfo->create->program->oname));
	}
	else
	    _xvf_init_cantata_warning("string selection 'oname' on pane 'program' of subform 'create'");


	forminfo->create->program->icon_name_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.create.program.icon_name");
	if (forminfo->create->program->icon_name_struct != NULL)
	{
	    selection = forminfo->create->program->icon_name_struct->Selptr;
	    kvf_get_attribute(forminfo->create->program->icon_name_struct, KVF_STRING_DEF,
	                    &(forminfo->create->program->icon_name));
	}
	else
	    _xvf_init_cantata_warning("string selection 'icon_name' on pane 'program' of subform 'create'");


	forminfo->create->program->category_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.create.program.category");
	if (forminfo->create->program->category_struct != NULL)
	{
	    selection = forminfo->create->program->category_struct->Selptr;
	    kvf_get_attribute(forminfo->create->program->category_struct, KVF_STRING_DEF,
	                    &(forminfo->create->program->category));
	}
	else
	    _xvf_init_cantata_warning("string list selection 'category' on pane 'program' of subform 'create'");

	forminfo->create->program->category_selected = FALSE;

	forminfo->create->program->subcategory_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.create.program.subcategory");
	if (forminfo->create->program->subcategory_struct != NULL)
	{
	    selection = forminfo->create->program->subcategory_struct->Selptr;
	    kvf_get_attribute(forminfo->create->program->subcategory_struct, KVF_STRING_DEF,
	                    &(forminfo->create->program->subcategory));
	}
	else
	    _xvf_init_cantata_warning("string list selection 'subcategory' on pane 'program' of subform 'create'");


	forminfo->annotationform_struct =
	    kvf_create_struct_from_subformname(form, "cantata.annotationform");
	if (forminfo->annotationform_struct == NULL)
	{
	    _xvf_init_cantata_error("subform 'annotationform' on form 'cantata'", 
			    "cantata_annotationform");
	    return(FALSE);
	}

	/*
	 * initializing 'cantata->annotationform' Subform Info structure
	 */

	forminfo->annotationform = (cantata_annotationform *)
				kcalloc(1, sizeof(cantata_annotationform));
	subform = forminfo->annotationform_struct->Subformptr;

	/*
	 * initializing 'cantata->annotationform->annotations' Pane Info structure
	 */

	forminfo->annotationform->annotations = (annotationform_annotations *)
				kcalloc(1, sizeof(annotationform_annotations));
	forminfo->annotationform->annotations_struct =
	    kvf_create_struct_from_panename(subform, "cantata.annotationform.annotations");
	if (forminfo->annotationform->annotations_struct == NULL)
	{
	    _xvf_init_cantata_error("pane 'annotations' on subform 'annotationform'", "annotationform_annotations");
	    return(FALSE);
	}
	pane = forminfo->annotationform->annotations_struct->Controlptr;
	forminfo->annotationform->annotations->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.annotationform.annotations.help");
	if (forminfo->annotationform->annotations->help_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help' on pane 'annotations' of subform 'annotationform'");

	forminfo->annotationform->annotations->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.annotationform.annotations.quit");
	if (forminfo->annotationform->annotations->quit_struct == NULL)
		    _xvf_init_cantata_warning("quit button 'quit' on pane 'annotations' of subform 'annotationform'");
	forminfo->annotationform->annotations->quit = FALSE;

	forminfo->annotationform->annotations->restore_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.annotationform.annotations.restore");
	if (forminfo->annotationform->annotations->restore_struct != NULL)
	{
	    selection = forminfo->annotationform->annotations->restore_struct->Selptr;
	    kvf_get_attribute(forminfo->annotationform->annotations->restore_struct, KVF_FILE_DEF,
	                    &(forminfo->annotationform->annotations->restore));
	}
	else
	    _xvf_init_cantata_warning("input selection 'restore' on pane 'annotations' of subform 'annotationform'");

	forminfo->annotationform->annotations->restore_selected = FALSE;

	forminfo->annotationform->annotations->save_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.annotationform.annotations.save");
	if (forminfo->annotationform->annotations->save_struct != NULL)
	{
	    selection = forminfo->annotationform->annotations->save_struct->Selptr;
	    kvf_get_attribute(forminfo->annotationform->annotations->save_struct, KVF_FILE_DEF,
	                    &(forminfo->annotationform->annotations->save));
	}
	else
	    _xvf_init_cantata_warning("output selection 'save' on pane 'annotations' of subform 'annotationform'");

	forminfo->annotationform->annotations->save_selected = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_annotationform(forminfo->annotationform);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_annotations(forminfo->annotationform->annotations);
	forminfo->annotationform->annotations->wksp_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.annotationform.annotations.wksp");
	if (forminfo->annotationform->annotations->wksp_struct == NULL)
	    _xvf_init_cantata_warning("workspace 'wksp' on pane 'annotations' of subform 'annotationform'");
	else
	{
	    kvf_get_attribute(forminfo->annotationform->annotations->wksp_struct, KVF_WORKSPACE,
	                    &(forminfo->annotationform->annotations->wksp));

	}
	forminfo->dir_struct =
	    kvf_create_struct_from_subformname(form, "cantata.dir");
	if (forminfo->dir_struct == NULL)
	{
	    _xvf_init_cantata_error("subform 'dir' on form 'cantata'", 
			    "cantata_dir");
	    return(FALSE);
	}

	/*
	 * initializing 'cantata->dir' Subform Info structure
	 */

	forminfo->dir = (cantata_dir *)
				kcalloc(1, sizeof(cantata_dir));
	subform = forminfo->dir_struct->Subformptr;

	/*
	 * initializing 'cantata->dir->files' Pane Info structure
	 */

	forminfo->dir->files = (dir_files *)
				kcalloc(1, sizeof(dir_files));
	forminfo->dir->files_struct =
	    kvf_create_struct_from_panename(subform, "cantata.dir.files");
	if (forminfo->dir->files_struct == NULL)
	{
	    _xvf_init_cantata_error("pane 'files' on subform 'dir'", "dir_files");
	    return(FALSE);
	}
	pane = forminfo->dir->files_struct->Controlptr;
	forminfo->dir->files->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.dir.files.help");
	if (forminfo->dir->files->help_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help' on pane 'files' of subform 'dir'");

	forminfo->dir->files->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.dir.files.quit");
	if (forminfo->dir->files->quit_struct == NULL)
		    _xvf_init_cantata_warning("quit button 'quit' on pane 'files' of subform 'dir'");
	forminfo->dir->files->quit = FALSE;

	forminfo->dir->files->restore_workspace_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.dir.files.restore_workspace");
	if (forminfo->dir->files->restore_workspace_struct != NULL)
	{
	    selection = forminfo->dir->files->restore_workspace_struct->Selptr;
	    kvf_get_attribute(forminfo->dir->files->restore_workspace_struct, KVF_FILE_DEF,
	                    &(forminfo->dir->files->restore_workspace));
	}
	else
	    _xvf_init_cantata_warning("input selection 'restore_workspace' on pane 'files' of subform 'dir'");

	forminfo->dir->files->restore_workspace_selected = FALSE;

	forminfo->dir->files->save_workspace_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.dir.files.save_workspace");
	if (forminfo->dir->files->save_workspace_struct != NULL)
	{
	    selection = forminfo->dir->files->save_workspace_struct->Selptr;
	    kvf_get_attribute(forminfo->dir->files->save_workspace_struct, KVF_FILE_DEF,
	                    &(forminfo->dir->files->save_workspace));
	}
	else
	    _xvf_init_cantata_warning("output selection 'save_workspace' on pane 'files' of subform 'dir'");

	forminfo->dir->files->save_workspace_selected = FALSE;

	forminfo->dir->files->save_glyphs_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.dir.files.save_glyphs");
	if (forminfo->dir->files->save_glyphs_struct != NULL)
	{
	    selection = forminfo->dir->files->save_glyphs_struct->Selptr;
	    kvf_get_attribute(forminfo->dir->files->save_glyphs_struct, KVF_FILE_DEF,
	                    &(forminfo->dir->files->save_glyphs));
	}
	else
	    _xvf_init_cantata_warning("output selection 'save_glyphs' on pane 'files' of subform 'dir'");

	forminfo->dir->files->save_glyphs_selected = FALSE;

	forminfo->dir->files->tmpdir_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.dir.files.tmpdir");
	if (forminfo->dir->files->tmpdir_struct != NULL)
	{
	    selection = forminfo->dir->files->tmpdir_struct->Selptr;
	    kvf_get_attribute(forminfo->dir->files->tmpdir_struct, KVF_STRING_DEF,
	                    &(forminfo->dir->files->tmpdir));
	}
	else
	    _xvf_init_cantata_warning("string selection 'tmpdir' on pane 'files' of subform 'dir'");

	forminfo->dir->files->tmpdir_selected = FALSE;

	forminfo->dir->files->blank0_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.dir.files.blank0");
	if (forminfo->dir->files->blank0_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'blank0' on pane 'files' of subform 'dir'");
	forminfo->dir->files->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.dir.files.blank1");
	if (forminfo->dir->files->blank1_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'blank1' on pane 'files' of subform 'dir'");
	forminfo->dir->files->blank3_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.dir.files.blank3");
	if (forminfo->dir->files->blank3_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'blank3' on pane 'files' of subform 'dir'");
	forminfo->dir->files->blank4_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.dir.files.blank4");
	if (forminfo->dir->files->blank4_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'blank4' on pane 'files' of subform 'dir'");
	forminfo->list_struct =
	    kvf_create_struct_from_subformname(form, "cantata.list");
	if (forminfo->list_struct == NULL)
	{
	    _xvf_init_cantata_error("subform 'list' on form 'cantata'", 
			    "cantata_list");
	    return(FALSE);
	}

	/*
	 * initializing 'cantata->list' Subform Info structure
	 */

	forminfo->list = (cantata_list *)
				kcalloc(1, sizeof(cantata_list));
	subform = forminfo->list_struct->Subformptr;

	/*
	 * initializing 'cantata->list->routines' Pane Info structure
	 */

	forminfo->list->routines = (list_routines *)
				kcalloc(1, sizeof(list_routines));
	forminfo->list->routines_struct =
	    kvf_create_struct_from_panename(subform, "cantata.list.routines");
	if (forminfo->list->routines_struct == NULL)
	{
	    _xvf_init_cantata_error("pane 'routines' on subform 'list'", "list_routines");
	    return(FALSE);
	}
	pane = forminfo->list->routines_struct->Controlptr;
	forminfo->list->routines->open_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.list.routines.open");
	if (forminfo->list->routines->open_struct == NULL)
	    _xvf_init_cantata_warning("pane action button 'open' on pane 'routines' of subform 'list'");
	forminfo->list->routines->open = FALSE;
	selection = forminfo->list->routines->open_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->list->routines->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.list.routines.help");
	if (forminfo->list->routines->help_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help' on pane 'routines' of subform 'list'");

	forminfo->list->routines->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.list.routines.quit");
	if (forminfo->list->routines->quit_struct == NULL)
		    _xvf_init_cantata_warning("quit button 'quit' on pane 'routines' of subform 'list'");
	forminfo->list->routines->quit = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_list(forminfo->list);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_routines(forminfo->list->routines);
	forminfo->list->routines->rlists_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.list.routines.rlists");
	if (forminfo->list->routines->rlists_struct == NULL)
	    _xvf_init_cantata_warning("workspace 'rlists' on pane 'routines' of subform 'list'");
	else
	{
	    kvf_get_attribute(forminfo->list->routines->rlists_struct, KVF_WORKSPACE,
	                    &(forminfo->list->routines->rlists));

	}
	forminfo->find_struct =
	    kvf_create_struct_from_subformname(form, "cantata.find");
	if (forminfo->find_struct == NULL)
	{
	    _xvf_init_cantata_error("subform 'find' on form 'cantata'", 
			    "cantata_find");
	    return(FALSE);
	}

	/*
	 * initializing 'cantata->find' Subform Info structure
	 */

	forminfo->find = (cantata_find *)
				kcalloc(1, sizeof(cantata_find));
	subform = forminfo->find_struct->Subformptr;

	/*
	 * initializing 'cantata->find->finder' Pane Info structure
	 */

	forminfo->find->finder = (find_finder *)
				kcalloc(1, sizeof(find_finder));
	forminfo->find->finder_struct =
	    kvf_create_struct_from_panename(subform, "cantata.find.finder");
	if (forminfo->find->finder_struct == NULL)
	{
	    _xvf_init_cantata_error("pane 'finder' on subform 'find'", "find_finder");
	    return(FALSE);
	}
	pane = forminfo->find->finder_struct->Controlptr;
	forminfo->find->finder->open_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.find.finder.open");
	if (forminfo->find->finder->open_struct == NULL)
	    _xvf_init_cantata_warning("pane action button 'open' on pane 'finder' of subform 'find'");
	forminfo->find->finder->open = FALSE;
	selection = forminfo->find->finder->open_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->find->finder->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.find.finder.help");
	if (forminfo->find->finder->help_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help' on pane 'finder' of subform 'find'");

	forminfo->find->finder->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.find.finder.quit");
	if (forminfo->find->finder->quit_struct == NULL)
		    _xvf_init_cantata_warning("quit button 'quit' on pane 'finder' of subform 'find'");
	forminfo->find->finder->quit = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_find(forminfo->find);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_finder(forminfo->find->finder);
	forminfo->find->finder->flist_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.find.finder.flist");
	if (forminfo->find->finder->flist_struct == NULL)
	    _xvf_init_cantata_warning("workspace 'flist' on pane 'finder' of subform 'find'");
	else
	{
	    kvf_get_attribute(forminfo->find->finder->flist_struct, KVF_WORKSPACE,
	                    &(forminfo->find->finder->flist));

	}
	forminfo->find->finder->expr_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.find.finder.expr");
	if (forminfo->find->finder->expr_struct != NULL)
	{
	    selection = forminfo->find->finder->expr_struct->Selptr;
	    kvf_get_attribute(forminfo->find->finder->expr_struct, KVF_STRING_DEF,
	                    &(forminfo->find->finder->expr));
	}
	else
	    _xvf_init_cantata_warning("string selection 'expr' on pane 'finder' of subform 'find'");

	forminfo->find->finder->expr_selected = FALSE;

	forminfo->var_struct =
	    kvf_create_struct_from_subformname(form, "cantata.var");
	if (forminfo->var_struct == NULL)
	{
	    _xvf_init_cantata_error("subform 'var' on form 'cantata'", 
			    "cantata_var");
	    return(FALSE);
	}

	/*
	 * initializing 'cantata->var' Subform Info structure
	 */

	forminfo->var = (cantata_var *)
				kcalloc(1, sizeof(cantata_var));
	subform = forminfo->var_struct->Subformptr;

	/*
	 * initializing 'cantata->var->variables' Pane Info structure
	 */

	forminfo->var->variables = (var_variables *)
				kcalloc(1, sizeof(var_variables));
	forminfo->var->variables_struct =
	    kvf_create_struct_from_panename(subform, "cantata.var.variables");
	if (forminfo->var->variables_struct == NULL)
	{
	    _xvf_init_cantata_error("pane 'variables' on subform 'var'", "var_variables");
	    return(FALSE);
	}
	pane = forminfo->var->variables_struct->Controlptr;
	forminfo->var->variables->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.var.variables.help");
	if (forminfo->var->variables->help_struct == NULL)
		    _xvf_init_cantata_warning("unknown selection 'help' on pane 'variables' of subform 'var'");

	forminfo->var->variables->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.var.variables.quit");
	if (forminfo->var->variables->quit_struct == NULL)
		    _xvf_init_cantata_warning("quit button 'quit' on pane 'variables' of subform 'var'");
	forminfo->var->variables->quit = FALSE;

	forminfo->var->variables->expression_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.var.variables.expression");
	if (forminfo->var->variables->expression_struct != NULL)
	{
	    selection = forminfo->var->variables->expression_struct->Selptr;
	    kvf_get_attribute(forminfo->var->variables->expression_struct, KVF_STRING_DEF,
	                    &(forminfo->var->variables->expression));
	}
	else
	    _xvf_init_cantata_warning("string selection 'expression' on pane 'variables' of subform 'var'");


	forminfo->var->variables->evaluate_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.var.variables.evaluate");
	if (forminfo->var->variables->evaluate_struct == NULL)
	    _xvf_init_cantata_warning("pane action button 'evaluate' on pane 'variables' of subform 'var'");
	forminfo->var->variables->evaluate = FALSE;
	selection = forminfo->var->variables->evaluate_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->var->variables->scope_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.var.variables.scope");
	if (forminfo->var->variables->scope_struct != NULL)
	{
	    selection = forminfo->var->variables->scope_struct->Selptr;
	    kvf_get_attribute(forminfo->var->variables->scope_struct, KVF_LIST_VAL,
	                    &(forminfo->var->variables->scope));
	    kvf_get_attribute(forminfo->var->variables->scope_struct, KVF_LIST_LABEL,
	                    &(forminfo->var->variables->scope_label));
	}
	else
	    _xvf_init_cantata_warning("displaylist selection 'scope' on pane 'variables' of subform 'var'");

	forminfo->var->variables->scope_selected = FALSE;

	forminfo->var->variables->vardef_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.var.variables.vardef");
	if (forminfo->var->variables->vardef_struct != NULL)
	{
	    selection = forminfo->var->variables->vardef_struct->Selptr;
	    kvf_get_attribute(forminfo->var->variables->vardef_struct, KVF_LIST_VAL,
	                    &(forminfo->var->variables->vardef));
	    kvf_get_attribute(forminfo->var->variables->vardef_struct, KVF_LIST_LABEL,
	                    &(forminfo->var->variables->vardef_label));
	}
	else
	    _xvf_init_cantata_warning("displaylist selection 'vardef' on pane 'variables' of subform 'var'");

	forminfo->var->variables->vardef_selected = FALSE;

	forminfo->var->variables->delete_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.var.variables.delete");
	if (forminfo->var->variables->delete_struct == NULL)
	    _xvf_init_cantata_warning("pane action button 'delete' on pane 'variables' of subform 'var'");
	forminfo->var->variables->delete = FALSE;
	selection = forminfo->var->variables->delete_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->var->variables->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.var.variables.blank1");
	if (forminfo->var->variables->blank1_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'blank1' on pane 'variables' of subform 'var'");
	forminfo->var->variables->blank2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "cantata.var.variables.blank2");
	if (forminfo->var->variables->blank2_struct == NULL)
	    _xvf_init_cantata_warning("blank selection 'blank2' on pane 'variables' of subform 'var'");
	forminfo->cantata_struct =
	    kvf_create_struct_from_mastername(form, "cantata");
	if (forminfo->cantata_struct == NULL)
	{
	    _xvf_init_cantata_error("form 'cantata'",
			    "gui_info");
	    return(FALSE);
	}

	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_cantata_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_cantata_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_cantata_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_cantata_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_cantata
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_cantata_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_cantata(
    gui_info_struct *forminfo)
{
	if (forminfo->options_struct != NULL)
	    kfree(forminfo->options_struct);
	if (forminfo->bugs_struct != NULL)
	    kfree(forminfo->bugs_struct);
	if (forminfo->license_struct != NULL)
	    kfree(forminfo->license_struct);
	if (forminfo->help1_struct != NULL)
	    kfree(forminfo->help1_struct);
	if (forminfo->quit_struct != NULL)
	    kfree(forminfo->quit_struct);
	if (forminfo->workspace_struct != NULL)
	    kfree(forminfo->workspace_struct);
	if (forminfo->wksp_attributes_struct != NULL)
	    kfree(forminfo->wksp_attributes_struct);
	if (forminfo->workspace_menu_struct != NULL)
	    kfree(forminfo->workspace_menu_struct);
	if (forminfo->run_struct != NULL)
	    kfree(forminfo->run_struct);
	if (forminfo->reset_struct != NULL)
	    kfree(forminfo->reset_struct);
	if (forminfo->clear_struct != NULL)
	    kfree(forminfo->clear_struct);
	if (forminfo->check_struct != NULL)
	    kfree(forminfo->check_struct);
	if (forminfo->redraw_struct != NULL)
	    kfree(forminfo->redraw_struct);
	if (forminfo->wksp_info_struct != NULL)
	    kfree(forminfo->wksp_info_struct);
	if (forminfo->b4_struct != NULL)
	    kfree(forminfo->b4_struct);
	if (forminfo->panel_struct != NULL)
	    kfree(forminfo->panel_struct);
	if (forminfo->export_struct != NULL)
	    kfree(forminfo->export_struct);
	if (forminfo->b5_struct != NULL)
	    kfree(forminfo->b5_struct);
	if (forminfo->create_procedure_struct != NULL)
	    kfree(forminfo->create_procedure_struct);
	if (forminfo->create_countloop_struct != NULL)
	    kfree(forminfo->create_countloop_struct);
	if (forminfo->create_whileloop_struct != NULL)
	    kfree(forminfo->create_whileloop_struct);
	if (forminfo->b6_struct != NULL)
	    kfree(forminfo->b6_struct);
	if (forminfo->b7_struct != NULL)
	    kfree(forminfo->b7_struct);
	if (forminfo->help2_struct != NULL)
	    kfree(forminfo->help2_struct);
	if (forminfo->clipboard_menu_struct != NULL)
	    kfree(forminfo->clipboard_menu_struct);
	if (forminfo->copy_struct != NULL)
	    kfree(forminfo->copy_struct);
	if (forminfo->cut_struct != NULL)
	    kfree(forminfo->cut_struct);
	if (forminfo->paste_struct != NULL)
	    kfree(forminfo->paste_struct);
	if (forminfo->duplicate_struct != NULL)
	    kfree(forminfo->duplicate_struct);
	if (forminfo->raise_struct != NULL)
	    kfree(forminfo->raise_struct);
	if (forminfo->lower_struct != NULL)
	    kfree(forminfo->lower_struct);
	if (forminfo->delete_struct != NULL)
	    kfree(forminfo->delete_struct);
	if (forminfo->undo_struct != NULL)
	    kfree(forminfo->undo_struct);
	if (forminfo->b1_struct != NULL)
	    kfree(forminfo->b1_struct);
	if (forminfo->select_struct != NULL)
	    kfree(forminfo->select_struct);
	if (forminfo->unselect_struct != NULL)
	    kfree(forminfo->unselect_struct);
	if (forminfo->b2_struct != NULL)
	    kfree(forminfo->b2_struct);
	if (forminfo->show_clipboard_struct != NULL)
	    kfree(forminfo->show_clipboard_struct);
	if (forminfo->b3_struct != NULL)
	    kfree(forminfo->b3_struct);
	if (forminfo->help3_struct != NULL)
	    kfree(forminfo->help3_struct);
	if (forminfo->b0_struct != NULL)
	    kfree(forminfo->b0_struct);
	if (forminfo->consoleform->console->clear_struct != NULL)
	    kfree(forminfo->consoleform->console->clear_struct);
	if (forminfo->consoleform->console->help_struct != NULL)
	    kfree(forminfo->consoleform->console->help_struct);
	if (forminfo->consoleform->console->quit_struct != NULL)
	    kfree(forminfo->consoleform->console->quit_struct);
	if (forminfo->consoleform->console->wksp_struct != NULL)
	    kfree(forminfo->consoleform->console->wksp_struct);
	kfree(forminfo->consoleform->console);
	if (forminfo->consoleform->console_struct != NULL)
	    kfree(forminfo->consoleform->console_struct);


	if (forminfo->consoleform_struct != NULL)
	    kfree(forminfo->consoleform_struct);
	kfree(forminfo->consoleform);
	if (forminfo->preferences->customize->change_struct != NULL)
	    kfree(forminfo->preferences->customize->change_struct);
	if (forminfo->preferences->customize->help_struct != NULL)
	    kfree(forminfo->preferences->customize->help_struct);
	if (forminfo->preferences->customize->quit_struct != NULL)
	    kfree(forminfo->preferences->customize->quit_struct);
	if (forminfo->preferences->customize->toolboxes_struct != NULL)
	    kfree(forminfo->preferences->customize->toolboxes_struct);
	kfree(forminfo->preferences->customize->toolboxes_label);
	if (forminfo->preferences->customize->objects_struct != NULL)
	    kfree(forminfo->preferences->customize->objects_struct);
	kfree(forminfo->preferences->customize->objects_label);
	kfree(forminfo->preferences->customize->tbname);
	if (forminfo->preferences->customize->tbname_struct != NULL)
	    kfree(forminfo->preferences->customize->tbname_struct);
	kfree(forminfo->preferences->customize->oname);
	if (forminfo->preferences->customize->oname_struct != NULL)
	    kfree(forminfo->preferences->customize->oname_struct);
	kfree(forminfo->preferences->customize->icon_name);
	if (forminfo->preferences->customize->icon_name_struct != NULL)
	    kfree(forminfo->preferences->customize->icon_name_struct);
	kfree(forminfo->preferences->customize->category);
	if (forminfo->preferences->customize->category_struct != NULL)
	    kfree(forminfo->preferences->customize->category_struct);
	kfree(forminfo->preferences->customize->subcategory);
	if (forminfo->preferences->customize->subcategory_struct != NULL)
	    kfree(forminfo->preferences->customize->subcategory_struct);
	kfree(forminfo->preferences->customize);
	if (forminfo->preferences->customize_struct != NULL)
	    kfree(forminfo->preferences->customize_struct);


	if (forminfo->preferences_struct != NULL)
	    kfree(forminfo->preferences_struct);
	kfree(forminfo->preferences);
	if (forminfo->create->program->create_struct != NULL)
	    kfree(forminfo->create->program->create_struct);
	if (forminfo->create->program->help_struct != NULL)
	    kfree(forminfo->create->program->help_struct);
	if (forminfo->create->program->quit_struct != NULL)
	    kfree(forminfo->create->program->quit_struct);
	if (forminfo->create->program->toolboxes_struct != NULL)
	    kfree(forminfo->create->program->toolboxes_struct);
	kfree(forminfo->create->program->toolboxes_label);
	if (forminfo->create->program->objects_struct != NULL)
	    kfree(forminfo->create->program->objects_struct);
	kfree(forminfo->create->program->objects_label);
	kfree(forminfo->create->program->tbname);
	if (forminfo->create->program->tbname_struct != NULL)
	    kfree(forminfo->create->program->tbname_struct);
	kfree(forminfo->create->program->oname);
	if (forminfo->create->program->oname_struct != NULL)
	    kfree(forminfo->create->program->oname_struct);
	kfree(forminfo->create->program->icon_name);
	if (forminfo->create->program->icon_name_struct != NULL)
	    kfree(forminfo->create->program->icon_name_struct);
	kfree(forminfo->create->program->category);
	if (forminfo->create->program->category_struct != NULL)
	    kfree(forminfo->create->program->category_struct);
	kfree(forminfo->create->program->subcategory);
	if (forminfo->create->program->subcategory_struct != NULL)
	    kfree(forminfo->create->program->subcategory_struct);
	kfree(forminfo->create->program);
	if (forminfo->create->program_struct != NULL)
	    kfree(forminfo->create->program_struct);


	if (forminfo->create_struct != NULL)
	    kfree(forminfo->create_struct);
	kfree(forminfo->create);
	if (forminfo->annotationform->annotations->help_struct != NULL)
	    kfree(forminfo->annotationform->annotations->help_struct);
	if (forminfo->annotationform->annotations->quit_struct != NULL)
	    kfree(forminfo->annotationform->annotations->quit_struct);
	kfree(forminfo->annotationform->annotations->restore);
	if (forminfo->annotationform->annotations->restore_struct != NULL)
	    kfree(forminfo->annotationform->annotations->restore_struct);
	kfree(forminfo->annotationform->annotations->save);
	if (forminfo->annotationform->annotations->save_struct != NULL)
	    kfree(forminfo->annotationform->annotations->save_struct);
	if (forminfo->annotationform->annotations->wksp_struct != NULL)
	    kfree(forminfo->annotationform->annotations->wksp_struct);
	kfree(forminfo->annotationform->annotations);
	if (forminfo->annotationform->annotations_struct != NULL)
	    kfree(forminfo->annotationform->annotations_struct);


	if (forminfo->annotationform_struct != NULL)
	    kfree(forminfo->annotationform_struct);
	kfree(forminfo->annotationform);
	if (forminfo->dir->files->help_struct != NULL)
	    kfree(forminfo->dir->files->help_struct);
	if (forminfo->dir->files->quit_struct != NULL)
	    kfree(forminfo->dir->files->quit_struct);
	kfree(forminfo->dir->files->restore_workspace);
	if (forminfo->dir->files->restore_workspace_struct != NULL)
	    kfree(forminfo->dir->files->restore_workspace_struct);
	kfree(forminfo->dir->files->save_workspace);
	if (forminfo->dir->files->save_workspace_struct != NULL)
	    kfree(forminfo->dir->files->save_workspace_struct);
	kfree(forminfo->dir->files->save_glyphs);
	if (forminfo->dir->files->save_glyphs_struct != NULL)
	    kfree(forminfo->dir->files->save_glyphs_struct);
	kfree(forminfo->dir->files->tmpdir);
	if (forminfo->dir->files->tmpdir_struct != NULL)
	    kfree(forminfo->dir->files->tmpdir_struct);
	if (forminfo->dir->files->blank0_struct != NULL)
	    kfree(forminfo->dir->files->blank0_struct);
	if (forminfo->dir->files->blank1_struct != NULL)
	    kfree(forminfo->dir->files->blank1_struct);
	if (forminfo->dir->files->blank3_struct != NULL)
	    kfree(forminfo->dir->files->blank3_struct);
	if (forminfo->dir->files->blank4_struct != NULL)
	    kfree(forminfo->dir->files->blank4_struct);
	kfree(forminfo->dir->files);
	if (forminfo->dir->files_struct != NULL)
	    kfree(forminfo->dir->files_struct);


	if (forminfo->dir_struct != NULL)
	    kfree(forminfo->dir_struct);
	kfree(forminfo->dir);
	if (forminfo->list->routines->open_struct != NULL)
	    kfree(forminfo->list->routines->open_struct);
	if (forminfo->list->routines->help_struct != NULL)
	    kfree(forminfo->list->routines->help_struct);
	if (forminfo->list->routines->quit_struct != NULL)
	    kfree(forminfo->list->routines->quit_struct);
	if (forminfo->list->routines->rlists_struct != NULL)
	    kfree(forminfo->list->routines->rlists_struct);
	kfree(forminfo->list->routines);
	if (forminfo->list->routines_struct != NULL)
	    kfree(forminfo->list->routines_struct);


	if (forminfo->list_struct != NULL)
	    kfree(forminfo->list_struct);
	kfree(forminfo->list);
	if (forminfo->find->finder->open_struct != NULL)
	    kfree(forminfo->find->finder->open_struct);
	if (forminfo->find->finder->help_struct != NULL)
	    kfree(forminfo->find->finder->help_struct);
	if (forminfo->find->finder->quit_struct != NULL)
	    kfree(forminfo->find->finder->quit_struct);
	if (forminfo->find->finder->flist_struct != NULL)
	    kfree(forminfo->find->finder->flist_struct);
	kfree(forminfo->find->finder->expr);
	if (forminfo->find->finder->expr_struct != NULL)
	    kfree(forminfo->find->finder->expr_struct);
	kfree(forminfo->find->finder);
	if (forminfo->find->finder_struct != NULL)
	    kfree(forminfo->find->finder_struct);


	if (forminfo->find_struct != NULL)
	    kfree(forminfo->find_struct);
	kfree(forminfo->find);
	if (forminfo->var->variables->help_struct != NULL)
	    kfree(forminfo->var->variables->help_struct);
	if (forminfo->var->variables->quit_struct != NULL)
	    kfree(forminfo->var->variables->quit_struct);
	kfree(forminfo->var->variables->expression);
	if (forminfo->var->variables->expression_struct != NULL)
	    kfree(forminfo->var->variables->expression_struct);
	if (forminfo->var->variables->evaluate_struct != NULL)
	    kfree(forminfo->var->variables->evaluate_struct);
	if (forminfo->var->variables->scope_struct != NULL)
	    kfree(forminfo->var->variables->scope_struct);
	kfree(forminfo->var->variables->scope_label);
	if (forminfo->var->variables->vardef_struct != NULL)
	    kfree(forminfo->var->variables->vardef_struct);
	kfree(forminfo->var->variables->vardef_label);
	if (forminfo->var->variables->delete_struct != NULL)
	    kfree(forminfo->var->variables->delete_struct);
	if (forminfo->var->variables->blank1_struct != NULL)
	    kfree(forminfo->var->variables->blank1_struct);
	if (forminfo->var->variables->blank2_struct != NULL)
	    kfree(forminfo->var->variables->blank2_struct);
	kfree(forminfo->var->variables);
	if (forminfo->var->variables_struct != NULL)
	    kfree(forminfo->var->variables_struct);


	if (forminfo->var_struct != NULL)
	    kfree(forminfo->var_struct);
	kfree(forminfo->var);
	kfree(forminfo);
}
