 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane annotations
   >>>> 
   >>>>  Private: 
   >>>> 	annotations_restore
   >>>> 	annotations_save
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "cantata.h"

/*-----------------------------------------------------------
| 
|  Routine Name: annotations_restore
| 
|       Purpose: Do routine which is called when
|                  input selection restore is used
| 
|         Input: annotations_info - ptr to PaneInfo struct for annotations pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 11, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void annotations_restore(
     annotationform_annotations *annotations_info)
{
	kfile *file;
	char  *filename = annotations_info->restore;

	if ((file = kfinput(filename)) == NULL)
	{
	   kerror(NULL, "annotations_restore", "Unable to open file '%s' for \
restoring workspace annotations", !filename ? "(NULL)" : filename);
	   return;
	}
	xvw_restore_annotations(workspace, file);
	kfclose(file);
}


/*-----------------------------------------------------------
| 
|  Routine Name: annotations_save
| 
|       Purpose: Do routine which is called when
|                  output selection save is used
| 
|         Input: annotations_info - ptr to PaneInfo struct for annotations pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 11, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void annotations_save(
     annotationform_annotations *annotations_info)
{
	kfile *file;
	char  *filename = annotations_info->save;

	if ((file = kfoutput(filename)) == NULL)
	{
	   kerror(NULL, "annotations_save", "Unable to open file '%s' for \
saving workspace annotations", !filename ? "(NULL)" : filename);
	   return;
	}
	xvw_save_annotations(workspace, file);
	kfclose(file);
}
