 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for cantata
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "cantata.h"

clui_info_struct *clui_info = NULL;

gui_info_struct *gui_info;

/*-----------------------------------------------------------
|
|  Routine Name: main() - The visual programming language for Khoros
|
|       Purpose: main program for cantata
|
|         Input:
|		int clui_info->tbmenus_logic; {Create Cantata Pulldown Toolbox Menus}
|		int clui_info->tbmenus_flag; {TRUE if -tbmenus specified}
|
|		Optional M.E. group:
|		    char *clui_info->wksp_file; {file for restoring cantata workspace}
|		    int   clui_info->wksp_flag; {TRUE if -wksp specified}
|
|		    M.I. group:
|			char *clui_info->tb_string; {the toolbox in which the encapsulated workspace}
|			int   clui_info->tb_flag; {TRUE if -tb specified}
|
|			char *clui_info->oname_string; {The encapsulated workspace object name}
|			int   clui_info->oname_flag; {TRUE if -oname specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 12, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *form;            /* form tree representing *.form file */
	char   *form_filestring; /* *.form file for cantata    */ 
	char   *form_pathname;   /* location of cantata.form   */
	char   *form_fullpath;   /* expanded cantata.form path */
	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DESIGN");
	kexit_handler(cantata_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_XVROUTINE, "DESIGN", "cantata",
		cantata_usage_additions);

	cantata_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

	/*
	 * Set location of cantata.form
	 */
	if (clui_info->form_flag)
	{
	    form_filestring = kstrdup(clui_info->form_file);
	    form_pathname   = NULL;
	}
	else
	{
	    form_filestring = kstrdup("cantata.form");
	    form_pathname   = kstrdup("$TOOLBOX/objects/xvroutine/cantata/uis");
	}
	form_fullpath   = kfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Allocate the GUI Info structure 
	 */
	gui_info = (gui_info_struct *)
				kcalloc (1, sizeof (gui_info_struct));
	/*
	 * Create the forms for cantata 
	 */
	form = xvf_create_form(form_fullpath, NONE, run_cantata, gui_info,
				clui_info->x_int, clui_info->y_int,
				XVF_PARTIAL_EDIT);
	if (form == NULL)
	   kexit(KEXIT_FAILURE);

	/*
	 * Initialize the GUI Info structure 
	 */
	if (!(_xvf_init_cantata(form, gui_info)))
	    kexit(KEXIT_FAILURE);

/* -main_before_lib_call */
	/*
	 *  Busy the toplevel while we build things..
	 */
	xvw_busy(NULL, TRUE);
	initialize_cantata();
	cantata_form = form;
	xvw_busy(NULL, FALSE);

	xvf_add_extra_call(gui_info->quit_struct, cantata_exit, NULL,
			   XVF_CALL_SUBSTITUTE);
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */

	kfree(form_filestring);
	kfree(form_pathname);
	kfree(form_fullpath);

	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_usage_additions
| 
|       Purpose: Prints usage additions in cantata_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname cantata
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void cantata_usage_additions(void)
{
	kfprintf(kstderr, "\tThe visual programming language for Khoros\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: cantata_free_args
| 
|       Purpose: Frees CLUI struct allocated in cantata_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname cantata
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
cantata_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
		kfree(clui_info->form_file);
	kfree(clui_info->wksp_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
