 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         	Abstract Widget Set
   >>>>
   >>>>   Private:
   >>>>    Static:
   >>>>    Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "internals.h"

/************************************************************
*
*  Routine Name: xvw_initialize - initialize the xvwidgets library
*
*       Purpose: Opens the display, sets the widget set of choice,
*                and initializes the xvwidgets library prior to use.
*		 A call to this routine \fImust\fP be made before any other
*		 calls to routines in GUI & Visualization services
*		 are made.
*
*         Input: menu_handler - specifies the menu handling routines. 
*                               May be one of:
*                ! XVW_MENUS_XVFORMS -  Enable use of xvforms as internal menus
*                ! XVW_MENUS_NONE    -  Disable internal menus
*        Output:
*       Returns: The newly opened display on success, NULL on failure
*
*  Restrictions: 
*    Written By: Danielle Argiro & Mark Young
*          Date: Jun 17, 1993
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: 
*                Display *xvw_initialize(
*                ! kfunc_void menu_handler)
*
*******************************************************************/

/*
 {
 *   This routine actually exists in ../Athena/initialize.c,
 *   ../Olit/initialize.c, and ../Motif/initialize.c.  The appropriate 
 *   version of xvw_initialize is linked into the application, depending 
 *   on the widget set being used. 
 }
 */


/************************************************************
*
*  Routine Name: xvw_create_menubutton - create menubutton GUI object
*
*       Purpose: The \fImenubutton\fP GUI object is a button on which the 
*		 user can click to pull down a menu of items;  holding the mouse
*		 button down, the user may select an item from the menu.  
*		 Items in the menu may be \fIbutton\fP objects or \fIlabel\fP 
*		 objects.  Button object items in the menu will be highlighted
*		 when the user moves the pointer over them. If the mouse button 
*		 is released with the pointer over a button in the menu when
*		 that button has a callback installed, the button callback 
*		 will be fired normally.
*
*		 It is important to understand that the \fImenubutton\fP GUI 
*		 object is a \fIcompound\fP object.  That is, there are actually
*		 two objects created: the menubutton and the menu itself, where 
*		 the menubutton is the button that appears on the GUI,
*		 and the menu is what pops up when the user clicks on the 
*		 menubutton.
*
*		 When you create a menubutton object, the GUI object returned 
*		 is the \fIbutton\fP; this object should be referenced when 
*		 setting geometry, relative offset, and so on.  Attributes 
*		 such as label, width, and height may also be set on the 
*		 menubutton.
*
*		 However, in order to add buttons and labels to the pulldown 
*		 menu, you will to call \fIxvw_create_button()\fP and
*		 \fIxvw_create_label()\fP with the \fImenu\fP (not the 
*		 \fImenubutton\fP) as the parent.  The actual menu component
*		 of the compound menubutton object can be obtained with a call 
*		 to \fIxvw_retrieve_menu()\fP.  Unfortunately, a limitation in 
*		 the widget abstraction prevents the setting and getting of 
*		 resources directly on the menu.
*
*		 When the Athena Widget set is used, the menubutton component 
*		 of the compound object will be instantiated as an Athena 
*		 \fImenuButton\fP widget, while the menu component is 
*		 instantiated as an Athena \fIsimpleMenu\fP.  Use of the OLIT 
*		 widget set will result in the menubutton component of the 
*		 compound object being instantiated as a \fImenuButton\fP 
*		 widget, while the menu component is created internally to 
*		 the menu button, accessible as the \fImenuPane\fP.  When the
*		 Motif widget set is used, the menubutton object is 
*		 instantiated as a \fIPushButton\fP widget while the menu is
*		 created with \fIXmCreatePopupMenu\fP.
*
*		 The menubutton object has no special attributes of its own.
*
*         Input: parent - parent of the menubutton object
*                name   - name for menubutton object
*
*        Output:
*       Returns: The compound menubutton GUI object on success, NULL on failure.
*
*  Restrictions: Must be created as the child of a manager object,
*                viewport object, or rowcol object.
*    Written By: Danielle Argiro & Mark Young
*          Date: Apr 9, 1992
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvobject xvw_create_menubutton(
*                !   xvobject parent,
*                !   char     *name)
*
*******************************************************************/

/*
 {
 *   This routine actually exists in ../Athena/Athena.c, ../Olit/Olit.c,
 *   and ../Motif/Motif.c.  The appropriate version of xvw_create_menubutton
 *   is linked into the application, depending on the widget set being used. 
 }
 */


/************************************************************
*
*  Routine Name: xvw_create_button - create button GUI object
*
*       Purpose: A button object is a rectangular or oval mechanism 
*		 displaying either a text label or a pixmap. If a callback 
*                is installed on the button, software control will be passed 
*                to the callback routine when the user clicks the mouse on the
*                button.
*
*                When the Athena Widget set is used, the button object will 
*                be instantiated as an Athena \fIcommand\fP widget.  Use of 
*                the OLIT widget set will result in an instantiation of a 
*                \fIrect\fP button or an \fIoblong\fP button, depending on the 
*                value of the XVW_BUTTON_SHAPE parameter. When the Motif 
*		 widget set is used, the button is instantiated as a 
*		 PushButton widget.
*
*         Input: parent - parent of the button object
*                name   - name for button object
*
*        Output:
*       Returns: The GUI button object on success, NULL on failure.
*
*  Restrictions: Must be created as the child of a manager object,
*                a viewport object, or a menu object.
*    Written By: Danielle Argiro & Mark Young
*          Date: Apr 9, 1992 9:18
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvobject xvw_create_button(
*                !   xvobject parent,
*                !   char   *name)
*
*******************************************************************/

/*
 {
 *   This routine actually exists in ../Athena/Athena.c, ../Olit/Olit.c,
 *   and ../Motif/Motif.c.  The appropriate version of xvw_create_button
 *   is linked into the application, depending on the widget set being used. 
 }
 */


/************************************************************
*
*  Routine Name: xvw_create_label - create label GUI object
*
*       Purpose: The label GUI object displays a non-editable text 
*		 string or a pixmap.  The label object cannot have a 
*                callback installed.
*
*		 When the Athena Widget set is used, the label object 
*		 will be instantiated as an Athena \fIlabel\fP widget.  
*		 Use of the OLIT widget set will result in an 
*		 instantiation of a \fIstaticText\fP widget or a 
*		 \fIpixmap\fP widget, depending on the value of the
*		 XVW_LABEL_TYPE parameter.  When the Motif widget set is
*		 used, the label object is instantiated as an \fIxmLabel\fP 
*		 widget.  
*
*         Input: parent - parent of the label object
*                name   - name for label object
*
*        Output:
*       Returns: The label GUI object on success, NULL on failure.
*
*  Restrictions: Must be created as the child of a manager object,
*                a viewport object, or a menu object.
*    Written By: Danielle Argiro & Mark Young
*          Date: Apr 9, 1992 9:25
*      Verified:
*  Side Effects: 
* Modifications:
*   Declaration: xvobject xvw_create_label(
*                !   xvobject parent,
*                !   char   *name)
*
*******************************************************************/

/*
 {
 *   This routine actually exists in ../Athena/Athena.c, ../Olit/Olit.c,
 *   and ../Motif/Motif.c.  The appropriate version of xvw_create_label
 *   is linked into the application, depending on the widget set being used. 
 }
 */


/************************************************************
*
*  Routine Name: xvw_create_text - create text GUI object
*
*       Purpose: A text GUI object is a rectangular area in which 
*		 text may be displayed. The text may be specified directly, 
*		 or the contents of a file may be referenced instead.  
*
*		 The text GUI object may be read-only or read-write. When
*		 it is read-write, the user is allowed to edit the text in 
*		 the text GUI object; when it is read-only, an attempt to
*		 edit the text will fail, and cause a beep.   
*
*		 Text can be wrapped on words, on lines, or not at all.
*
*                Text objects may be single-line or multi-line;  multiple
*                lines of text are only allowed in multi-line text objects.
*
*		 No callback can be installed on a text GUI object (If 
*		 you need a compound, editable text object with a callback, see
*		 \fIxvw_create_textinput()\fP in the \fIxvobjects\fP library).
*
*		 When the Athena widget set is used, the text object will be 
*		 instantiated as an Athena \fIasciiText\fP widget.  Use of the 
*		 OLIT widget set will result in an instantiation of a 
*		 \fItextEdit\fP widget.  When the Motif widget set is used,
*		 the text object is instantiated as a \fIxmText\fP widget.
*
*         Input: parent - parent of the text object
*                name   - name for text object
*
*        Output:
*       Returns: The text GUI object on success, NULL on failure.
*
*  Restrictions: Must be created as the child of a manager object,
*                viewport object, or rowcol object.
*    Written By: Danielle Argiro & Mark Young
*          Date: Apr 9, 1992 9:25
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvobject xvw_create_text(
*                !   xvobject parent,
*                !   char   *name)
*
*******************************************************************/

/*
 {
 *   This routine actually exists in ../Athena/Athena.c, ../Olit/Olit.c,
 *   and ../Motif/Motif.c.  The appropriate version of xvw_create_text
 *   is linked into the application, depending on the widget set being used. 
 }
 */


/************************************************************
*
*  Routine Name: xvw_create_scrollbar - create scrollbar GUI object
*
*       Purpose: The \fIscrollbar\fP GUI object is a slider-like mechanism 
*		 called a \fIthumb\fP which the user may move back and forth 
*		 using the mouse to set a value.  
*
*		 A callback can be installed on the scrollbar for either 
*		 incremental movement or continuous movement (or both),
*		 which will be activated when the user moves the thumb of 
*		 the scrollbar.
*
*		 Creation of the scrollbar GUI object results in an 
*		 instantiation of a \fIscrollbar\fP widget in the Athena,
*                Olit, and Motif widget sets.
*
*         Input: parent      - parent of the scrollbar object
*                name        - name for scroll object
*
*        Output:
*       Returns: The scrollbar GUI object on success, NULL on failure.
*
*  Restrictions: Must be created as the child of a manager object,
*                viewport object, or rowcol object.
*    Written By: Danielle Argiro & Mark Young
*          Date: Apr 9, 1992 9:42
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvobject xvw_create_scrollbar(
*                !   xvobject parent,
*                !   char   *name)
*
************************************************************/

/*
 {
 *   This routine actually exists in ../Athena/Athena.c, ../Olit/Olit.c,
 *   and ../Motif/Motif.c.  The appropriate version of xvw_create_scrollbar
 *   is linked into the application, depending on the widget set being used. 
 }
 */


/************************************************************
*
*  Routine Name: xvw_create_list - create list GUI object
*
*       Purpose: The \fIlist\fP GUI object presents the user with a set of 
*		 strings inside a scrolled viewport. A callback can be 
*		 installed on the list object which will be fired when 
*		 the user selects an item from the list.
*
*		 A list GUI object is really a \fIcompound\fP object;
*                that is, it is made up of two objects: the viewport and the
*                "actual list", where the viewport contains the list and
*                provides scrolling capabilities, and the "actual list" is
*                inside the viewport and contains the list contents.
*
*                When you create a list, the GUI object returned is the
*                viewport object; this object should be referenced when
*                setting geometry, relative offset, and so on (in other words,
*                when setting or getting any attribute not having to do
*                \fIdirectly\fP with the contents of the list, where those
*		 particular attributes are called out below).
*
*                The "actual list" part of the object is used when changing
*                the contents of the list, setting the size of the list, and
*                highlighting or unhighlighting elements of the list.  The
*                "actual list" part of the compound list object can be obtained
*                with a call to xvw_retrieve_list().
*
*		 When the Athena widget set is used, the list object is
*		 instantiated as a xfwfScrolledListWidget.  When the Olit
*		 widget set is used, the list object is instantiated as a
*		 scrollingListWidget.  When the Motif widget set is used,
*		 the list object is instantiated as a ScrolledList.
*
*         Input: parent - parent of the list object
*                name   - name for list object
*
*        Output:
*       Returns: The compound list GUI object on success, NULL on failure.
*
*  Restrictions: Must be created as the child of a manager object,
*                viewport object, or rowcol object.
*    Written By: Danielle Argiro & Mark Young
*          Date: Apr 9, 1992 9:51
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvobject xvw_create_list(
*                !   xvobject parent,
*                !   char   *name)
*
*******************************************************************/

/*
 {
 *   This routine actually exists in ../Athena/Athena.c, ../Olit/Olit.c,
 *   and ../Motif/Motif.c.  The appropriate version of xvw_create_list
 *   is linked into the application, depending on the widget set being used. 
 }
 */

/************************************************************
*
*  Routine Name: xvw_change_list - change the contents of a list object
*
*       Purpose: Changes the contents of a list object while it is displayed
*
*         Input: object - the list object to have contents changed
*                list   - new contents of list object
*                size   - size of the new list (# entries)
*                resize - TRUE if list object should try to resize
*                         itself after the change, FALSE otherwise.
*  Restrictions: The list object must have been previously
*                 created with a call to xvw_create_list()
*    Written By: Danielle Argiro
*          Date: Apr 9, 1992 9:51
*      Verified:
*  Side Effects:
* Modifications:
*  Declaration: xvobject xvw_change_list(
*               !     xvobject object,
*               !     char   **list,
*               !     int    size,
*               !     int    resize)
*
************************************************************/
/*
 {
 *   This routine actually exists in ../Athena/utilities.c, ../Olit/utilities.c,
 *   and ../Motif/utilities.c.  The appropriate version of xvw_change_list
 *   is linked into the application, depending on the widget set being used.
 }
*/


/************************************************************
*
*  Routine Name: xvw_reverse_colors - reverse the foreground & background 
*                                     colors of an object
*
*       Purpose: Reverses the foreground and background colors
*                on a button object.  This is used to over-ride the
*                automatic color reversal of a button.  By default, the 
*                foreground and background colors of a button are reversed
*                when the button is depressed; they revert to normal as
*                soon as the button is released.  In some cases, however,
*                an application may want to force the appearance of a button
*                to stay "depressed", even after the button is released.
*                An example of this is a subform button in an application,
*                where the subform button needs to stay "depressed" as long
*		 as the subform in question is mapped.  For cases like this,
*                the desired effect can be acheived by reversing the colors
*                of the button.
*
*         Input: object - the button object on which to reverse colors
*                value  - TRUE if button should be changed to look selected,
*                         FALSE if button should be changed to look un-selected.
*        Output: 
*       Returns:
*  Restrictions: The button object must have been previously
*                created with a call to xvf_create_oval_button or
*                xvf_create_rect_button.
*    Written By: Danielle Argiro
*          Date: Jul 17, 1992 15:02
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: void xvw_reverse_colors(
*                !   xvobject object,
*                !   int    value)
*
*******************************************************************/

/*
 {
 *   This routine actually exists in ../Athena/utilities.c, ../Olit/utilities.c,
 *   and ../Motif/utilities.c.  The appropriate version of xvw_reverse_colors
 *   is linked into the application, depending on the widget set being used.
 }
 */

/************************************************************
*
*  Routine Name: xvw_retrieve_list - get the actual list component of a
*                                    compound list object
*
*       Purpose: Returns the actual list object component of
*                the compound list object returned by xvw_create_list().
*         Input: list - the compound list object for which the 
*                       actual list component is desired
*        Output: 
*       Returns: The actual list object on success, NULL on failure
*  Restrictions:
*    Written By: Danielle Argiro
*          Date: April 21, 1993
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: void xvw_retrieve_list(
*                !   xvobject list_object)
*
*******************************************************************/

/*
 {
 *   This routine actually exists in ../Athena/utilities.c, ../Olit/utilities.c,
 *   and ../Motif/utilities.c.  The appropriate version of xvw_retrieve_list
 *   is linked into the application, depending on the widget set being used.
 }
 */

/************************************************************
*
*  Routine Name: xvw_retrieve_menu - get the menu component of a
*                                    menubutton object
*
*       Purpose: Given a compound menubutton object, returns the
*                menu associated with the menubutton
*
*         Input: menubutton - the compound menubutton object
*                             for which the menu is desired
*        Output:
*       Returns: The menu object on success, NULL on failure
*  Restrictions:
*    Written By: Danielle Argiro
*          Date: May 18, 1993
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: void xvw_retrieve_menu(
*                !   xvobject menubutton_object)
*
*******************************************************************/


/*
 {
 *   This routine actually exists in ../Athena/utilities.c, ../Olit/utilities.c,
 *   and ../Motif/utilities.c.  The appropriate version of xvw_retrieve_menu
 *   is linked into the application, depending on the widget set being used.
 }
 */



