 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Error Handling Routines for xvobjects
   >>>>                                     
   >>>>  Private:
   >>>>                 xvw_init_error()
   >>>>   Static:
   >>>>                 xvw_error_handler()
   >>>>                 xvw_io_error_handler()
   >>>>                 xvw_xt_error_handler()
   >>>>                 xvw_xt_warning_handler()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <X11/Xproto.h>
#ifdef KMITSHM_DEF
#include <X11/extensions/XShm.h>
#endif



/*-----------------------------------------------------------
|
|  Routine Name: xvw_error_handler
|
|       Purpose: This routine is used to handle Xlib errors.
|		 When an Xlib error is encountered then one
|		 of two things happen.  If the error is recoverable,
|		 then xvw_error_handler returns 0 and the program
|                continues.  Otherwise, it prints out the Xlib error 
|                message and exits the program.
|
|         Input: display - the display that the error occurred on.
|		 xerror  - the error that was encountered.
|      
|        Output: none
|	Returns: Exits on X protocol error, otherwise returns 0. 
|
|    Written By: Mark Young
|          Date: May 12, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/

static int xvw_error_handler(
   Display     *display,
   XErrorEvent *xerror)
{
	FILE     *file;
	unsigned char request, error;


	request = xerror->request_code;
	error   = xerror->error_code;
	switch (request)
	{
	   case X_QueryTree:
	   case X_GetGeometry:
	   case X_GetWindowAttributes:
		if (error == BadWindow || error == BadPixmap ||
		    error == BadDrawable)
		   return(0);
		break;

	   case 131:
		if (error == BadAccess)
		   return(0);
		break;

	   case X_QueryColors:
		if (error == BadValue)
		   return(0);
		break;
		
	   case X_CreatePixmap:
		if (error == BadAlloc)
		   return(0);
		break;

	   default:
	        if ((file = fopen("/dev/tty", "w")) == NULL)
		   file = stderr;

		XmuPrintDefaultErrorMessage(display, xerror, file);
		break;
	}
	kerror("xvwidgets", "xvw_error_handler",
	       "Major X error encountered for display '%s'! Unable to \
recover.\n\n", XDisplayName(NULL));
	kexit(KEXIT_FAILURE);

	return(0); /* make saber happy */
}


/*-----------------------------------------------------------
|
|   Routine Name: xvw_io_error_handler
|
|        Purpose: This routine is used to handle Xlib errors.
|		  When an Xlib error is encountered then one
|		  of two things happen.  If the error is recoverable
|		  then returns 0 and continues on.  Otherwise
|		  it prints out the Xlib error message and 
|		  exits the program. 
|
|         Input: display - the display that the error occured on.
|        Output: none
|	Returns: none
|
|    Written By: Mark Young
|          Date: May 12, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/
/* ARGSUSED */
static int xvw_io_error_handler(
   Display *display)
{
	kerror("xvwidgets", "xvw_io_error_handler",
	       "Major X error encountered for display '%s'! Unable to \
recover.\n\n", XDisplayName(NULL));
	kexit(KEXIT_FAILURE);

	/* make the bloody compilier happy */
	return(FALSE);
}


/*------------------------------------------------------------
|
|   Routine Name: xvw_xt_error_handler
|
|        Purpose: This routine is used to handle X toolkit errors.
|		  When an X toolkit error is encountered then one
|		  of two things happen.  If the error is recoverable
|		  then it returns 0 and continues on.  Otherwise
|		  it prints out the X toolkit error message and 
|		  exits the program.
|
|         Input: mesg - a string with the error encountered.
|        Output: none
|	Returns: Exits on X protocol error, otherwise returns 0 
|
|    Written By: Mark Young
|          Date: May 12, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/


static void xvw_xt_error_handler(
   kstring mesg)
{
	kerror("xvwidgets", "xvw_xt_error_handler",
	       "X Toolkit Error: %s\n", mesg);
	kexit(KEXIT_FAILURE);
	return; /* make saber happy */
}


/*------------------------------------------------------------
|
|  Routine Name: xvw_xt_warning_handler
|
|       Purpose: This routine is used to handle X toolkit warnings.
|		 When an X toolkit warnng is encountered then the
|		 warning is printed out and we return.
|
|         Input: mesg - a string with the error encountered.
|        Output: none
|	Returns: prints out warning and the returns a 0 
|
|    Written By: Mark Young
|          Date: May 12, 1992
| Modifications:
|
------------------------------------------------------------*/

static void xvw_xt_warning_handler(
   kstring mesg)
{
	if (!kstrstr(mesg, "nonexistent passive grab") &&
	    !kstrstr(mesg, "non-existant passive grab") &&
            !kstrstr(mesg, "Invalid columns, must be > 0.") &&
	    !kstrstr(mesg, "-*-Menu-Medium-R-Normal--*-120-*-*-P-*-ISO8859-1"))
	   kwarn(NULL, "xvwidgets", "X Toolkit Warning: %s\n", mesg);
	return;
}


/*------------------------------------------------------------
|
|  Routine Name: xvw_init_errors
|
|       Purpose: This routine installs all these local
|		 error handlers.
|
|         Input: none
|        Output: none
|	Returns: none
|
|    Written By: Mark Young and John Salas
|          Date: Aug 15, 1992 14:56
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/

void xvw_init_errors(void)
{
        XSetErrorHandler(xvw_error_handler);
        XSetIOErrorHandler(xvw_io_error_handler);
        XtSetErrorHandler(xvw_xt_error_handler);
        XtSetWarningHandler(xvw_xt_warning_handler);
}
