 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Private Character Geometry Routines
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>		    xvw_recompute_charfont()
   >>>>		    xvw_set_chargeom()
   >>>>		    xvw_get_chargeom()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*-----------------------------------------------------------
|
|  Routine Name: xvw_recompute_charfont
|
|       Purpose: This routine will adjust the x and y factors of
|                the XvwManagerWidget based on the average character size
|                for a given font.
|
|         Input: object - object to recompute the charfont for
|
|        Output: none
|       Returns: none
|
|    Written By: Mark Young
|          Date: Sep 15, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/

int xvw_recompute_charfont(
   xvobject object,
   int      *xf,
   int      *yf)
{
	static float xfactor, yfactor;
	static float xkludge = 0.85;
	static float ykludge = 1.36;
	static int   border = 3;
	static XFontStruct *save_font = NULL;
	static char *sample_string = "!@#$%^&*()_+1234567890-=qwertyuiop\
[]QWERTYUIOP{}asdfghjkl;'`ASDFGHJKL:\"~zxcvbnm,./ZXCVBNM<>?";

	XFontStruct *font;
        int width, height, len;

        if ((font = xvw_font(object)) != save_font)
	{
	   if (font == NULL)
	      return(FALSE);

	   save_font = font;
	   len  = kstrlen(sample_string);
	   width  = XTextWidth(font, sample_string, len);
           height = kabs(font->max_bounds.ascent) +
				kabs(font->max_bounds.descent);

           xfactor = width/((float) len) * xkludge + border;
           yfactor = (height * ykludge + border * 2);
	}
	if (xf) *xf = (int) xfactor;
	if (yf) *yf = ((int) yfactor/2)*2;
	return(TRUE);
}


/*-------------------------------------------------------------
|
|  Routine Name: xvw_set_chargeom -
|
|       Purpose: Sets the char geometry for:
|			XVW_CHAR_XPOS
|			XVW_CHAR_YPOS
|			XVW_CHAR_XSNAP
|			XVW_CHAR_YSNAP
|			XVW_CHAR_WIDTH
|			XVW_CHAR_HEIGHT
|			XVW_CHAR_MIN_WIDTH
|			XVW_CHAR_MIN_HEIGHT
|			XVW_CHAR_MAX_WIDTH
|			XVW_CHAR_MAX_HEIGHT
|
|         Input: object    - the object to have contents set
|                attribute - (see above)
|                calldata  - pointer to contents of string
|
|        Output:
|    Written By: Mark Young
|          Date: Feb 17, 1993 14:20
| Modifications:
|
------------------------------------------------------------------*/

int xvw_set_chargeom(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	float   *char_val = (float *) calldata;

	unsigned int bw = 0;
	char	*name = NULL;
	int     status, xfactor, yfactor, value, dist = 0;


	xvw_recompute_charfont(object, &xfactor, &yfactor);
	xvw_geometry(object, NULL, NULL, NULL, NULL, &bw);
	if (xvw_class(xvw_parent(object)) == ManagerWidgetClass)
	   xvw_get_attribute(xvw_parent(object), XVW_BUFFER_DIST, &dist);

	if (kstrcmp(attribute, XVW_CHAR_XPOS) == 0)
	{
	   name  = XVW_XPOSITION;
	   value = *char_val * xfactor + dist;
	}
	else if (kstrcmp(attribute, XVW_CHAR_YPOS) == 0)
	{
	   name  = XVW_YPOSITION;
	   value = *char_val * yfactor + dist;
	}
	else if (kstrcmp(attribute, XVW_CHAR_MIN_WIDTH) == 0)
	{
	   name  = XVW_MINIMUM_WIDTH;
	   value = *char_val * xfactor - bw*2;
	}
	else if (kstrcmp(attribute, XVW_CHAR_MIN_HEIGHT) == 0)
	{
	   name  = XVW_MINIMUM_HEIGHT;
	   value = *char_val * yfactor - bw*2;
	}
	else if (kstrcmp(attribute, XVW_CHAR_MAX_WIDTH) == 0)
	{
	   name  = XVW_MAXIMUM_WIDTH;
	   value = *char_val * xfactor - bw*2;
	}
	else if (kstrcmp(attribute, XVW_CHAR_MAX_HEIGHT) == 0)
	{
	   name  = XVW_MAXIMUM_HEIGHT;
	   value = *char_val * yfactor - bw*2;
	}
	else if (kstrcmp(attribute, XVW_CHAR_XSNAP) == 0)
	{
	   name  = XVW_XSNAP;
	   value = *char_val * xfactor;
	}
	else if (kstrcmp(attribute, XVW_CHAR_YSNAP) == 0)
	{
	   name  = XVW_YSNAP;
	   value = *char_val * yfactor;
	}
	else if (kstrcmp(attribute, XVW_CHAR_WIDTH) == 0)
	{
	   name  = XVW_WIDTH;
	   value = *char_val * xfactor - bw*2;
           if (xvw_class(xvw_parent(object)) == ManagerWidgetClass)
              xvw_set_attribute(object, XVW_PREFERRED_WIDTH, value + bw*2);
	}
	else if (kstrcmp(attribute, XVW_CHAR_HEIGHT) == 0)
	{
	   name  = XVW_HEIGHT;
	   value = *char_val * yfactor - bw*2;
           if (xvw_class(xvw_parent(object)) == ManagerWidgetClass)
              xvw_set_attribute(object, XVW_PREFERRED_HEIGHT, value + bw*2);
	}
	else
	{
	   return(FALSE);
	}
	status = xvw_set_attribute(object, name, value);
	return(status);
}


/*-------------------------------------------------------------
|
|  Routine Name: xvw_get_chargeom -
|
|       Purpose: Gets the char geometry for:
|			XVW_CHAR_XPOS
|			XVW_CHAR_YPOS
|			XVW_CHAR_SNAP
|			XVW_CHAR_WIDTH
|			XVW_CHAR_HEIGHT
|			XVW_CHAR_MIN_WIDTH
|			XVW_CHAR_MIN_HEIGHT
|			XVW_CHAR_MAX_WIDTH
|			XVW_CHAR_MAX_HEIGHT
|
|         Input: object    - the object to have contents set
|                attribute - (see above)
|                calldata  - pointer to contents of string
|
|        Output:
|    Written By: Mark Young
|          Date: Feb 17, 1993 14:20
| Modifications:
|
------------------------------------------------------------------*/

int xvw_get_chargeom(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	float *char_val = (float *) calldata;

	char  *name;
	unsigned int width, height, bw;
	int   xfactor, yfactor, factor, x, y, value, dist = 0;


	xvw_recompute_charfont(object, &xfactor, &yfactor);
	xvw_geometry(object, &x, &y, &width, &height, &bw);
	if (xvw_class(xvw_parent(object)) == ManagerWidgetClass)
	   xvw_get_attribute(xvw_parent(object), XVW_BUFFER_DIST, &dist);

	if (kstrcmp(attribute, XVW_CHAR_XPOS) == 0)
	   *char_val = (x-dist)/((float) xfactor);
	else if (kstrcmp(attribute, XVW_CHAR_YPOS) == 0)
	   *char_val = (y-dist)/((float) yfactor);
	else if (kstrcmp(attribute, XVW_CHAR_WIDTH) == 0)
	   *char_val = (width + bw*2)/((float) xfactor);
	else if (kstrcmp(attribute, XVW_CHAR_HEIGHT) == 0)
	   *char_val = (height + bw*2)/((float) yfactor);
	else
	{
	   if (kstrcmp(attribute, XVW_CHAR_MIN_WIDTH) == 0)
	   {
	      name = XVW_MINIMUM_WIDTH;
	      factor = xfactor;
	   }
	   else if (kstrcmp(attribute, XVW_CHAR_MIN_HEIGHT) == 0)
	   {
	      name = XVW_MINIMUM_HEIGHT;
	      factor = yfactor;
	   }
	   else if (kstrcmp(attribute, XVW_CHAR_MAX_WIDTH) == 0)
	   {
	      name = XVW_MAXIMUM_WIDTH;
	      factor = xfactor;
	   }
	   else if (kstrcmp(attribute, XVW_CHAR_MAX_HEIGHT) == 0)
	   {
	      name = XVW_MAXIMUM_HEIGHT;
	      factor = yfactor;
	   }
	   else if (kstrcmp(attribute, XVW_CHAR_XSNAP) == 0)
	   {
	      name = XVW_XSNAP;
	      factor = xfactor; bw = 0;
	   }
	   else if (kstrcmp(attribute, XVW_CHAR_YSNAP) == 0)
	   {
	      name = XVW_YSNAP;
	      factor = yfactor; bw = 0;
	   }
	   else
	      return(FALSE);

	   if (!xvw_get_attribute(object, name, &value))
	      return(FALSE);

	   *char_val = (value + bw*2)/((float) factor);
	}
	return(TRUE);
}
