 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Busy Wait Routines
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>   Public:
   >>>>		    xvw_busy()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/************************************************************
*
*  Routine Name: xvw_busy - set an object to be busy or not busy
*
*       Purpose: Sets an object to be "busy" or "not busy".  
*		 If an object is busy, then all input events to the object
*		 are ignored and a "watch" cursor is installed to alert
*		 the user that the object will not accept input.
*
*         Input: object - the object to make "busy" or "not busy" 
*                busy   - TRUE to set object "busy", FALSE to set
*			  object "not busy"
*        Output: 
*       Returns:
*  Restrictions:
*
*    Written By: Neil Bowers & Mark Young
*          Date: Aug 19, 1994
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

void xvw_busy(
   xvobject object,
   int      busy)
{
	klist *list = xvw_toplevels;


	if (object != NULL)
	{
	   if (!object->busy && !busy)
	      return;

	   if (!object->busy)
	   {
	      object->busy = xvw_create(object, FALSE, TRUE, "Busy",
                                InputOnlyWidgetClass);
           }
           xvw_set_attribute(object->busy, XVW_BUSY, busy);
	}
	else
	{
	   for (list = xvw_toplevels; list != NULL; list = klist_next(list))
	   {
	      object = (xvobject) klist_identifier(list);

	      if ((busy == FALSE && !object->busy) ||
		  (busy == TRUE && xvw_check_mapped(object) == FALSE))
	      {
		 continue;
	      }

	      if (!object->busy)
	      {
	         object->busy = xvw_create(object, FALSE, TRUE, "Busy",
				InputOnlyWidgetClass);
	      }
	      xvw_set_attribute(object->busy, XVW_BUSY, busy);
	   }
	}
	XFlush(xvw_display(object));
}
