/*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                 Text Display/Edit Object	      <<<<
   >>>>                                                       <<<<
   >>>>                xvu_text_wait()			      <<<<              
   >>>>                xvu_create_text_object()		      <<<<              
   >>>>                xvu_use_text_cb()		      <<<<              
   >>>>                xvu_cancel_text_cb()		      <<<<              
   >>>>                xvu_unglyph_text()		      <<<<              
   >>>>                xvu_glyph_text()		  	      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

void xvu_use_text_cb    PROTO((xvobject, kaddr, kaddr ));
void xvu_cancel_text_cb PROTO((xvobject, kaddr, kaddr ));

static int xvu_text_count = 0;
static int xvu_use_text   = FALSE;
static int xvu_text_done  = FALSE;

/*******************************************************************
*
*  Routine Name:  xvu_text_wait - prompts the user for a string using
*                                 a pop-up text object
*
*      Purpose:   This routine is called directly by the user application.
*		  It takes a string (or NULL), and displays that string in a 
*                 pop-up text object.  The user is allowed to edit the string 
*                 as desired; when done, they may click on "Use".  The modified
*                 string is then returned to the application program.  If the
*                 user clicks on "Cancel", the default string is returned.
*                 NOTE: this routine will block the application until the
*                       user clicks on "Use" or "Cancel".
*
*        Input:   default_text - the text to be initially displayed (in the
*			 	 form of one long string - \n's are permitted,
*				 but not necessary, as the text object will
*				 place carriage returns where needed.
*		  prompt - a prompt indicating expected action by the user 
*		  label  - label for the text object
*                 text_width   - width for pop-up text object (in characters)
*                 text_height  - height for pop-up text object (in characters)
*
*	Returns:  When the user clicks on "Use", the edited string is returned.
*                 If the text object is completely empty, NULL is returned.
*                 If the user clicks on "Cancel", the default text passed in
*                 is returned.
*
*  Restrictions:
*    Written By: Danielle Argiro
*          Date: July 16, 1992
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

char *xvu_text_wait(
    char *default_string, 
    char *label, 
    char *prompt,
    int  text_width,
    int  text_height)
{
        char     *string_return;
        char     *new_text;
	xvobject text, toplevel;

	xvu_text_done = FALSE;
	xvu_use_text  = FALSE;

	text = xvu_create_text_object(default_string, label, 
				      prompt, text_width, text_height);
	while (!xvu_text_done)
           xvw_process_event();

	if (xvu_use_text)
	{
	    xvw_get_attribute(text, XVW_TEXT_STRING, 
			      &string_return);
	    new_text = kstring_copy(string_return, NULL);
	}
	else new_text = kstring_copy(default_string, NULL);

	toplevel = xvw_toplevel(text);
        xvw_remove_protocol(toplevel, "WM_DELETE_WINDOW",
                            xvu_cancel_text_cb, toplevel);
        xvw_destroy(toplevel);

	return(new_text);
}



/*---------------------------------------------------------------
|
|  Routine Name:  xvu_create_text_object - pops up a text object in
|                                          which the user may enter a string.
|
|      Purpose:   Create a large read-write text object in which the default
|		  text is displayed. Also creates "Use" and "Quit" buttons
|                 so that the user may add or modify text, and indicate when
|                 they are finished.
|
|        Input:   text_string  - character string containing the text to
|				 be initially displayed in text object
|		  text_prompt  - prompt for user
|                 text_label   - short label for top of object.
|			         NULL gives default of "Edit Text".
|                 text_width   - width for pop-up text object (in characters)
|                 text_height  - height for pop-up text object (in characters)
|
|      Returns:  The pointer to the text object
|   Written By:  Danielle Argiro
|          Date: Jul 16, 1992
|
-----------------------------------------------------------------*/

xvobject xvu_create_text_object(
   char *text_string,
   char *text_label,
   char *text_prompt,
   int  text_width,
   int  text_height)
{
	xvobject toplevel;
	xvobject back;
	xvobject label;	
	xvobject prompt;
	xvobject text;	
	xvobject use;
	xvobject cancel;	 
	char     name[KLENGTH];
	
	
	if (text_label == NULL)
	    text_label = kstring_copy("Edit Text", NULL);
	
	/*
	 * create identifying object name
	 */
	ksprintf(name, "%d_text", xvu_text_count);
	toplevel = xvw_create_application_shell(name, NULL, NULL);
	
	/* 
	 * create the backplane object 
	 */
	back = xvw_create_manager(toplevel, "back");

	/* 
	 * create the label object 
	 */
	label = xvw_create_label(back, "text_label");
	xvw_set_attributes(label,
			   XVW_LABEL,      text_label,
			   XVW_RIGHT_OF,   NULL,
			   XVW_LEFT_OF,    NULL,
			   NULL);
			   
	/* 
	 * create the cancel button 
	 */
	cancel = xvw_create_button(back, "cancel");
        xvw_set_attributes(cancel,
			   XVW_LEFT_OF,  NULL,
			   XVW_LABEL,   "Cancel",
			   NULL);
	xvw_add_callback(cancel, XVW_BUTTON_SELECT, xvu_cancel_text_cb, NULL);
	
	/* 
	 * create the use button 
	 */
	use = xvw_create_button(back, "use");
        xvw_set_attributes(use,
			   XVW_LEFT_OF,  cancel,
			   XVW_LABEL,    "Use",
			   NULL);
	xvw_add_callback(use, XVW_BUTTON_SELECT, xvu_use_text_cb, NULL);

	/*
	 * create prompt object
	 */
	prompt = xvw_create_label(back, "prompt");
	xvw_set_attributes(prompt,
			   XVW_LABEL,        text_prompt,
			   XVW_BELOW,        label,
			   XVW_LEFT_OF,      NULL,
			   XVW_RIGHT_OF,     NULL,
			   XVW_BORDER_WIDTH, 0,
			   NULL);
	/* 
	 * create text object 
	 */
	text = xvw_create_text(back, "text");
        xvw_set_attributes(text,
			   XVW_TEXT_MULTILINE,   TRUE,
			   XVW_TEXT_STRING,      text_string,
			   XVW_TEXT_TYPE,        KTEXT_TYPE_STRING,
		           XVW_TEXT_SCROLL_VERT, TRUE,
			   XVW_TEXT_EDIT_TYPE,   KTEXT_EDIT,
			   XVW_CHAR_HEIGHT,      (float) text_height,
			   XVW_CHAR_WIDTH,       (float) text_width,
			   XVW_BELOW,            prompt,
			   NULL);
	
	xvw_realize(toplevel);
	
	xvw_add_protocol(toplevel, "WM_DELETE_WINDOW", 
			 xvu_cancel_text_cb, toplevel);
	return(text);
}

/* ARGSUSED */
void xvu_use_text_cb(
    xvobject object,
    kaddr    clientData, 
    kaddr    callData)
{
	xvu_text_done = TRUE;
	xvu_use_text = TRUE;
}

/* ARGSUSED */
void xvu_cancel_text_cb(
    xvobject object,
    kaddr clientData, 
    kaddr callData)
{
	xvu_text_done = TRUE;
	xvu_use_text = FALSE;
}

