 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros TextInput GUI Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		ActionCallback()
   >>>>   Public:
   >>>>			xvw_create_textinput()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/TextInputP.h>

static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static void	ActionCallback  PROTO((xvobject, kaddr));



/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_TEXTINPUT_LABEL_OBJECT,     NULL,   XtRPointer,  NULL},
{XVW_TEXTINPUT_TEXT_OBJECT,      NULL,   XtRPointer,  NULL},
{XVW_TEXTINPUT_CRLABEL_OBJECT,   NULL,   XtRPointer,  NULL},
{XVW_TEXTINPUT_CALLBACK,	  NULL,   XtRCallback, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwTextInputWidgetRec, textinput.field)

static XtResource resources[] = { 
{XVW_TEXTINPUT_LABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(label), XtRImmediate, (XtPointer) NULL},
{XVW_TEXTINPUT_TEXT_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(text), XtRImmediate, (XtPointer) NULL},
{XVW_TEXTINPUT_CRLABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(crlabel), XtRImmediate, (XtPointer) NULL},
{XVW_TEXTINPUT_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(textinput_callback), XtRCallback, (XtPointer) NULL},

{XVW_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwTextInputWidgetRec, core.width),
        XtRImmediate, (XtPointer) 300 },
{XVW_BORDER_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwTextInputWidgetRec, core.border_width),
        XtRImmediate, (XtPointer) 0 },
{XVW_BUFFER_DIST, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwTextInputWidgetRec, manager.buffer_dist),
        XtRImmediate, (XtPointer) 0 },
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for TextInput Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwTextInputWidgetClassRec xvwTextInputWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "TextInput",			/* class_name		  */
    sizeof(XvwTextInputWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    NULL,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwTextInputWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwTextInputWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwTextInputWidgetClass = (WidgetClass) &xvwTextInputWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwTextInputWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwTextInputWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input:
|
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwTextInputWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/TextInput");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial textinput widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwTextInputWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);


	xwid->textinput.label = xvw_create_labelstr(object, "label");
	xvw_set_attributes(xwid->textinput.label,
		XVW_LABEL,	      "String:",
		XVW_CHAR_MAX_HEIGHT,  1.0,
		XVW_LABEL_JUSTIFY,    KLABEL_JUSTIFY_LEFT,
		XVW_BORDER_WIDTH,     0,
		XVW_RIGHT_OF,	      NULL,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xwid->textinput.crlabel = xvw_create_pixmap(object, "cr_pixmap");
	xvw_set_attributes(xwid->textinput.crlabel,
		XVW_BORDER_WIDTH,     0,
		XVW_LEFT_OF,	      NULL,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xwid->textinput.text = xvw_create_text(object, "text");
	xvw_set_attributes(xwid->textinput.text,
		XVW_TEXT_MULTILINE,   FALSE,
		XVW_CHAR_MAX_HEIGHT,  1.0,
		XVW_CHAR_WIDTH,	      10.0,
		XVW_LEFT_OF,	      xwid->textinput.crlabel,
		XVW_RIGHT_OF,	      xwid->textinput.label,
		XVW_TACK_EDGE,	      KMANAGER_TACK_HORIZ,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xvw_set_attributes(object,
		XVW_BORDER_WIDTH,    0,
		NULL);

	xvw_add_action(xwid->textinput.text, "<Key>Return", ActionCallback,
		object, TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ActionCallback
|
|       Purpose: This routine will be called when the user presses return
|		 within the text window.
|
|         Input: text      - which text being manipulated
|                client_data - the textinput gui object
|
|        Output: None
|       Returns: None
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ActionCallback(
   xvobject text,
   kaddr    client_data)
{
	xvobject object = (xvobject) client_data;

	char *filename = NULL;

	xvw_get_attribute(text, XVW_TEXT_STRING, &filename);
	XtCallCallbacks(xvw_widget(object), XVW_TEXTINPUT_CALLBACK, &filename);
}


/************************************************************
*
*  Routine Name: xvw_create_textinput - create a textinput object
*
*       Purpose: The textinput GUI object allows the user to enter a 
*		 string of arbitrary length.  It features a text box 
*		 in which the user may enter the string;  the string 
*		 is registered when the user hits <cr>. 
*
*                A callback can be installed on the textinput object, which
*                will be fired when the user enters a new string.
*
*         Input: parent - parent of the textinput object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference textinput object
*
*        Output:
*       Returns: The textinput object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 01, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_textinput(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, TextInputWidgetClass);
	return(object);
}
