 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                RowCol Widget Routines
   >>>>
   >>>>	Private:
   >>>>			ClassInitialize()
   >>>>			ConstraintInitialize
   >>>>			ChangeManaged();
   >>>>			Resize()
   >>>>			SetValues()
   >>>>			Layout()
   >>>>	Public:
   >>>>			xvw_create_rowcol()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/RowColP.h>

static void ClassInitialize PROTO((void));
static void ClassPartInitialize  PROTO((WidgetClass));
static void ConstraintInitialize PROTO((Widget, Widget, ArgList, Cardinal *));
static void ChangeManaged   PROTO((Widget));
static void Resize	    PROTO((Widget));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,
				   Cardinal *));
static void Layout	    PROTO((Widget));


/*-------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_ROWCOL_NUMBER_ACROSS, NULL,    XtRInt,	   NULL},
{XVW_ROWCOL_SPACING,	   NULL,    XtRInt,	   NULL},
};

static xvattribute constraints[] = {
  {XVW_ROWCOL_ACTIVE,   NULL,  XtRInt,	      XtRBoolean},
};


/*-------------------------------------------------------------------*
|
|   Constraint SubResources
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwRowColWidgetConstraintsRec, rowcol.field)

static XtResource rowcolConstraintResources[] = {
{XVW_ROWCOL_ACTIVE, NULL, XtRBoolean, sizeof(Boolean),
        offset(active), XtRImmediate, (XtPointer) TRUE},
};
#undef offset


/*-------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwRowColWidgetRec, rowcol.field)

static XtResource resources[] = { 
{XVW_ROWCOL_SPACING, NULL, XtRInt, sizeof(int),
      offset(spacing), XtRString, (XtPointer) "-1"},
{XVW_ROWCOL_NUMBER_ACROSS, NULL, XtRInt, sizeof(int),
      offset(number_across), XtRString, (XtPointer) "-1"},
};
#undef offset


#define SUPERCLASS (&xvwManagerWidgetClassRec)

XvwRowColWidgetClassRec xvwRowColWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "RowCol",				/* class_name		  */
    sizeof(XvwRowColWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    ClassPartInitialize,		/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    XtInheritTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    ChangeManaged,			/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    rowcolConstraintResources,	    	    /* subresources	  */
    XtNumber(rowcolConstraintResources),    /* subresources_count */
    sizeof(XvwRowColWidgetConstraintsRec),  /* constraint_size    */
    ConstraintInitialize,		    /* initialize         */
    NULL,                                   /* destroy            */
    NULL,				    /* set_values         */
    NULL,                                   /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,			    /* child rowcol routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    Resize,				    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwRowColWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwRowColWidgetClass for public consumption
 */
WidgetClass xvwRowColWidgetClass = (WidgetClass) &xvwRowColWidgetClassRec;

/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/
 
#define kwidget(widget)      (XvwRowColWidget) (widget)
#define kwidgetclass(widget) (XvwRowColWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwRowColWidgetConstraints) (widget)->core.constraints

/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of a xvwRowColWidgetClass has been created. 
|                It will initialize all the class attributes. 
|
|         Input:
|        Output:
|    Written By: Mark Young
|          Date: Dec 1, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
        xvw_init_attributes(xvwRowColWidgetClass, attributes,
		XtNumber(attributes), constraints, XtNumber(constraints), 
		"$DESIGN/objects/library/xvobjects/uis/RowCol.pane");
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/RowCol");
}

/*-----------------------------------------------------------
|
|  Routine Name: ClassPartInitialize
|
|       Purpose: This method is called when the first time an 
|                instance of XvwManagerWidgetClass or a subclass of 
|                the XvwManagerWidgetClass is created.  It handles the
|                inheritence of the layout method from the superclass
|		 to the subclass. 
|
|         Input: wclass - the widget class  
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassPartInitialize(
   WidgetClass wclass)
{
	XvwManagerWidgetClass mclass = (XvwManagerWidgetClass) wclass;
	XvwManagerWidgetClass sclass = (XvwManagerWidgetClass)
						wclass->core_class.superclass;

}

/*-----------------------------------------------------------
|
|  Routine Name: ConstraintInitialize
|
|       Purpose: This method is used to make sure that if the child being
|		 added is an InputOnly object then we make it's constraint
|		 active resource FALSE.
|
|         Input: request - widget child with requested constraints 
|                new     - widget child with new constraints
|    Written By: Mark Young
|          Date: Dec 10, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConstraintInitialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwRowColWidgetConstraints kman = kconstraint(new);
	XvwRowColWidget xwid = kwidget(XtParent(new));


	if (XtClass(new) == InputOnlyWidgetClass)
	   kman->rowcol.active = FALSE;
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangeManaged
|
|       Purpose: This method is called once while the instance
|		 of rowcolWidget is being realized.  It handles the
|		 initial rowcol of the widget.  It will also be called
|		 to unmanage a managed widget, or to manage an unmanaged
|		 one.
|
|         Input: widget - the rowcol widget
|        Output:
|    Written By: Mark Young
|          Date: Dec 1, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ChangeManaged(
   Widget widget)
{
	Layout(widget);
	ManagerRequestLayout(widget, FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Resize
|
|       Purpose: This method is used to recalculate the rowcol
|		 of the widget in the event of a resize. 
|
|         Input: widget - the widget containing the new position
|			  and size information 
|        Output:
|    Written By: Mark Young
|          Date: Dec 1, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Resize(
   Widget widget)
{
	Layout(widget);
	ManagerRequestLayout(widget, FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: Determine what the widget should do by
|		 comparing the current public settable values 
|		 versus the new settings.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output: 
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Dec 1, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
       XvwRowColWidget cxwid = (XvwRowColWidget) current;
       XvwRowColWidget nxwid = (XvwRowColWidget) new;


       if (cxwid->rowcol.spacing       != nxwid->rowcol.spacing  ||
	   cxwid->rowcol.number_across != nxwid->rowcol.number_across)
       {
	  Layout(new);
	  ManagerRequestLayout(new, FALSE);
       }
       return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Layout
|
|       Purpose: This routine will rowcol the children of the
|		 rowcolWidget.  
|
|         Input: widget - the rowcol widget 
|
|        Output: None
| 
|    Written By: Mark Young
|          Date: Dec 1, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Layout(
   Widget widget)
{
	XvwRowColWidget xwid = (XvwRowColWidget) widget;

	Widget   *children;
	XvwRowColWidgetConstraints kman;
	unsigned int w, h, bw, maxw, maxh;
	int      i, j, x, y, num_children, nacross, xspacing, yspacing,
		 hoffset, voffset;


	/* Don't RowCol if there are no children */
	if (xwid->composite.num_children == 0)
	   return;

	/* Get the relevant and useful information from the widget */ 
	children  = xwid->composite.children;
	nacross   = xwid->rowcol.number_across;
	num_children = xwid->composite.num_children;

	/* Get the spacing... if spacing is -1 then use the current gridsize */
	if (xwid->rowcol.spacing == -1)
	{
	   xspacing = xwid->manager.horiz_offset;
	   yspacing = xwid->manager.vert_offset;
	}
	else
	   xspacing = yspacing = xwid->rowcol.spacing;

	for (i = 0, maxw = maxh = 0; i < num_children; i++)
	{
	   kman = kconstraint(children[i]);
	   if (kman->rowcol.active == FALSE)
	      continue;

	   bw = children[i]->core.border_width << 1;
	   w  = children[i]->core.width  + bw;
	   h  = children[i]->core.height + bw;
	   if (maxw < w) maxw = w;
	   if (maxh < h) maxh = h;
	}

	bw = xwid->core.border_width;
	x = (bw > 0) ? xspacing : 0;
	y = (bw > 0) ? yspacing : 0;
	w = xwid->core.width;
	h = xwid->core.height;
	for (j = i = 0; i < num_children; i++)
	{
	   kman = kconstraint(children[i]);
	   if (kman->rowcol.active == FALSE)
	      continue;

	   if (kman->manager.horiz_offset > 0)
	      hoffset = kman->manager.horiz_offset;
	   else
	      hoffset = 0;

	   if (kman->manager.vert_offset > 0)
	      voffset = kman->manager.vert_offset;
	   else
	      voffset = 0;

	   if ((nacross <= 0 || (j > 0 && (j % nacross) == 0)) &&
	       (nacross > 0 || (x + maxw + hoffset) > w))
	   {
	      x = (bw > 0) ? xspacing : 0;
	      y += yspacing + maxh;
	      hoffset = 0;
	   }
	   XtMoveWidget(children[i],(Position) x+hoffset, (Position) y+voffset);
	   x += xspacing + maxw + hoffset; j++;
	}
}


/************************************************************
*
*  Routine Name: xvw_create_rowcol - create a rowcol object
*
*       Purpose: A rowcol object is designed specifically for
*                doing convenient layout of other objects in a
*		 table-like format, in rows and columns.  The
*		 rowcol object may be used as a parent for any 
*		 GUI or visual object, but works particularly 
*		 well when laying out objects of similar size
*		 and nature, such as labels, buttons, pixmaps, 
*		 annoations, and so on.
*
*         Input: parent - the parent of the rowcol object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference rowcol object 
*
*        Output: 
*	Returns: The rowcol object on success, NULL on failure
*  Restrictions:
*    Written By: Mark Young
*          Date: Dec 1, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_rowcol(
   xvobject parent,
   char     *name)
{
	xvobject object;

	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, RowColWidgetClass);
	return(object);
}
