 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	                The Manager Widget
   >>>>
   >>>>         The following widget is the base widget
   >>>>		used by all graphical user interface programs.
   >>>>		This manager plays an integral role in managing
   >>>>		all Khoros related applications.  It is the
   >>>>		glue by which several important Khoros features
   >>>>		are implemented.
   >>>>
   >>>>		The features that this widget provide are:
   >>>>
   >>>>		   1) common manager widget to make imple-
   >>>>		      menting multiple widgets set possible.
   >>>>
   >>>>		   2) the ability of providing an interactive
   >>>>		      editing capibility to every application.
   >>>>
   >>>>		   3) with the advent of an object (gadget)
   >>>>		      based annotations capibility.  We want
   >>>>		      any application to be able to advantage
   >>>>		      of this feature with little or no work.
   >>>>		      (this also enforces a common interface).
   >>>>
   >>>>
   >>>>		First off by having a common widget "manager"
   >>>>		we effectively make the implementation of mult-
   >>>>		iple widget sets possible.  The idea is that
   >>>>		most widgets sets such as
   >>>>
   >>>>			Athena, Motif, Open Look (KOLIT)
   >>>>
   >>>>		have similar objects such as buttons, labels,
   >>>>		lists, etc.  But the manager widgets are not
   >>>>		similar.  They all have a different layout
   >>>>		philsophy and terminolgy thus making it diffi-
   >>>>		to write transparent code for.  Also, since we
   >>>>		originally wrote all of Khoros with the MIT
   >>>>		Form Widget in mind, this part of the system
   >>>>		is extremely similar in terminology and imple-
   >>>>		mentation.
   >>>>	
   >>>>  Private:
   >>>>			ManagerGeometryManager
   >>>>   Static:
   >>>>			ClassInitialize
   >>>>			ClassPartInitialize
   >>>>			Initialize
   >>>>			Realize
   >>>>			Resize
   >>>>			ConstraintSetValues
   >>>>			ConstraintInitialize
   >>>>			ManagerRequestLayout
   >>>>			ConstraintLayout
   >>>>			LayoutChild
   >>>>			PreferredGeometry
   >>>>			ChangeManaged
   >>>>			Destroy 
   >>>>			SetValues 
   >>>>   Public:
   >>>>			xvw_create_manager()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/ManagerP.h>
#include <xvobjects/ManagerObjP.h>

static void ClassInitialize      PROTO((void));
static void ClassPartInitialize  PROTO((WidgetClass));
static void Initialize           PROTO((Widget, Widget, ArgList, Cardinal *));
static void Realize              PROTO((Widget, XtValueMask *, 
					XSetWindowAttributes *));
static void Resize               PROTO((Widget));
static void ConstraintInitialize PROTO((Widget, Widget, ArgList, Cardinal *));
static void ConstraintLayout     PROTO((XtPointer, XtIntervalId *));
static void ConstraintDestroy    PROTO((Widget));
static void ChangeManaged        PROTO((Widget));
static void Destroy              PROTO((Widget));
static void Redisplay	         PROTO((Widget, XEvent *, Region));

static void  CompositeDeleteChild    PROTO((Widget));
static Boolean  ConstraintSetValues  PROTO((Widget, Widget, Widget, 
					  ArgList, Cardinal *));
static Boolean LayoutChild PROTO((Widget, XtWidgetGeometry *, Widget, int));
static Boolean SetValues   PROTO((Widget, Widget, Widget, ArgList, Cardinal *));
static int ManagerRelayout PROTO((xvobject, char *, kaddr));

static XtGeometryResult PreferredGeometry PROTO((Widget, XtWidgetGeometry *, 
					         XtWidgetGeometry *));

long manager_undefined = -1;

#define NO_EDGES    (0)
#define LEFT_EDGE   (1 << 0)
#define RIGHT_EDGE  (1 << 1)
#define TOP_EDGE    (1 << 2)
#define BOTTOM_EDGE (1 << 3)
#define ALL_EDGES   (LEFT_EDGE|RIGHT_EDGE|TOP_EDGE|BOTTOM_EDGE)


/*-------------------------------------------------------------------*
|
|   Full class attribute
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
  {XVW_RESIZABLE,       NULL,  XtRInt,        XtRBoolean},
  {XVW_MENUABLE,        NULL,  XtRInt,        XtRBoolean},
  {XVW_SELECTABLE,      NULL,  XtRInt,        XtRBoolean},
  {XVW_EDIT_MODE_ON,    NULL,  XtRInt,        XtRBoolean},
  {XVW_SELECTIONS,	NULL,  XtRWidgetList, NULL},
  {XVW_NUM_SELECTIONS,  NULL,  XtRInt,	      NULL},
  {XVW_XSNAP,		NULL,  XtRInt,	      XtRDimension},
  {XVW_YSNAP,		NULL,  XtRInt,	      XtRDimension},
  {XVW_BUFFER_DIST,     NULL,  XtRInt,        XtRDimension},
  {XVW_CANVAS_GRID,	NULL,  XtRInt,        NULL},
  {XVW_CANVAS_GRIDSIZE,	NULL,  XtRInt,	      NULL},
  {XVW_CANVAS_PIXEL,	NULL,  XtRPixel,      NULL},
  {XVW_CANVAS_COLOR,	XVW_CANVAS_PIXEL, XtRString,     XtRPixel},
  {XVW_GEOMETRY_CALLBACK,NULL, XtRCallback,   NULL},
  {XVW_SELECT_CALLBACK, NULL,  XtRCallback,   NULL},
  {XVW_FONT,            NULL,  XtRFontStruct, NULL},
  {XVW_DEF_VERT_DIST,   NULL,  XtRInt,        XtRPosition},
  {XVW_DEF_HORIZ_DIST,  NULL,  XtRInt,        XtRPosition},
  {XVW_CHILDREN,	NULL,  XtRWidgetList, NULL},
  {XVW_NUM_CHILDREN,	NULL,  XtRInt,        NULL},
  {XVW_TOP_SHADOW_PIXEL,    NULL, XtRPixel,   NULL},
  {XVW_BOTTOM_SHADOW_PIXEL, NULL, XtRPixel,   NULL},
  {XVW_TOP_SHADOW_COLOR,    XVW_TOP_SHADOW_PIXEL,    XtRString, XtRPixel},
  {XVW_BOTTOM_SHADOW_COLOR, XVW_BOTTOM_SHADOW_PIXEL, XtRString, XtRPixel},
  {XVW_MINIMUM_WIDTH,   NULL,  XtRInt,	      XtRDimension},
  {XVW_MINIMUM_HEIGHT,  NULL,  XtRInt,        XtRDimension},
  {XVW_MAXIMUM_WIDTH,   NULL,  XtRInt,        XtRDimension},
  {XVW_MAXIMUM_HEIGHT,  NULL,  XtRInt,        XtRDimension},
  {XVW_PREFERRED_WIDTH, NULL,  XtRInt,        XtRDimension},
  {XVW_PREFERRED_HEIGHT,NULL,  XtRInt,        XtRDimension},
  {XVW_MANAGER_DELAYED_LAYOUT, NULL,  XtRInt,        XtRBoolean},
};

static xvattribute constraints[] = {
  {XVW_RESIZABLE,       NULL,  XtRInt,	      XtRBoolean},
  {XVW_MENUABLE,        NULL,  XtRInt,        XtRBoolean},
  {XVW_SELECTABLE,      NULL,  XtRInt,        XtRBoolean},
  {XVW_LEFT_OF,         NULL,  XtRObject,     XtRWidget},
  {XVW_RIGHT_OF,        NULL,  XtRObject,     XtRWidget},
  {XVW_ABOVE,           NULL,  XtRObject,     XtRWidget},
  {XVW_BELOW,           NULL,  XtRObject,     XtRWidget},
  {XVW_HORIZ_DIST,      NULL,  XtRInt,        XtRPosition},
  {XVW_VERT_DIST,       NULL,  XtRInt,        XtRPosition},
  {XVW_TACK_EDGE,	NULL,  XtRInt,        NULL},
  {XVW_MINIMUM_WIDTH,   NULL,  XtRInt,	      XtRDimension},
  {XVW_MINIMUM_HEIGHT,  NULL,  XtRInt,        XtRDimension},
  {XVW_MAXIMUM_WIDTH,   NULL,  XtRInt,        XtRDimension},
  {XVW_MAXIMUM_HEIGHT,  NULL,  XtRInt,        XtRDimension},
  {XVW_PREFERRED_WIDTH, NULL,  XtRInt,        XtRDimension},
  {XVW_PREFERRED_HEIGHT,NULL,  XtRInt,        XtRDimension},
};


/*-------------------------------------------------------------------*
|
|   Constraint SubResources
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwManagerWidgetConstraintsRec, manager.field)

static XtResource managerConstraintResources[] = {
{XVW_RESIZABLE, NULL, XtRBoolean, sizeof(Boolean),
        offset(allow_resizing), XtRImmediate, (XtPointer) TRUE},
{XVW_MENUABLE, NULL, XtRBoolean, sizeof(Boolean),
        offset(allow_menuing), XtRImmediate, (XtPointer) TRUE},
{XVW_SELECTABLE, NULL, XtRBoolean, sizeof(Boolean),
        offset(allow_selecting), XtRImmediate, (XtPointer) TRUE},
{XVW_LEFT_OF, NULL, XtRWidget, sizeof(Widget),
        offset(left_of), XtRImmediate, (XtPointer) KMANAGER_UNDEFINED},
{XVW_RIGHT_OF, NULL, XtRWidget, sizeof(Widget),
        offset(right_of), XtRImmediate, (XtPointer) KMANAGER_UNDEFINED},
{XVW_ABOVE, NULL, XtRWidget, sizeof(Widget),
        offset(above), XtRImmediate, (XtPointer) KMANAGER_UNDEFINED},
{XVW_BELOW, NULL, XtRWidget, sizeof(Widget),
        offset(below), XtRImmediate, (XtPointer) KMANAGER_UNDEFINED},
{XVW_TACK_EDGE, NULL, XtRInt, sizeof(int),
        offset(tacking), XtRInt, (XtPointer) KMANAGER_TACK_NONE},
{XVW_MAXIMUM_WIDTH, NULL, XtRDimension, sizeof(Dimension),
      offset(max_width), XtRImmediate, (XtPointer) ~0L},
{XVW_MAXIMUM_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
      offset(max_height), XtRImmediate, (XtPointer) ~0L},
{XVW_MINIMUM_WIDTH, NULL, XtRDimension, sizeof(Dimension),
      offset(min_width), XtRImmediate, (XtPointer) 1},
{XVW_MINIMUM_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
      offset(min_height), XtRImmediate, (XtPointer) 1},
{XVW_PREFERRED_WIDTH, NULL, XtRDimension, sizeof(Dimension),
      offset(preferred_width), XtRImmediate, (XtPointer) 0},
{XVW_PREFERRED_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
      offset(preferred_height), XtRImmediate, (XtPointer) 0},
{XVW_HORIZ_DIST, NULL, XtRPosition, sizeof(Position),
        offset(horiz_offset), XtRImmediate, (XtPointer) -1},
{XVW_VERT_DIST, NULL, XtRPosition, sizeof(Position),
        offset(vert_offset), XtRImmediate, (XtPointer) -1},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwManagerWidgetRec, manager.field)

static XtResource resources[] = { 
{XVW_SELECTIONS, NULL, XtRPosition, sizeof(xvobject *),
        offset(objectsels), XtRImmediate, NULL},
{XVW_NUM_SELECTIONS, NULL, XtRInt, sizeof(int),
        offset(numsels), XtRImmediate, 0},
{XVW_EDIT_MODE_ON, NULL, XtRBoolean, sizeof(Boolean),
        offset(editing), XtRImmediate, (XtPointer) FALSE},
{XVW_GEOMETRY_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(geometry_callback), XtRCallback, (XtPointer) NULL},
{XVW_SELECT_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(select_callback), XtRCallback, (XtPointer) NULL},
{XVW_CURSOR, NULL, XtRCursor, sizeof(Cursor),
      offset(cursor), XtRImmediate, (XtPointer) None},
{XVW_FONT, NULL, XtRFontStruct, sizeof(XFontStruct *),
      offset(font), XtRString, XtDefaultFont},
{XVW_XSNAP, NULL, XtRDimension, sizeof(Dimension),
      offset(xsnap), XtRImmediate, (XtPointer) 10},
{XVW_YSNAP, NULL, XtRDimension, sizeof(Dimension),
      offset(ysnap), XtRImmediate, (XtPointer) 10},
{XVW_CANVAS_GRID, NULL, XtRInt, sizeof(int),
        offset(gridtype), XtRImmediate, (XtPointer) KMANAGER_GRID_SELECT},
{XVW_CANVAS_GRIDSIZE, NULL, XtRInt, sizeof(int),
        offset(gridsize), XtRImmediate, (XtPointer) 0},
{XVW_CANVAS_PIXEL, NULL, XtRPixel, sizeof(Pixel),
        offset(grid_pixel), XtRString, (XtPointer) XtDefaultBackground},
{XVW_FOREGROUND_PIXEL, NULL, XtRPixel, sizeof(Pixel),
      offset(foreground_pixel), XtRString, XtDefaultForeground},
{XVW_DEF_HORIZ_DIST, NULL, XtRPosition, sizeof(Position),
        offset(horiz_offset), XtRImmediate, (XtPointer) 3},
{XVW_DEF_VERT_DIST, NULL, XtRPosition, sizeof(Position),
        offset(vert_offset), XtRImmediate, (XtPointer) 3},
{XVW_BUFFER_DIST, NULL, XtRDimension, sizeof(Dimension),
        offset(buffer_dist), XtRImmediate, (XtPointer) 3},
{XVW_VISUAL, NULL, XtRVisual, sizeof(Visual *),
        offset(visual), XtRImmediate, (XtPointer) CopyFromParent},
{XVW_TOP_SHADOW_PIXEL, NULL, XtRPixel, sizeof(Pixel),
	offset(top_shadow), XtRString, XtDefaultForeground},
{XVW_BOTTOM_SHADOW_PIXEL, NULL, XtRPixel, sizeof(Pixel),
	offset(bottom_shadow), XtRString, XtDefaultBackground},
{XVW_MAXIMUM_WIDTH, NULL, XtRDimension, sizeof(Dimension),
      offset(max_width), XtRImmediate, (XtPointer) ~0L},
{XVW_MAXIMUM_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
      offset(max_height), XtRImmediate, (XtPointer) ~0L},
{XVW_MINIMUM_WIDTH, NULL, XtRDimension, sizeof(Dimension),
      offset(min_width), XtRImmediate, (XtPointer) 1},
{XVW_MINIMUM_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
      offset(min_height), XtRImmediate, (XtPointer) 1},
{XVW_PREFERRED_WIDTH, NULL, XtRDimension, sizeof(Dimension),
      offset(preferred_width), XtRImmediate, (XtPointer) 0},
{XVW_PREFERRED_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
      offset(preferred_height), XtRImmediate, (XtPointer) 0},
{XVW_RESIZABLE, NULL, XtRBoolean, sizeof(Boolean),
        offset(allow_resizing), XtRImmediate, (XtPointer) TRUE},
{XVW_MENUABLE, NULL, XtRBoolean, sizeof(Boolean),
        offset(allow_menuing), XtRImmediate, (XtPointer) TRUE},
{XVW_SELECTABLE, NULL, XtRBoolean, sizeof(Boolean),
        offset(allow_selecting), XtRImmediate, (XtPointer) TRUE},
{XVW_MANAGER_DELAYED_LAYOUT, NULL, XtRBoolean, sizeof(Boolean),
        offset(delayed_layout), XtRImmediate, (XtPointer) TRUE},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Manager Widget
|
--------------------------------------------------------------------*/

typedef enum {
	LayoutPending,	  /* set initially so that the layout is recomputed   */
	LayoutDelayed,    /* set so the layout may be performed afterward     */
	LayoutDone	  /* set when the layout was successfully	      */
} Layout;

#define XtInheritLayout ((void (*)())_XtInherit)

static CompositeClassExtensionRec composite_rec = {
	/* next_extension */  NULL,
	/* record_type */     NULLQUARK,
	/* version */         XtCompositeExtensionVersion,
	/* record_size */     sizeof(CompositeClassExtensionRec),
	/* accepts_objects */ TRUE,
};

#define superclass (&constraintClassRec)

XvwManagerWidgetClassRec xvwManagerWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Manager",				/* class_name		  */
    sizeof(XvwManagerWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    ClassPartInitialize,		/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,            /* compress_exposure      */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL, /* set in class_initialize */ /* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                  		/* geometry_manager	  */
    ChangeManaged,			/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    CompositeDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    managerConstraintResources,	    	    /* subresources	  */
    XtNumber(managerConstraintResources),   /* subresources_count */
    sizeof(XvwManagerWidgetConstraintsRec), /* constraint_size	  */
    ConstraintInitialize,		    /* initialize	  */
    ConstraintDestroy,			    /* destroy		  */
    ConstraintSetValues,		    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    ConstraintLayout,                       /* child layout routine  */
    NULL,				    /* change selection proc  */
    DefaultEraseSelection,	    	    /* erase selected proc    */
    DefaultRefreshSelection,	    	    /* refresh selection proc */
    Resize,				    /* resize		      */
    ManagerGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwManagerWidgetClass = (WidgetClass) &xvwManagerWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#define kwidget(widget)      (XvwManagerWidget) (widget)
#define kwidgetclass(widget) (XvwManagerWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwManagerWidgetConstraints) (widget)->core.constraints


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize 
|
|       Purpose: This method is called the first time an  
|                instance of XvwManagerWidgetClass has been created.
|                This is where translations for the class are
|                initialized.
|
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(ManagerWidgetClass, attributes,
		XtNumber(attributes), constraints, XtNumber(constraints),
		NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/Manager");
	xvw_define_attributes(ManagerWidgetClass,
		XVW_SELECT_REPLACE,XtRObject, ManagerSetSelect,ManagerGetSelect,
		XVW_SELECT_ADD,    XtRObject, ManagerSetSelect, NULL,
		XVW_SELECT_DELETE, XtRObject, ManagerSetSelect, NULL,
		XVW_SELECT_ADD_ALL,    XtRInt,   ManagerSetSelect, NULL,
		XVW_SELECT_DELETE_ALL, XtRInt,   ManagerSetSelect, NULL,
		XVW_MANAGER_RELAYOUT, XtRInt, ManagerRelayout, NULL,
		NULL);

	xvw_define_constraints(ManagerWidgetClass,
		XVW_GROUP_ADD,        XtRObject, ManagerSetGroup, NULL,
		XVW_GROUP_DELETE,     XtRObject, ManagerSetGroup, NULL,
		XVW_GROUP_DELETE_ALL, XtRObject, ManagerSetGroup, NULL,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: ClassPartInitialize
|
|       Purpose: This method is called when the first time an 
|                instance of XvwManagerWidgetClass or a subclass of 
|                the XvwManagerWidgetClass is created.  It handles the
|                inheritence of the layout method from the superclass
|		 to the subclass. 
|
|         Input: wclass - the widget class  
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassPartInitialize(
   WidgetClass wclass)
{
	XvwManagerWidgetClass mclass = (XvwManagerWidgetClass) wclass;
	XvwManagerWidgetClass sclass = (XvwManagerWidgetClass)
						wclass->core_class.superclass;

	composite_rec.next_extension = mclass->composite_class.extension;
	mclass->composite_class.extension = (XtPointer) &composite_rec;
	if (wclass != ManagerWidgetClass)
	{
	   if (mclass->manager_class.layout == XtInheritLayout)
	   {
	      mclass->manager_class.layout = sclass->manager_class.layout;
	   }

	   if (mclass->manager_class.change_selection == XtInheritChangeSel)
	   {
	      mclass->manager_class.change_selection =
			sclass->manager_class.change_selection;
	   }

	   if (mclass->manager_class.erase_selection == XtInheritEraseSel)
	   {
	      mclass->manager_class.erase_selection =
			sclass->manager_class.erase_selection;
	   }

	   if (mclass->manager_class.refresh_selection == XtInheritRefreshSel)
	   {
	      mclass->manager_class.refresh_selection =
			sclass->manager_class.refresh_selection;
	   }

	   if (mclass->manager_class.resize == XtInheritResize)
	   {
	      mclass->manager_class.resize = sclass->manager_class.resize;
	   }

	   if (mclass->manager_class.geometry_manager==XtInheritGeometryManager)
	   {
	      mclass->manager_class.geometry_manager =
			sclass->manager_class.geometry_manager;
	   }
	}
	mclass->core_class.resize = mclass->manager_class.resize;
	mclass->composite_class.geometry_manager =
		mclass->manager_class.geometry_manager;
}

/*-----------------------------------------------------------
|
|  Routine Name: CompositeDeleteChild 
|
|       Purpose: Deletes a child from our composite structure and
|		 makes sure they are not on the selection list.
|
|         Input: widget - the child to be deleted
|    Written By: Mark Young
|          Date: Jun 23, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void CompositeDeleteChild(
   Widget widget)
{
	WidgetClass class;
	XtWidgetProc delete;

	ManagerDeleteSelection(widget->core.parent, widget);

	class = ManagerWidgetClass->core_class.superclass;
	delete = ((CompositeWidgetClass) class)->composite_class.delete_child;
	if (delete)
	   (*delete)(widget);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial values 
|                for all the fields for a XvwManagerWidget instance.
|                It will set up an initial size, the gc used for refresh, 
|                as well as other private variables.
|		 Accelerators and Event Handlers for managing
|		 the instance's children are installed here. 
|
|         Input: request - widget instance with requested public settings 
|                new     - widget instance after initialization, with 
|                          settings initialized 
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwManagerWidget xwid = (XvwManagerWidget) new;

	xwid->manager.raise_id  =  0;
	xwid->manager.layout_id = -2;
	xwid->core.width  = (xwid->core.width  != 0) ? xwid->core.width : 10;
	xwid->core.height = (xwid->core.height != 0) ? xwid->core.height : 10;
	xwid->manager.grid = None;
	if (xwid->manager.preferred_width  == 0)
	   xwid->manager.preferred_width  = xwid->core.width;
	if (xwid->manager.preferred_height == 0)
	   xwid->manager.preferred_height = xwid->core.height;

	/*
	 *  Set the selection array size to be zero
	 */
        xwid->manager.active  = FALSE;
	xwid->manager.numsels = 0;
	xwid->manager.inputonly  = NULL;
	xwid->manager.widgetsels = NULL;
	xwid->manager.objectsels = NULL;
        xwid->manager.gc         = NULL;
        xwid->manager.top_shadow_gc    = NULL;
        xwid->manager.bottom_shadow_gc = NULL;

	/*
	 *  Add action handler for editing our children
	 */
	xvw_add_action(xvw_object(new),"Meta<Btn1Down>", 
                      ManagerActionHandler, (kaddr) new, TRUE);
	xvw_add_action(xvw_object(new),"Shift<Btn1Down>", 
		      ManagerActionHandler, (kaddr) new, TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ReorderChildren - kludge routine to reorder the managers
|                                  stacking order
|
|       Purpose: This routine is called in order to reorder the stacking
|                order of the children.  Since Xt realizes it's children
|                in reverse order this means the last added is below
|                the first widgets added.  This is visually wrong.  Yes
|                i have tried reorder the entries and put all new children
|                in the front of the list.  But the problem is that this
|                plays havoc on the rest of the system....
|
|         Input: calldata - the manager widget
|                id       - the timer id
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Dec 21, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ReorderChildren(
   XtPointer    calldata,
   XtIntervalId *id)
{
        Widget    widget = (Widget) calldata;
        XvwManagerWidget xwid = kwidget(widget);
 
        int        i;
        Widget     *child = xwid->composite.children;
 
        /*
         *  Need to reorder the children, since they have been realized
         *  in the wrong order.
         */
        for (i = 0; i < xwid->composite.num_children; i++)
        {
           if (XtIsWidget(child[i]) && XtWindowOfObject(child[i]))
              XRaiseWindow(XtDisplay(child[i]), XtWindow(child[i]));
        }
	xwid->manager.raise_id = 0;
}

/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This method will set up the window attributes 
|                and create a window for the XvwManagerWidget.  It will
|		 resize it's children to guarantee that they will 
|                correctly fit into its initial size.   The desired
|                initial window attributes are passed in via
|                a mask and list of specification attributes. 
|
|         Input: widget     - the widget to realize
|                valuemask  - determines the window attributes being passed in 
|                attributes - the list of window attributes to be set 
|    Written By: Mark Young
|          Date: Oct 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget               widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
	XvwManagerWidget xwid = kwidget(widget);
	XtGCMask     mask;
	XGCValues    values;


	*valuemask |= CWColormap;
	winattrib->colormap = widget->core.colormap;

	if ((winattrib->cursor = xwid->manager.cursor) != None)
	   *valuemask |= CWCursor;

	if (widget->core.width ==  0) widget->core.width  = 1;
	if (widget->core.height == 0) widget->core.height  = 1;

	/*
	 *  Layout the children so that our initial creation of
	 *  the window has the correct size.
	 */
	if (xwid->manager.layout_id == -2 || xwid->manager.layout_id > 0)
	{
           if (xwid->manager.layout_id > 0)
              XtRemoveTimeOut((XtIntervalId) xwid->manager.layout_id);

	   ConstraintLayout(widget, NULL);
	}

        if (xwid->manager.visual == CopyFromParent)
        {
           xwid->manager.visual = XDefaultVisual(XtDisplay(widget),
                        XScreenNumberOfScreen(XtScreen(widget)));
	}

	/*
	 *  Now our manager widget should hopefully be the correct size, so go
	 *  ahead and create it's window.
	 */
	XtCreateWindow(widget, InputOutput, xwid->manager.visual, *valuemask,
			winattrib);

	/*
	 *  Create the gc to be used with the refresh mechanism
	 */
	mask = GCForeground|GCBackground|GCFont;
	values.font       = xwid->manager.font->fid;
        values.foreground = xwid->manager.foreground_pixel;
        values.background = xwid->core.background_pixel;
        xwid->manager.gc = XtGetGC(widget, mask, &values);

	/*
	 *  Create the top & bottom shadow GCs
	 */
        values.foreground = xwid->manager.top_shadow;
        xwid->manager.top_shadow_gc = XtGetGC(widget, GCForeground, &values);
        values.foreground = xwid->manager.bottom_shadow;
        xwid->manager.bottom_shadow_gc = XtGetGC(widget, GCForeground, &values);

	/*
	 *  Initialize the background grid, now that we have a valid window
	 */
	ManagerCreateGrid(widget);
	xwid->manager.raise_id = XtAppAddTimeOut(
		XtWidgetToApplicationContext(widget), 0,
                ReorderChildren, (XtPointer) widget);
}

/*-----------------------------------------------------------
|
|  Routine Name: Resize
|
|       Purpose:
|
|         Input: 
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Resize(
   Widget widget)
{
	XvwManagerWidget xwid = kwidget(widget);
	XvwManagerWidgetConstraints kman;

	/*
	 *  Set the minimum width and height to the size that the resize
	 *  has requested.  If the application has set an upper limit then
	 *  we should be able to limit the upper bound.
	 */
	if (XtWindow(widget))
	{
	   xwid->manager.preferred_width  = xwid->core.width;
	   xwid->manager.preferred_height = xwid->core.height;
           if (XtIsSubclass(XtParent(widget), ManagerWidgetClass))
           {
              kman = kconstraint(widget);
 
              kman->manager.preferred_width   = xwid->manager.preferred_width;
              kman->manager.preferred_height  = xwid->manager.preferred_height;
           }
	}
	ManagerRequestLayout(widget, FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Redisplay
|
|       Purpose: This routine will redraw the gadgets within the widget
|		 in response to an expose event 
|
|         Input: widget - widget data structure for manager
|		 event	- the event that caused the redraw
|		 region	- the region that was exposed
|    Written By: Mark Young
|          Date: Jun 29, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
	XvwManagerWidget xwid = kwidget(widget);

	int	         i;
	Dimension        bw;
	RectObj          robj;
	XvwManagerGadget xobj;
	RectObjPart      *rect;
	RectObjClass     rclass;

	/*
	 *  Make sure this is an expose event.  If not then don't worry since
	 *  all we have to do is refresh our children that are rectangular
	 *  objects.
	 */
	if ((event->type != Expose && event->type != GraphicsExpose) ||
	    (XtIsRealized(widget) == FALSE))
	   return;

	/*
	 *  Need to see if any of our children are Rectangular objects.  If so
	 *  then we need to refresh them if the exposed region intersects with
	 *  their rectangular area.
	 */
	for (i = 0; i < xwid->composite.num_children; i++)
	{
	   Widget   child = xwid->composite.children[i];

	   if (!XtIsWidget(child))
	   {
              /*
               *  If the child is an object and it's Realize procedure is not
               *  NULL then go ahead and call it with itself.  This is a
               *  nicety that most objects won't need to take advantage of.
               */
	      if (XtIsSubclass(child, ManagerGadgetClass))
	      {
	         xobj = (XvwManagerGadget) child;
	         if (xobj->manager.realized == FALSE)
		    ManagerRealizeObject(XtClass((Widget) xobj), child);
	      }

	      /*
	       *  If the child is not mapped then continue
	       */
	      if (!xvw_check_mapped(xvw_object(child)))
		 continue;

	      /*
	       *  Check to see if the child has an expose procedure
	       */
              robj = (RectObj) child;
	      rclass = (RectObjClass) robj->object.widget_class;
	      if (rclass->rect_class.expose == NULL)
	         continue;

	      /*
	       *  Check to see if the child has been exposed
	       */
              rect = (RectObjPart *) &robj->rectangle;
	      bw = (rect->border_width << 1);
	      if (XRectInRegion(region, (int) rect->x, (int) rect->y,
			(unsigned int) (rect->width + bw),
			(unsigned int) (rect->height + bw)) != RectangleOut)
	      {
		 (*(rclass->rect_class.expose)) (child, event, region);
	      }
           }

	   /*
	    *  Check to see if the child is selected.  If so then refresh
	    *  the selection.
	    */
	   if (ManagerCheckIfSelection(widget, child) == TRUE)
	      ManagerRefreshSelection(widget, child);
	}
return;
#if 0
	XPoint pts[6];
	int    w, h, size;

	size = 2;
	if ((int) xwid->manager.buffer_dist < size)
	   return;

	w = widget->core.width; h = widget->core.height;
        if (XRectInRegion(region, 0, 0, w, size) != RectangleOut ||
            XRectInRegion(region, 0, 0, size, h) != RectangleOut)
	{
            pts[0].x = 0;        pts[0].y = h;
            pts[1].x =           pts[1].y = 0;
            pts[2].x = w;        pts[2].y = 0;
            pts[3].x = w-size;   pts[3].y = size;
            pts[4].x =           pts[4].y = size;
            pts[5].x = size;     pts[5].y = h-size;
            XFillPolygon(XtDisplay(widget), XtWindow(widget),
	       xwid->manager.top_shadow_gc, pts, 6, Convex, CoordModeOrigin);
        }
 
        if (XRectInRegion(region, 0, w-size, w, size) != RectangleOut ||
            XRectInRegion(region, w-size, 0, size, h) != RectangleOut)
	{
            pts[0].x = 0;        pts[0].y = h;
            pts[1].x = w;        pts[1].y = h;
            pts[2].x = w;        pts[2].y = 0;
            pts[3].x = w-size;   pts[3].y = size;
            pts[4].x = w-size;   pts[4].y = h-size;
            pts[5].x = size;     pts[5].y = h-size;
            XFillPolygon(XtDisplay(widget), XtWindow(widget),
	       xwid->manager.bottom_shadow_gc, pts, 6, Convex, CoordModeOrigin);
        }
#endif
}

/*-----------------------------------------------------------
|
|  Routine Name: DefaultRefreshSelection - refreshes the selected indicators
|
|       Purpose: This is the default refresh selection mechanism that is
|		 used to visually indicate that a selection is selected.
|         Input: selection - selection to be refreshed
|    Written By: Mark Young
|          Date: Dec 09, 1994
|
------------------------------------------------------------*/
/*ARGSUSED*/
void DefaultRefreshSelection(
   Widget selection)
{
	Window   window;
	Display  *display;
	XvwManagerWidget xwid = kwidget(XtParent(selection));

	Position x, y;
	Dimension width, height, bw;

	/*
	 *  Get the display and window.  If the window is 0 or it's not
	 *  visible, then return.
	 */
	display = XtDisplay((Widget) xwid);
	window  = XtWindowOfObject((Widget) xwid);
	if (window == 0) return;

	/*
	 *  Since the selection doesn't have a refresh mechanism of it's own
	 *  we will go ahead and put selection boxes on it's four corners.
	 */
	ManagerGeometry(selection, &x, &y, &width, &height, &bw);

	XFillRectangle(display, window, xwid->manager.gc,
		       (int) (x - PICK_TOLERANCE/2),
		       (int) (y - PICK_TOLERANCE/2),
		       (unsigned int) PICK_TOLERANCE,
		       (unsigned int) PICK_TOLERANCE);
	XFillRectangle(display, window, xwid->manager.gc,
		       (int) ((x+width+bw) - PICK_TOLERANCE/2),
		       (int) (y - PICK_TOLERANCE/2),
		       (unsigned int) PICK_TOLERANCE,
		       (unsigned int) PICK_TOLERANCE);
	XFillRectangle(display, window, xwid->manager.gc,
		       (int) (x - PICK_TOLERANCE/2),
		       (int) ((y+height+bw) - PICK_TOLERANCE/2),
		       (unsigned int) PICK_TOLERANCE,
		       (unsigned int) PICK_TOLERANCE);
	XFillRectangle(display, window, xwid->manager.gc,
		       (int) ((x+width+bw) - PICK_TOLERANCE/2),
		       (int) ((y+height+bw) - PICK_TOLERANCE/2),
		       (unsigned int) PICK_TOLERANCE,
		       (unsigned int) PICK_TOLERANCE);

}

/*-----------------------------------------------------------
|
|  Routine Name: DefaultEraseSelection - erases the selection indicators
|
|       Purpose: This is the default erase selection mechanism that is
|		 used to visually erase that a selection has been selected.
|         Input: selection - selection to be refreshed
|    Written By: Mark Young
|          Date: Dec 09, 1994
|
------------------------------------------------------------*/
/*ARGSUSED*/
void DefaultEraseSelection(
   Widget selection)
{
	Window  window;
	Display *display;
	XvwManagerWidget xwid = kwidget(XtParent(selection));

	Position x, y;
	Dimension width, height, bw;


	/*
	 *  Get the window and display.  If the window is 0, then return.
	 */
	display = XtDisplay((Widget) xwid);
	window  = XtWindowOfObject((Widget) xwid);
	if (window == 0) return;
	ManagerGeometry(selection, &x, &y, &width, &height, &bw);

	XClearArea(display, window,
		       (int) (x - PICK_TOLERANCE/2),
		       (int) (y - PICK_TOLERANCE/2),
		       (unsigned int) PICK_TOLERANCE,
		       (unsigned int) PICK_TOLERANCE,
		       TRUE);
	XClearArea(display, window,
		       (int) ((x+width+bw) - PICK_TOLERANCE/2),
		       (int) (y - PICK_TOLERANCE/2),
		       (unsigned int) PICK_TOLERANCE,
		       (unsigned int) PICK_TOLERANCE,
		       TRUE);
	XClearArea(display, window, (int) (x - PICK_TOLERANCE/2),
		       (int) ((y+height+bw) - PICK_TOLERANCE/2),
		       (unsigned int) PICK_TOLERANCE,
		       (unsigned int) PICK_TOLERANCE,
		       TRUE);
	XClearArea(display, window,
		       (int) ((x+width+bw) - PICK_TOLERANCE/2),
		       (int) ((y+height+bw) - PICK_TOLERANCE/2),
		       (unsigned int) PICK_TOLERANCE,
		       (unsigned int) PICK_TOLERANCE,
		       TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ConstraintSetValues
|
|       Purpose: This method is used to update the constraint parameters
|		 of a child of XvwManagerWidget.  The paramters which can
|		 be changed are the relative position in terms of left_of,
|		 right_of, above, below (in which case the manager is
|		 requested to relayout all the children). 
|
|         Input: current  - the widget whose constraint values are being set
|                request  - the widget containing requested settings
|                new      - the widget processed through all set values methods
|                args     - an argument list of constraints being set 
|                num_args - the number of arguments being set 
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean ConstraintSetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwManagerWidgetConstraints ckman = kconstraint(current);
	XvwManagerWidgetConstraints nkman = kconstraint(new);


	if (!widgetequal(ckman->manager.left_of, nkman->manager.left_of)   ||
	    !widgetequal(ckman->manager.right_of, nkman->manager.right_of) ||
	    !widgetequal(ckman->manager.above, nkman->manager.above)       ||
	    !widgetequal(ckman->manager.below, nkman->manager.below)       ||
	    ckman->manager.vert_offset  != nkman->manager.vert_offset	   ||
	    ckman->manager.horiz_offset != nkman->manager.horiz_offset	   ||
	    ckman->manager.tacking      != nkman->manager.tacking)
	{
	   ManagerRequestLayout(XtParent(new), FALSE);
	}

	if (ckman->manager.max_width    != nkman->manager.max_width        ||
	    ckman->manager.max_height   != nkman->manager.max_height       ||
	    ckman->manager.min_width    != nkman->manager.min_width        ||
	    ckman->manager.min_height   != nkman->manager.min_height	   ||
	    ckman->manager.preferred_width  != nkman->manager.preferred_width ||
	    ckman->manager.preferred_height != nkman->manager.preferred_height)
	{
	   ManagerRequestLayout(XtParent(new), FALSE);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ConstraintInitialize
|
|       Purpose: This method is used to overide the translations
|		 of a child of the XvwManagerWidget and to 
|	         install the accelerators from the XvwManagerWidget
|		 into the child.
|
|         Input: request - widget child with requested constraints 
|                new     - widget child with overidden translations and
|                          installed accelerators 
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConstraintInitialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwManagerWidgetConstraints kman = kconstraint(new);
	XvwManagerWidget xwid = kwidget(XtParent(new));


	kman->manager.allow_menuing   = xwid->manager.allow_menuing;
	kman->manager.allow_selecting = xwid->manager.allow_selecting;
	kman->manager.allow_resizing  = xwid->manager.allow_resizing;

	kman->manager.group  = NULL;
	kman->manager.group_size = 0;
	kman->manager.status = LayoutDone;
	if (new->core.x == 0) new->core.x = xwid->manager.buffer_dist;
	if (new->core.y == 0) new->core.y = xwid->manager.buffer_dist;
}

/*-----------------------------------------------------------
|
|  Routine Name: ConstraintDestroy
|
|       Purpose: This method is used to delete
|
|         Input: child   - child widget to be deleted
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConstraintDestroy(
   Widget child)
{
	Widget  parent = XtParent(child);


	ManagerDeleteSelection(parent, child);
}

/*-----------------------------------------------------------
|
|  Routine Name: ManagerRelayout - allows the programmer to force a relayout
|
|       Purpose: This routine is called via the XVW_MANAGER_REALAYOUT
|		 attribute.  It allows the programmer the ability to force
|                a relayout.  This really shouldn't be necessary, but it
|		 helps on certain manager layout bugs.  As the system matures
|		 it is the hope that this routine and attribute will go
|		 away.
|
|         Input: object - object to force the relayout
|                attribute - the XVW_MANAGER_REALAYOUT attribute
|                client_data - not used
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: May 17, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static int ManagerRelayout(
   xvobject object,
   char *attribute,
   kaddr client_data)
{
	Widget widget = xvw_widget(object);

	if (!widget) return(FALSE);

	ManagerRequestLayout(widget, FALSE);
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ManagerRequestLayout
|
|       Purpose: This routine puts in a request to have
|		 the XvwManagerWidget relay itself out. 
|
|         Input: widget - the widget to be laid out
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
void ManagerRequestLayout(
   Widget widget,
   int    override)
{
	XvwManagerWidget xwid = kwidget(widget);
	XvwManagerWidget xpar = kwidget(XtParent(widget));
        XvwManagerWidgetClass class = kwidgetclass(widget);


	if (!class->manager_class.layout || xwid->manager.layout_id == 0)
	   return;

	if (override || !xwid->manager.delayed_layout ||
	    XtIsSubclass(XtParent(widget), ManagerWidgetClass) &&
	    xpar->manager.layout_id == 0)
	{
	   if (xwid->manager.layout_id > 0)
	      XtRemoveTimeOut(xwid->manager.layout_id);

	   class->manager_class.layout(widget, NULL);
	   return;
	}
	else if (xwid->manager.layout_id >= 0)
	   return;

	xwid->manager.layout_id = (long) XtAppAddTimeOut(
			XtWidgetToApplicationContext(widget), 0,
			class->manager_class.layout, (XtPointer) widget);
}

/*-----------------------------------------------------------
|
|  Routine Name: ConstraintLayout
|
|       Purpose: This method of the XvwManagerWidget class will 
|		 layout all the children of a given widget. 
|
|         Input: widget - the widget whose children are going 
|			  to be laid out
|                id     - timeout id (not used) 
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConstraintLayout(
   XtPointer	calldata,
   XtIntervalId *id)
{
	Widget  widget = (Widget) calldata;
	XvwManagerWidget xwid = kwidget(widget);
	XvwManagerWidgetConstraints kman;

	Widget     *child;
	XtWidgetGeometry req;
	Position   x, y, xdist, ydist;
	Boolean	   active_children = FALSE;
	int	   i, width, height, temp_width, temp_height;
	Dimension  w, h, bw, max_width, max_height, old_width, old_height;


	kinfo(KDEBUG,"XvwManagerWidget: Entering Constraint Layout for '%s'",
		XtName(widget));

	/*
	 *  Set layout request to be in progress...
	 */
	xwid->manager.layout_id = 0;

	/*
	 *  Need to relayout the children, but first change the layout status
	 *  so that we can detect when a child has been laid out or when a
	 *  constraint loop exists.
	 */
	child  = xwid->composite.children;
	old_width  = xwid->core.width;
	old_height = xwid->core.height;
	xwid->core.width = xwid->manager.preferred_width;
	xwid->core.height = xwid->manager.preferred_height;
	for (i = 0; i < xwid->composite.num_children; i++, child++)
	{
	   int    tacking;
	   Widget above, left;

	   kman  = kconstraint(*child);
	   left  = kman->manager.left_of;
	   above = kman->manager.above;
	   tacking = kman->manager.tacking;
	   kman->manager.layout_state = NO_EDGES;
	   if (!left || !above ||
	       (!widgetdefined(left) && (tacking & KMANAGER_TACK_RIGHT)) ||
	       (!widgetdefined(above) && (tacking & KMANAGER_TACK_BOTTOM)))
	   {
	      kman->manager.status = LayoutDelayed;
	   }
	   else
	      kman->manager.status = LayoutPending;

	   if (XtIsSubclass(*child, ManagerWidgetClass))
	   {
	      XvwManagerWidget xchd = kwidget(*child);
	      if (xchd->manager.layout_id == -2 || xchd->manager.layout_id > 0)
	         ManagerRequestLayout(*child, TRUE);
	   }

	   /*
	    *  Record the child's old geometry so that we can postpone the
	    *  resizing until later.
	    */
	   kman->manager.old_x = (*child)->core.x;
	   kman->manager.old_y = (*child)->core.y;
	   kman->manager.old_width  = (*child)->core.width;
	   kman->manager.old_height = (*child)->core.height;
	}

	/*
	 *  Loop thru all the children calling the LayoutChild routine to
	 *  layout all pending layouts.
	 */
	child  = xwid->composite.children;
	max_width  = xwid->manager.max_width;
	max_height = xwid->manager.max_height;
	width  = kmax(xwid->core.width, xwid->manager.min_width);
	height = kmax(xwid->core.height, xwid->manager.min_height);
	for (i = 0; i < xwid->composite.num_children; i++, child++)
	{
	   kman = kconstraint(*child);
	   temp_width  = kman->manager.preferred_width;
	   temp_height = kman->manager.preferred_height;
	   if (kman->manager.status == LayoutPending ||
	       kman->manager.status == LayoutDelayed)
	     (void) LayoutChild(*child, NULL, NULL, NO_EDGES);

	   /*
	    *  Check the child's layout status to make sure that it was
	    *  was laid out.
	    */
	   if (XtIsManaged(*child) == TRUE &&
	       XtClass(*child) != InputOnlyWidgetClass)
	   {
	      ManagerGeometry(*child, &x, &y, &w, &h, &bw);
	      xdist = (kman->manager.horiz_offset != -1) ?
		       kman->manager.horiz_offset : xwid->manager.horiz_offset;
	      ydist = (kman->manager.vert_offset != -1) ?
		       kman->manager.vert_offset : xwid->manager.vert_offset;
	      xdist = kmin(xdist, (int) xwid->manager.buffer_dist);
	      ydist = kmin(ydist, (int) xwid->manager.buffer_dist);

	      temp_width  = x + ((int) w + (bw << 1)) + xdist;
	      temp_height = y + ((int) h + (bw << 1)) + ydist;
	      if (temp_width > width)
	         width = kmin(temp_width, (int) max_width);
	      if (temp_height > height)
	         height = kmin(temp_height, (int) max_height);
	   }
	}
	xwid->core.width  = (Dimension) kmin(width,  (int) max_width);
	xwid->core.height = (Dimension) kmin(height, (int) max_height);

	/*
	 *  Perform Delayed Layout since all the other children were laid out
	 *  and we have our final max and minimum width.
	 */
	child  = xwid->composite.children;
	for (i = 0; i < xwid->composite.num_children; i++, child++)
	{
	   kman = kconstraint(*child);
	   if (kman->manager.status == LayoutDelayed)
	   {
	      kman->manager.status = LayoutPending;
	      kman->manager.layout_state = NO_EDGES;
	   }
	}

	child  = xwid->composite.children;
	for (i = 0; i < xwid->composite.num_children; i++, child++)
	{
	   kman = kconstraint(*child);
	   if (kman->manager.status == LayoutPending)
	      (void) LayoutChild(*child, NULL, NULL, NO_EDGES);
	}

	/*
	 *  Ask our parent to resize us to the desired width and height, but
	 *  first make sure that our current size isn't already the same as
	 *  out desired size.
	 */
	if (old_width != xwid->core.width || old_height != xwid->core.height)
	{
#if 0
kfprintf(kstderr, "Resizing parent '%s':  %d x %d\n", XtName(widget),
		xwid->core.width, xwid->core.height);
#endif
	   req.request_mode = CWWidth | CWHeight;
	   req.width  = xwid->core.width;
	   req.height = xwid->core.height;
	   xwid->core.width  = old_width;
	   xwid->core.height = old_height;
	   if (XtMakeGeometryRequest(widget, &req, &req) == XtGeometryAlmost)
	      (void) XtMakeGeometryRequest(widget, &req, &req);
	}

	/*
	 *  Set layout request to be off...
	 */
	xwid->manager.layout_id = -1;

	child = xwid->composite.children;
	req.request_mode = CWX | CWY | CWWidth | CWHeight;
	for (i = 0; i < xwid->composite.num_children; i++, child++)
	{
	   kman = kconstraint(*child);
	   if (kman->manager.old_x != (*child)->core.x ||
	       kman->manager.old_y != (*child)->core.y ||
	       kman->manager.old_width  != (*child)->core.width ||
	       kman->manager.old_height != (*child)->core.height)
	   {
#if 0
kfprintf(kstderr, "Resizing child '%s':  %d x %d  (%d, %d)\n", XtName(*child),
		(*child)->core.width, (*child)->core.height,
		(*child)->core.x, (*child)->core.y);
#endif
	       req.x = (*child)->core.x; req.width  = (*child)->core.width;
	       req.y = (*child)->core.y; req.height = (*child)->core.height;
	       (*child)->core.x = kman->manager.old_x;
	       (*child)->core.y = kman->manager.old_y;
	       (*child)->core.width  = kman->manager.old_width;
	       (*child)->core.height = kman->manager.old_height;
	       ManagerPixelGeometry(*child, &req, NULL);
	   }
	}
	kinfo(KDEBUG,"XvwManagerWidget: Leaving Constraint Layout for '%s' \
(changes made)", XtName(widget));
}

/*-----------------------------------------------------------
|
|  Routine Name: LayoutChild
|
|       Purpose: This routine, which is called from the 
|		 ConstraintLayoutLoop, will layout a single child
|		 of the manager widget.
|
|         Input: widget    - the child widget being laid out
|                request   - the requested geometry or NULL
|                dependent - another widget whose position the child 
|                            widget depends on 
|		 edge	   - the edge in which the dependency is being processed
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean LayoutChild(
   Widget widget,
   XtWidgetGeometry *request,
   Widget dependent,
   int    edge)
{
	XvwManagerWidgetConstraints kman;
	Widget	parent = XtParent(widget);
	XvwManagerWidget xwid = kwidget(parent);

	int	   tacking, offset;
	Widget	   left, right, above, below;
	Position   xpos, ypos, xpos1, xpos2, ypos1, ypos2;
	Dimension  width, height, w1, w2, h1, h2, bw, bd;


	if (!XtIsSubclass(parent, ManagerWidgetClass))
	   return(TRUE);

	/*
	 *  Check the layout status of the child.  If the the child has been
	 *  laid out then return
	 */
	kman = kconstraint(widget);
	if ((kman->manager.layout_state & edge) != 0)
	{
	   if (dependent == NULL)
	      return(FALSE);

	   if (kman->manager.status == LayoutDelayed)
	   {
	      kman = kconstraint(dependent);
	      kman->manager.status = LayoutDelayed;
	   }
	   return(TRUE);
	}
	else if (kman->manager.status == LayoutDone)
	   return(TRUE);

	if (dependent != NULL)
	   kinfo(KDEBUG,"LayoutChild: Child '%s' being laid by '%s'",
		   XtName(widget), XtName(dependent));
	else
	   kinfo(KDEBUG,"LayoutChild: Laying out child '%s'",
		   XtName(widget));

	kman->manager.layout_state |= edge;
	left    = kman->manager.left_of;
	right   = kman->manager.right_of;
	above   = kman->manager.above;
	below   = kman->manager.below;
	tacking = kman->manager.tacking;
	if (!widgetdefined(right) && (tacking & KMANAGER_TACK_LEFT))
	   right = NULL;
	if (!widgetdefined(below) && (tacking & KMANAGER_TACK_TOP))
	   below = NULL;
	if (!widgetdefined(left) && (tacking & KMANAGER_TACK_RIGHT))
	   left = NULL;
	if (!widgetdefined(above) && (tacking & KMANAGER_TACK_BOTTOM))
	   above = NULL;

	/*
	 *  Get the width, height, and border width of the widget to be laid
	 *  out.  If the widget's layout depends on another widget it is
	 *  necessary to use the widget's geometry in the placement calcu-
	 *  lations.
	 */
	ManagerGeometry(widget, &xpos, &ypos, &width, &height, &bd);
	if (request != NULL)
	{
	   if (request->request_mode & CWX)
	      xpos = request->x;
	   if (request->request_mode & CWY)
	      ypos = request->y;
	   if (request->request_mode & CWWidth)
	      width = request->width;
	   if (request->request_mode & CWHeight)
	      height = request->height;
	   if (request->request_mode & CWBorderWidth)
	      bd = request->border_width;
	}

	/*
	 *  Do the horizontal placement by seeing the widget's "left of" and
	 *  "right of" dependence.
	 */
	offset = (kman->manager.horiz_offset != -1) ? 
			kman->manager.horiz_offset :
		 	xwid->manager.horiz_offset;
	if (widgetdefined(left) && widgetdefined(right))
	{
	   if (left != NULL && LayoutChild(left, NULL, widget, RIGHT_EDGE))
	      ManagerGeometry(left, &xpos1, NULL, &w1, NULL, NULL);
	   else
	   {
	      w1 = 0;
	      xpos1 = parent->core.width;
	   }

	   if (right != NULL && LayoutChild(right, NULL, widget, LEFT_EDGE))
	      ManagerGeometry(right, &xpos2, NULL, &w2, NULL, &bw);
	   else
	      bw = xpos2 = w2 = 0;

	   xpos2 = xpos2 + w2 + (bw << 1);
	   xpos = kabs(xpos2 - xpos1)/2 + kmin(xpos1, xpos2) -
			(int) (width + bd)/2;

	   if (tacking & KMANAGER_TACK_LEFT)
	   {
	      xpos = offset + xpos2;
	      width += kmax(kabs(xpos2 - xpos) - offset - (int) (bd << 1), 0);
	   }
	   else if (xpos < xpos2 && (left != right || left == NULL))
	      xpos = offset + xpos2;

	   if (tacking & KMANAGER_TACK_RIGHT)
	   {
	      width = kmax(kabs(xpos1 - xpos) - offset - (int) (bd << 1), 0);
	      kman->manager.preferred_width = width;
#if 1
	      if (XtIsSubclass(widget, ManagerWidgetClass))
              {
                 XvwManagerWidget xtmp = kwidget(widget);
		 xtmp->manager.preferred_width = width;
	      }
#endif
	   }
	}
	else if (widgetdefined(right))
	{
	   if (right != NULL && LayoutChild(right, NULL, widget, LEFT_EDGE))
	      ManagerGeometry(right, &xpos2, NULL, &w2, NULL, &bw);
	   else
	   {
	      xpos2 = bw = w2 = 0;
	   }
	   xpos = xpos2 + w2 + (bw << 1) + offset;
	}
	else if (widgetdefined(left))
	{
	   if (left != NULL && LayoutChild(left, NULL, widget, RIGHT_EDGE))
	      ManagerGeometry(left, &xpos1, NULL, NULL, NULL, NULL);
	   else
	   {
	      xpos1 = parent->core.width;
	   }

	   if (tacking & KMANAGER_TACK_RIGHT)
	   {
	      width = kmax(kabs(xpos1 - xpos) - offset - (int) (bd << 1), 0);
	      kman->manager.preferred_width = width;
#if 1
	      if (XtIsSubclass(widget, ManagerWidgetClass))
              {
                 XvwManagerWidget xtmp = kwidget(widget);
		 xtmp->manager.preferred_width = width;
	      }
#endif
	   }
	   else
	      xpos = xpos1 - (int) width - (int) (bd << 1) - offset;
	}

	offset = (kman->manager.vert_offset != -1) ?
			kman->manager.vert_offset :
		 	xwid->manager.vert_offset;
	if (widgetdefined(above) && widgetdefined(below))
	{
	   if (above != NULL && LayoutChild(above, NULL, widget, BOTTOM_EDGE))
	      ManagerGeometry(above, NULL, &ypos1, NULL, &h1, NULL);
	   else
	   {
	      h1 = 0;
	      ypos1 = parent->core.height;
	   }

	   if (below != NULL && LayoutChild(below, NULL, widget, TOP_EDGE))
	      ManagerGeometry(below, NULL, &ypos2, NULL, &h2, &bw);
	   else
	      bw = ypos2 = h2 = 0;

	   ypos2 = ypos2 + h2 + (bw << 1);
	   ypos = kabs(ypos2 - ypos1)/2 + kmin(ypos1, ypos2) -
			(int) (height + bd)/2;

	   if (tacking & KMANAGER_TACK_TOP)
	   {
	      ypos = offset + ypos2;
	      height += kmax(kabs(ypos2 - ypos) - offset - (int) (bd << 1), 0);
	   }
	   else if (ypos < ypos2 && (above != below || below == NULL))
	      ypos = offset + ypos2;

	   if (tacking & KMANAGER_TACK_BOTTOM)
	   {
	      height = kmax(kabs(ypos1 - ypos) - offset - (int) (bd << 1), 0);
              kman->manager.preferred_height = height;
#if 1
	      if (XtIsSubclass(widget, ManagerWidgetClass))
              {
                 XvwManagerWidget xtmp = kwidget(widget);
		 xtmp->manager.preferred_height = height;
	      }
#endif
	   }
	}
	else if (widgetdefined(below))
	{
	   if (below != NULL && LayoutChild(below, NULL, widget, TOP_EDGE))
	      ManagerGeometry(below, NULL, &ypos2, NULL, &h2, &bw);
	   else
	   {
	      ypos2 = bw = h2 = 0;
	   }
	   ypos = ypos2 + h2 + (bw << 1) + offset;
	}
	else if (widgetdefined(above))
	{
	   if (above != NULL && LayoutChild(above, NULL, widget, BOTTOM_EDGE))
	      ManagerGeometry(above, NULL, &ypos1, NULL, NULL, NULL);
	   else
	   {
	      ypos1 = parent->core.height;
	   }

	   if (tacking & KMANAGER_TACK_BOTTOM)
	   {
	      height = kmax(kabs(ypos1 - ypos) - offset - (int) (bd << 1), 0);
	      kman->manager.preferred_height = height;
#if 1
	      if (XtIsSubclass(widget, ManagerWidgetClass))
	      {
		 XvwManagerWidget xtmp = kwidget(widget);
		 xtmp->manager.preferred_height = height;
	      }
#endif
	   }
	   else
	      ypos = ypos1 - (int) height - (int) (bd << 1) - offset;
	}

	bw = bd << 1; 
	if (((int) width + (int) bw) < (int) kman->manager.preferred_width)
	   width  = (int) kman->manager.preferred_width  - (int) bw;
	if (((int) height + (int) bw) < (int) kman->manager.preferred_height)
	   height = (int) kman->manager.preferred_height - (int) bw;

	if (width < kman->manager.min_width)
	   width = kman->manager.min_width;
	else if (width > kman->manager.max_width)
	   width = kman->manager.max_width;

	if (height < kman->manager.min_height)
	   height = kman->manager.min_height;
	else if (height > kman->manager.max_height)
           height = kman->manager.max_height;

#if 1
	if (kman->manager.preferred_width != 0)
#endif
	   kman->manager.preferred_width = width;
#if 1
	if (kman->manager.preferred_height != 0)
#endif
	   kman->manager.preferred_height = height;

	/*
	 *  Change the layout status...
	 */
	if (dependent != NULL && kman->manager.status == LayoutDelayed)
	{
	   kman = kconstraint(dependent);
	   kman->manager.status = LayoutDelayed;
	}
	else if (kman->manager.status == LayoutPending)
	   kman->manager.status = LayoutDone;

        widget->core.x = xpos; widget->core.width  = width;
        widget->core.y = ypos; widget->core.height = height;
	widget->core.border_width = bd;
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: PreferredGeometry
|
|       Purpose: This is technically the query_geometry method.
|		 When the XvwManagerWidget is given a suggested
|		 new size, this routine will analyze the size
|		 and either accept it or suggest a new geometry. 
|
|         Input: widget - the widget being queried
|                request - the requested geometry size 
|                reply   - the size that the method will agree to
|       Returns: XtGeometryYes    if the request is accepted
|                XtGeometryNo     if the request is rejected 
|                XtGeometryAlmost if part of the geometry is accepted 
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static XtGeometryResult PreferredGeometry(
   Widget           widget,
   XtWidgetGeometry *request,
   XtWidgetGeometry *reply)
{
	reply->width  = widget->core.width;
	reply->height = widget->core.height;
	reply->request_mode = CWWidth | CWHeight;
	if (request->request_mode & (CWWidth | CWHeight))
	{
	   if (request->width == widget->core.width &&
	       request->height == widget->core.height)
	      return(XtGeometryYes);
	   else
	      return(XtGeometryAlmost);
	}
	else if (request->request_mode & CWWidth)
	{
	   if (request->width == widget->core.width)
	      return(XtGeometryYes);
	   else
	      return(XtGeometryAlmost);
	}
	else if (request->request_mode & CWHeight)
	{
	   if (request->height == widget->core.height)
	      return(XtGeometryYes);
	   else
	      return(XtGeometryAlmost);
	}
	else
	   return(XtGeometryNo);
}
 
/*-----------------------------------------------------------
|
|  Routine Name: ManagerGeometryManager
|
|       Purpose: This method is used to determine a child's
|                x, y, width, height, and border_width.
|
|         Input: widget  - the widget being laid out 
|                request - not used 
|                reply   - the size that the method will agree to
|       Returns: XtGeometryDone (it only returns when it is done)
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
XtGeometryResult ManagerGeometryManager(
   Widget           widget,
   XtWidgetGeometry *request,
   XtWidgetGeometry *reply)
{
	Widget parent = XtParent(widget);
	XvwManagerWidgetConstraints kman = kconstraint(widget);

	Position   xpos, ypos;
	Dimension  width, height, border_width;

	/*
	 *  Perform the requested layout, and if the geometry has changed
	 *  then request a layout to be performed.
	 */
	ManagerGeometry(widget, &xpos, &ypos, &width, &height, &border_width);
	kman->manager.status = LayoutPending;
	kman->manager.layout_state = NO_EDGES;
	(void) LayoutChild(widget, request, NULL, NO_EDGES);
	kman->manager.status = LayoutDone;

	if (xpos  != widget->core.x     || ypos   != widget->core.y ||
	    width != widget->core.width || height != widget->core.height ||
	    border_width != widget->core.border_width)
	{
           request->x = widget->core.x; request->width  = widget->core.width;
           request->y = widget->core.y; request->height = widget->core.height;
	   request->border_width = widget->core.border_width;
           widget->core.x = xpos; widget->core.width  = width;
           widget->core.y = ypos; widget->core.height = height;
           widget->core.border_width = border_width;
           ManagerPixelGeometry(widget, request, NULL);
	}
        ManagerRequestLayout(parent, FALSE);

	/*
	 *  See if a reply configuration is desired.
	 */
	if (reply != NULL)
	{
	   reply->request_mode = request->request_mode;
	   reply->x = widget->core.x;
	   reply->y = widget->core.y;
	   reply->width  = widget->core.width;
	   reply->height = widget->core.height;
	   reply->border_width = widget->core.border_width;
	}
	return(XtGeometryDone);
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangeManaged
|
|       Purpose: This method is called once while the 
|                instance of XvwManagerWidget is being realized.
|		 It will handle the initial layout of the widget.
|		 It will also be called to when the manager widget is
|		 unmanaged or managed.
|
|         Input: widget - the widget of interest
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ChangeManaged(
   Widget widget)
{
	ManagerRequestLayout(widget, FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy 
|
|       Purpose: This method will deallocate the gc used 
|                by the XvwManagerWidget before it is destroyed. 
|
|         Input: widget - the widget being destroyed
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwManagerWidget xwid = kwidget(widget);


	if (xwid->manager.gc)
	   XtReleaseGC(widget, xwid->manager.gc);
	if (xwid->manager.top_shadow_gc)
	   XtReleaseGC(widget, xwid->manager.top_shadow_gc);
	if (xwid->manager.bottom_shadow_gc)
	   XtReleaseGC(widget, xwid->manager.bottom_shadow_gc);

	if (xwid->manager.grid != None)
	   XFreePixmap(XtDisplay(widget), xwid->manager.grid);
	if (xwid->manager.layout_id > 0)
	   XtRemoveTimeOut((XtIntervalId) xwid->manager.layout_id);
	if (xwid->manager.raise_id > 0)
	   XtRemoveTimeOut((XtIntervalId) xwid->manager.raise_id);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues 
|
|       Purpose: This method is used to set the public values 
|                of a XvwManagerWidget instance.  The public values
|		 which can be changed are the font, default spacing,
|		 max and min width and height. 
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Aug 19, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwManagerWidget cxwid = kwidget(current);
	XvwManagerWidget nxwid = kwidget(new);


	if (cxwid->core.width  != nxwid->core.width    ||
	    cxwid->core.height != nxwid->core.height)
	{
	   xvw_set_attributes(xvw_object(new),
		XVW_PREFERRED_WIDTH,  (int) nxwid->core.width,
		XVW_PREFERRED_HEIGHT, (int) nxwid->core.height,
		NULL);
	}

	if (cxwid->core.colormap != nxwid->core.colormap)
	   ManagerSetWMColormap(nxwid);

	if (cxwid->manager.editing != nxwid->manager.editing)
	   ManagerSelect(nxwid, nxwid->manager.editing);

	if (cxwid->manager.vert_offset  != nxwid->manager.vert_offset         ||
	    cxwid->manager.horiz_offset != nxwid->manager.horiz_offset        ||
	    cxwid->manager.max_width    != nxwid->manager.max_width           ||
	    cxwid->manager.max_height   != nxwid->manager.max_height          ||
	    cxwid->manager.min_width    != nxwid->manager.min_width           ||
	    cxwid->manager.min_height   != nxwid->manager.min_height	      ||
	    cxwid->manager.preferred_width  != nxwid->manager.preferred_width ||
	    cxwid->manager.preferred_height != nxwid->manager.preferred_height)
	{
	   if (XtIsSubclass(XtParent(new), ManagerWidgetClass))
	   {
	      XvwManagerWidgetConstraints kman = kconstraint(new);

	      kman->manager.min_width         = nxwid->manager.min_width;
	      kman->manager.max_width         = nxwid->manager.max_width;
	      kman->manager.min_height        = nxwid->manager.min_height;
	      kman->manager.max_height        = nxwid->manager.max_height;
	      kman->manager.preferred_width   = nxwid->manager.preferred_width;
	      kman->manager.preferred_height  = nxwid->manager.preferred_height;
	   }

	   if (nxwid->manager.min_width > nxwid->core.width)
	      nxwid->core.width = nxwid->manager.min_width;
	   else if (nxwid->manager.max_width < nxwid->core.width)
	      nxwid->core.width = nxwid->manager.max_width;

	   if (nxwid->manager.min_height > nxwid->core.height)
	      nxwid->core.height = nxwid->manager.min_height;
	   else if (nxwid->manager.max_height < nxwid->core.height)
	      nxwid->core.height = nxwid->manager.max_height;
	   ManagerRequestLayout(new, FALSE);
	}

	if (cxwid->manager.allow_menuing   != nxwid->manager.allow_menuing   ||
	    cxwid->manager.allow_selecting != nxwid->manager.allow_selecting ||
	    cxwid->manager.allow_resizing  != nxwid->manager.allow_resizing)
	{
	   if (XtIsSubclass(XtParent(new), ManagerWidgetClass))
	   {
	      XvwManagerWidgetConstraints kman = kconstraint(new);

	      kman->manager.allow_menuing   = nxwid->manager.allow_menuing;
	      kman->manager.allow_selecting = nxwid->manager.allow_selecting;
	      kman->manager.allow_resizing  = nxwid->manager.allow_resizing;
	   }
	}

	if (cxwid->manager.visual != nxwid->manager.visual)
	{
	   XVisualInfo vinfo, *info;
	   Display *display = XtDisplay(new);
	   int     num, screen = XScreenNumberOfScreen(XtScreen(new));

	   vinfo.visualid = XVisualIDFromVisual(nxwid->manager.visual);
	   if ((info = XGetVisualInfo(XtDisplay(new), VisualIDMask, &vinfo,
			      &num)) != NULL && num == 1)
	   {
	      nxwid->core.depth = info[0].depth;
	      kfree(info);
	   }

	   if (nxwid->manager.visual != DefaultVisual(display, screen))
	   {
	      new->core.colormap = XCreateColormap(display, RootWindow(display,
			screen), nxwid->manager.visual, AllocNone);
	   }
	   else
	      new->core.colormap = DefaultColormap(display, screen);

	   if (XtWindow(new) != None)
	   {
	      XtUnrealizeWidget(current);
	      xvw_realize(xvw_object(new));
	   }
	}

	if (cxwid->manager.gridtype != nxwid->manager.gridtype ||
	    cxwid->manager.gridsize != nxwid->manager.gridsize ||
	    cxwid->manager.xsnap    != nxwid->manager.xsnap ||
	    cxwid->manager.ysnap    != nxwid->manager.ysnap ||
	    cxwid->manager.grid_pixel       != nxwid->manager.grid_pixel    ||
	    cxwid->core.background_pixel    != nxwid->core.background_pixel ||
	    cxwid->manager.foreground_pixel != nxwid->manager.foreground_pixel)
	{
	   if (cxwid->manager.gridsize != nxwid->manager.gridsize)
	   {
	      nxwid->manager.xsnap =
	      nxwid->manager.ysnap = nxwid->manager.gridsize;
	   }

	   if (nxwid->manager.editing == FALSE)
	      ManagerCreateGrid(new);
	}

	if (cxwid->core.background_pixmap != nxwid->core.background_pixmap)
	{
	   if (nxwid->core.background_pixmap == XtUnspecifiedPixmap)
	      ManagerCreateGrid(new);
	}

        if (cxwid->manager.cursor != nxwid->manager.cursor &&
            new->core.window)
        {
           XDefineCursor(XtDisplay(new), XtWindow(new), nxwid->manager.cursor);
        }
	return(FALSE);
}


/************************************************************
*
*  Routine Name: xvw_create_manager - create a Khoros Manager object
*
*       Purpose: Creates a Khoros Manager object to serve as a backplane
*                (parent) for visual objects and/or GUI objects .
*                The following widget is the base widget
*		 used by all graphical user interface programs.
*		 This manager plays an integral role in managing
*		 all Khoros related applications.  It is the
*		 glue by which several important Khoros features
*		 are implemented.
*		 
*		 The features that this widget provide are:
*		 
*		 1) common manager widget to make implementing
*		    multiple widgets set possible.
*		 
*		 2) the ability of providing an interactive
*		    editing capibility to every application.
*		 
*		 3) with the advent of an object (gadget)
*		    based annotations capibility.  We want
*		    any application to be able to advantage
*		    of this feature with little or no work.
*		    (this also enforces a common interface).
*		 
*		    First off by having a common widget "manager"
*		    we effectively make the implementation of multiple
*		    widget sets possible.  The idea is that most widgets
*		    sets such as
*		 
*		    Athena, Motif, Open Look (Olit)
*		 
*		    have similar objects such as buttons, labels,
*		    lists, etc.  But the manager widgets are not
*		    similar.  They all have a different layout
*		    philsophy and terminolgy thus making it difficult
*		    to write transparent code for.  Also, since we
*		    originally wrote Khoros 1.0 with the MIT
*		    Form Widget in mind, this part of the system
*		    is extremely similar in terminology.
*
*         Input: parent - parent of the Manager object: a toplevel object,
*			  another Manager object, or NULL.  If NULL is 
*                         provided, a default toplevel object will be created 
*                         automatically to serve as a parent for the manager.
*                name   - name with which to reference Manager object
*
*        Output: 
*	Returns: The Manager object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jan 14, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_manager(
   xvobject parent,
   char     *name)
{
	xvobject back;


	back = xvw_create(parent, FALSE, TRUE, name, ManagerWidgetClass);
	return(back);
}
