 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Info Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		ButtonCallback()
   >>>>   Public:
   >>>>			xvw_create_info()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/InfoP.h>

static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static void	ButtonCallback  PROTO((xvobject, kaddr, kaddr));


/*-------------------------------------------------------------------*
|
|   Define Default Pixmap Paths
|
--------------------------------------------------------------------*/
 
#define INFO_PIXMAP "$DESIGN/objects/library/xvobjects/misc/pixmaps/info.xpm"

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_INFO_LABEL_OBJECT,   NULL,   XtRPointer,  NULL},
{XVW_INFO_BUTTON_OBJECT,  NULL,   XtRPointer,  NULL},
{XVW_INFO_TEXT_OBJECT,    NULL,   XtRPointer,  NULL},
{XVW_INFO_CALLBACK,	  NULL,   XtRCallback, NULL},

{XVW_INFO_PIXMAP,	  NULL,   XtRPixmap,   NULL},
{XVW_INFO_PIXMAPFILE,	  XVW_INFO_PIXMAP, XtRFilename, XtRPixmap},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwInfoWidgetRec, info.field)

static XtResource resources[] = { 
{XVW_INFO_LABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(label), XtRImmediate, (XtPointer) NULL},
{XVW_INFO_BUTTON_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(button), XtRImmediate, (XtPointer) NULL},
{XVW_INFO_TEXT_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(text), XtRImmediate, (XtPointer) NULL},
{XVW_INFO_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(info_callback), XtRCallback, (XtPointer) NULL},

{XVW_INFO_PIXMAP, XVW_INFO_PIXMAPFILE,  XtRPixmap, sizeof(Pixmap),
        offset(info_pixmap), XtRString, (XtPointer) INFO_PIXMAP},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Info Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwInfoWidgetClassRec xvwInfoWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Info",				/* class_name		  */
    sizeof(XvwInfoWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    NULL,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwInfoWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwInfoWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwInfoWidgetClass = (WidgetClass) &xvwInfoWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef kwidget
#undef kwidgetclass
#undef kconstraint

#define kwidget(widget)	     (XvwInfoWidget) (widget)
#define kwidgetclass(widget) (XvwInfoWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwInfoWidgetConstraints) (widget)->core.constraints


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwInfoWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input:
|
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Oct 19, 1992 9:54
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwInfoWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/Info");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial info widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: May 26, 1993 13:28
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwInfoWidget xwid = kwidget(new);
	xvobject info_symbol, object = xvw_object(new);


	info_symbol = xvw_create_pixmap(object, "pixmap");
	xvw_set_attributes(info_symbol,
		XVW_PIXMAP,	      xwid->info.info_pixmap,
		XVW_BELOW,            NULL,
		XVW_RIGHT_OF,         NULL,
		XVW_BORDER_WIDTH,     0,
		NULL);

	xwid->info.text = xvw_create_text(object, "text");
	xvw_set_attributes(xwid->info.text,
		XVW_TEXT_MULTILINE,   TRUE,
		XVW_TACK_EDGE,        KMANAGER_TACK_ALL,
		XVW_TEXT_EDIT_TYPE,   KTEXT_READ,
		XVW_TEXT_WRAP,        KTEXT_WRAP_WORD,
		XVW_BELOW,	      info_symbol,
		NULL);

	xwid->info.button = xvw_create_button(object, "button");
	xvw_set_attributes(xwid->info.button,
		XVW_LABEL,		"Ok",
		XVW_CHAR_HEIGHT,	1.0,
		XVW_LABEL_JUSTIFY,      KLABEL_JUSTIFY_CENTER,
		XVW_LEFT_OF,		NULL,
		XVW_ABOVE,		xwid->info.text,
		XVW_BELOW,		NULL,
		NULL);

	xwid->info.label = xvw_create_label(object, "label");
	xvw_set_attributes(xwid->info.label,
		XVW_BORDER_WIDTH,       0,
		XVW_LABEL,		"Info:",
		XVW_CHAR_HEIGHT,	1.0,
		XVW_LABEL_JUSTIFY,      KLABEL_JUSTIFY_CENTER,
		XVW_RIGHT_OF,		info_symbol,
		XVW_LEFT_OF,		xwid->info.button,
		XVW_ABOVE,		xwid->info.text,
		XVW_BELOW,		NULL,
		NULL);

	xvw_set_attributes(object,
		XVW_CHAR_WIDTH,     42.0,
		XVW_CHAR_HEIGHT,     9.0,
		NULL);

	xvw_insert_callback(xwid->info.button, XVW_BUTTON_SELECT, TRUE,
			ButtonCallback, object);
}

/*-----------------------------------------------------------
|
|  Routine Name: ButtonCallback
|
|       Purpose: This routine will be called when the button callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|
|        Output: None
|       Returns: None
|
|    Written By: Mark Young
|          Date: Jun 06, 1993 10:58
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ButtonCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject info = (xvobject) client_data;


	XtCallCallbacks(xvw_widget(info), XVW_INFO_CALLBACK, NULL);
	xvw_unmap(xvw_toplevel(info));
	xvw_destroy(info);
}


/************************************************************
*
*  Routine Name: xvw_create_info - create an info object
*
*       Purpose: The info object is
*                a pop-up window that displays an informative message.
*                A "nose knows" icon on the upper left hand side of
*                the info object draws the attention of the user;
*                a single button on the upper right hand side of
*                the info object allows the user to acknowledge
*                the information.
*
*                After the user clicks on the acknowledgment button,
*                the info object is destroyed.
*
*                A callback can be installed on the info object, which
*                will be fired when the user clicks on the acknowledgment
*                button.
*
*         Input: parent - parent of the info object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference info object
*
*        Output:
*       Returns: The info object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Oct 27, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_info(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, TRUE, TRUE, name, InfoWidgetClass);
	return(object);
}
