 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros GenericWindow Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		Realize()
   >>>> 		Destroy()
   >>>>			SetValues 
   >>>>   Public:
   >>>>			xvw_create_genericwindow()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/GenericWindowP.h>

static void ClassInitialize PROTO((void));
static void Realize      PROTO((Widget, XtValueMask *, XSetWindowAttributes *));
static void Destroy      PROTO((Widget));
static Boolean SetValues PROTO((Widget, Widget, Widget, ArgList, Cardinal *));

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
  {XVW_GENERIC_WINDOW,  XtNwindow,  XtRWindow,  NULL},
};

/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwGenericWindowWidgetRec, genericwindow.field)

static XtResource resources[] = { 
{XtNwindow, NULL, XtRWindow, sizeof(Window),
        XtOffsetOf(XvwManagerWidgetRec, core.window),
        XtRImmediate, (XtPointer) 0},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for GenericWindow Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwGenericWindowWidgetClassRec xvwGenericWindowWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "GenericWindow",			/* class_name		  */
    sizeof(XvwGenericWindowWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwGenericWindowWidgetConstraintsRec),/* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwGenericWindowWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwGenericWindowWidgetClass = (WidgetClass) &xvwGenericWindowWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef kwidget
#undef kwidgetclass
#undef kconstraint

#define kwidget(widget)	    (XvwGenericWindowWidget) (widget)
#define kwidgetclass(widget) (XvwGenericWindowWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwGenericWindowWidgetConstraints) (widget)->core.constraints


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwGenericWindowWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Apr 01, 1995
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwGenericWindowWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/GenericWindow");
}

/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This method will set up the window attributes
|                and create a window for the XvwGenericWindowWidget. 
|                The desired initial window attributes are passed 
|                in via a mask and list of specification attributes.
|		 The gc is also initialized here.
|
|         Input: widget     - the widget to realize
|                valuemask  - determines the window attributes being passed in
|                attributes - the list of window attributes to be set
|    Written By: Mark Young
|          Date: Apr 01, 1995
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget               widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
	XvwGenericWindowWidget xwid = kwidget(widget);

}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: This method will used to destroy the generic window object.
|		 This routine needs to unset the window, since when the object
|		 is destroyed Xt will also destroy the window.  Therefore, we
|		 will use this routine to avoid destroying the window.
|
|         Input: widget     - the widget to destroy
|    Written By: Mark Young
|          Date: Apr 05, 1995
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget               widget)
{
	XvwGenericWindowWidget xwid = kwidget(widget);

	xwid->core.window = NONE;
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues 
|
|       Purpose: This method is used to set the public values 
|                of a XvwGenericWindowWidget instance.  The public values
|		 which can be changed are the actual window.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Apr 01, 1995
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwGenericWindowWidget cxwid = kwidget(current);
	XvwGenericWindowWidget nxwid = kwidget(new);

	int      x, y;
	Window   rootwindow;
	unsigned int width, height, border_width, depth;

	if (cxwid->core.window != nxwid->core.window &&
	    nxwid->core.window != None)
	{
	   XGetGeometry(XtDisplay(current), nxwid->core.window, &rootwindow,
		&x, &y, &width, &height, &border_width, &depth);
	   nxwid->core.x = x;
	   nxwid->core.y = y;
	   nxwid->core.width  = width;
	   nxwid->core.height = height;
	   nxwid->core.border_width = border_width;
/*
	   XtGrabPointer(new, True, PointerMotionMask|ButtonPressMask|
		ButtonReleaseMask, GrabModeAsync, GrabModeAsync,
		None, None, CurrentTime);
 */
	}
	return(FALSE);
}


/************************************************************
*
*  Routine Name: xvw_create_genericwindow - create a genericwindow object
*
*       Purpose: Creates a genericwindow object.  The genericwindow object
*		 allows the user to reverse engineer a window into a
*		 object.  The object is subclassed from the Manager,
*		 which means that the programmer also has access to
*		 that window's children.  The programmer may also added
*		 new children to the object, as well as manipulate the
*		 children.
*
*		 This allows the programmer with a powerful in which
*		 to reverse engineer a window, that can then be manipulated
*		 as a standard gui object.
*
*         Input: parent - parent of the genericwindow object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference genericwindow object
*
*        Output:
*       Returns: The genericwindow object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Apr 01, 1995
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_genericwindow(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name,GenericWindowWidgetClass);
	return(object);
}
