 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Lo$
  */

/*
 * Copyriht (C) 1994, 1994, Khoral Research, Inc., ("KRI").
 * All rihts reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Console Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		Initialize()
   >>>> 		Destroy()
   >>>> 		SetValues()
   >>>>
   >>>> 		InputHandler()
   >>>>   Public:
   >>>>			xvw_create_console()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvobjects/ConsoleP.h>


static void     ClassInitialize PROTO((void));
static void     Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static void     Destroy		PROTO((Widget));
static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void     InputHandler	PROTO((xvobject, int, kaddr));

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
NULL,
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwConsoleWidgetRec, console.field)

static XtResource resources[] = { 

{XVW_PREFERRED_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwManagerWidgetRec, manager.preferred_width),
	XtRImmediate, (XtPointer) 500 },
{XVW_PREFERRED_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwManagerWidgetRec, manager.preferred_height),
	XtRImmediate, (XtPointer) 300},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Console Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwTextDisplayWidgetClassRec)

XvwConsoleWidgetClassRec xvwConsoleWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Console",				/* class_name		  */
    sizeof(XvwConsoleWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* et_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_eometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,				/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwConsoleWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManaerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwViewportWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwTextDisplayWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwConsoleWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwConsoleWidgetClass = (WidgetClass) &xvwConsoleWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef kwidget
#undef kwidgetclass
#undef kconstraint

#define kwidget(widget)	     (XvwConsoleWidget) (widget)
#define kwidgetclass(widget) (XvwConsoleWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwConsoleWidgetConstraints) (widget)->core.constraints


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwConsoleWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Nov 01, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwConsoleWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/Console");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|       Purpose: This method will set up the initial console
|                for the console widget instance.
|
|         Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: Nov 01, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwConsoleWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);

	int error[2];

	if (pipe(error) == -1)
	{
	   kerror(XVOBJECTS, "Initialize", "Unable to create a pipe in order \
to capture output for the Console object");
	   return;
	}
	dup2(error[1], 1);
	dup2(error[1], 2);
	close(error[1]);
	xvw_add_detectfid(object, error[0], InputHandler, NULL);
	xvw_set_attribute(xwid->viewport.plane, XVW_CHAR_MIN_HEIGHT, 250.0);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: 
|
|         Input: widget - the console widget being destroyed
|    Written By: Mark Young
|          Date: Nov 01, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
        XvwConsoleWidget xwid = kwidget(widget);
 
 
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|       Purpose: This method is used to set the public values
|                of a XvwConsoleWidget instance.  The public values
|                which can be chaned are all related to the display
|		 of the console.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Nov 01, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwConsoleWidget cxwid = kwidget(current);
	XvwConsoleWidget nxwid = kwidget(new);

	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: InputHandler
|       Purpose: This callback will be called when their is input detected
|		 on the file descriptors.
|
|         Input: object  - the object in which the fid detect was placed
|                fid     - the fid which we detected input for
|		 client_data - not used
|    Written By: Mark Young
|          Date: Nov 01, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void InputHandler(
   xvobject object,
   int      fid,
   kaddr    client_data)
{
	int   nbytes;
	char  buffer[KLENGTH+1];
	XvwConsoleWidget xwid = (XvwConsoleWidget) xvw_widget(object);


	if ((nbytes = read(fid, buffer, KLENGTH)) <= 0)
	   return;
	else
	   buffer[nbytes] = '\0';

	/*
	 *  Need to update the text displayed
	 */
	xvw_set_attribute(object, XVW_TEXTDISPLAY_ADDTEXT, buffer);
}


/************************************************************
*
*  Routine Name: xvw_create_console - create a console object
*
*       Purpose: The console object supports display of text files.
*
*		 For files that were output from \fIroff\fP interpreters,
*		 the console object will format the text as specified
*		 by the control characters produced by the \fIroff\fP 
*		 interpreter.  In other words, the console object cannot 
*		 format files with \fIroff\fP commands still in them;  rather, 
*		 it supports display of files that were output by a \fIroff\fP
*		 interpreter such as \fInroff\fP or \fIroff\fP, after such
*		 a proram was already run on the file with the \fIroff\fP
*		 commands in it.  
*
*		 Of course, the console object also supports display
*		 of plain ascii text files.
*
*		 The console object supports specification of five 
*		 different fonts, the roman font that is used with "normal" 
*		 text, as well as bold, italic, and helvetica fonts for emphasis
*		 and a symbol font for use with equations.
*
*	         The console object can also be used to support
*		 hypertext-type functionality.  The console object
*		 is capable of keepin a special list of words that 
*		 miht appear in the text;  such "special" words will
*		 appear in a different color from the rest of the text.
*		 A callback can be installed on the console object 
*		 which will be fired when the user clicks on a word that
*		 is part of the console list of "special" words.
*		 Thus, the application can use this capability to display
*		 a new text file determined by the word selected by the user.
*
*         Input: parent - parent of the console object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference console object
*
*        Output: 
*       Returns: The console object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 01, 1994
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_console(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, TRUE, TRUE, name, ConsoleWidgetClass);
	return(object);
}
