 /* Khoros: $Id$ */
 /* $Log$ */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for xvlang library
   >>>>
   >>>>    Written By: Mark Young and John Salas
   >>>>
   >>>>          Date: Mar 28, 1993 15:04
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_internals_h_
#define _xvlang_internals_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <design.h>
#include <xvinclude.h>
#include <X11/IntrinsicP.h>
#include <xvlang/xvlang.h>


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define XVLANG "xvlang"


	/*-------------------------------------*
	|       #macros 
	---------------------------------------*/


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  GlyphUtil.c
 */
void GlyphUpdateForm PROTO((Widget));
void GlyphInitForm   PROTO((kaddr));
void GlyphHandler    PROTO((xvobject, kaddr, XEvent *, int *));
int  SetFormfile     PROTO((xvobject, char *, kaddr));
int  GetFormfile     PROTO((xvobject, char *, kaddr));
void GlyphDestroyCallback  PROTO((xvobject, kaddr, kaddr));
int  GlyphFormExpression   PROTO((kform *, kaddr, char *, int, kaddr, char *));
int  GlyphCreateConnection PROTO((xvobject, xvobject));
void GlyphFormCallback PROTO((kform *, ksubform *, kaddr));


/*
 *  WorkspaceUtil.c
 */
void WorkspaceRun	    PROTO((kaddr));
void WorkspaceInitClipboard PROTO((void));
int  WorkspaceActions	    PROTO((xvobject, char *, kaddr));
void WorkspaceCallbacks     PROTO((xvobject, kaddr, kaddr));
int WorkspaceRestore 	    PROTO((Widget, kfile *, int, int, xvobject *, int));
int WorkspaceSave 	    PROTO((Widget, kfile *, int, int, int, int,
				   xvobject **, int *));
void WorkspaceAnnounce	    PROTO((xvobject, kaddr, XEvent *, int *));
xvobject *WorkspaceChildren PROTO((xvobject, int, int *));
void WorkspaceGlyphRunCallback      PROTO((xvobject, kaddr, kaddr));
void WorkspaceGlyphModifiedCallback PROTO((xvobject, kaddr, kaddr));
void WorkspaceMap 	    PROTO((xvobject));
void WorkspaceUnmap 	    PROTO((xvobject));


/*
 *  Glyph.c
 */
xvobject  GlyphFindNode PROTO((xvobject, char *, char *, kform_struct **));

/*
 *  Node.c
 */
void RequestDispatchNode PROTO((void));

/*
 *  Port.c
 */
int  PortCreateConnection PROTO((xvobject, xvobject));
int  PortGetInfo PROTO((xvobject, char **, char **, int *,
			int *, int *, xvobject **));

/*
 *  utilities.c
 */
void xvw_copy_pane      PROTO((kform *, xvobject, xvobject, kform *));
void xvw_copy_selection PROTO((kform *, xvobject, xvobject, kform_struct *,
			       char *));

#endif /* _xvlang_internals_h_ */
/* Don't add after this point */
