 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "copyright.h"          /* Khoros copyright */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros ToolboxList Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		SetValues()
   >>>> 		SelectCallback()
   >>>> 		CreateCallback()
   >>>> 		ToolboxListActions()
   >>>>   Public:
   >>>>			xvw_create_toolboxlist()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvlang/ToolboxListP.h>

static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));

static void	SelectCallback     PROTO((xvobject, kaddr, kaddr));
static void	CreateCallback     PROTO((xvobject, kaddr, kaddr));
static int	ToolboxListActions PROTO((xvobject, char *, kaddr));



/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_TOOLBOXLIST_SELECT,      NULL,   XtRCallback, NULL},
{XVW_TOOLBOXLIST_CREATE,      NULL,   XtRCallback, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwToolboxListWidgetRec, toolboxlist.field)

static XtResource resources[] = { 
{XVW_TOOLBOXLIST_SELECT, NULL, XtRCallback, sizeof(XtPointer),
      offset(select_callback), XtRCallback, (XtPointer) NULL},
{XVW_TOOLBOXLIST_CREATE, NULL, XtRCallback, sizeof(XtPointer),
      offset(create_callback), XtRCallback, (XtPointer) NULL},

{XVW_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwToolboxListWidgetRec, core.width),
        XtRImmediate, (XtPointer) 500},
{XVW_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwToolboxListWidgetRec, core.height),
        XtRImmediate, (XtPointer) 200},
{XVW_DEF_HORIZ_DIST, NULL, XtRPosition, sizeof(Position),
        XtOffsetOf(XvwToolboxListWidgetRec, manager.horiz_offset),
        XtRImmediate, (XtPointer) 0},
{XVW_DEF_VERT_DIST, NULL, XtRPosition, sizeof(Position),
        XtOffsetOf(XvwToolboxListWidgetRec, manager.vert_offset),
        XtRImmediate, (XtPointer) 0},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for ToolboxList Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwToolboxListWidgetClassRec xvwToolboxListWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "ToolboxList",			/* class_name		  */
    sizeof(XvwToolboxListWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwToolboxListWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwToolboxListWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwToolboxListWidgetClass = (WidgetClass) &xvwToolboxListWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwToolboxListWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwToolboxListWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwToolboxListWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/ToolboxList");

	xvw_define_attributes(xvwToolboxListWidgetClass,
		XVW_TOOLBOXLIST_OPEN, XtRInt, ToolboxListActions, NULL,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial toolboxlist widget
|		 instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwToolboxListWidget xwid = kwidget(new);

	xvw_list_struct entry;
	int      width, height;
	xvobject object, cat_listobj, sub_listobj, icon_listobj;


	/*
	 *  Initialize the selected program info to be initially empty
	 */
	xwid->toolboxlist.sublist  = NULL;
	xwid->toolboxlist.iconlist = NULL;
	xwid->toolboxlist.selected.icon_name   = NULL;
	xwid->toolboxlist.selected.tbname      = NULL;
	xwid->toolboxlist.selected.oname       = NULL;
	xwid->toolboxlist.selected.category    = NULL;
	xwid->toolboxlist.selected.subcategory = NULL;
	xwid->toolboxlist.selected.panefile    = NULL;
	xwid->toolboxlist.selected.short_desc  = NULL;

	object = xvw_object(new);
	cat_listobj  = xvw_create_list(object, "CategoryList");
	sub_listobj  = xvw_create_list(object, "SubCategoryList");
	icon_listobj = xvw_create_list(object, "IconList");
	width  = new->core.width;
	height = new->core.height;
	xvw_set_attributes(cat_listobj,
		XVW_RIGHT_OF,      NULL,
		XVW_MINIMUM_WIDTH, width/3,
		XVW_MAXIMUM_WIDTH, width/3,
		XVW_TACK_EDGE,     KMANAGER_TACK_VERT,
		XVW_BORDER_WIDTH,  0,
		NULL);
	xvw_set_attributes(sub_listobj,
		XVW_RIGHT_OF,      cat_listobj,
		XVW_MINIMUM_WIDTH, width/3,
		XVW_MAXIMUM_WIDTH, width/3,
		XVW_TACK_EDGE,     KMANAGER_TACK_VERT,
		XVW_BORDER_WIDTH,  0,
		NULL);
	xvw_set_attributes(icon_listobj,
		XVW_RIGHT_OF,      sub_listobj,
		XVW_MINIMUM_WIDTH, width/3,
		XVW_MAXIMUM_WIDTH, width/3,
		XVW_TACK_EDGE,     KMANAGER_TACK_VERT,
		XVW_BORDER_WIDTH,  0,
		NULL);

	xwid->toolboxlist.cat_listobj  = cat_listobj;
	xwid->toolboxlist.sub_listobj  = sub_listobj;
	xwid->toolboxlist.icon_listobj = icon_listobj;
	xwid->toolboxlist.catobj  = xvw_retrieve_list(cat_listobj);
	xwid->toolboxlist.subobj  = xvw_retrieve_list(sub_listobj);
	xwid->toolboxlist.iconobj = xvw_retrieve_list(icon_listobj);

	xvw_insert_callback(xwid->toolboxlist.catobj,
		 XVW_LIST_ITEM_SELECT, FALSE, SelectCallback, new);
	xvw_insert_callback(xwid->toolboxlist.subobj,
		 XVW_LIST_ITEM_SELECT, FALSE, SelectCallback, new);
	xvw_insert_callback(xwid->toolboxlist.iconobj,
		XVW_LIST_ITEM_SELECT, FALSE, SelectCallback, new);
	xvw_insert_callback(xwid->toolboxlist.iconobj,
		XVW_LIST_ITEM_ACTION, FALSE, CreateCallback, new);

	/*
	 *  Gotta bootstrap ourselves.  This is pretty crude, but it works...
	 */
	entry.list_index = -1;
	SelectCallback(xwid->toolboxlist.catobj, new, &entry);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwToolboxListWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the error.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwToolboxListWidget cxwid = kwidget(current);
	XvwToolboxListWidget nxwid = kwidget(new);


	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: SelectCallback
|
|       Purpose: This routine will be called when the list callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/
 
static void SelectCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject toolboxlist = (xvobject) client_data;
        xvw_list_struct *entry = (xvw_list_struct *) call_data;

	Widget widget = xvw_widget(toolboxlist);
	XvwToolboxListWidget xwid = kwidget(widget);
	xvobject catobj  = xwid->toolboxlist.catobj;
	xvobject subobj  = xwid->toolboxlist.subobj;
	xvobject iconobj = xwid->toolboxlist.iconobj;

	klist *list, *master;
	xvw_program_info selected;
	char  *name, **info = NULL, **temp = NULL;
        int   i, selected_indx = -1, indx = entry->list_index;
 
 
        if (xvw_get_attribute(object, XVW_LIST_HIGHLT_ELEM, &selected_indx) &&
	    selected_indx != -1 && selected_indx != indx)
	{
           xvw_set_attribute(object, XVW_LIST_UNHIGHLT_ELEM, selected_indx);
	}

	if (object == catobj)
	{
           xvw_get_contents(&master, NULL);
           if (indx == -1)
           {
              for (i = 0, list = master; list != NULL; i++)
              {
                 name = ktoken_to_string((int) klist_identifier(list));
                 temp = karray_add(temp, name, i);
                 list = klist_next(list);
              }
              xvw_change_list(object, temp, i, FALSE);
              kfree(temp);
           }

	   for (i = 0, list = master; i < indx && list != NULL; i++)
	      list = klist_next(list);

	   if (!list) return;
	   entry->list_index = -1;
	   xwid->toolboxlist.sublist = klist_clientdata(list);
	   SelectCallback(subobj, client_data, call_data);
	}
	else if (object == subobj)
	{
	   list = master = xwid->toolboxlist.sublist;
	   for (i = 0; list != NULL; i++)
	   {
	      if (indx == -1)
	      {
	         name = ktoken_to_string((int) klist_identifier(list));
	         temp = karray_add(temp, name, i);
	      }
	      if (i == indx) master = list;
	      list = klist_next(list);
	   }

	   if (indx == -1)
	   {
	      xvw_change_list(object, temp, i, FALSE);
	      kfree(temp);
	   }
	   entry->list_index = -1;
	   xwid->toolboxlist.iconlist = klist_clientdata(master);
	   SelectCallback(iconobj, client_data, call_data);
	}
	else if (object == iconobj)
	{
	   master = xwid->toolboxlist.iconlist;
	   if (indx == -1)
	   {
	      for (i = 0, list = master; list != NULL; i++)
	      {
                 info = klist_clientdata(list);
	         temp = karray_add(temp, info[0], i);
		 list = klist_next(list);
	      }
	      xvw_change_list(object, temp, i, FALSE);
	      kfree(temp);
           }

	   for (i = 0, list = master; i < indx; i++)
	      list = klist_next(list);

	   if (xvw_load_content(list, &xwid->toolboxlist.selected) == TRUE)
	   {
	      selected = xwid->toolboxlist.selected;
	      XtCallCallbacks(widget, XVW_TOOLBOXLIST_SELECT, &selected);
	   }
	}

        if (selected_indx != indx || indx == -1)
	{
	   if (indx == -1) indx = 0;
	   xvw_set_attribute(object, XVW_LIST_HIGHLT_ELEM, indx);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: CreateCallback
|
|       Purpose: This routine will be called when the list callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/
 
static void CreateCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject toolboxlist = (xvobject) client_data;

	xvw_program_info selected;
	Widget   widget = xvw_widget(toolboxlist);
	XvwToolboxListWidget xwid = (XvwToolboxListWidget) widget;

	selected = xwid->toolboxlist.selected;
	XtCallCallbacks(widget, XVW_TOOLBOXLIST_CREATE, &selected);
}

/*-----------------------------------------------------------
|
|  Routine Name: ToolboxListActions
|
|       Purpose: ToolboxListActions is used to set the certain actions
|		 associated with the current ToolboxList object.
|
|         Input: object    - the object in which we will be setting the
|			     attribute value for
|		 attribute - the desired attribute
|		 calldata  - the value to be set
|       Returns: TRUE on success, FALSE on failure
|    Written By: Mark Young
|          Date: Jul 10, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static int ToolboxListActions(
   xvobject toolboxlist,
   char     *attribute,
   kaddr    calldata)
{
	XvwToolboxListWidget xwid=(XvwToolboxListWidget)xvw_widget(toolboxlist);
	Widget widget = (Widget) xwid;


	if (kstrcmp(attribute, XVW_TOOLBOXLIST_OPEN) == 0)
	{
	   XtCallCallbacks(widget, XVW_TOOLBOXLIST_CREATE,
			&xwid->toolboxlist.selected);
	}
	else
	{
	   kerror(XVLANG, "ToolboxListActions", "invalid attribute %s",
			attribute);
	   return(FALSE);
	}
	return(TRUE);
}


/************************************************************
*
*  Routine Name: xvw_create_toolboxlist - create a toolbox list object
*
*       Purpose: Creates a toolbox list object, that consists of three
*		 list objects.  The first list displays the different
*		 categories.  The second list displays the sub-categories
*		 for the selected category.  And finally the third
*		 displays the operators for the selected sub-category.
*
*		 Two callbacks are provided which can be used to notify
*		 the programmer when the user selects or activates an operator
*		 from the list.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object
*        Output: None
*       Returns: The toolboxlist object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jul 02, 1994
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_toolboxlist(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, ToolboxListWidgetClass);
	return(object);
}
