 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                 TextString Gadget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			SetValues()
   >>>>			TextStringHandler()
   >>>>   Public:
   >>>>			xvw_create_textstring()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/TextStringP.h>


static void ClassInitialize	PROTO((void));
static void Initialize		PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues	PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void TextStringHandler	PROTO((xvobject, kaddr, XEvent *, int *));


/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_TEXTSTRING_INSERTION,     NULL,    XtRInt,	NULL},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwTextStringGadgetRec, textstring.field)

static XtResource resources[] = { 
{XVW_TEXTSTRING_INSERTION, NULL, XtRInt, sizeof(int),
      offset(insertion), XtRImmediate, (XtPointer) 0},
};
#undef offset

#define SUPERCLASS (&xvwStringGadgetClassRec)

XvwTextStringGadgetClassRec xvwTextStringGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "TextString",		        /* class_name		  */
    sizeof(XvwTextStringGadgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    XtInheritPicking,			/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritChangeGeometry,		/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    XtInheritRecomputePosition,		/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* xvwStringGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* xvwTextStringGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * XvwTextStringGadgetClass for public consumption
 */
WidgetClass xvwTextStringGadgetClass = (WidgetClass) &xvwTextStringGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of text object class has been created.
|                It will initialize all the class attributes. 
|
|         Input:
|
|        Output:
|
|    Written By: Mark Young
|          Date: Mar 09, 1993 12:02
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwTextStringGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/TextString.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/TextString");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize 
|
|       Purpose: This method will set up the initial values 
|                for all the text fields of a text object instance.
|		 The text uptext routine is also installed to uptext
|		 the text via a text event handler.
|
|         Input: request - not used 
|                new     - object instance after initialization, with
|                          text initialized 
|
|        Output:
|
|    Written By: Mark Young
|          Date: Mar 09, 1993 12:02
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	xvw_add_event(xvw_object(new), ButtonPressMask | KeyPressMask,
		      TextStringHandler, NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public fields
|                of a text object instance.  These fields are
|		 the text format and uptext time.
|                 
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young 
|          Date: Mar 09, 1993 12:03
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwTextStringGadget cobj = (XvwTextStringGadget) current;
	XvwTextStringGadget nobj = (XvwTextStringGadget) new;

	return(FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: This method will destroy the text cursor
|		 since the textstring cursor is not our child.
|
|         Input: widget - the object being destroyed
|
|        Output:
|
|    Written By: Mark Young
|          Date: May 26, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwTextStringGadget xobj = (XvwTextStringGadget) widget;

	Widget parent =  XtParent(widget);

	if (!parent->core.being_destroyed)
           xvw_destroy(xobj->textstring.cursor);
}


/*-----------------------------------------------------------
|
|  Routine Name: TextStringHandler 
|
|       Purpose: This routine is used 
|
|         Input: xobj - the text object being changed
|		 id   - the id of the timeout interval
|
|        Output:
|
|    Written By: Mark Young
|          Date: Mar 09, 1993 12:03
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void TextStringHandler(
   xvobject object,
   kaddr    clientData,
   XEvent   *event,
   int      *dispatch)
{
	XvwTextStringGadget xobj = (XvwTextStringGadget) xvw_widget(object);

	double factor;
	int    insert, length;
	char   ch, text[KLENGTH], *oldtext;
	static Boolean deleted_last, inserted_last;


	length = kstrlen(xobj->string.string);
	oldtext = xobj->string.string;

	if (event->type == KeyPress)
	{
	   if (!XLookupString(&(event->xkey), &ch, 1, NULL, NULL))
	      return;

	   insert = xobj->textstring.insertion;
	   if (ch == 8 || ch == 127)
	   {
	      insert--;
	      if (insert < 0)
		 return;

	      length--;
	      kstrncpy(text, oldtext, insert);
	      kstrncpy(&text[insert], &oldtext[insert+1], length-insert);
	      text[length] = '\0';
	      xobj->textstring.insertion--;
	      deleted_last = TRUE;
	      inserted_last = FALSE;
	   }
	   else
	   {
	      if (insert < 0)
	         insert = 0;

	      kstrncpy(text, oldtext, insert);
	      text[insert] = ch;
	      kstrncpy(&text[insert+1], &oldtext[insert], length-insert);
	      text[length+1] = '\0';
	      xobj->textstring.insertion++;
	      deleted_last = FALSE;
	      inserted_last = TRUE;
	    }
	    xvw_set_attribute(object, XVW_STRING_STRING, text);
	}
	else if (event->type == ButtonPress)
	{
	   int xpos = event->xbutton.x - ((int) xobj->rectobj.x);

	   factor = ((double) xobj->string.string_width)/((double) length);
	   xobj->textstring.insertion = (int) (((double) xpos)/factor);
	}
}


/************************************************************
*
*  Routine Name: xvw_create_textstring - create a textstring object.
*
*       Purpose: The textstring object is similar to a string object
*                in that it is an annotation which displays text.  
*                However, unlike the string object, the textstring object 
*                is \fIeditable\fP.
*
*                Like the other annotations, the (x, y) placement of the 
*                textstring object is specified in world coordinates.  The world
*                coordinates are specified by the parent.  By default, these
*                world coordinates are from 0 to 1 unless otherwise specified.
*                So, for example, if the string is created as the child of
*                a manager object, its world coordinates are from 0 to 1.
*                In contrast, if the string is created as the child of an image,
*                the world coordinates will be dictated by the size of the
*                image; if it created as the child of a plot object, the world
*                coordinates will be dictated by the plot.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output:
*	Returns: The textstring object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young 
*          Date: Mar 09, 1993 12:05
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_textstring(
   xvobject parent,
   char     *name)
{
	xvobject  object;

	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, TextStringGadgetClass);
	if (object != NULL)
	{
	   xvw_set_attributes(object,
		XVW_MENUABLE,     TRUE,     /* menuable       */
		XVW_RESIZABLE,    FALSE,    /* resizable      */
		XVW_SELECTABLE,   TRUE,     /* selectable     */
		NULL);
	}
	return(object);
}
