 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                Pseudo Widget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			SetValues()
   >>>>			ValueCallback()
   >>>>			UpdateValue()
   >>>>			PaletteCallback()
   >>>>			ChangePseudoIndex()
   >>>>  Public:
   >>>>			xvw_create_pseudo()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/xvisual.h>
#include <xvisual/PseudoP.h>
#include <xvisual/Palette.h>


static void ClassInitialize PROTO((void));
static void Initialize	    PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,
				   Cardinal *));

static void ValueCallback    PROTO((xvobject, kaddr, kaddr));
static void UpdateValue      PROTO((XvwPseudoWidget, xvobject, int));
static void PaletteCallback   PROTO((xvobject, kaddr, kaddr));
static int  ChangePseudoIndex PROTO((xvobject, char *, kaddr));

#undef kwidget
#undef kwidgetclass
#undef kconstraint

#define kwidget(widget)      (XvwPseudoWidget) (widget)
#define kwidgetclass(widget) (XvwPseudoWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwPseudoWidgetConstraints) (widget)->core.constraints

/*-------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_PSEUDO_REDVAL,       NULL, XtRInt, NULL},
{XVW_PSEUDO_GREENVAL,     NULL, XtRInt, NULL},
{XVW_PSEUDO_BLUEVAL,      NULL, XtRInt, NULL},
{XVW_PSEUDO_ALPHAVAL,     NULL, XtRInt, NULL},
{XVW_PSEUDO_USE_ALPHA,    NULL, XtRInt, XtRBoolean},
{XVW_PSEUDO_INDEX1,       NULL, XtRInt, NULL},
{XVW_PSEUDO_INDEX2,       NULL, XtRInt, NULL},
{XVW_PSEUDO_INDEXLIST,    NULL, XtRPointer, NULL},
{XVW_PSEUDO_INDEXNUM,     NULL, XtRInt, NULL},
{XVW_PSEUDO_SHOW_PALETTE, NULL, XtRInt, XtRBoolean},
{XVW_PSEUDO_UPDATE_ONADD, NULL, XtRInt, XtRBoolean},
{XVW_PSEUDO_CALLBACK,     NULL, XtRCallback, NULL},
{XVW_PSEUDO_PALETTE_OBJECT, NULL, XtRPointer, NULL},
};

/*-------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwPseudoWidgetRec, pseudo.field)

static XtResource resources[] = { 
{XVW_PSEUDO_INDEX1, NULL, XtRInt, sizeof(int),
      offset(index1), XtRImmediate, (XtPointer) -1},
{XVW_PSEUDO_INDEX2, NULL, XtRInt, sizeof(int),
      offset(index2), XtRImmediate, (XtPointer) -1},
{XVW_PSEUDO_INDEXLIST, NULL, XtRPointer, sizeof(XtPointer),
      offset(indexes), XtRImmediate, (XtPointer) NULL},
{XVW_PSEUDO_INDEXNUM, NULL, XtRInt, sizeof(int),
      offset(num), XtRImmediate, (XtPointer) 0},
{XVW_PSEUDO_REDVAL, NULL, XtRInt, sizeof(int),
      offset(redval), XtRImmediate, (XtPointer) 0},
{XVW_PSEUDO_GREENVAL, NULL, XtRInt, sizeof(int),
      offset(greenval), XtRImmediate, (XtPointer) 0},
{XVW_PSEUDO_BLUEVAL, NULL, XtRInt, sizeof(int),
      offset(blueval), XtRImmediate, (XtPointer) 0},
{XVW_PSEUDO_ALPHAVAL, NULL, XtRInt, sizeof(int),
      offset(alphaval), XtRString, (XtPointer) 0},
{XVW_PSEUDO_USE_ALPHA, NULL, XtRBoolean, sizeof(Boolean),
      offset(use_alpha), XtRImmediate, (XtPointer) FALSE},
{XVW_PSEUDO_SHOW_PALETTE, NULL, XtRBoolean, sizeof(Boolean),
      offset(show_palette), XtRImmediate, (XtPointer) TRUE},
{XVW_PSEUDO_UPDATE_ONADD, NULL, XtRBoolean, sizeof(Boolean),
      offset(update_onadd), XtRImmediate, (XtPointer) FALSE},
{XVW_PSEUDO_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(pseudo_callbacks), XtRCallback, (XtPointer) NULL},
{XVW_PSEUDO_PALETTE_OBJECT, NULL, XtRObject, sizeof(xvobject),
        offset(palette), XtRImmediate, (XtPointer) NULL},
{XVW_PREFERRED_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwPseudoWidgetRec, manager.preferred_width),
        XtRImmediate, (XtPointer) 300},
{XVW_PREFERRED_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwPseudoWidgetRec, manager.preferred_height),
        XtRImmediate, (XtPointer) 175},

{NULL, NULL, XtRBoolean, sizeof(Boolean),
      XtOffsetOf(XvwColorWidgetRec, color.initialize_visual),
      XtRImmediate, (XtPointer) FALSE},
};
#undef offset


#define SUPERCLASS (&xvwColorWidgetClassRec)

XvwPseudoWidgetClassRec xvwPseudoWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Pseudo",				/* class_name		  */
    sizeof(XvwPseudoWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    XtInheritTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,	            		/* subresources       */
    0,					/* subresources_count */
    sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size    */
    NULL,				/* initialize         */
    NULL,                               /* destroy            */
    NULL,				/* set_values         */
    NULL,                               /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,			/* child layout routine  */
    XtInheritChangeSel,		        /* change selected proc   */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritResize,			/* resize		  */
    XtInheritGeometryManager,  		/* geometry_manager	  */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
  {
    XtInheritColorReload,		/* reload color proc             */
  },  /* XvwColorWidgetClass fields initialization */
  {
    NULL,                               /* field not used    */
  },  /* XvwPseudoWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwPseudoWidgetClass for public consumption
 */
WidgetClass xvwPseudoWidgetClass = (WidgetClass) &xvwPseudoWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of pseudo widget class has been created.
|                It will initialize all the class attributes.
|
|         Input: none 
|
|        Output: none
|
|    Written By: Mark Young 
|          Date: Nov 17, 1992
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwPseudoWidgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Pseudo.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Pseudo");

	xvw_define_attributes(xvwPseudoWidgetClass,
	  XVW_PSEUDO_ADD,    XtRInt, ChangePseudoIndex, NULL,
	  XVW_PSEUDO_DELETE, XtRInt, ChangePseudoIndex, NULL,
	  XVW_PSEUDO_CLEAR,  XtRInt, ChangePseudoIndex, NULL,
	  NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial pseudo color
|                widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: May 26, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwPseudoWidget xwid = kwidget(new);

	xvobject offsetobj; 
	xvobject object = xvw_object(new);

	/*
	 *  Set the "dirty" field to false.  This is used by the
	 *  palette callback...
	 */
	xwid->pseudo.dirty = FALSE;

	/*
	 *  
	 */
	/*
	 *  Create the palette and pseudo color integer objects
	 */
	xwid->pseudo.palette = xvw_create_palette(object, "palette");
	if (!xwid->pseudo.show_palette)
	   xvw_unmanage(xwid->pseudo.palette);

	xwid->pseudo.red    = xvw_create_integer(object, "red");
	xwid->pseudo.blue   = xvw_create_integer(object, "blue");
	xwid->pseudo.green  = xvw_create_integer(object, "green");

	if (xwid->pseudo.use_alpha)
	    offsetobj = xwid->pseudo.alpha = xvw_create_integer(object,"alpha");
	else offsetobj = NULL;


	/*
	 *  Initialize the palette to extend the width of the palette
	 */
	if (xwid->pseudo.show_palette)
	    xvw_set_attributes(xwid->pseudo.palette,
		XVW_BELOW,		NULL,
		XVW_ABOVE,		xwid->pseudo.red,
		XVW_TACK_EDGE,		KMANAGER_TACK_ALL,
		XVW_WIDTH,    200, 
		XVW_HEIGHT,   150, 
		XVW_PALETTE_TYPE,       KPALETTE_TYPE_COLORCELL, 
		NULL);

        /*
         *  Make sure the scrollbars extends the height of the
         *  pseudo widget.
         */
        xvw_set_attributes(xwid->pseudo.red,
		XVW_ABOVE,	        xwid->pseudo.green,
		XVW_RIGHT_OF,	        NULL,
		XVW_LEFT_OF,	        NULL,
		XVW_TACK_EDGE,	        KMANAGER_TACK_HORIZ,
		XVW_CHAR_HEIGHT,        1.0,
		XVW_INTEGER_LABEL,      "Red:  ",
		XVW_INTEGER_VALUE,      0,
		XVW_INTEGER_MINVALUE,   0,
		XVW_INTEGER_MAXVALUE,   255,
		NULL);

        xvw_set_attributes(xwid->pseudo.green,
		XVW_ABOVE,	        xwid->pseudo.blue,
		XVW_RIGHT_OF,	        NULL,
		XVW_LEFT_OF,	        NULL,
		XVW_TACK_EDGE,	        KMANAGER_TACK_HORIZ,
                XVW_INTEGER_LABEL,      "Green:",
		XVW_CHAR_HEIGHT,        1.0,
                XVW_INTEGER_VALUE,      0,
                XVW_INTEGER_MINVALUE,   0,
                XVW_INTEGER_MAXVALUE,   255,
		NULL);

        xvw_set_attributes(xwid->pseudo.blue,
		XVW_ABOVE,	        offsetobj,
		XVW_RIGHT_OF,	        NULL,
		XVW_LEFT_OF,	        NULL,
		XVW_TACK_EDGE,	        KMANAGER_TACK_HORIZ,
		XVW_CHAR_HEIGHT,        1.0,
                XVW_INTEGER_LABEL,      "Blue: ",
                XVW_INTEGER_VALUE,      0,
                XVW_INTEGER_MINVALUE,   0,
                XVW_INTEGER_MAXVALUE,   255,
		NULL);

	if (xwid->pseudo.use_alpha)
            xvw_set_attributes(xwid->pseudo.alpha,
		XVW_ABOVE,	        NULL,
		XVW_RIGHT_OF,	        NULL,
		XVW_LEFT_OF,	        NULL,
		XVW_TACK_EDGE,	        KMANAGER_TACK_HORIZ,
		XVW_CHAR_HEIGHT,        1.0,
                XVW_INTEGER_LABEL,      "Alpha:",
                XVW_INTEGER_VALUE,      0,
                XVW_INTEGER_MINVALUE,   0,
                XVW_INTEGER_MAXVALUE,   255,
		NULL);
	/*
	 *  Add the callbacks for the red, green, and blue integer objects 
	 *  that will be used to change the color palette.
	 */
	xvw_insert_callback(xwid->pseudo.red, XVW_INTEGER_CALLBACK,
			 FALSE, ValueCallback, (XtPointer) xwid);
	xvw_insert_callback(xwid->pseudo.green, XVW_INTEGER_CALLBACK,
			 FALSE, ValueCallback, (XtPointer) xwid);
	xvw_insert_callback(xwid->pseudo.blue, XVW_INTEGER_CALLBACK,
			 FALSE, ValueCallback, (XtPointer) xwid);

	if (xwid->pseudo.use_alpha)
	    xvw_insert_callback(xwid->pseudo.alpha, XVW_INTEGER_CALLBACK,
	    		        FALSE, ValueCallback, (XtPointer) xwid);

	xvw_insert_callback(xwid->pseudo.palette, XVW_PALETTE_CALLBACK,
			 FALSE, PaletteCallback, (XtPointer) xwid);
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: Determine what the widget should do by
|		 comparing the current values verse the
|		 new settings.
|
|         Input: current - the widget containing current settings 
|		 request - the widget containing requested settings
|		 new	 - the widget processed through all set values methods 
|
|        Output: None directly
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwPseudoWidget cxwid = kwidget(current);
	XvwPseudoWidget nxwid = kwidget(new);


	/*
	 *  Change the Scrollbar, and it's values, for the appropriate
	 *  red, green, or blue components.
	 */
	if (cxwid->pseudo.redval != nxwid->pseudo.redval)
	   UpdateValue(nxwid, nxwid->pseudo.red, nxwid->pseudo.redval);

	if (cxwid->pseudo.greenval != nxwid->pseudo.greenval)
	   UpdateValue(nxwid, nxwid->pseudo.green, nxwid->pseudo.greenval);

	if (cxwid->pseudo.blueval != nxwid->pseudo.blueval)
	   UpdateValue(nxwid, nxwid->pseudo.blue, nxwid->pseudo.blueval);

	if (cxwid->pseudo.alphaval != nxwid->pseudo.alphaval)
	   UpdateValue(nxwid, nxwid->pseudo.alpha, nxwid->pseudo.alphaval);

	if (cxwid->color.object != nxwid->color.object)
	{
	   xvw_set_attribute(nxwid->pseudo.palette, XVW_COLOR_COLOROBJ,
			nxwid->color.object);
	}

	if (cxwid->pseudo.show_palette != nxwid->pseudo.show_palette)
	{
	   xvobject palette = nxwid->pseudo.palette;

	   if (!nxwid->pseudo.show_palette)
	      xvw_unmanage(palette);
	   else
	      xvw_manage(palette);
	}

	if (cxwid->color.alloc_policy != nxwid->color.alloc_policy)
	{
	   xvw_set_attribute(nxwid->pseudo.palette, XVW_COLOR_ALLOC_POLICY,
			     nxwid->color.alloc_policy);
	}
	return(FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: ValueCallback
|
|       Purpose: This routine will change the (R, G, B, or Alpha) 
|                component according to the new int value provided.
|
|         Input: object      - the scrollbar being manipulated
|		 client_data - the pseudo widget
|		 call_data   - int representing the scroll position
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young 
|          Date: Jun 06, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ValueCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	XvwPseudoWidget   xwid = kwidget(client_data);
	xvw_pseudo_struct pseudo;
	int               value;

	/*
	 *  The movement is really a double that represents the new
	 *  value of the (RGB) component.
	 */
	pseudo.object = object;
	xvw_get_attribute(object, XVW_INTEGER_VALUE, &value);
	pseudo.value   = value;

	if (object == xwid->pseudo.red)
	   pseudo.type = KPSEUDO_RED;
	else if (object == xwid->pseudo.green)
	   pseudo.type = KPSEUDO_GREEN;
	else if (object == xwid->pseudo.blue)
	   pseudo.type = KPSEUDO_BLUE;
	else if (object == xwid->pseudo.alpha)
	   pseudo.type = KPSEUDO_ALPHA;

	UpdateValue(xwid, object, (int) value);
	XtCallCallbackList((Widget) xwid, xwid->pseudo.pseudo_callbacks,
			(XtPointer) &pseudo);

	UpdateValue(xwid, object, (int) value);
}

/*-----------------------------------------------------------
|
|  Routine Name: UpdateValue
|
|       Purpose: This routine will update the (R, G, B, or Alpha)
|                value displayed according to the new value.
|
|         Input: xwid	- the pseudo widget
|		 object - the scrollbar being manipulated
|		 value  - the new scrollbar value
|
|        Output:
|       Returns:
|
|    Written By: Mark Young 
|          Date: Jun 06, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void UpdateValue(
   XvwPseudoWidget xwid,
   xvobject	   object,
   int		   value)
{
	int    i, num, indx, pos;
	static int active = FALSE;
	Widget widget = (Widget) xwid;

	/*
	 *  Make sure we aren't in the middle of callback...
	 */
	if (active)
	   return;
	else
	   active = TRUE;

	/*
	 *  The movement is really a double that represents the new
	 *  value of the (RGB) component.
	 */
	if (object == xwid->pseudo.red)
	{
	   if (xwid->pseudo.redval == value)
	   {
	      active = FALSE;
	      return;
	   }
	   pos   = 0;
	   xwid->pseudo.redval = value;
	}
	else if (object == xwid->pseudo.green)
	{
	   if (xwid->pseudo.greenval == value)
	   {
	      active = FALSE;
	      return;
	   }
	   pos   = 1;
	   xwid->pseudo.greenval = value;
	}
	else if (object == xwid->pseudo.blue)
	{
	   if (xwid->pseudo.blueval == value)
	   {
	      active = FALSE;
	      return;
	   }
	   pos   = 2;
	   xwid->pseudo.blueval = value;
	}
	else if (object == xwid->pseudo.alpha)
	{
	   if (xwid->pseudo.alphaval == value)
	   {
	      active = FALSE;
	      return;
	   }
	   pos   = 2;
	   xwid->pseudo.alphaval = value;
	}
	else
	{
	   active = FALSE;
	   return;
	}
	xvw_set_attribute(object, XVW_INTEGER_VALUE, value);

	/*
         *  If we have indexes to update and a valid pseudocolor object,
	 *  then go ahead and update the data object's mapdata with our new
	 *  pseudo color value(s).
	 */
	if (xwid->pseudo.indexes != NULL && xwid->color.object != NULL)
	{
	   XColor *xcolors = ColorGetXColors(widget);

	    /*
	     *  Loop thru all the pixel values in the pseudo color list 
	     *  and put the new pseudo color value.
	     */
	    num = value << 8;
	    for (i = 0; i < xwid->pseudo.num; i++)
	    {
	        indx = xwid->pseudo.indexes[i];

		if (pos == 0)
		   xcolors[indx].red = num;
		else if (pos == 1)
		   xcolors[indx].green = num;
		else if (pos == 2)
		   xcolors[indx].blue = num;

		ColorStore(widget, indx, NULL);
	        kinfo(KDEBUG,"pseudo: %d,%d: %g", pos, indx, value);
	    }
	}
	xwid->pseudo.dirty = TRUE;
	active = FALSE;
}

/*-----------------------------------------------------------
|
|  Routine Name: PaletteCallback
|
|       Purpose: This routine will be called when the palette callback is
|		 activated.
|
|         Input: object      - which palette being manipulated
|		 client_data - the palette widget
|		 call_data   - int representing the index
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young 
|          Date: Jun 06, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void PaletteCallback(
   xvobject palette,
   kaddr    client_data,
   kaddr    call_data)
{
	XvwPseudoWidget xwid = kwidget(client_data);
	xvobject object = (xvobject) client_data;
	int i, indx = *((int *) call_data);

	if (xwid->pseudo.index1 == -1 || xwid->pseudo.dirty == TRUE)
	{
	   xvw_set_attribute(object, XVW_PSEUDO_CLEAR, TRUE);

	   xwid->pseudo.index1 = indx;
	   xvw_set_attribute(object, XVW_PSEUDO_ADD, indx);
	   xwid->pseudo.dirty = FALSE;
	}
	else
	{
	   xwid->pseudo.index2 = kmax(xwid->pseudo.index1, indx);
	   xwid->pseudo.index1 = kmin(xwid->pseudo.index1, indx);
	   for (i = xwid->pseudo.index1; i <= xwid->pseudo.index2; i++)
	      xvw_set_attribute(object, XVW_PSEUDO_ADD, i);
	}
}


/*-----------------------------------------------------------
|
|  Routine Name: ChangePseudoIndex
|
|       Purpose: ChangePseudoIndex is used to set the indexes associated
|		 with the pseudo widget.
|
|         Input: object    - the object in which we will be getting the
|			     filename
|		 attribute - the old object to be closed
|		 calldata  - the filename to be set
|
|        Output:
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 21, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int ChangePseudoIndex(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	XvwPseudoWidget xwid = (XvwPseudoWidget) xvw_widget(object);
	int indx = *((int *) calldata);

	XColor    *xcolors;
	Widget    widget = (Widget) xwid;
	int val, num = xwid->pseudo.num, *indexes = xwid->pseudo.indexes;


	if (kstrcmp(attribute, XVW_PSEUDO_ADD) == 0)
	{
	   if (karray_locate((char **) indexes, (kaddr) indx, num) == -1)
	   {
	      if (xwid->pseudo.update_onadd && indexes != NULL)
	      {
		 xcolors = ColorGetXColors(widget);
		 ColorStore(widget, indx, &xcolors[indexes[0]]);
	      }
	      else if (!indexes && (xcolors = ColorGetXColors(widget)) != NULL)
	      {
		 val = (int) ((int) xcolors[indx].red >> 8);
		 UpdateValue(xwid, xwid->pseudo.red, val);

		 val = (double) ((int) xcolors[indx].green >> 8);
		 UpdateValue(xwid, xwid->pseudo.green, val);

		 val = (double) ((int) xcolors[indx].blue >> 8);
		 UpdateValue(xwid, xwid->pseudo.blue, val);
	      }
	      indexes = (int *) karray_add((char **)indexes,(kaddr) indx,num++);
	   }
	}
        else if (kstrcmp(attribute, XVW_PSEUDO_DELETE) == 0)
	{
	   if (karray_locate((char **) indexes, (kaddr) indx, num) != -1)
	      indexes=(int *) karray_delete((char **)indexes,(kaddr)indx,num--);
	}
        else if (kstrcmp(attribute, XVW_PSEUDO_CLEAR) == 0)
	{
	   kfree(indexes);
	   indexes = NULL; num = 0;
	}
	else
	{
	   kerror(XVISUAL, "ChangePseudoIndex", "invalid attribute %s",
			attribute);
	   return(FALSE);
	}
	xwid->pseudo.num = num;
	xwid->pseudo.indexes = indexes;
	return(TRUE);
}


/************************************************************
*
*  Routine Name: xvw_create_pseudo - create a pseudo xvobject
*
*       Purpose: The psuedocolor visual object provides a method of changing 
*                the colormap of another visual object.  It displays the colors 
*                associated with the pixel values of the displayed object
*                (a linear palette, colorcell grid, or color wheel may be used)
*                and offers three scrollbars underneath with which the user 
*                may change the red, green, and blue values associated with a 
*                pixel or range of pixels.  The
*                .symbol noindex XVW_COLOR_COLOROBJ
*                attribute is used to specify the data object whose colormap 
*                the psuedocolor object will be used to modify.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None
*
*	Returns: The pseudo xvobject on success, NULL otherwise
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 17, 1992
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_pseudo(
   xvobject parent,
   char     *name)
{
	xvobject object;


	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, PseudoWidgetClass);
	return(object);
}
