 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                 Polyline Gadget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			Redisplay()
   >>>>			SetValues()
   >>>>			Destroy()
   >>>>			PickGadget()
   >>>>			FindMinMax()
   >>>>  Public:
   >>>>			xvw_create_polyline()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/PolylineP.h>

static void ClassInitialize PROTO((void));
static void Redisplay	    PROTO((Widget, XEvent *, Region));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,Cardinal *));
static void Destroy	    PROTO((Widget));
static int PickGadget	    PROTO((Widget, int, int));
static void FindMinMax	    PROTO((XvwPolylineGadget));


/*-------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_POLYLINE_NUMPTS,    NULL,    XtRInt,	NULL},
{XVW_POLYLINE_POINTS,    NULL,    XtRPointer,	NULL},
};

/*-------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwPolylineGadgetRec, polyline.field)

static XtResource resources[] = { 
{XVW_POLYLINE_NUMPTS, NULL, XtRInt, sizeof(int),
      offset(numpts), XtRImmediate, (XtPointer) 0},
{XVW_POLYLINE_POINTS, NULL, XtRPointer, sizeof(Coord *), 
      offset(points), XtRPointer, (XtPointer) NULL},
};
#undef offset


#define SUPERCLASS (&xvwGraphicsGadgetClassRec)

XvwPolylineGadgetClassRec xvwPolylineGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Polyline",				/* class_name		  */
    sizeof(XvwPolylineGadgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    PickGadget,				/* pick object proc       */
    XtInheritEraseSel,                  /* erase selected proc    */
    XtInheritRefreshSel,	        /* refresh selection proc */
    XtInheritChangeGeometry,		/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    XtInheritRecomputePosition,		/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwPolylineGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwPolylineGadgetClass for public consumption
 */
WidgetClass xvwPolylineGadgetClass = (WidgetClass) &xvwPolylineGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of polyline object class has been created.
|                It will initialize all the class attributes. 
|
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwPolylineGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Polyline.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Polyline");
}

/*-----------------------------------------------------------
|
|  Routine Name: Redisplay
|
|       Purpose: This routine will redraw the polyline object in response
|                to an expose event. 
|
|         Input: widget - the polyline object that was exposed 
|                event  - the event that caused the redraw
|                region - the region that was exposed 
|
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
	XvwPolylineGadget xobj = (XvwPolylineGadget) widget;

	XColor   *plotcolor;
	register Coord *points;
	register int id, numpts;


	/*
	 *  Check to see if we are currently visible and we have points
	 *  to be displayed
	 */
	if (!xobj->polyline.points || !xvw_check_visible(xvw_object(widget)))
	   return;

	id        = xobj->graphics.id;
	numpts    = xobj->polyline.numpts;
	points    = xobj->polyline.points;
	plotcolor = &xobj->graphics.fg;

	if (!xobj->graphics.filled)
	   X2D_draw_polyline(id, points, numpts, plotcolor);
	else
	   X2D_draw_polygon(id, points, numpts, plotcolor);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: If the the size or postion of the polyline has changed, 
|		 recalculate the size and position of the polyline.
|
|         Input: current - the object containing current settings 
|                request - the object containing requested settings
|                new     - the object processed through all set values methods 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Nov 11, 1993
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwPolylineGadget cobj = (XvwPolylineGadget) current;
	XvwPolylineGadget nobj = (XvwPolylineGadget) new;

	Coord *tmp;
	int   size;
	Boolean redisplay = FALSE;


	if (cobj->polyline.points != nobj->polyline.points)
	{
	   size = (nobj->polyline.numpts * sizeof(Coord));
	   tmp = (Coord *) kmalloc(size);

	   kfree(cobj->polyline.points);
	   kmemcpy(tmp, nobj->polyline.points, size);
	   nobj->polyline.points = tmp;
	   FindMinMax(nobj);
	   redisplay = TRUE;
	}
	return(redisplay);
}

/*-----------------------------------------------------------
|
|  Routine Name: PickGadget
|
|       Purpose: Given a polyline object and an attempted picking location,
|                see if the polyline has been picked. 
|
|         Input: widget - the polyline object we are checking 
|                x      - the x device coordinate that the pick attempt was at 
|                y      - the y device coordinate that the pick attempt was at
|
|       Returns: TRUE (1) if object was successfully picked, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Nov 11, 1993
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static int PickGadget(
   Widget widget,
   int    x,
   int    y)
{
	XvwPolylineGadget xobj = (XvwPolylineGadget) widget;

	Coord c1, c2, c, *points;
	int i, id = xobj->graphics.id;
	Real  xpos1, xpos2, ypos1, ypos2;


	if (!(points = xobj->polyline.points))
	   return(FALSE);

	xpos1 = x - PICK_TOLERANCE; ypos1 = y - PICK_TOLERANCE;
	xpos2 = x + PICK_TOLERANCE; ypos2 = y + PICK_TOLERANCE;
	X2D_convert_point_dc_to_wc(id, xpos1, ypos1, &c1);
	X2D_convert_point_dc_to_wc(id, xpos2, ypos2, &c2);
	X2D_convert_point_dc_to_wc(id, (Real) x, (Real) y, &c);

	xpos1 = kabs(c1.x - c2.x);
	ypos1 = kabs(c1.y - c2.y);
	for (i = 0; i < xobj->polyline.numpts; i++)
	{
	   if (kabs(c.x - points[i].x) < xpos1 &&
	       kabs(c.y - points[i].y) < ypos1)
              return(TRUE);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: free the points associated with the polyline
|		 object.
|
|         Input: widget - the image widget being destroyed
|    Written By: Mark Young
|          Date: Nov 11, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void Destroy(
   Widget widget)
{
	XvwPolylineGadget xobj = (XvwPolylineGadget) widget;

	/*
	 *  free points
	 */
	kfree(xobj->polyline.points);
}

/*-----------------------------------------------------------
|
|  Routine Name: FindMinMax
|
|       Purpose: This routine will find the min and max values
|                from the data in a given polyline object
|
|         Input: xobj - the object to find the min max for
|        Output: None
|    Written By: Mark Young
|          Date: Nov 11, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void FindMinMax(
   XvwPolylineGadget xobj)
{
	register int i;
	register Coord wcmin, wcmax, *points;


	if (!(points = xobj->polyline.points))
	   return;

	wcmin.x = wcmax.x = points[0].x;
	wcmin.y = wcmax.y = points[0].y;
	wcmin.d = wcmax.d = points[0].d;

	for (i = xobj->polyline.numpts -1; i >= 0; i--)
	{
	   if (points[i].x > wcmax.x) wcmax.x = points[i].x;
	   else if (points[i].x < wcmin.x) wcmin.x = points[i].x;

	   if (points[i].y > wcmax.y) wcmax.y = points[i].y;
	   else if (points[i].y < wcmin.y) wcmin.y = points[i].y;

	   if (points[i].d > wcmax.d) wcmax.d = points[i].d;
	   else if (points[i].d < wcmin.d) wcmin.d = points[i].d;
	}

	if (xobj->graphics.reset_world)
	{
	   if ( wcmax.x < xobj->graphics.wcmin.x )
	   {
	      xvw_set_attribute(xvw_object((Widget) xobj),
				XVW_GRAPHICS_WCMIN_X, wcmin.x);
	      xvw_set_attribute(xvw_object((Widget) xobj),
				XVW_GRAPHICS_WCMAX_X, wcmax.x);
	   }
	   else
	   {
	      xvw_set_attribute(xvw_object((Widget) xobj),
				XVW_GRAPHICS_WCMAX_X, wcmax.x);
	      xvw_set_attribute(xvw_object((Widget) xobj),
				XVW_GRAPHICS_WCMIN_X, wcmin.x);
	   }

	   if ( wcmax.y < xobj->graphics.wcmin.y )
	   {
	      xvw_set_attribute(xvw_object((Widget) xobj),
				XVW_GRAPHICS_WCMIN_Y, wcmin.y);
	      xvw_set_attribute(xvw_object((Widget) xobj),
				XVW_GRAPHICS_WCMAX_Y, wcmax.y);
	   }
	   else
	   {
	      xvw_set_attribute(xvw_object((Widget) xobj),
				XVW_GRAPHICS_WCMAX_Y, wcmax.y);
	      xvw_set_attribute(xvw_object((Widget) xobj),
				XVW_GRAPHICS_WCMIN_Y, wcmin.y);
	   }
	}
}


/************************************************************
*
*  Routine Name: xvw_create_polyline - create a polyline object.
*
*       Purpose: The polyline object supports the display of a polyline 
*                annotation.  The polyline object is currently still
*                under construction.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None 
*
*	Returns: The polyline object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young 
*          Date: Nov 11, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_polyline(
   xvobject parent,
   char   *name)
{
	xvobject  object;


	/*
	 *  Create the polyline object
	 */
	object = xvw_create(parent, FALSE, TRUE, name, PolylineGadgetClass);
	return(object);
}
