 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>               Marker Gadget Routines
   >>>>
   >>>>	Private:
   >>>>  Static:
   >>>>			ClassInitialize()
   >>>>			Redisplay()
   >>>>			SetValues()
   >>>>			RecomputePosition()
   >>>>			ChangeGeometry()
   >>>>			PickGadget()
   >>>>   Public:
   >>>>			xvw_create_marker()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/MarkerP.h>

static void ClassInitialize	 PROTO((void));
static void Redisplay		 PROTO((Widget, XEvent *, Region));
static Boolean SetValues	 PROTO((Widget, Widget, Widget, ArgList,
					Cardinal *));
static void RecomputePosition	 PROTO((Widget));
static void ChangeGeometry	 PROTO((Widget));
static int PickGadget            PROTO((Widget, int, int));


/*------------------------------------------------------- 
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_MARKER_XPLACEMENT,    NULL,   XtRDouble,   NULL},
{XVW_MARKER_YPLACEMENT,    NULL,   XtRDouble,   NULL},
};

/*------------------------------------------------------- 
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwMarkerGadgetRec, marker.field)

static XtResource resources[] = { 
{XVW_MARKER_XPLACEMENT, NULL, XtRDouble, sizeof(double),
     offset(placement.x), XtRString, (XtPointer) "0.0"},
{XVW_MARKER_YPLACEMENT, NULL, XtRDouble, sizeof(double),
     offset(placement.y), XtRString, (XtPointer) "0.0"},

{XVW_WIDTH, NULL, XtRDimension, sizeof(Dimension),
     XtOffsetOf(XvwMarkerGadgetRec, rectobj.width), XtRImmediate,
     (XtPointer) 15},
{XVW_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
     XtOffsetOf(XvwMarkerGadgetRec, rectobj.height), XtRImmediate,
     (XtPointer) 15},
};
#undef offset


#define SUPERCLASS (&xvwGraphicsGadgetClassRec)

XvwMarkerGadgetClassRec xvwMarkerGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Marker",			        /* class_name		  */
    sizeof(XvwMarkerGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    PickGadget,				/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    ChangeGeometry,			/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    RecomputePosition,			/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwMarkerGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwMarkerGadgetClass for public consumption
 */
WidgetClass xvwMarkerGadgetClass = (WidgetClass) &xvwMarkerGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of marker object class has been created.
|                It will initialize all the class attributes. 
|
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwMarkerGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Marker.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Marker");
}

/*-----------------------------------------------------------
|
|  Routine Name: Redisplay
|
|       Purpose: This routine will redraw the marker object in response
|                to an expose event. 
|
|         Input: widget - the marker object that was exposed 
|                event  - the event that caused the redraw
|                region - the region that was exposed 
|
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
	XvwMarkerGadget xobj = (XvwMarkerGadget) widget;


	X2D_draw_marker(xobj->graphics.id, xobj->marker.placement,
		xobj->graphics.marker_type, &xobj->graphics.fg);
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: Update if the the postion of the marker or if the
|		 marker type has changed, 
|
|         Input: current - the object containing current settings 
|                request - the object containing requested settings
|                new     - the object processed through all set values methods 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwMarkerGadget cobj = (XvwMarkerGadget) current;
	XvwMarkerGadget robj = (XvwMarkerGadget) request;


	if (!GraphicsCheckCoord(robj->marker.placement, cobj->marker.placement))
	   RecomputePosition(new);

	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: RecomputePosition
|
|       Purpose: Given a new world coordinate marker location 
|                recompute the new device coordinate position 
|		 of the marker. 
|
|         Input: widget - the marker object 
|
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RecomputePosition(
   Widget widget)
{
	XvwMarkerGadget xobj = (XvwMarkerGadget) widget;

	Real x, y;
	XtWidgetGeometry temp;


	X2D_convert_point_wc_to_dc(xobj->graphics.id,
		xobj->marker.placement, &x, &y);
	temp.request_mode = CWX | CWY;
	temp.x = ((Position) x) - widget->core.width/2;
	temp.y = ((Position) y) - widget->core.width/2;
	(void) XtMakeGeometryRequest(widget, &temp, &temp);
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangeGeometry
|
|       Purpose: Given a new device coordinate location of the
|                marker, recompute the world coordinate location.
|
|         Input: widget - the marker object
|
|        Output: None directly 
|
|    Written By: Mark Young
|          Date: Jun 29, 1992 10:35
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ChangeGeometry(
   Widget widget)
{
	XvwMarkerGadget xobj = (XvwMarkerGadget) widget;

	Real x, y;


	x = (Real) ((int) widget->core.x + (int) widget->core.width/2);
	y = (Real) ((int) widget->core.y + (int) widget->core.height/2);
	X2D_convert_point_dc_to_wc(xobj->graphics.id, x, y,
			&xobj->marker.placement);
}

/*-----------------------------------------------------------
|
|  Routine Name: PickGadget
|
|       Purpose: Given a line object and an attempted picking location,
|                see if the line has been picked. 
|
|         Input: widget - the line object we are checking 
|                x      - the x device coordinate that the pick attempt was at 
|                y      - the y device coordinate that the pick attempt was at
|
|        Output:
|
|       Returns: TRUE (1) if object was successfully picked, FALSE (0) otherwise|
|    Written By: John Salas
|          Date: Mar 13, 1993 12:56
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static int PickGadget(
   Widget widget,
   int    x,
   int    y)
{
	return(TRUE);
}


/************************************************************
*
*  Routine Name: xvw_create_marker - create a marker object
*
*       Purpose: A marker visual object supports the display of a marker.
*                The (x, y) location of the marker 
*                is specified in world coordinates.  The world
*                coordinates are specified by the parent.  By default, these
*                world coordinates are from 0 to 1 unless otherwise specified.
*                So, for example, if the marker is created as the child of
*                a manager object, its world coordinates are from 0 to 1.
*                In contrast, if the marker is created as the child of an image,
*                the world coordinates will be dictated by the size of the
*                image; if it created as the child of a plot object, the world
*                coordinates will be dictated by the plot.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None 
*
*	Returns: The marker object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young 
*          Date: Jun 29, 1992 10:31
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_marker(
   xvobject parent,
   char   *name)
{
	xvobject  object;


	/*
	 *  Create the marker object
	 */
	object = xvw_create(parent, FALSE, TRUE, name, MarkerGadgetClass);
	if (object != NULL)
	{
	   xvw_set_attributes(object,
                XVW_MENUABLE,     TRUE,     /* menuable       */
                XVW_RESIZABLE,    FALSE,    /* resizable      */
                XVW_SELECTABLE,   TRUE,     /* selectable     */
		NULL);
	}
	return(object);
}
