 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>               Area Widget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			checkattach()
   >>>>		    	ConstraintAttach()
   >>>>		    	ConstraintSetValues()
   >>>>			Initialize()
   >>>>			Realize()
   >>>>			Resize()
   >>>>			SetValues()
   >>>>			GetAttachWidget()
   >>>>	 Public:
   >>>>			xvw_create_area()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/AreaP.h>

static void ClassInitialize PROTO((void));
static void Initialize	    PROTO((Widget, Widget, ArgList, Cardinal *));
static void Resize          PROTO((Widget));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,Cardinal *));
static void Realize         PROTO((Widget, XtValueMask *,
				   XSetWindowAttributes *));

static void ConstraintInitialize   PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean ConstraintSetValues PROTO((Widget, Widget, Widget, ArgList,
					  Cardinal *));

static Widget GetAttachWidget PROTO((Widget));
static void ConstraintAttach  PROTO((XvwAreaWidget, Widget, Widget,
				     XvwGraphicsPart *, XvwGraphicsPart *));

#undef kwidget
#undef kwidgetclass
#undef kconstraint

#define kwidget(widget)      (XvwAreaWidget) (widget)
#define kwidgetclass(widget) (XvwAreaWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwAreaWidgetConstraints) (widget)->core.constraints

/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_AREA_DISPLAY_DATE,	     NULL,	        XtRInt,		XtRBoolean},
{XVW_AREA_DISPLAY_TITLE,     NULL,	        XtRInt,		XtRBoolean},
{XVW_AREA_DATE,		     NULL,        	XtRObject,	NULL},
{XVW_AREA_TITLE,	     NULL,   	        XtRObject,	NULL},
{XVW_AREA_TITLE_STRING,	    "areaTitle.stringString",	XtRString,	NULL},
};

static xvattribute constraints[] = {
{XVW_AREA_ATTACH,	     NULL,	XtRObject,	XtRWidget},
};

/*--------------------------------------------------------
|
|   Full class record constant 
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwAreaWidgetRec, area.field)

static XtResource resources[] = { 
{XVW_AREA_DISPLAY_DATE, NULL, XtRBoolean, sizeof(Boolean),
      offset(display_date), XtRImmediate, (XtPointer) FALSE},
{XVW_AREA_DISPLAY_TITLE, NULL, XtRBoolean,sizeof(Boolean),
      offset(display_title), XtRImmediate, (XtPointer) TRUE},
{XVW_AREA_DATE, NULL, XtRObject, sizeof(xvobject),
        offset(date), XtRImmediate, (XtPointer) NULL},
{XVW_AREA_TITLE, NULL, XtRObject, sizeof(xvobject),
        offset(title), XtRImmediate, (XtPointer) NULL},

{XVW_PREFERRED_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwManagerWidgetRec, manager.preferred_width),
        XtRImmediate, (XtPointer) 512 },
{XVW_PREFERRED_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwManagerWidgetRec, manager.preferred_height),
        XtRImmediate, (XtPointer) 512},
};
#undef offset


/*--------------------------------------------------------
|
|   Constraint SubResources
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwAreaWidgetConstraintsRec, area.field)

static XtResource areaConstraintResources[] = {
{XVW_AREA_ATTACH, NULL, XtRWidget, sizeof(Widget),
	offset(attach), XtRImmediate, NULL},
};
#undef offset


#define SUPERCLASS (&xvwGraphicsWidgetClassRec)

XvwAreaWidgetClassRec xvwAreaWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Area",				/* class_name		  */
    sizeof(XvwAreaWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),			/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal |
    XtExposeGraphicsExposeMerged,	/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    XtInheritTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    areaConstraintResources,	            /* subresources       */
    knumber(areaConstraintResources),	    /* subresources_count */
    sizeof(XvwAreaWidgetConstraintsRec),    /* constraint_size    */
    ConstraintInitialize,		    /* initialize         */
    NULL,                                   /* destroy            */
    ConstraintSetValues,		    /* set_values         */
    NULL,                                   /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,			    /* child layout routine  */
    XtInheritChangeSel,		            /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    Resize,				    /* resize		      */
    XtInheritGeometryManager,  		    /* geometry_manager	      */
  }, /* XXvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwAreaWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwAreaWidgetClass for public consumption
 */
WidgetClass xvwAreaWidgetClass = (WidgetClass) &xvwAreaWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of area widget class has been created.
|		 It will initialize all the class attributes. 
|
|         Input: None 
|
|        Output: None
|
|    Written By: Mark Young & John M. Salas
|          Date: Aug 15, 1992
| Modifications:
|
------------------------------------------------------------*/
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwAreaWidgetClass, attributes,knumber(attributes),
		constraints, knumber(constraints), 
		"$DESIGN/objects/library/xvisual/uis/Area.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Area");
}

/*-----------------------------------------------------------
|
|  Routine Name: GetAttachWidget 
|
|       Purpose: Given and area widget, find its corresponding 
|		 attach widget.
|		 
|         Input: widget - the area widget we want the attach widget from 
|	Returns: The attach widget  
|
|    Written By: John M. Salas
|          Date: Jun 29, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Widget GetAttachWidget(
   Widget widget)
{
	Widget attach;
	XvwAreaWidgetConstraints karea = kconstraint(widget);

	if (karea->area.attach != NULL)
	   attach = karea->area.attach;
	else
	   attach = NULL;

	return(attach);
}

/*-----------------------------------------------------------
|
|  Routine Name: checkattach 
|
|       Purpose: check the attached attributes to see if they
|		 have changed
|		 
|         Input: widget - the widget to set the attributes on
|		 graphics - the values to set the attributes to.
|		 npart - the new attribute values
|		 graphics - the current attribute values
|
|        Output: None 
|
|	Returns: 
|
|    Written By: John M. Salas
          Date: Nov 06, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void checkattach(
   Widget          widget,
   XvwGraphicsPart *cpart,
   XvwGraphicsPart *npart)
{
	xvobject   object;
	XvwGraphicsPart part;

	/*
	 * Check to see if the child subclassed off of the Graphics widget.
	 * If not continue.
	 */
	if (!GetGraphicsPart(widget))
	   return;

	object = xvw_object(widget);
	xvw_get_attributes(object,
		XVW_GRAPHICS_MODE_X, &part.axis_mode_x,
		XVW_GRAPHICS_MODE_Y, &part.axis_mode_y,
		XVW_GRAPHICS_MODE_Z, &part.axis_mode_z,
		XVW_GRAPHICS_PROPORTIONAL, &part.proportional,
		XVW_GRAPHICS_VIEWPORT_MIN_X, &part.viewmin.x,
		XVW_GRAPHICS_VIEWPORT_MIN_Y, &part.viewmin.y,
		XVW_GRAPHICS_VIEWPORT_MIN_Z, &part.viewmin.z,
		XVW_GRAPHICS_VIEWPORT_MAX_X, &part.viewmax.x,
		XVW_GRAPHICS_VIEWPORT_MAX_Y, &part.viewmax.y,
		XVW_GRAPHICS_VIEWPORT_MAX_Z, &part.viewmax.z,
		XVW_GRAPHICS_WCMIN_X, &part.wcmin.x,
		XVW_GRAPHICS_WCMIN_Y, &part.wcmin.y,
		XVW_GRAPHICS_WCMIN_Z, &part.wcmin.z,
		XVW_GRAPHICS_WCMAX_X, &part.wcmax.x,
		XVW_GRAPHICS_WCMAX_Y, &part.wcmax.y,
		XVW_GRAPHICS_WCMAX_Z, &part.wcmax.z,
		NULL);

	if (npart->axis_mode_x != cpart->axis_mode_x)
	   part.axis_mode_x = npart->axis_mode_x;

	if (npart->axis_mode_y != cpart->axis_mode_y)
	   part.axis_mode_y = npart->axis_mode_y;

	if (npart->axis_mode_z != cpart->axis_mode_z)
	   part.axis_mode_z = npart->axis_mode_z;

	if (npart->proportional != cpart->proportional)
	   part.proportional = npart->proportional;

	if (cpart->viewmin.x != npart->viewmin.x)
	   part.viewmin.x = npart->viewmin.x;

	if (cpart->viewmin.y != npart->viewmin.y)
	   part.viewmin.y = npart->viewmin.y;

	if (cpart->viewmin.z != npart->viewmin.z)
	   part.viewmin.z = npart->viewmin.z;

	if (cpart->viewmax.x != npart->viewmax.x)
	   part.viewmax.x = npart->viewmax.x;

	if (cpart->viewmax.y != npart->viewmax.y)
	   part.viewmax.y = npart->viewmax.y;

	if (cpart->viewmax.z != npart->viewmax.z)
	   part.viewmax.z = npart->viewmax.z;

	if (cpart->wcmin.x != npart->wcmin.x)
	   part.wcmin.x = npart->wcmin.x;

	if (cpart->wcmin.y != npart->wcmin.y)
	   part.wcmin.y = npart->wcmin.y;

	if (cpart->wcmin.z != npart->wcmin.z)
	   part.wcmin.z = npart->wcmin.z;

	if (cpart->wcmax.x != npart->wcmax.x)
	   part.wcmax.x = npart->wcmax.x;

	if (cpart->wcmax.y != npart->wcmax.y)
	   part.wcmax.y = npart->wcmax.y;

	if (cpart->wcmax.z != npart->wcmax.z)
	   part.wcmax.z = npart->wcmax.z;

	xvw_set_attributes(object,
		XVW_GRAPHICS_MODE_X, part.axis_mode_x,
		XVW_GRAPHICS_MODE_Y, part.axis_mode_y,
		XVW_GRAPHICS_MODE_Z, part.axis_mode_z,
		XVW_GRAPHICS_PROPORTIONAL, part.proportional,
		XVW_GRAPHICS_VIEWPORT_MIN_X, part.viewmin.x,
		XVW_GRAPHICS_VIEWPORT_MIN_Y, part.viewmin.y,
		XVW_GRAPHICS_VIEWPORT_MIN_Z, part.viewmin.z,
		XVW_GRAPHICS_VIEWPORT_MAX_X, part.viewmax.x,
		XVW_GRAPHICS_VIEWPORT_MAX_Y, part.viewmax.y,
		XVW_GRAPHICS_VIEWPORT_MAX_Z, part.viewmax.z,
		XVW_GRAPHICS_WCMIN_X, part.wcmin.x,
		XVW_GRAPHICS_WCMIN_Y, part.wcmin.y,
		XVW_GRAPHICS_WCMIN_Z, part.wcmin.z,
		XVW_GRAPHICS_WCMAX_X, part.wcmax.x,
		XVW_GRAPHICS_WCMAX_Y, part.wcmax.y,
		XVW_GRAPHICS_WCMAX_Z, part.wcmax.z,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: ConstraintAttach
|
|       Purpose: This routine will propogate constraint changes
|		 from the area widget's attatched children to 
|		 the other attached children. 
|
|         Input: xwid   - The area widget 
|	 	 widget - The widget who initiated the changes 
|
|        Output: None
|
|    Written By: John M. Salas & Mark Young
|          Date: Apr 14, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConstraintAttach(
   XvwAreaWidget   xwid,
   Widget          widget,
   Widget          attach,
   XvwGraphicsPart *cpart,
   XvwGraphicsPart *npart)
{
        int    i;
        Widget *child;
	XvwAreaWidgetConstraints ktemp;

	/*
	 *  Initialize the current graphics to the attached graphics area
	 */
	if (attach == NULL || npart == NULL || cpart == NULL)
	   return;

        kinfo(KDEBUG,"ConstraintAttach: Attach widget '%s' for area '%s'",
                XtName(attach), XtName((Widget) xwid));

	child  = xwid->composite.children;
	for (i = 0; i < xwid->composite.num_children; i++, child++)
	{
	   ktemp = kconstraint(*child);

	   /*
	    * If the attached widget for the child is the same as the one
	    * for the widget that start this continue.
	    */
	   if (ktemp->area.attach == attach && widget != *child)
	      checkattach(*child, cpart, npart);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: ConstraintInitialize
|
|       Purpose: When a new child of the area is created,
|                set it's initial values.
|
|         Input: request  - widget child with requested constraints
|                new      - widget child with actual constraints
|                args     - not used
|                num_args - not used
|
|        Output: None
|       Returns: None
|
|    Written By: John Salas & Mark Young
|          Date: Aug 28, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConstraintInitialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwGraphicsPart *graphics;

	if (XtIsSubclass(new, xvwGraphicsWidgetClass) ||
	    XtIsSubclass(new, xvwGraphicsGadgetClass))
	{
	   if ((graphics = GetGraphicsPart(XtParent(new))) != NULL)
	   {
              xvw_set_attributes(xvw_object(new),
		XVW_GRAPHICS_VIEWPORT_MIN_X, graphics->viewmin.x,
		XVW_GRAPHICS_VIEWPORT_MIN_Y, graphics->viewmin.y,
		XVW_GRAPHICS_VIEWPORT_MIN_Z, graphics->viewmin.z,
		XVW_GRAPHICS_VIEWPORT_MAX_X, graphics->viewmax.x,
		XVW_GRAPHICS_VIEWPORT_MAX_Y, graphics->viewmax.y,
		XVW_GRAPHICS_VIEWPORT_MAX_Z, graphics->viewmax.z,
		XVW_GRAPHICS_WCMIN_X,  graphics->wcmin.x,
		XVW_GRAPHICS_WCMIN_Y,  graphics->wcmin.y,
		XVW_GRAPHICS_WCMIN_Z,  graphics->wcmin.z,
		XVW_GRAPHICS_WCMAX_X,  graphics->wcmax.x,
		XVW_GRAPHICS_WCMAX_Y,  graphics->wcmax.y,
		XVW_GRAPHICS_WCMAX_Z,  graphics->wcmax.z,
		XVW_GRAPHICS_MODE_X, graphics->axis_mode_x,
		XVW_GRAPHICS_MODE_Y, graphics->axis_mode_y,
		XVW_GRAPHICS_MODE_Z, graphics->axis_mode_z,
		XVW_GRAPHICS_PROPORTIONAL, graphics->proportional,
		NULL);
	   }
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: ConstraintSetValues
|
|       Purpose: This method is used to update the constraint
|		 parameters of the children of an area widget. 
|		 The resulting changes are initiated here.
|		 
|         Input: current  - the widget whose constraint values are being set
|                request  - the widget containing requested settings
|		 new      - the widget processed through all set values methods 
|		 args     - an argument list of constraints being set
|		 num_args - the number of arguments being set
|
|        Output: None
|
|	Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: John M. Salas  & Mark Young
|          Date: Jun 29, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean ConstraintSetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	Widget attach;
	XvwGraphicsPart *npart, *cpart, *graphics;
	XvwAreaWidget xwid = kwidget(XtParent(new));
	static Boolean attaching = FALSE;

	/*
	 * If already in ConstraintAttach() return.
	 */
	if (attaching)
	   return(FALSE);

	if (XtIsSubclass(current, xvwGraphicsWidgetClass) ||
	    XtIsSubclass(current, xvwGraphicsGadgetClass))
	{

	   /*
	    * If the attached widget has changed set all the attached attributes
	    * to the values of the newly attached widget and return else
	    * get the graphics parts so those attributes that have changed can
	    * be determined and set.  
	    */
	   attach = GetAttachWidget(new);
	   if (GetAttachWidget(current) != GetAttachWidget(new))
	   {
	      if ((graphics = GetGraphicsPart(attach)) == NULL)
	         return(FALSE);

	      xvw_set_attributes(xvw_object(new),
			XVW_GRAPHICS_VIEWPORT_MIN_X, graphics->viewmin.x,
			XVW_GRAPHICS_VIEWPORT_MIN_Y, graphics->viewmin.y,
			XVW_GRAPHICS_VIEWPORT_MIN_Z, graphics->viewmin.z,
			XVW_GRAPHICS_VIEWPORT_MAX_X, graphics->viewmax.x,
			XVW_GRAPHICS_VIEWPORT_MAX_Y, graphics->viewmax.y,
			XVW_GRAPHICS_VIEWPORT_MAX_Z, graphics->viewmax.z,
			XVW_GRAPHICS_WCMIN_X,  graphics->wcmin.x,
			XVW_GRAPHICS_WCMIN_Y,  graphics->wcmin.y,
			XVW_GRAPHICS_WCMIN_Z,  graphics->wcmin.z,
			XVW_GRAPHICS_WCMAX_X,  graphics->wcmax.x,
			XVW_GRAPHICS_WCMAX_Y,  graphics->wcmax.y,
			XVW_GRAPHICS_WCMAX_Z,  graphics->wcmax.z,
			XVW_GRAPHICS_MODE_X, graphics->axis_mode_x,
			XVW_GRAPHICS_MODE_Y, graphics->axis_mode_y,
			XVW_GRAPHICS_MODE_Z, graphics->axis_mode_z,
			XVW_GRAPHICS_PROPORTIONAL, graphics->proportional,
			NULL);

	      return(FALSE);
	   }

	   npart = GetGraphicsPart(new);
	   cpart = GetGraphicsPart(current);
	   if (npart == NULL || cpart == NULL || attach == NULL)
	      return(FALSE);

	   /*
	    * Check to see if any of the attached attributes have changed if
	    * so call ConstraintAttach() to adjust all the attached widgets.
	    */
	   if (npart->viewmin.x != cpart->viewmin.x ||
	       npart->viewmin.y != cpart->viewmin.y ||
	       npart->viewmin.z != cpart->viewmin.z ||
	       npart->viewmax.x != cpart->viewmax.x ||
	       npart->viewmax.y != cpart->viewmax.y ||
	       npart->viewmax.z != cpart->viewmax.z ||
	       npart->wcmin.x != cpart->wcmin.x ||
	       npart->wcmin.y != cpart->wcmin.y ||
	       npart->wcmin.z != cpart->wcmin.z ||
	       npart->wcmax.x != cpart->wcmax.x ||
	       npart->wcmax.y != cpart->wcmax.y ||
	       npart->wcmax.z != cpart->wcmax.z ||
	       npart->proportional != cpart->proportional ||
	       npart->axis_mode_x != cpart->axis_mode_x ||
	       npart->axis_mode_y != cpart->axis_mode_y ||
	       npart->axis_mode_z != cpart->axis_mode_z)
	   {
	      /*
	       * If the attached widget is the parent than set the attributes
	       * of the parent (attached widget).  ???
	       */
	      if (attach == XtParent(new))
	      {
	         xvw_set_attributes(xvw_object(attach),
			XVW_GRAPHICS_VIEWPORT_MIN_X, npart->viewmin.x,
			XVW_GRAPHICS_VIEWPORT_MIN_Y, npart->viewmin.y,
			XVW_GRAPHICS_VIEWPORT_MIN_Z, npart->viewmin.z,
			XVW_GRAPHICS_VIEWPORT_MAX_X, npart->viewmax.x,
			XVW_GRAPHICS_VIEWPORT_MAX_Y, npart->viewmax.y,
			XVW_GRAPHICS_VIEWPORT_MAX_Z, npart->viewmax.z,
			XVW_GRAPHICS_WCMIN_X, npart->wcmin.x,
			XVW_GRAPHICS_WCMIN_Y, npart->wcmin.y,
			XVW_GRAPHICS_WCMIN_Z, npart->wcmin.z,
			XVW_GRAPHICS_WCMAX_X, npart->wcmax.x,
			XVW_GRAPHICS_WCMAX_Y, npart->wcmax.y,
			XVW_GRAPHICS_WCMAX_Z, npart->wcmax.z,
			XVW_GRAPHICS_MODE_X, npart->axis_mode_x,
			XVW_GRAPHICS_MODE_Y, npart->axis_mode_y,
			XVW_GRAPHICS_MODE_Z, npart->axis_mode_z,
			XVW_GRAPHICS_PROPORTIONAL, npart->proportional,
			NULL);
	      }
	      attaching = TRUE;
	      ConstraintAttach(xwid, new, attach, cpart, npart);
	      attaching = FALSE;
	   }
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial values 
|                for all the fields for a XvwAreaWidget instance. 
|
|         Input: request - widget instance with requested public settings
|		 new	 - widget instance after initialization, with 
|                          settings initialized 
|        Output: None
|
|    Written By: Mark Young
|          Date: Jun 29, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget request,
   Widget new,
   ArgList args,
   Cardinal *num_args)
{
	XvwAreaWidget xwid = kwidget(new);

        xwid->area.date = xvw_create_date(xvw_object(new), "date");
	xvw_set_attributes(xwid->area.date,
			   XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_RIGHT,
			   XVW_MAPPED, xwid->area.display_date,
			   XVW_FONT,   xwid->manager.font,
			   XVW_ABOVE,    NULL,
			   XVW_LEFT_OF,  NULL,
			   NULL);

        xwid->area.title = xvw_create_string(xvw_object(new), "title");
	xvw_set_attributes(xwid->area.title,
			   XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
			   XVW_MAPPED, xwid->area.display_title,
			   XVW_FONT,   xwid->manager.font,
			   XVW_STRING_STRING, "Area Title",
			   XVW_BELOW,  NULL,
			   XVW_LEFT_OF, NULL,
			   XVW_RIGHT_OF, NULL,
			   NULL);
	xwid->area.display_legend = FALSE;
}

/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This method will set up the window attributes 
|                and create a window for the area widget. 
|
|         Input: widget	    - the widget to realize 
|		 valuemask  - determines the window attributes being passed in
|		 attributes - the list of window attributes to be set 
|
|        Output: None 
|
|    Written By: Mark Young
|          Date: Jun 29, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget               widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
	int	   mode;

	/*
	 *  Set backing store if applicable
	 */
	if ((mode = XDoesBackingStore(XtScreen(widget))) != NotUseful)
	{
	   *valuemask |= CWBackingStore;
	   winattrib->backing_store = mode;
	} 
	(*xvwAreaWidgetClass->core_class.superclass->core_class.realize)
		(widget, valuemask, winattrib);
}

/*-----------------------------------------------------------
|
|  Routine Name: Resize
|
|       Purpose: This method is used to set the area size
|		 to a new size if the area is resized, and
|		 to redraw the area at its new size. 
|
|         Input: widget - the widget containing the new position 
|                         and size information
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Jun 29 10:35:32 MDT 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Resize(
   Widget widget)
{
	XvwAreaWidget xwid = kwidget(widget);

	int	i;
	Widget	current;


	if (!XtWindow(widget))
	   return;

	for (i = xwid->composite.num_children-1; i >=0; i--)
	{
	    current = xwid->composite.children[i];
	    if (XtIsSubclass(current, xvwGraphicsGadgetClass))
	    {
                XvwGraphicsGadgetClass gclass = (XvwGraphicsGadgetClass)
                                                current->core.widget_class;

		/*
		 *  Kludge:  Apr 14, 1995  (MY & DA)
		 *
		 *  The AxisGadget is special, since it had two graphics ids.
		 *  If the Axis is not managed, but realized, then the Resize()
		 *  method will not be called, and the second graphics id not
		 *  updated.  So by managing the child before calling it's
		 *  recompute position, we avoid this problem.
		 */
		if (!XtIsManaged(current) &&
		    XtIsSubclass(current, AxisGadgetClass))
		{
		   XtManageChild(current);
		}

		X3D_set_X11((int) current, XtDisplay(widget), None, widget);
	        if (gclass->graphics_class.recompute_position != NULL)
		   gclass->graphics_class.recompute_position(current);
	    }
	}
	ManagerRequestLayout(widget, FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: Determine what the widget should do by
|		 comparing the current values verse the
|		 new settings.
|
|         Input: current - the widget containing current settings 
|		 request - the widget containing requested settings
|		 new	 - the widget processed through all set values methods 
|
|        Output: None directly 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Jun 29, 1992
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget current,
   Widget request,
   Widget new,
   ArgList  args,
   Cardinal *num)
{
	XvwAreaWidget cxwid = kwidget(current);
	XvwAreaWidget nxwid = kwidget(new);
	XvwGraphicsPart *npart, *cpart;


	if (cxwid->area.display_date != nxwid->area.display_date)
	{
	   xvw_set_attribute(nxwid->area.date, XVW_MAPPED,
			nxwid->area.display_date);
	}

	if (cxwid->area.display_title != nxwid->area.display_title)
	{
	   xvw_set_attribute(nxwid->area.title, XVW_MAPPED,
			nxwid->area.display_title);
	}

	npart = GetGraphicsPart(new);
	cpart = GetGraphicsPart(current);
	if (npart->viewmin.x != cpart->viewmin.x ||
	    npart->viewmin.y != cpart->viewmin.y ||
	    npart->viewmin.z != cpart->viewmin.z ||
	    npart->viewmax.x != cpart->viewmax.x ||
	    npart->viewmax.y != cpart->viewmax.y ||
	    npart->viewmax.z != cpart->viewmax.z ||
	    npart->wcmin.x != cpart->wcmin.x ||
	    npart->wcmin.y != cpart->wcmin.y ||
	    npart->wcmin.z != cpart->wcmin.z ||
	    npart->wcmax.x != cpart->wcmax.x ||
	    npart->wcmax.y != cpart->wcmax.y ||
	    npart->wcmax.z != cpart->wcmax.z ||
	    npart->proportional != cpart->proportional ||
	    npart->axis_mode_x != cpart->axis_mode_x ||
	    npart->axis_mode_y != cpart->axis_mode_y ||
	    npart->axis_mode_z != cpart->axis_mode_z)
	{
	   ConstraintAttach(nxwid, new, new, cpart, npart);
	}

	if (cxwid->area.display_legend != nxwid->area.display_legend)
	   kinfo(KSTANDARD,"Legend is not supported at this time");

	return(FALSE);
}


/************************************************************
*
*  Routine Name: xvw_create_area - create a graphics area object
*
*       Purpose: An area object provides an area which contains a 
*                coordinated view of other visual objects, such as plots, 
*                axes, annotations, and so on.  All visual objects that are

*                children of the area object can have the same world 
*                coordinates, viewport, and perspective as the controlling 
*                visual object, where the controlling visual object may be 
*                specified by the application using the XVW_AREA_ATTACH
*                attribute.
*
*         Input: parent - the parent object; NULL will cause a  
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None
*
*	Returns: The area object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young & John M. Salas
*          Date: Jun 29, 1992
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_area(
   xvobject parent,
   char     *name)
{
	xvobject object;


	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, AreaWidgetClass);
	return(object);
}
