/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                 3D Scale Utilities
   >>>>
   >>>>  Private:
   >>>>			_X3D_scale_wc_coords()
   >>>>			_X3D_scale_wc_coord()
   >>>>			_X3D_get_scale_value()
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "graphics.h"


/*-----------------------------------------------------------
|
|  Routine Name: _X3D_scale_wc_coords
|
|       Purpose: Converts a 3D world coordinate to the scale
|		 type desired
|
|         Input: scale	 -
|		 coords	 -
|		 size	 -
|
|        Output: scoords -
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Mike Lang
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int	_X3D_scale_wc_coords(
   Coord scale,
   Coord *coords,
   Coord **scoords,
   int   size)
{
	int	i;
	Coord	*temp;

	if (scale.x == KGRAPHICS_LINEAR && 
            scale.y == KGRAPHICS_LINEAR && 
            scale.z == KGRAPHICS_LINEAR)
	{
	   *scoords = coords;
	   return(TRUE);
	}

	if ((temp = (Coord *) kmalloc((unsigned) sizeof(Coord) * size)) == NULL)
	{
	   *scoords = coords;
	   return(FALSE);
	}

	for (i = 0; i < size; i++)
	{
	   temp[i].x = _X3D_get_scale_value((int) scale.x, coords[i].x);
	   temp[i].y = _X3D_get_scale_value((int) scale.y, coords[i].y);
	   temp[i].z = _X3D_get_scale_value((int) scale.z, coords[i].z);
	}
	*scoords = temp;
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _X3D_scale_wc_coord
|
|       Purpose: Converts a 3D world coordinate to the scale
|		 type desired.
|
|         Input: scale	-
|		 coord	-
|
|        Output: scoord -
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Mike Lang
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int	_X3D_scale_wc_coord(
   Coord scale,
   Coord coord,
   Coord *scoord)
{
	Coord	temp;

	if (scale.x == KGRAPHICS_LINEAR && 
            scale.y == KGRAPHICS_LINEAR && 
            scale.z == KGRAPHICS_LINEAR)
	{
	   *scoord = coord;
	   return(TRUE);
	}

	temp.x = _X3D_get_scale_value((int) scale.x, coord.x);
	temp.y = _X3D_get_scale_value((int) scale.y, coord.y);
	temp.z = _X3D_get_scale_value((int) scale.z, coord.z);

	*scoord = temp;
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _X3D_get_scale_value
|
|       Purpose:
|
|         Input: scale_type - type a scale wanted
|		 value	    - number to be scale
|
|        Output: none
|
|       Returns: the scaled value
|
|    Written By: Mark Young & Mike Lang
|          Date: 
| Modifications:
|
------------------------------------------------------------*/
Real _X3D_get_scale_value(
   int  scale_type,
   Real value)
{
	switch (scale_type)
	{
	   case KGRAPHICS_LINEAR:
	        return(value);

	   case KGRAPHICS_LOG10:
	        return((Real) log10((double) value));

	   case KGRAPHICS_LN:
	        return((Real) log((double) value));
	}
	return(value);
}
