/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                 3D Drawing Utilities
   >>>>
   >>>>  Private:
   >>>>			_X3D_find_color()
   >>>>			_X3D_find_level()
   >>>>			_X3D_find_corner()
   >>>>			_X2D_draw_markers()
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "graphics.h"


/*-----------------------------------------------------------
|
|  Routine Name: _X3D_find_color
|
|       Purpose: 
|
|         Input: indx	      -
|		 colors	      -
|		 color_offset -
|		 num	      -
|
|        Output: none
|
|       Returns: indx into the XColor array
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/
int _X3D_find_color(
   register int    indx,
   register XColor *colors,
   int             color_offset,
   int             num)
{
	register int  cmax, cmin;

	cmin = color_offset;
	cmax = color_offset+num-1;

	if (indx > cmax)
	   indx = cmax-1;

	while ((char)colors[indx].flags == 0 && indx > cmin)
	   indx--;

	if ((char)colors[indx].flags == 0)
	{
	   while ((char)colors[indx].flags == 0 && indx < cmax)
	      indx++;

	   if ((char)colors[indx].flags == 0)
	      return(-1);
	}
	return(indx);
}

/*-----------------------------------------------------------
|
|  Routine Name: _X3D_find_corner
|
|       Purpose: This routine finds the rear most corner to start
|		 drawing a plot.  Horizon & Mesh plots use painter's
|		 algorithm in order to draw the plot, thus it is
|		 important to find the opposite corner in which to
|		 start drawing from.
|
|         Input: graphics -
|		 pt0	  -
|		 pt1	  -
|		 pt2	  -
|		 pt3	  -
|
|        Output: none
|
|       Returns: the corner the point
|		 BL - Back Left  BR - Back Right  
|		 FL - Front Left  FR - Front Right

|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int _X3D_find_corner(
   X3DGraphics *graphics,
   Coord       *pt0,
   Coord       *pt1,
   Coord       *pt2,
   Coord       *pt3)
{
	return(graphics->corner);
}

/*-----------------------------------------------------------
|
|  Routine Name: _X3D_find_level
|
|       Purpose: 
|
|         Input: value	- the value to check
|		 levels - the array of levels
|		 num	- the number of levels
|
|        Output: none
|
|       Returns: the indx of the level the value is above
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int _X3D_find_level(
   Real value,
   Real *levels,
   int  num)
{
	int	indx = num -1;

	while (value < levels[indx] && indx > 0)
	   indx--;

	return(indx);
}

/*-----------------------------------------------------------
|
|  Routine Name: _X2D_draw_markers - draw the marker at the points specified
|
|       Purpose:
|
|         Input: id	     -
|		 points	     - array of points to draw
|		 size	     - number of points to draw 
|		 marker_type - marker type to draw with
|
|        Output: none
|
|       Returns: nothing
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

void _X2D_draw_markers(
   int    id,
   XPoint *points,
   int    size,
   int    marker_type)
{
	register int	i, scale;
	X3DGraphics	*graphics;
	int		old_line_type;

	XPoint  triangle[4];
	XPoint  diamond[6];

	if ((graphics = _X3D_get_graphics(id)) == NULL)
	{
	   kfprintf (kstderr,"draw_marker:\n");
	   kfprintf (kstderr,"\t unknown graphics id\n");
	   return;
	}

	scale = 1;

	old_line_type = graphics->line_type;
	X3D_set_line_type(id, KLINE_SOLID);

	switch (marker_type)
	{
	   case KMARKER_POINT:	/* marker star or astrix */
		for (i = 0; i < size; i++)
		{
		    X3D_draw[graphics->device].line(graphics,
				 points[i].x, points[i].y +3*scale,
				 points[i].x, points[i].y -3*scale);
		    X3D_draw[graphics->device].line(graphics,
				 points[i].x +3*scale, points[i].y +2*scale,
				 points[i].x -3*scale, points[i].y -2*scale);
		    X3D_draw[graphics->device].line(graphics,
				 points[i].x +3*scale, points[i].y -2*scale,
				 points[i].x -3*scale, points[i].y +2*scale);
		}
		break;

	   case KMARKER_SQUARE:
		for (i = 0; i < size; i++)
		{
		       X3D_draw[graphics->device].rectangle(graphics,
			      points[i].x-2*scale, points[i].y -2*scale,
			      4*scale, 4*scale);
		}
		break;

	   case KMARKER_TRIANGLE:
/*
	        triangle[1].x = triangle[3].x = -2 * scale;
		triangle[1].y = -4 * scale;
	        triangle[2].y = 0;
	        triangle[3].y = triangle[2].x =  4 * scale;

		for (i = 0; i < size; i++)
		{
		    triangle[0].x = points[i].x +2*scale;
		    triangle[0].y = points[i].y +2*scale;
		    X3D_draw[graphics->device].lines(graphics,
				  triangle, 4, CoordModePrevious);
		}
*/
	        triangle[1].x = triangle[3].x = -3 * scale;
		triangle[1].y = -4 * scale;
	        triangle[2].y = 0;
	        triangle[3].y = triangle[2].x =  4 * scale;

		for (i = 0; i < size; i++)
		{
		    triangle[0].x = points[i].x +2*scale;
		    triangle[0].y = points[i].y +2*scale;
		    X3D_draw[graphics->device].lines(graphics,
				  triangle, 4, CoordModePrevious);
		}
		break;

	   case KMARKER_DIAMOND:
		diamond[0].x = diamond[0].y = diamond[1].x = 0;
		diamond[2].y = diamond[3].x = diamond[3].y =
		diamond[4].x =  2*scale;
		diamond[1].y = diamond[2].x = diamond[4].y = diamond[5].x =
		diamond[5].y = -2*scale;
		for (i = 0; i < size; i++)
		{
		    diamond[0] = points[i];
		    X3D_draw[graphics->device].lines(graphics, diamond, 6,
			          CoordModePrevious);
		}
		break;

	   case KMARKER_DAGGER:
		for (i = 0; i < size; i++)
		{
		    X3D_draw[graphics->device].line(graphics,
				 points[i].x -2*scale, points[i].y,
				 points[i].x +2*scale,points[i].y);
		    X3D_draw[graphics->device].line(graphics,
				 points[i].x, points[i].y +2*scale,
				 points[i].x, points[i].y -4*scale);
		}
		break;

	   case KMARKER_CROSS:
		for (i = 0; i < size; i++)
		{
		    X3D_draw[graphics->device].line(graphics,
				 points[i].x -3*scale, points[i].y,
				 points[i].x+3*scale, points[i].y);
		    X3D_draw[graphics->device].line(graphics,
				 points[i].x, points[i].y+3*scale,
				 points[i].x, points[i].y-3*scale);
		}
		break;

	   case KMARKER_X:
		for (i = 0; i < size; i++)
		{
		    X3D_draw[graphics->device].line(graphics,
				 points[i].x -2*scale, points[i].y -2*scale,
				 points[i].x +2*scale, points[i].y +2*scale);
		    X3D_draw[graphics->device].line(graphics,
				 points[i].x -2*scale, points[i].y +2*scale,
				 points[i].x +2*scale, points[i].y -2*scale);
		}
		break;

	   case KMARKER_V:
		for (i = 0; i < size; i++)
		{
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x, points[i].y +2*scale,
			      points[i].x -2*scale, points[i].y -2*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x, points[i].y +2*scale,
			      points[i].x +2*scale, points[i].y -2*scale);
		}
		break;

	   case KMARKER_CARET:
		for (i = 0; i < size; i++)
		{
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x, points[i].y -2*scale,
			      points[i].x -2*scale, points[i].y +2*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x, points[i].y -2*scale,
			      points[i].x +2*scale, points[i].y +2*scale);
		}
		break;

	   case KMARKER_BOW_TIE:
		for (i = 0; i < size; i++)
		{
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x -3*scale, points[i].y -3*scale,
			      points[i].x +3*scale, points[i].y +3*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x -3*scale, points[i].y +3*scale,
			      points[i].x +3*scale, points[i].y -3*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x -3*scale, points[i].y +3*scale,
			      points[i].x -3*scale, points[i].y -3*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x +3*scale, points[i].y +3*scale,
			      points[i].x +3*scale, points[i].y -3*scale);
		}
		break;

	   case KMARKER_BOX:
		for (i = 0; i < size; i++)
		{
		    X3D_draw[graphics->device].rectangle(graphics,
			      points[i].x-2*scale, points[i].y -2*scale,
			      4*scale, 4*scale);

		    X3D_draw[graphics->device].line(graphics,
			      points[i].x -3*scale, points[i].y -3*scale,
			      points[i].x +3*scale, points[i].y +3*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x -3*scale, points[i].y +3*scale,
			      points[i].x +3*scale, points[i].y -3*scale);
		}
		break;

	   case KMARKER_CIRCLE:
		for (i = 0; i < size; i++)
		{
                       X3D_draw[graphics->device].arc(graphics,
                             points[i].x, points[i].y,
                             4*scale, 4*scale, 0, 360);

		}
		break;

/*
	   case KMARKER_HOTSPOT:
		for (i = 0; i < size; i++)
		{
		       X3D_draw[graphics->device].arc(graphics,
			     points[i].x-2*scale-1, points[i].y -2*scale-1,
			     4*scale+2, 4*scale+2, 0, 360);
		}
		break;
 */
	   case KMARKER_ARC:
		for (i = 0; i < size; i++)
		{
                       X3D_draw[graphics->device].arc(graphics,
                             points[i].x, points[i].y,
                             6*scale, 6*scale, 0, 180);

		}
		break;

	   case KMARKER_HEXAGON:
		for (i = 0; i < size; i++)
		{
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x, points[i].y +3*scale,
			      points[i].x +2*scale, points[i].y +1*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x +2*scale, points[i].y +1*scale,
			      points[i].x +2*scale, points[i].y -1*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x +2*scale, points[i].y -1*scale,
			      points[i].x, points[i].y -3*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x, points[i].y -3*scale,
			      points[i].x -2*scale, points[i].y -1*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x -2*scale, points[i].y -1*scale,
			      points[i].x -2*scale, points[i].y +1*scale);
		    X3D_draw[graphics->device].line(graphics,
			      points[i].x -2*scale, points[i].y +1*scale,
			      points[i].x, points[i].y +3*scale);
		}
		break;

           case KMARKER_DOT:
		scale = 1;
		for (i = 0; i < size; i++)
		{
/*
		    X3D_draw[graphics->device].arc(graphics,
			     points[i].x - scale, points[i].y,
			     2*scale, 2*scale, 0, 360);
*/
		    X3D_draw[graphics->device].arc(graphics,
			     points[i].x, points[i].y,
			     2*scale, 2*scale, 0, 360);
		}
		break;
	}
	X3D_set_line_type(id, old_line_type);
}
