/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	        Mapping & Unmapping Routines                  <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                xvf_map_form()                         <<<<
   >>>>                xvf_map_subform()                      <<<<
   >>>>                xvf_map_kformstruct()                  <<<<
   >>>>                                                       <<<<
   >>>>                xvf_unmap_form()                       <<<<
   >>>>                xvf_unmap_subform()                    <<<<
   >>>>                xvf_unmap_kformstruct()                <<<<
   >>>>                                                       <<<<
   >>>>                xvf_iconify_object()                   <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*-----------------------------------------------------------
|
|  Routine Name: xvf_map_form()
|
|       Purpose: Maps the main form of a GUI.  
|         Input: form - pointer to the form tree 
|        Output: none
|    Written By: Danielle Argiro & Mark Young
|          Date: Jul 16, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void xvf_map_form(
   kform *form)
{
	ksubform *subform;

	if (form->toplevel != NULL)
	{
	    xvw_realize(form->toplevel);
	    xvw_map(form->toplevel);
	    xvw_raise(form->toplevel);
	}

	/* map the subforms associated with master form */
	if (form->master != NULL)
	{
	    subform = form->master->subform_list;
	    while (subform != NULL)
	    {
		if (subform->selected == TRUE) 
		    xvf_map_subform(subform);
		subform = subform->next;
	    }
	}
	else
	{
	    subform = form->subform;
	    if (subform->selected == TRUE)
                xvf_map_subform(subform);
	}

}


/*-----------------------------------------------------------
|
|  Routine Name: xvf_map_subform()
|
|       Purpose: Maps a subform of the GUI.  
|         Input: subform - pointer to the subform to be mapped
|        Output: none
|    Written By: Danielle Argiro & Mark Young
|          Date: Jul 16, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void xvf_map_subform(
   ksubform *subform)
{
	if (subform->back == NULL) 
	{
	    if (!(xvf_create_subform(subform, -1, -1, TRUE))) return;
	}
	else
	{
	    xvw_realize(subform->toplevel);
	    xvw_map(subform->toplevel);
	    xvw_raise(subform->toplevel);
	}
}


/*-----------------------------------------------------------
|
|  Routine Name: xvf_map_kformstruct()
|
|       Purpose: Maps the GUI objects comprising the selection,
|                subform, or whatever, represented by the kformstruct
|                passed in.
|         Input: selection - pointer to the selection to be unmapped
|        Output: none
|    Written By: Danielle Argiro 
|          Date: April 28, 1994
| Modifications:
|
-------------------------------------------------------------*/

void xvf_map_kformstruct(
  kform_struct *kformstruct)
{
        xvobject backplane;

        /*
         * special case for submenu buttons: you know you want to map
         * the button, but xvf_get_backplane will return the menu backplane,
         * so take care of this case individually.
         */
        if (kformstruct->flag == KUIS_STARTSUBMENU)
        {
            /* submenu button is saved as label object */
            if (kformstruct->Selptr->label_object != NULL)
                xvw_map(kformstruct->Selptr->label_object);
        }

        /*
         *  general case for pretty much everything else: map the backplane
         */
        backplane = xvf_get_backplane(kformstruct, TRUE);
        if (backplane != NULL)
            xvw_map(backplane);
}


/*-----------------------------------------------------------
|
|  Routine Name: xvf_unmap_form()
|
|       Purpose: Unmaps the main form of a GUI.  
|         Input: form - pointer to the form tree 
|        Output: none
|    Written By: Danielle Argiro, Mark Young
|          Date: Jul 16, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void xvf_unmap_form(
   kform *form)
{
	ksubform *subform = NULL;

	xvw_unmap(form->toplevel);

	/* unmap the subforms associated with master form */
	if ((form->master != NULL) && 
            (form->master->subform_list != NULL))
	    subform = form->master->subform_list;
	else subform = form->subform;
	while (subform != NULL)
	{
	    if ((subform->type == KUIS_SUBFORMBUTTON) && 
                (subform->selected == TRUE))
	        xvf_unmap_subform(subform);
	    subform = subform->next;
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: xvf_unmap_subform()
|
|       Purpose: Unmaps a subform of a GUI  
|         Input: subform - pointer to the subform to be unmapped 
|        Output: none
|    Written By: Danielle Argiro & Mark Young
|          Date: Jul 16, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void xvf_unmap_subform(
   ksubform *subform)
{
	xvw_unmap(subform->toplevel);
}


/*-----------------------------------------------------------
|
|  Routine Name: xvf_unmap_kformstruct()
|
|       Purpose: Unmaps the GUI objects comprising the selection,
|                subform, or whatever, represented by the kformstruct 
|                passed in.
|         Input: selection - pointer to the selection to be unmapped
|        Output: none
|    Written By: Danielle Argiro 
|          Date: April 28, 1994
| Modifications: 
|
-------------------------------------------------------------*/

void xvf_unmap_kformstruct(
  kform_struct *kformstruct)
{
        xvobject backplane;
       
	/* 
	 * special case for submenu buttons: you know you want to unmap 
         * the button, but xvf_get_backplane will return the menu backplane,
         * so take care of this case individually.
         */
	if (kformstruct->flag == KUIS_STARTSUBMENU)
	{
	    /* submenu button is saved as label object */
	    if (kformstruct->Selptr->label_object != NULL)
	        xvw_unmap(kformstruct->Selptr->label_object);
	}

	/*
	 *  general case for pretty much everything else: unmap the backplane
	 */
	backplane = xvf_get_backplane(kformstruct, TRUE);
        if (backplane != NULL)
            xvw_unmap(backplane);
}

/*--------------------------------------------------------------
|
|  Routine Name: xvf_iconify_object
|
|	Purpose: Iconifies a object, if the object pointer is not NULL
|
|	  Input: object - the object to be iconified
|        Output: none
|    Written By: Danielle Argiro
|          Date: Jul 16, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------------*/

void xvf_iconify_object(
   xvobject object)
{
	if (object != NULL)
	{
	   XIconifyWindow(xvw_display(object), xvw_window(object),
		          XDefaultScreen(xvw_display(object)));
	}
}

