 /* Khoros: $Id$ */
 /* $Log$ */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Motif Widget Set
   >>>>
   >>>>    Written By: Danielle Argiro, John Salas
   >>>>
   >>>>          Date: April 12, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _motif_internals_h_
#define _motif_internals_h_



	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <design.h>
#ifdef KMOTIF_DEF
#include <xvinclude.h>

#undef XtRLong
#include <Xm/Xm.h>

#if XmVERSION == 1 && XmREVISION == 2
#include <Xm/Display.h>
#endif

#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/ScrollBar.h>
#include <Xm/List.h>

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

	/*-------------------------------------*
	|       #macros 
	---------------------------------------*/

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* utilities.c */
int xvw_get_misc                  PROTO((xvobject, char *, kaddr));
int xvw_set_misc                  PROTO((xvobject, char *, kaddr));
void xvw_popup_motif_menu         PROTO((Widget, kaddr, kaddr));
int xvw_get_buttonshape           PROTO((xvobject, char *, kaddr));
int xvw_set_buttonshape           PROTO((xvobject, char *, kaddr));
int xvw_get_text                  PROTO((xvobject, char *, kaddr));
int xvw_set_text                  PROTO((xvobject, char *, kaddr));
int xvw_get_texttype              PROTO((xvobject, char *, kaddr));
int xvw_set_texttype              PROTO((xvobject, char *, kaddr));
int xvw_get_textmulti             PROTO((xvobject, char *, kaddr));
int xvw_set_textmulti             PROTO((xvobject, char *, kaddr));
int xvw_get_scrollbar             PROTO((xvobject, char *, kaddr));
int xvw_set_scrollbar             PROTO((xvobject, char *, kaddr));
int xvw_get_list_highlight        PROTO((xvobject, char *, kaddr));
int xvw_set_list_highlight        PROTO((xvobject, char *, kaddr));
int xvw_set_list_unhighlight      PROTO((xvobject, char *, kaddr));
int xvw_set_orientation           PROTO((xvobject, char *, kaddr));

void xvw_set_textfocus 		  PROTO((xvobject, kaddr, XEvent *));
void xvw_set_textpos 		  PROTO((Widget, kaddr, XmAnyCallbackStruct *));
int xvw_set_menubutton            PROTO((xvobject, char *, kaddr));
int xvw_get_menubutton            PROTO((xvobject, char *, kaddr));


void xvw_update_scroll_value      PROTO((xvobject, char *, kaddr, double *));
void xvw_update_list_struct       PROTO((xvobject, char *, kaddr, int *,
				         xvw_list_struct *));
Boolean cvtCompoundStringToString PROTO((Display *, XrmValuePtr, Cardinal *,
					XrmValuePtr, XrmValuePtr, XtPointer *));
Boolean cvtStringToCompoundString PROTO((Display *, XrmValuePtr, Cardinal *,
					XrmValuePtr, XrmValuePtr, XtPointer *));

#else

/*
 * A kludge so that initialize.c compiles.
 */
typedef struct _XDisplay Display;


#endif /* KMOTIF_DEF    */
#endif /* _Motif_internals_h_ */
/* Don't add after this point */
