 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes structure used to describe
   >>>>		       Khoros resource information with different
   >>>>		       visual and GUI objects
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Jul 21, 1992 22:55
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvwidgets_attributes_h_
#define _xvwidgets_attributes_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <X11/Xresource.h>


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct
{
	kstring  xvwname;
	kstring  widname;
	kstring  xvwres;
	kstring  widres;
} xvattribute;


	/*-------------------------------------*
	|       macros
	---------------------------------------*/

/************************************************************
*
*  Routine Name: xvw_set_attribute - set a single attribute on an object
*
*       Purpose: sets a single attribute for a visual or GUI object
*
*         Input: object    - the object for which to set the attribute 
*                attribute - the attribute name
*                value     - the attribute value
*
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*     Written By: Mark Young & Danielle Argiro & John Salas
*          Date: Nov 13, 1992
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvw_set_attribute(
*                !   xvobject object,
*                !   char     *attribute,
*                !   data     value)
*
*************************************************************/

#define xvw_set_attribute(object, attribute, value) \
		xvw_set_attributes(object, attribute, value, NULL)


/************************************************************
*
*  Routine Name: xvw_get_attribute - get a single attribute of an object
*
*       Purpose: gets a single attribute for a visual or GUI object
*
*         Input: object    - the object for which to get the attribute 
*                attribute - the attribute name
*
*        Output: value     - returns the current attribute value
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*     Written By: Mark Young & Danielle Argiro & John Salas
*          Date: Nov 13, 1992
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvw_get_attribute(
*                !   xvobject object,
*                !   char     *attribute,
*                !   data     *value)
*
*************************************************************/

#define xvw_get_attribute(object, attribute, value) \
		xvw_get_attributes(object, attribute, value, NULL)


/************************************************************
*
*  Routine Name: xvw_define_attribute - define a single attribute for a
*				     widget class
*
*       Purpose: This allows the advance application programmer to add
*		 their own user defined attributes for a particular widget
*		 class.  This allows the addition of attributes
*                to a widget class or if NULL then a general set of
*                attributes.  When the "set" or "get" attribute routines
*                are called then the corresponding routine is called.
*
*         Input: widget_class   - the widget to get the attribute for
*		 attribute_name - the attribute name
*		 resource_type  - the resource type of the attribute
*		 setroutine     - the routine to call when a set attribute
*				  is called (xvw_set_attribute).
*		 getroutine     - the routine to call when a get attribute
*				  is called (xvw_get_attribute).
*
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*     Written By: Mark Young & Danielle Argiro & John Salas
*          Date: Nov 13, 1992
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvw_define_attribute(
*                !   WidgetClass widget_class,
*                !   char     *attribute_name,
*                !   char     *resource_type,
*		 !   kfunc_int setroutine,
*		 !   kfunc_int getroutine)
*
*************************************************************/

#define xvw_define_attribute(wclass, name, type, set, get) \
	xvw_define_attributes(wclass, name, type, set, get, NULL)

/************************************************************
*
*  Routine Name: xvw_define_constraint - define a single constraint attribute
*					for a widget class
*
*       Purpose: This allows the advance application programmer to add
*		 their own user defined constraint attributes for a particular
*		 widget class.  This allows the addition of constraint
*		 attributes to a widget class or if NULL then a general set of
*                constraint attributes.  When the "set" or "get" attribute
*		 routines are called then the corresponding routine is called.
*
*         Input: widget_class   - the widget to get the attribute for
*		 constraint_name- the constraint attribute name
*		 resource_type  - the resource type of the attribute
*		 setroutine     - the routine to call when a set attribute
*				  is called (xvw_set_attribute).
*		 getroutine     - the routine to call when a get attribute
*				  is called (xvw_get_attribute).
*
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*     Written By: Mark Young
*          Date: Dec 06, 1994
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvw_define_constraint(
*                !   WidgetClass widget_class,
*                !   char     *constraint_name,
*                !   char     *resource_type,
*		 !   kfunc_int setroutine,
*		 !   kfunc_int getroutine)
*
*************************************************************/

#define xvw_define_constraint(wclass, name, type, set, get) \
	xvw_define_constraints(wclass, name, type, set, get, NULL)


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

#endif /* _xvwidgets_attributes_h_ */
/* don't add after the endif */
