 /*
  * Khoros: $Id$
  */
 
 /*
  * $Log$
  */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 
 
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Defines for the Button Widget
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Sep 29, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */
 
#ifndef _xvwidgets_Button_h_
#define _xvwidgets_Button_h_
 
        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/
 
/*------------------------------------------------------------------------
| Attribute:	XVW_BUTTON_TYPE
|
| Description:	A button can display a label or a pixmap.  This attribute
|		specifies which the button will be displaying.  Set to
|		.symbol index KBUTTON_TYPE_LABEL
|		for a normal label,
|		.symbol index KBUTTON_TYPE_PIXMAP
|		for a pixmap (or bitmap).   
|		A label must be set using the
|		.symbol noindex XVW_LABEL
|		attribute, and the pixmap must be set using either the
|		.symbol noindex XVW_PIXMAP
|		or the
|		.symbol noindex XVW_PIXMAP_FILENAME
|		attribute.  By default, a label is used.
|		If the button is to display a pixmap, this attribute must
|		be set to 
|		.symbol index KBUTTON_TYPE_PIXMAP
|		\fIbefore\fP the pixmap is specified
|		with 
|		.symbol index XVW_PIXMAP
|		or
|		.symbol index XVW_PIXMAP_FILENAME
|
| Type:		int
| Default:	.symbol index KBUTTON_TYPE_LABEL
| Legal Values:	.symbol index KBUTTON_TYPE_LABEL
|		.symbol index KBUTTON_TYPE_PIXMAP
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_BUTTON_TYPE   "buttonType"

/*------------------------------------------------------------------------
| Attribute:    XVW_LABEL
|
| Description:  The label used for the button object.  Note that this
|		is only used when
|		.symbol index XVW_BUTTON_TYPE
|		is set to
|		.symbol index KBUTTON_TYPE_LABEL
|		(the default).
|
| Type:         char *
| Default:      NULL
| Legal Values: any printable text
| Resource:     label
------------------------------------------------------------------------*/
/* attribute defined to "label" in Label.h */

/*------------------------------------------------------------------------
| Attribute:    XVW_LABEL_JUSTIFY
|
| Description:  Specifies whether the label on the button
|               is to be left justified, middle justified, or right justified.
|		Note that this is only used when
|               .symbol index XVW_BUTTON_TYPE
|               is set to
|               .symbol index KBUTTON_TYPE_LABEL
|               (the default).
|
| Type:         int
| Default:      .symbol index KBUTTON_JUSTIFY_CENTER
| Legal Values: .symbol index KBUTTON_JUSTIFY_LEFT
|               .symbol index KBUTTON_JUSTIFY_CENTER
|               .symbol index KBUTTON_JUSTIFY_RIGHT
| Resource:     labelJustify
------------------------------------------------------------------------*/
/* attribute defined to "labelJustify" in Label.h */

/*------------------------------------------------------------------------
| Attribute:	XVW_PIXMAP
|
| Description:  This is the pixmap (or bitmap) that appears on the button when
|               .symbol index XVW_BUTTON_TYPE
|               is set to
|               .symbol index KBUTTON_TYPE_PIXMAP .
|		Candidates for the value of this attribute may be created 
|		with the use of \fIXCreatePixmap()\fP;  see \fIThe Xlib 
|		Reference Manual\fP by O'Reilly and Associates.  Note that 
|		this attribute is mutually exclusive with
|               .symbol index XVW_PIXMAP_FILENAME ;
|               specify one or the other, not both.
|
| Type:		Pixmap
| Default:	NULL
| Legal Values:	Valid Pixmap structure
| Resource:     pixmap
------------------------------------------------------------------------*/
/* attribute defined to "pixmap" in Label.h */

/*------------------------------------------------------------------------
| Attribute:    XVW_PIXMAP_FILENAME
|
| Description:  This is the name of the file defining the pixmap (or bitmap)
|		to be used when 
|		.symbol index XVW_BUTTON_TYPE
|		is set to
|		.symbol index KBUTTON_TYPE_PIXMAP .
|
| Type:		char *
| Default:	NULL
| Legal Values: The full path to a valid xpm or xbm file, dfining the 
|		desired pixmap (or bitmap).  Note that the path may contain
|               $TOOLBOX.
| Resource:     N/A
------------------------------------------------------------------------*/
/* attribute defined to "pixmapFilename" in Label.h */

/*------------------------------------------------------------------------
| Attribute:    XVW_BUTTON_SELECT
|
| Description:  A button is not much fun without a callback installed on
|		it;  it has no functionality otherwise. Use 
|		\fIxvw_add_callback()\fP to install a callback on the button
|		object which will be fired when the user clicks on the 
|		button.  When calling \fIxvw_add_callback()\fP, pass this 
|		attribute directly, as in
|               .begin code
|               xvw_add_callback(button, XVW_BUTTON_SELECT,
|                                button_cb, client_data);
|               .end code
|
| Type:		kfunc_void
| Default:	NULL
| Legal Values:	callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_BUTTON_SELECT       "buttonSelect"

/*------------------------------------------------------------------------
| Attribute:    XVW_BUTTON_SHAPE
|
| Description:  For those widget sets that support oval buttons (Athena
|               and OLIT), this attribute dictates whether the button is
|               to be rectangular or oval.  Since the Motif widget set
|               does not support oval buttons, this attribute has no
|               effect when used with Motif.
|
| Type:         int
| Default:      .symbol index KBUTTON_SHAPE_RECT
| Legal Values: .symbol index KBUTTON_SHAPE_RECT
|               .symbol index KBUTTON_SHAPE_OVAL
| Resource:     buttonShape
------------------------------------------------------------------------*/
#define XVW_BUTTON_SHAPE  "buttonShape"

/* 
 * button shape for attribute XVW_BUTTON_SHAPE 
 */
#define KBUTTON_SHAPE_OVAL    0
#define KBUTTON_SHAPE_RECT    1

/* 
 * button & label type for attribute XVW_BUTTON_TYPE
 */
#define KBUTTON_TYPE_LABEL     1
#define KBUTTON_TYPE_PIXMAP    2

/* 
 *   how to define justification of buttons (for button widgets and 
 *   pixmap button widgets)
 */
#define KBUTTON_JUSTIFY_LEFT    0
#define KBUTTON_JUSTIFY_RIGHT   1
#define KBUTTON_JUSTIFY_CENTER  2 


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Button Widget
 */
xvobject xvw_create_button            PROTO((xvobject, char *));


#endif /* _xvwidgets_Button_h_ */
/* Do not add after this line */
