 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of Warn Object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Warn_h_
#define _xvobjects_Warn_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_WARN_LABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               label object component of the warn object (the
|               object used to display the label).
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The label object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WARN_LABEL_OBJECT   "warnLabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_WARN_BUTTON_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               the button object component of the warn object (the button
|               used to allow the user to acknowledge the warning message).
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The button object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WARN_BUTTON_OBJECT  "warnButtonObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_WARN_TEXT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               the text object component of the warn object (the text
|               displaying the warning message).
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The text object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WARN_TEXT_OBJECT    "warnTextObject"


/*------------------------------------------------------------------------
| Attribute:	XVW_WARN_MESSAGE
| Description:  The error message to be displayed in the error object. 
| Type:         char * 
| Default:      NULL 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WARN_MESSAGE	"warnTextObject.textString"

/*------------------------------------------------------------------------
| Attribute:	XVW_WARN_LABEL
| Description:  The label for the warn object. 
| Type:         char * 
| Default:      NULL 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WARN_LABEL		"warnLabelObject.label"

/*------------------------------------------------------------------------
| Attribute:	XVW_WARN_BUTTON_LABEL
| Description:  The label for the acknowledgment button. 
| Type:         char * 
| Default:      "Ok" 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WARN_BUTTON_LABEL	"warnButtonObject.label"

/*------------------------------------------------------------------------
| Attribute:	XVW_WARN_CALLBACK
|
| Description:	If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the warn object which will be
|               fired when the user clicks on the acknowledgement button.
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(warnobj, XVW_WARN_CALLBACK,
|                                warn_cb, client_data);
|               .end code
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WARN_CALLBACK	"warnCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_WARN_PIXMAPFILE
|
| Description:  This is the file defining the pixmap that appears at the
|               upper left of the warn object.
|
| Type:         char *
| Default:      The caution.xpm file in the \fIxvobjects/misc/pixmaps\fP 
|		directory, which defines the "caution" pixmap.
| Legal Values: The full path to a valid xpm or xbm file, defining
|               the desired pixmap.  Note that the path may contain
|               $TOOLBOX.
| Resource:     warnPixmapfile
------------------------------------------------------------------------*/
#define XVW_WARN_PIXMAPFILE	"warnPixmapfile"

/*------------------------------------------------------------------------
| Attribute:    XVW_WARN_PIXMAP
|
| Description:  This is the pixmap that appears to the upper
|               left of the warn object.  Candidates for the value
|               of this attribute may be created with the use
|               of \fIXCreatePixmap()\fP;  see \fIThe Xlib Reference Manual\fP
|               by O'Reilly and Associates.  Note that this attribute is
|               mutually exclusive with
|               .symbol index XVW_WARN_PIXMAPFILE ;
|               specify one or the other, not both.
|
| Type:         Pixmap
| Default:      The "caution" pixmap.
| Legal Values: Valid Pixmap structure
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_WARN_PIXMAP		"warnPixmap"


/*
 *  Define the Class name, by which people should be externally referencing
 *  the Warn Object by.
 */
#define WarnWidgetClass	xvwWarnWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration WarnWidgetClass
 */
extern   WidgetClass     WarnWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Warn Object
 */
xvobject xvw_create_warn PROTO((xvobject, char *));


#endif /* _xvobjects_Warn_h_ */
/* Do not add after this line */
