 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       row/col manager.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_RowCol_h_
#define _xvobjects_RowCol_h_


    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/

/*
 *  Attribute definitions for RowCol Gui Object
 */

/*------------------------------------------------------------------------
| Attribute:	XVW_ROWCOL_NUMBER_ACROSS
| Description:  This attribute specifies how many area objects will be 
|		placed on the same row before a new row is started.
| Type:         int
| Default:      -1
| Legal Values: integer value
| Resource:	rowcolNumberAcross
------------------------------------------------------------------------*/
#define XVW_ROWCOL_NUMBER_ACROSS	"rowcolNumberAcross"

/*------------------------------------------------------------------------
| Attribute:	XVW_ROWCOL_SPACING
| Description:  This attribute specifies the minimum spacing between each 
|		objects, in pixels.  The default is -1, which means it uses 
|		the Manager Object subclass attribute
|		.symbol noindex XVW_CANVAS_GRIDSIZE .
|		If the
|		.symbol noindex XVW_CANVAS_GRIDSIZE
|		is 0, then the
|		.symbol noindex XVW_XSNAP
|		and the
|		.symbol noindex XVW_YSNAP
|		is used. If a 0 or positive value is provided, then that is
|		used as the spacing.
| Type:         int
| Default:      -1
| Legal Values: integer value
| Resource:	rowcolSpacing
------------------------------------------------------------------------*/
#define XVW_ROWCOL_SPACING      	"rowcolSpacing"

/*------------------------------------------------------------------------
| Attribute:	XVW_ROWCOL_ACTIVE
| Description:  This constraint attribute can be placed on any RowCol child.
|		It is used to indicate which children should be actively
|		used in the row/column layout method.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	rowcolActive
------------------------------------------------------------------------*/
#define XVW_ROWCOL_ACTIVE	"rowcolActive"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the RowCol Object by.
 */
#define RowColWidgetClass	xvwRowColWidgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration for RowColWidgetClass
 */
extern   WidgetClass     RowColWidgetClass;


    /*-------------------------------------*
    |       routine definitions
    ---------------------------------------*/

/*
 *  Function definitions for RowCol Gui Object
 */
xvobject xvw_create_rowcol PROTO((xvobject, char *));


#endif /* _xvobjects_RowCol_h_ */
/* Don't add after this point */
