 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions of Attributes
   >>>>                used to specify tacking.
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_ManagerTack_h_
#define _xvobjects_ManagerTack_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/
/*------------------------------------------------------------------------
| Attribute:    XVW_TACK_EDGE
| Description:	Tacks the edge(s) of the object to the edge(s) of its 
|		nearest neighbor or parent.  This attribute takes a mask.  
|		These masks may be OR'ed together in order to achieve the 
|		desired tacking setup.  Values accepted include:
|		.sp
|		.symbol index KMANAGER_TACK_LEFT : 
|		!Set to NULL:     Tack the left edge of the object 
|               !                 to the left edge of its parent
|               !Set to non-NULL: Tack the left edge of the object
|               !                 to the right edge of its nearest neighbor 
|               !                 on the left.
|		.sp
|		.symbol index KMANAGER_TACK_RIGHT : 
|               !Set to NULL:     Tack the right edge of the object
|               !                 to the right edge of its parent
|               !Set to non-NULL: Tack the right edge of the object 
|		!                 to the left edge of its nearest neighbor 
|               !                 on the right.
|		.sp
|		.symbol index KMANAGER_TACK_TOP : 
|               !Set to NULL:     Tack the top edge of the object 
|               !                 to the top edge of its parent 
|               !Set to non-NULL: Tack the top edge of the object 
|		!                 to the bottom edge of the nearest neighbor 
|               !                 above it.
|		.sp
|		.symbol index KMANAGER_TACK_BOTTOM : 
|               !Set to NULL:     Tack the bottom edge of the object 
|               !                 to the bottom edge of its parent
|               !Set to non-NULL: Tack the bottom edge of the object 
|               !                 to the top edge of the nearest neighbor 
|               !                 below it.
|		.sp
|		.symbol index KMANAGER_TACK_VERT : 
|		Tack the left and right edges of the object at the same time; 
|               note that this is the same as OR'ing together
|		.symbol index KMANAGER_TACK_LEFT 
|		and 
|		.symbol index MANAGER_TACK_RIGHT ,
|		and passing the result.
|		.sp
|		.symbol index KMANAGER_TACK_HORIZ : 
|		Tack the top and bottom edges of the object at the same time; 
|               note that this is the same as OR'ing together
|               .symbol index KMANAGER_TACK_TOP 
| 		and
|		.symbol index KMANAGER_TACK_BOTTOM ,
|		and passing the result.
|               .sp
|		.symbol index KMANAGER_TACK_ALL : 
|		Tack all four edges of the object at the same time; note 
|               that this is the same as OR'ing together 
|		.symbol index KMANAGER_TACK_LEFT ,
|		.symbol index KMANAGER_TACK_RIGHT ,
|		.symbol index KMANAGER_TACK_TOP ,
|		and
|               .symbol index KMANAGER_TACK_BOTTOM ,
|		and passing the result.
|		.sp
|		.symbol index KMANAGER_TACK_NONE : 
|		Disable tacking
| Type:		int
| Default:	.symbol index KMANAGER_TACK_NONE
| Legal Values:	.symbol index KMANAGER_TACK_NONE
|		.symbol index KMANAGER_TACK_LEFT
|		.symbol index KMANAGER_TACK_RIGHT
|		.symbol index KMANAGER_TACK_TOP
|		.symbol index KMANAGER_TACK_BOTTOM
|		.symbol index KMANAGER_TACK_VERT
|		.symbol index KMANAGER_TACK_LEFT
|		.symbol index KMANAGER_TACK_HORIZ
|		.symbol index KMANAGER_TACK_TOP
|		.symbol index KMANAGER_TACK_ALL
|		.symbol index KMANAGER_TACK_LEFT
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_TACK_EDGE           "tackEdge"

#define KMANAGER_TACK_NONE      0L
#define KMANAGER_TACK_LEFT      (1L << 0)
#define KMANAGER_TACK_RIGHT     (1L << 1)
#define KMANAGER_TACK_TOP       (1L << 2)
#define KMANAGER_TACK_BOTTOM    (1L << 3)
#define KMANAGER_TACK_VERT      (KMANAGER_TACK_TOP  | KMANAGER_TACK_BOTTOM)
#define KMANAGER_TACK_HORIZ     (KMANAGER_TACK_LEFT | KMANAGER_TACK_RIGHT)
#define KMANAGER_TACK_ALL       (KMANAGER_TACK_VERT | KMANAGER_TACK_HORIZ)

#endif /* _xvobjects_ManagerRL_h_ */
/* Do not add after this line */
