 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for InputFile object
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_InputFileP_h_
#define _xvobjects_InputFileP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvobjects/InputFile.h>
#include <xvobjects/ManagerP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwInputFileWidgetClassPart
{
     XtPointer  extension;
} XvwInputFileWidgetClassPart;

typedef struct _XvwInputFileWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwInputFileWidgetClassPart	inputfile_class;
} XvwInputFileWidgetClassRec;

extern  XvwInputFileWidgetClassRec xvwInputFileWidgetClassRec;

typedef struct
{
   xvobject button;
   xvobject crlabel;
   xvobject text;
   xvobject browser;
   Boolean  display_button;
   XtCallbackList inputfile_callback;

} XvwInputFilePart;


typedef struct _XvwInputFileWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwInputFilePart	inputfile;

} XvwInputFileWidgetRec;

typedef struct {int empty;} XvwInputFileConstraintsPart;

typedef struct _XvwInputFileWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwInputFileConstraintsPart	inputfile;
} XvwInputFileWidgetConstraintsRec, *XvwInputFileWidgetConstraints;

typedef struct  _XvwInputFileWidgetClassRec  *XvwInputFileWidgetClass;
typedef struct  _XvwInputFileWidgetRec       *XvwInputFileWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwInputFileWidget
 */
extern XvwInputFileWidgetClassRec xvwInputFileWidgetClassRec;


#endif /* _xvobjects_InputFileP_h_ */
/* Do not add after this line */
