 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  Help Widget
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Help_h_
#define _xvobjects_Help_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_NAME_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the label 
|		component of the help object that displays the filename.
|
| Type:		xvobject
| Default:      NULL
| Legal Values: The label object that displays the filename (read-only)
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_HELP_NAME_OBJECT	     "helpNameObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_TITLE_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the label 
|		component of the help object that displays the title.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The label object that displays the title (read-only)
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_HELP_TITLE_OBJECT	     "helpTitleObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_QUIT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the button 
|		object component of the help object that lets the user quit.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The button object that lets the user quit (read-only)
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_HELP_QUIT_OBJECT	     "helpQuitObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_MENU_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|		menubutton component of the help object that provides access 
|		to other help files in the directory.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The menubutton object (read-only)
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_HELP_MENU_OBJECT	     "helpMenuObject"


/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_TEXTDISPLAY_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|		textdisplay object component of the help object that 
|		does the actual display of online help text.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The textdisplay object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_HELP_TEXTDISPLAY_OBJECT  "helpTextdisplayObject"


/*------------------------------------------------------------------------
| Attribute:    XVW_HELP_NAME
|
| Description:  This is the text that appears on the label object component
|		that displays the filename.
|
| Type:         char * 
| Default:      "No File Currently Being Displayed" 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_HELP_NAME		 "helpNameObject.label"

/*------------------------------------------------------------------------
| Attribute:    XVW_HELP_TITLE
|
| Description:  This is the text that appears on the label object that
|		displays the title of the help object.
|
| Type:         char * 
| Default:      "Online Help" 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_HELP_TITLE		 "helpTitleObject.label"

/*------------------------------------------------------------------------
| Attribute:    XVW_HELP_QUITLABEL
|
| Description:  This is the text that appears on the quit button of the
|		help object
|
| Type:         char * 
| Default:      "Quit" 
| Legal Values: Any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_HELP_QUITLABEL	 "helpQuitObject.label"

/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_FILENAME
| Description:  The name of the help file to display.  Specify the full path 
|		to the help file, using $\fITOOLBOX\fP where \fITOOLBOX\fP 
|		is the name of the toolbox containing the program.
| Type:         char *
| Default:      NULL
| Legal Values: valid help file
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_HELP_FILENAME	 "helpFilename"

/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_DISPLAYTITLE
| Description:  If FALSE, this attribute will suppress creation of the title.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	helpDisplaytitle
------------------------------------------------------------------------*/
#define XVW_HELP_DISPLAYTITLE	 "helpDisplaytitle"

/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_DISPLAYQUIT
| Description:  If FALSE, this attribute will suppress creation of the 
|		quit button.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	helpDisplayquit
------------------------------------------------------------------------*/
#define XVW_HELP_DISPLAYQUIT	 "helpDisplayquit"

/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_DISPLAYMENU
| Description:  If FALSE, this attribute will suppress creation of the 
|		options menu button.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	helpDisplaymenu
------------------------------------------------------------------------*/
#define XVW_HELP_DISPLAYMENU	 "helpDisplaymenu"

/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_DESTROY_ON_QUIT
| Description:  If FALSE, the help object will not be destroyed when the 
|		user clicks on the "Quit" button, but will simply be unmapped.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	helpDestroyOnQuit
------------------------------------------------------------------------*/
#define XVW_HELP_DESTROY_ON_QUIT "helpDestroyOnQuit"

/*------------------------------------------------------------------------
| Attribute:	XVW_HELP_MORE_FILES
| Description:  If FALSE, the help object will not stat the directory in order
|		build the list of files included in the "Other Files" submenu.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	helpMoreFiles
------------------------------------------------------------------------*/
#define XVW_HELP_MORE_FILES "helpMoreFiles"


/*------------------------------------------------------------------------
| Attribute:    XVW_HELP_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the help object that will be fired when the 
|		user clicks on the "Quit" button.  When calling 
|		\fIxvw_add_callback()\fP, pass this attribute directly, as in
|               .begin code
|               xvw_add_callback(helpobj, XVW_HELP_CALLBACK,
|                                help_cb, client_data);
|               .end code
|		Note that this attribute does not apply if
|               .symbol noindex XVW_HELP_DISPLAYQUIT
|               is set to FALSE.
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_HELP_CALLBACK            "helpCallback"

/*
 *  This attribute is not publically available as of yet.
 */
#define XVW_HELP_HYPERTEXT	     "helpHypertext"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Help Object by.
 */
#define HelpWidgetClass	xvwHelpWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration HelpWidgetClass
 */
extern   WidgetClass     HelpWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Help Object
 */
xvobject xvw_create_help PROTO((xvobject, char *));


#endif /* _xvobjects_Help_h_ */
/* Do not add after this line */
