 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Browser object
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_BrowserP_h_
#define _xvobjects_BrowserP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvobjects/Browser.h>
#include <xvobjects/ManagerP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwBrowserWidgetClassPart
{
     XtPointer  extension;
} XvwBrowserWidgetClassPart;

typedef struct _XvwBrowserWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwBrowserWidgetClassPart	browser_class;
} XvwBrowserWidgetClassRec;

extern  XvwBrowserWidgetClassRec xvwBrowserWidgetClassRec;

typedef struct
{
   xvobject help;
   xvobject cancel;
   xvobject label;
   xvobject filter;
   xvobject list;
   xvobject filename;
   String   directory;
   String   old_directory;
   String   filter_string;
   Boolean  destroy_on_quit;
   Boolean  aliases;

   xvobject pixmap;
   XtCallbackList browser_callback;
   Pixmap directory_pixmap, aliases_pixmap;

} XvwBrowserPart;


typedef struct _XvwBrowserWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwBrowserPart	browser;

} XvwBrowserWidgetRec;

typedef struct {int empty;} XvwBrowserConstraintsPart;

typedef struct _XvwBrowserWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwBrowserConstraintsPart	browser;
} XvwBrowserWidgetConstraintsRec, *XvwBrowserWidgetConstraints;

typedef struct  _XvwBrowserWidgetClassRec  *XvwBrowserWidgetClass;
typedef struct  _XvwBrowserWidgetRec       *XvwBrowserWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwBrowserWidget
 */
extern XvwBrowserWidgetClassRec xvwBrowserWidgetClassRec;


#endif /* _xvobjects_BrowserP_h_ */
/* Do not add after this line */
