 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical string annotation.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 14:42
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_String_h_
#define _xvisual_String_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for String Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_STRING_XPLACEMENT
| Description:  .include $DESIGN/manual/shared/xvisual/string/XPlacement.sec
| Type:         double
| Default:      0.0
| Legal Values: any double value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_STRING_XPLACEMENT	   "stringXplacement"

/*------------------------------------------------------------------------
| Attribute:    XVW_STRING_YPLACEMENT
| Description:  .include $DESIGN/manual/shared/xvisual/string/YPlacement.sec
| Type:         double
| Default:      0.0
| Legal Values: any double value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_STRING_YPLACEMENT	   "stringYplacement"

/*------------------------------------------------------------------------
| Attribute:    XVW_STRING_JUSTIFICATION
| Description:  .include $DESIGN/manual/shared/xvisual/string/Justification.sec
| Type:         int
| Default:      .symbol index KSTRING_JUSTIFY_LEFT
| Legal Values: .symbol index KSTRING_JUSTIFY_CENTER
|               .symbol index KSTRING_JUSTIFY_TOP
|               .symbol index KSTRING_JUSTIFY_BOTTOM
|               .symbol index KSTRING_JUSTIFY_LEFT
|               .symbol index KSTRING_JUSTIFY_RIGHT
|               .symbol index KSTRING_JUSTIFY_TOPRIGHT
|               .symbol index KSTRING_JUSTIFY_TOPLEFT
|               .symbol index KSTRING_JUSTIFY_BOTTOMRIGHT
|               .symbol index KSTRING_JUSTIFY_BOTTOMLEFT
| Resource:     stringJustification
-----------------------------------------------------------------------*/
#define XVW_STRING_JUSTIFICATION   "stringJustification"

/*------------------------------------------------------------------------
| Attribute:    XVW_STRING_STRING
| Description:  This is the string to display in the string object.
| Type:         char *
| Default:      NULL
| Legal Values: any printable string
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_STRING_STRING	   "stringString"

/*------------------------------------------------------------------------
| Attribute:    XVW_STRING_EMPHASIZE
| Description:  .include $DESIGN/manual/shared/xvisual/string/Emphasize.sec
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     stringEmphasize
------------------------------------------------------------------------*/
#define XVW_STRING_EMPHASIZE	   "stringEmphasize"


/*
 * Value definitions for String Visual Object
 */

/* text string justification */
#define KSTRING_JUSTIFY_CENTER        1
#define KSTRING_JUSTIFY_TOP           2  
#define KSTRING_JUSTIFY_BOTTOM        3  
#define KSTRING_JUSTIFY_LEFT          4
#define KSTRING_JUSTIFY_RIGHT         5  
#define KSTRING_JUSTIFY_TOPRIGHT      6 
#define KSTRING_JUSTIFY_TOPLEFT       7  
#define KSTRING_JUSTIFY_BOTTOMRIGHT   8  
#define KSTRING_JUSTIFY_BOTTOMLEFT    9  

/*
 *  Define the Class name, by which people should be externally referencing
 *  the String Object by.
 */
#define StringGadgetClass	xvwStringGadgetClass

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

/*
 *  XToolkit Widget Declaration for StringGadgetClass
 */
extern   WidgetClass     StringGadgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for String Visual Object
 */
xvobject xvw_create_string PROTO((xvobject, char *));


#endif /* _xvisual_String_h_ */
/* Don't add after this point */
