 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       PrintMapVal widget.
   >>>>
   >>>>    Written By: Mark Young & Danielle Argiro
   >>>>
   >>>>          Date: Jun 26, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_PrintMapVal_h_
#define _xvisual_PrintMapVal_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for PrintMapVal Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTMAPVAL_WIDTH
| Description:  .include $DESIGN/manual/shared/xvisual/printmapval/Width.sec
| Type:         int
| Default:      8
| Legal Values: 1 <= width <= image width
| Resource:     printmapvalWidth
------------------------------------------------------------------------*/
#define XVW_PRINTMAPVAL_WIDTH		"printmapvalWidth"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTMAPVAL_HEIGHT
| Description:  .include $DESIGN/manual/shared/xvisual/printmapval/Height.sec
| Type:         int
| Default:      8
| Legal Values: 1 <= height <= image height
| Resource:     printmapvalHeight
------------------------------------------------------------------------*/
#define XVW_PRINTMAPVAL_HEIGHT		"printmapvalHeight"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTMAPVAL_XPOSITION
| Description:  This is the X position in the image corresponding to the
|		map value that appears in the upper left hand corner of the
|		printmapval grid.
| Type:         int 
| Default:      0 
| Legal Values: 0 - image width 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PRINTMAPVAL_XPOSITION	"printmapvalXposition"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTMAPVAL_YPOSITION
| Description:  This is the Y position in the image corresponding to the 
|               map value that appears in the upper left hand corner of the
|               printmapval grid.
| Type:         int
| Default:      0 
| Legal Values: 0 - image height 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PRINTMAPVAL_YPOSITION	"printmapvalYposition"

/*
 * this attribute will allow the user to edit the map value directly.
 * it is not supported as of yet.
 */
#define XVW_PRINTMAPVAL_EDITABLE	"printmapvalEditable" 

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTMAPVAL_OBJECT
|
| Description:  .include $DESIGN/manual/shared/xvisual/printmapval/Object.sec
|               Note that this attribute is mutually exclusive with
|               .symbol index XVW_PRINTMAPVAL_FILENAME ;
|               use one or the other, not both.
|
| Type:         kobject
| Default:      NULL
| Legal Values: valid data object
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PRINTMAPVAL_OBJECT		"printmapvalObject"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTMAPVAL_FILENAME
|
| Description:  .include $DESIGN/manual/shared/xvisual/printmapval/Filename.sec
|                Note that this attribute is mutually exclusive with
|               .symbol index XVW_PRINTMAPVAL_OBJECT ;
|               use one or the other, not both.
|
| Type:         char *
| Default:      NULL
| Legal Values: valid input filename
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PRINTMAPVAL_FILENAME	"printmapvalFilename"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTMAPVAL_SHOWCOLOR
| Description:  .include $DESIGN/manual/shared/xvisual/printmapval/ShowColor.sec
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     printmapvalShowcolor
------------------------------------------------------------------------*/
#define XVW_PRINTMAPVAL_SHOWCOLOR	"printmapvalShowcolor"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTMAPVAL_UPDATEMODE
| Description:  .include $DESIGN/manual/shared/xvisual/printmapval/UpdateMode.sec
| Type:         int
| Default:      .symbol index KPRINTMAPVAL_UM_CONTINUOUS
| Legal Values: .symbol index KPRINTMAPVAL_UM_CONTINUOUS
|               .symbol index KPRINTMAPVAL_UM_BUTTONPRESS
| Resource:     printmapvalUpdatemode
------------------------------------------------------------------------*/
#define XVW_PRINTMAPVAL_UPDATEMODE	"printmapvalUpdatemode"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTMAPVAL_POLICY
| Description:  .include $DESIGN/manual/shared/xvisual/printmapval/Policy.sec
| Type:         int
| Default:      .symbol index KPRINTMAPVAL_DISPLAYEDVALUES
| Legal Values: .symbol index KPRINTMAPVAL_DISPLAYEDVALUES
|               .symbol index KPRINTMAPVAL_MAPDATAVALUES
| Resource:     printmapvalPolicy
------------------------------------------------------------------------*/
#define XVW_PRINTMAPVAL_POLICY	"printmapvalPolicy"

/*
 *  Value definitions for XVW_PRINTMAPVAL_UPDATEMODE
 */
#define KPRINTMAPVAL_UM_CONTINUOUS      0
#define KPRINTMAPVAL_UM_BUTTON_PRESS    1

/*
 *  Value definitions for XVW_PRINTMAPVAL_POLICY
 */
#define KPRINTMAPVAL_DISPLAYEDVALUES  1
#define KPRINTMAPVAL_MAPDATAVALUES    2

/*
 *  Define the Class name, by which people should be externally referencing
 *  the PrintMapVal Object by.
 */
#define PrintMapValWidgetClass	xvwPrintMapValWidgetClass

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

/*
 *  XToolkit Widget Declaration for PrintMapValWidgetClass
 */
extern   WidgetClass     PrintMapValWidgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for PrintMapVal Visual Object
 */
xvobject xvw_create_printmapval  PROTO((xvobject, char *));


#endif /* _xvisual_PrintMapVal_h_ */
/* Don't add after this point */
