 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical polyline annotation.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 11, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Polyline_h_
#define _xvisual_Polyline_h_

    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/

/*
 *  Attribute definitions for Polyline Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_POLYLINE_POINTS
|
| Description:  This is the array of coordinates defining the vertices
|               of the polyline. It is an array of type Coord, where the Coord
|               type is defined as:
|               .begin code
|               typedef  struct
|               {
|                  Real  x, y, z;
|                  Index d;
|               }  Coord;
|               .end code
|               Note that the
|               .symbol index XVW_POLYLINE_NUMPTS
|               attribute \fImust\fP be set to the number of points in the
|               Coord array \fIprior\fP to setting the
|               .symbol index XVW_POLYLINE_POINTS
|               attribute.
|               .paragraph
|               The \fIz\fP and \fId\fP values are both ignored.
|
| Type:         Coord *
| Default:      NULL
| Legal Values: array of Coords of size given by
|               .symbol index XVW_POLYLINE_NUMPTS
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_POLYLINE_POINTS	"polylinePoints"

/*------------------------------------------------------------------------
| Attribute:    XVW_POLYLINE_NUMPTS
|
| Description:  This is the number of data points contained in the Coord
|               array specified by the attribute
|               .symbol noindex XVW_POLYLINE_POINTS .
|               Note that you \fImust\fP use this attribute to specify the
|               number of vertices prior to specifying the vertices with
|               .symbol noindex XVW_POLYLINE_POINTS .
|
| Type:         int 
| Default:      0
| Legal Values: values > 0
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_POLYLINE_NUMPTS	"polylineNumpts"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Polyline Object by.
 */
#define PolylineGadgetClass	xvwPolylineGadgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration for PolylineGadgetClass
 */
extern   WidgetClass     PolylineGadgetClass;


    /*-------------------------------------*
    |       routine definitions
    ---------------------------------------*/

/*
 *  Function definitions for Polyline Visual Object
 */
xvobject xvw_create_polyline PROTO((xvobject, char *));


#endif /* _xvisual_Polyline_h_ */
/* Don't add after this point */
