 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical plot3d object.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 14:27
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Plot3D_h_
#define _xvisual_Plot3D_h_

    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/

/*
 *  Attribute definitions for Plot 3D Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_PLOTOBJ
|
| Description:  The data object containing the 3D plot data to be displayed.
|               Note that this attribute is mutually exclusive with
|               .symbol index XVW_PLOT3D_PLOTFILE ;
|               use one or the other, not both.
|
| Type:         kobject
| Default:      NULL
| Legal Values: any valid data object
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT3D_PLOTOBJ              "plot3DPlotobj"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_PLOTFILE
|
| Description:  The file containing the 3D plot data to be displayed.
|               Note that this attribute is mutually exclusive with
|               .symbol index XVW_PLOT3D_PLOTOBJ ;
|               use one or the other, not both.
|
| Type:         char *
| Default:      NULL
| Legal Values: any valid input file
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT3D_PLOTFILE             "plot3DPlotfile"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_DATA_MAX_X
|
| Description:  This \fIread-only\fP attribute returns the maximum of the
|               X coordinates in the 3D plot data currently in the Coord array
|               specified with
|               .symbol index XVW_PLOT3D_POINTS .
|
| Type:         double
| Default:      1.0
| Legal Values: The maximum X world coordinate value (read only)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT3D_DATA_MAX_X           "plot3DDataMaxX"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_DATA_MAX_Y
|
| Description:  This \fIread-only\fP attribute returns the maximum of the
|               Y coordinates in the 3D plot data currently in the Coord array
|               specified with
|               .symbol index XVW_PLOT3D_POINTS .
|
| Type:         double
| Default:      1.0
| Legal Values: The maximum Y world coordinate value (read only)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT3D_DATA_MAX_Y           "plot3DDataMaxY"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_DATA_MAX_Z
|
| Description:  This \fIread-only\fP attribute returns the maximum of the
|               Z coordinates in the 3D plot data currently in the Coord array
|               specified with
|               .symbol index XVW_PLOT3D_POINTS .
|
| Type:         double
| Default:      1.0
| Legal Values: The maximum Z world coordinate value (read only)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT3D_DATA_MAX_Z           "plot3DDataMaxZ"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_DATA_MIN_X
|
| Description:  This \fIread-only\fP attribute returns the minimum of the
|               X coordinates in the 3D plot data currently in the Coord array
|               specified with
|               .symbol index XVW_PLOT3D_POINTS .
|
| Type:         double
| Default:      1.0
| Legal Values: The minimum X world coordinate value (read only)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT3D_DATA_MIN_X           "plot3DDataMinX"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_DATA_MIN_Y
|
| Description:  This \fIread-only\fP attribute returns the minimum of the
|               Y coordinates in the 3D plot data currently in the Coord array
|               specified with
|               .symbol index XVW_PLOT3D_POINTS .
|
| Type:         double
| Default:      1.0
| Legal Values: The minimum Y world coordinate value (read only)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT3D_DATA_MIN_Y           "plot3DDataMinY"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_DATA_MIN_Z
|
| Description:  This \fIread-only\fP attribute returns the minimum of the
|               Z coordinates in the 3D plot data currently in the Coord array
|               specified with
|               .symbol index XVW_PLOT3D_POINTS .
|
| Type:         double
| Default:      1.0
| Legal Values: The minimum Z world coordinate value (read only)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT3D_DATA_MIN_Z           "plot3DDataMinZ"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_PLOTTYPE
| Description:  This attribute indicates how the plot is to be displayed. 
|               Choices include:
|		.symbol index KPLOT3D_LINEPLOT
|		.symbol index KPLOT3D_MESH
|		.symbol index KPLOT3D_SCATTER
|		.symbol index KPLOT3D_CONTOUR_3D
|		.symbol index KPLOT3D_CONTOUR_2D
|		.symbol index KPLOT3D_IMPULSE
|		.symbol index KPLOT3D_PHONG_SHADING
|		.symbol index KPLOT3D_GHOURAUD_SHADING
|		.symbol index KPLOT3D_CONSTANT_SHADING
|		.symbol index KPLOT3D_HORIZON
|		.symbol index KPLOT3D_COLORMESH
|		.symbol index KPLOT3D_WIREFRAME
| Type:         int
| Default:      .symbol index KPLOT3D_LINEPLOT
| Legal Values: .symbol index KPLOT3D_LINEPLOT
|               .symbol index KPLOT3D_MESH
|               .symbol index KPLOT3D_SCATTER
|               .symbol index KPLOT3D_CONTOUR_3D
|               .symbol index KPLOT3D_CONTOUR_2D
|               .symbol index KPLOT3D_IMPULSE
|               .symbol index KPLOT3D_PHONG_SHADING
|               .symbol index KPLOT3D_GHOURAUD_SHADING
|               .symbol index KPLOT3D_CONSTANT_SHADING
|               .symbol index KPLOT3D_HORIZON
|               .symbol index KPLOT3D_COLORMESH
|               .symbol index KPLOT3D_WIREFRAME
| Resource:     plot3DPlotType
------------------------------------------------------------------------*/
#define XVW_PLOT3D_PLOTTYPE             "plot3DPlotType"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_SHADETYPE
|
| Description:  For 3D plots that are shaded, ie, when the 
|		.symbol index XVW_PLOT3D_PLOTTYPE
|		is set to one of:
|		.symbol index KPLOT3D_PHONG_SHADING 
|               .symbol index KPLOT3D_GHOURAUD_SHADING
|		or
|               .symbol index KPLOT3D_CONSTANT_SHADING ,
|		this attribute specifies what part of the data 
|		is to dictate the shading.  
|		.br
|               .symbol index KPLOT3D_SHADE_ELEVATION
|		specifies that shading is to be done on elevation,
|		ie, using the \fIz\fP value of each data point as defined
|		by its Coord structure.
|               .br
|               .symbol index KPLOT3D_SHADE_IMAGERY
|		specifies taht shading is to be done on imagery (or color)
|		ie, using the \fId\fP value of each data point as defined
|		by its Coord structure.
|		.br
|		When
|               .symbol index KPLOT3D_SHADE_NORMAL 
|		is used, the normal to each data point is computed, and
|		shading is done using the normals.
|
| Type:         int
| Default:      .symbol index KPLOT3D_SHADE_ELEVATION
| Legal Values: .symbol index KPLOT3D_SHADE_IMAGERY
|               .symbol index KPLOT3D_SHADE_ELEVATION
|               .symbol index KPLOT3D_SHADE_NORMAL
| Resource:     plot3DShadeType
------------------------------------------------------------------------*/
#define XVW_PLOT3D_SHADETYPE            "plot3DShadeType"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_PLOTSIZE
|
| Description:  This is the number of data points contained in the Coord
|               array specified by the attribute
|               .symbol noindex XVW_PLOT3D_POINTS .
|               Note that you \fImust\fP use this attribute to specify the
|               number of points prior to specifying the data points with
|               .symbol noindex XVW_PLOT3D_POINTS .
|
| Type:         int
| Default:      0
| Legal Values: values > 0
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT3D_PLOTSIZE             "plot3DPlotsize"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_PLOTWIDTH
|
| Description:  This attribute dictates the number of data points in 
|               each \fIrow\fP to be plotted.  Thus, if there are 100
|               data points specified by
|               .symbol index XVW_PLOT3D_PLOTSIZE
|		and 
|               .symbol index XVW_PLOT3D_PLOTWIDTH
|               is set to 2, this implies that the 3D plot has 50 continuous
|               lines, each with 2 data points.  Alternatively, if 
|               .symbol index XVW_PLOT3D_PLOTWIDTH
|               was set to 25, this would imply that the same 100 data triplets
|               were to be plotted as 4 continuous lines, each with 25 data
|               points.
|
| Type:         int
| Default:      N/A
| Legal Values: 0 < value <= 
|               .symbol index XVW_PLOT3D_PLOTSIZE
| Resource:     N/A
-----------------------------------------------------------------------*/
#define XVW_PLOT3D_PLOTWIDTH            "plot3DPlotwidth"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT3D_POINTS
|
| Description:  This is the array of coordinates defining the 3D data points
|               in the plot. It is an array of type Coord, where the Coord
|               type is defined as:
|		.begin code
|               typedef  struct
|               {
|                  Real  x, y, z;
|                  Index d;
|               }  Coord;
|               .end code
|               Note that the
|               .symbol index XVW_PLOT3D_PLOTSIZE
|               attribute \fImust\fP be set to the number of points in the
|               Coord array \fIprior\fP to setting the
|               .symbol index XVW_PLOT3D_POINTS
|               attribute.
|               .br
|               The \fId\fP value is used only in the plot types
|		.nf
|               .symbol index KPLOT3D_COLORMESH
|               .symbol index KPLOT3D_CONTOUR_2D
|               .symbol index KPLOT3D_CONTOUR_3D
|               .symbol index KPLOT3D_CONSTANT_SHADING
|               .symbol index KPLOT3D_PHONG_SHADING
|               .symbol index KPLOT3D_GHOURAUD_SHADING
|		.fi
|               It should be set to a valid color index (on a 8-bit display
|               the range is 0-255 all values outside that range are defaulted
|               to the default foreground color).
|
| Type:         Coord *
| Default:      NULL
| Legal Values: array of Coords defining data points for 3D plot
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT3D_POINTS               "plot3DPoints"


/*
 *  Value definitions for Plot 3D Visual Object
 */

/* 3D Plot Types */

#define KPLOT3D_UNDEFINED          0
#define KPLOT3D_LINEPLOT           20
#define KPLOT3D_WIREFRAME          21
#define KPLOT3D_MESH               22
#define KPLOT3D_COLORMESH          23
#define KPLOT3D_HORIZON            24
#define KPLOT3D_SCATTER            25
#define KPLOT3D_IMPULSE            26
#define KPLOT3D_CONTOUR_2D         27
#define KPLOT3D_CONTOUR_3D         28
#define KPLOT3D_CONSTANT_SHADING   29
#define KPLOT3D_PHONG_SHADING      30
#define KPLOT3D_GHOURAUD_SHADING   31
#define KPLOT3D_3D_BEZIER          32
#define KPLOT3D_SURFACE_BEZIER     33
#define KPLOT3D_RENDERED_BEZIER    34

/* 3D Shading Types */

#define KPLOT3D_SHADE_IMAGERY       1
#define KPLOT3D_SHADE_ELEVATION     2
#define KPLOT3D_SHADE_NORMAL        3

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Plot3D Object by.
 */
#define Plot3DGadgetClass	xvwPlot3DGadgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration for Plot3DGadgetClass
 */
extern   WidgetClass     Plot3DGadgetClass;


    /*-------------------------------------*
    |       routine definitions
    ---------------------------------------*/

/*
 *  Function definitions for Plot 3D Visual Object
 */
xvobject xvw_create_plot3d  PROTO((xvobject, char *));


#endif /* _xvisual_Plot3D_h_ */
/* Don't add after this point */
