 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private declarations for the graphical
   >>>>		       widget and object class.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 14:08
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_GraphicsP_h_
#define _xvisual_GraphicsP_h_


    /*-------------------------------------*
    |       #include 
    ---------------------------------------*/

#include <xvobjects/ManagerP.h>
#include <xvobjects/ManagerObjP.h>
#include <xvisual/Graphics.h>


    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/
#define	VIEWMIN_X	0.0
#define	VIEWMIN_Y	0.0
#define	VIEWMIN_Z	0.0
#define	VIEWMAX_X	1.0
#define	VIEWMAX_Y	1.0
#define	VIEWMAX_Z	1.0

#define XtInheritRecomputePosition	((void (*)())_XtInherit)


    /*-------------------------------------*
    |       typedefs
    ---------------------------------------*/

typedef struct
{
    int	      id;
    int	      projection;
    double    alpha, theta, gamma, view_distance, eye_distance, hfactor;
    Boolean   clipping, depth_clipping;
    Boolean   reset_world, reset_viewport;
    Coord     viewmin, viewmax, wcmin, wcmax, focus, camera, up;
    int	      proportional , axis_mode_x, axis_mode_y, axis_mode_z;
    Boolean   symmetric_x, symmetric_y, symmetric_z;

    Boolean   use_existing_max_min;
    Coord     old_wcmin, old_wcmax;
    Coord     default_range_viewport, center_viewport;
    Coord     default_range_wc, center_wc;

    int	      line_type;
    int	      marker_type;
    int	      line_width;
    int	      graphics_type;
    Boolean   filled;
    GC	      gc;
    XColor    fg, bg;
    Position  old_x, old_y;
    Dimension old_width, old_height;
} XvwGraphicsPart;



/*
 *  Declaration for the Graphics Gadget
 */
typedef struct _XvwGraphicsGadgetClassPart
{
    kfunc_void recompute_position;
} XvwGraphicsGadgetClassPart;


typedef struct _XvwGraphicsGadgetClassRec
{
    RectObjClassPart		rect_class;
    XvwManagerGadgetClassPart	manager_class;
    XvwGraphicsGadgetClassPart	graphics_class;
} XvwGraphicsGadgetClassRec;


typedef struct _XvwGraphicsGadgetRec
{
    ObjectPart		object;
    RectObjPart		rectobj;
    XvwManagerObjPart	manager;
    XvwGraphicsPart		graphics;
} XvwGraphicsGadgetRec;


typedef struct  _XvwGraphicsGadgetClassRec  *XvwGraphicsGadgetClass;
typedef struct  _XvwGraphicsGadgetRec        *XvwGraphicsGadget;


/*
 *  Declaration for the Graphics Widget
 */
typedef struct _XvwGraphicsWidgetClassPart
{
    XtPointer  extension;
} XvwGraphicsWidgetClassPart;


typedef struct _XvwGraphicsWidgetClassRec
{
    CoreClassPart			core_class;
    CompositeClassPart		composite_class;
    ConstraintClassPart		constraint_class;
    XvwManagerWidgetClassPart	manager_class;
    XvwGraphicsWidgetClassPart	graphics_class;
} XvwGraphicsWidgetClassRec;


typedef struct _XvwGraphicsWidgetRec
{
    CorePart		core;
    CompositePart		composite;
    ConstraintPart		constraint;
    XvwManagerPart		manager;
    XvwGraphicsPart		graphics;
} XvwGraphicsWidgetRec;


typedef struct  _XvwGraphicsWidgetClassRec  *XvwGraphicsWidgetClass;
typedef struct  _XvwGraphicsWidgetRec        *XvwGraphicsWidget;


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwGraphicsGadget
 */
extern  XvwGraphicsGadgetClassRec xvwGraphicsGadgetClassRec;

/*
 *  XToolkit Widget Declaration XvwGraphicsWidget
 */
extern  XvwGraphicsWidgetClassRec xvwGraphicsWidgetClassRec;

        /*-------------------------------------*
        |       macros
        ---------------------------------------*/

#define GraphicsCheckCoord(c1, c2) (c1.x==c2.x && c1.y==c2.y && c1.z==c2.z)


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

XvwGraphicsPart *GetGraphicsPart        PROTO((Widget widget));


#endif /* _xvisual_GraphicsP_h_ */
/* Don't add after this point */
