 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines for general axis class attributes 
   >>>>
   >>>>    Written By: John Salas, Danielle Argiro, Mark Young
   >>>>
   >>>>          Date: Aug 20, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_AxisGeneral_h_
#define _xvisual_AxisGeneral_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_AXIS_MODE
|
| Description:  This attribute specifies the scale with which axes will
|		be drawn.  The scale may be linear or log; natural log
|		is planned for the future but is not implemented as of yet. 
|
| Type:         int
| Default:      .symbol index KAXIS_LINEAR
| Legal Values: .symbol index KAXIS_LINEAR
|               .symbol index KAXIS_LOG
| Resource:     axisAxisMode
------------------------------------------------------------------------*/
#define XVW_AXIS_AXIS_MODE		 "axisAxisMode"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_BEGIN_AXIS
|
| Description:  This parameter specifies where the axis begins. It is specified
|               as a Coord structure representing a 3D point (x,y,z), where 
|               values of x, y, and z must be between 0 and 1.  
|		.br
|               Default begin pt for 2D/3D axis object (X axis): (0,0,0).
|               .br
|               Default begin pt for 2D/3D axis object (Y axis): (0,0,0).
|               .br
|               Default begin pt for 3D axis object (Z axis): (0,0,0).
|		.br
|		For example, suppose we wish to prevent a 2D X axis from 
|               displaying tic marks, grid, and numerical labels above 10% 
|               of the axis range. First, the X axis is obtained from the 2D
|		X axis object using
|		.symbol index XVW_AXIS2D_AXIS_X .
|		Then, the 
|		.symbol index XVW_AXIS_BEGIN_AXIS
|		attribute is used to specify the begin point of the X axis 
|               as (0.1, 0.0, 0.0). 
|
| Type:         Coord   
| Default:      (0.0,0.0,0.0)
| Legal Values: a Coord structure with values 0.0 - 1.0 specified for the
|               (x, y, z); 2D axes will always have the z value set to 0.0. 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_BEGIN_AXIS		 "axisBeginAxis"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_END_AXIS
|
| Description:  This parameter specifies where the axis ends. It is specified
|               as a Coord structure representing a 3D point (x,y,z), where 
|               values of x, y, and z must be between 0 and 1.  
|               .br
|               Default end pt for 2D/3D axis object (X axis): (1,0,0).
|               .br
|               Default end pt for 2D/3D axis object (Y axis): (0,1,0).
|               .br
|               Default end pt for 3D axis object (Z axis): (0,0,1).
|               .br
|               For example, suppose we wish to prevent a 2D X axis from 
|               displaying tic marks, grid, and numerical labels past 90% 
|               of the axis range. First, the X axis is obtained from the 2D
|               X axis object using
|               .symbol index XVW_AXIS2D_AXIS_X .
|               Then, the 
|               .symbol index XVW_AXIS_BEGIN_AXIS
|               attribute is used to specify the end point of the X axis 
|               as (0.9, 0.0, 0.0). 
|
| Type:         Coord
| Default:      (1.0,1.0,1.0)
| Legal Values: a Coord structure with values 0.0 - 1.0 specified for the
|               (x, y, z); 2D axes will always have the z value set to 0.0. 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_END_AXIS		 "axisEndAxis"

/*
 * XVW_AXIS_DIRECTION is not documented because we don't want it used directly.
 */
#define XVW_AXIS_DIRECTION		 "axisDirection"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_LABEL
|
| Description:  The text with which to label the axis.
|
| Type:         char *
| Default:      "Axis"
| Legal Values: printable text
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_LABEL			 "axisLabel"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_NUMBER_MINOR_TICS
|
| Description:  The number of minor tics to be desired. 
|
| Type:         int
| Default:      0
| Legal Values: value >= 0
| Resource:     axisNumberMinorTics
------------------------------------------------------------------------*/
#define XVW_AXIS_NUMBER_MINOR_TICS	 "axisNumberMinorTics"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_TIC_JUSTIFICATION
|
| Description:  Whether the major and minor axis tic marks appear 
|               to the outside of the axis line, to the inside of 
|               the axis line, or centered with the axis line running 
|               through the middle.
|
| Type:         int
| Default:      .symbol index KAXIS_INSIDE
| Legal Values: .symbol index KAXIS_INSIDE
|               .symbol index KAXIS_CENTERED
|               .symbol index KAXIS_OUTSIDE
| Resource:     axisTicJustification
------------------------------------------------------------------------*/
#define XVW_AXIS_TIC_JUSTIFICATION	 "axisTicJustification"

#endif /* _xvisual_AxisGeneral_h_ */
/* Don't add after this point */
