 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>                animate image display widget (used in
   >>>>		       such programs as animate).
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Oct 05, 1992 15:00
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Animate_h_
#define _xvisual_Animate_h_


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_ANIMATE_UPDATETIME
|
| Description:  .include $DESIGN/manual/shared/xvisual/animate/UpdateTime.sec
|
| Type:         double 
|
| Default:      1.0
|
| Legal Values: value > 0.0 
|
| Resource:     animateUpdatetime
------------------------------------------------------------------------*/
#define  XVW_ANIMATE_UPDATETIME	     "animateUpdatetime"

/*------------------------------------------------------------------------
| Attribute:    XVW_ANIMATE_CONTROL
|
| Description:  .include $DESIGN/manual/shared/xvisual/animate/Control.sec 
|
| Type:         int
|
| Default:	.symbol index KANIMATE_CONTROL_LOOP
|
| Legal Values:	.symbol index KANIMATE_CONTROL_LOOP
|		.symbol index KANIMATE_CONTROL_SINGLE
|		.symbol index KANIMATE_CONTROL_AUTOREVERSE
|
| Resource:	 animateControl
------------------------------------------------------------------------*/
#define  XVW_ANIMATE_CONTROL	     "animateControl"

/*------------------------------------------------------------------------
| Attribute:    XVW_ANIMATE_DIRECTION
|
| Description:  .include $DESIGN/manual/shared/xvisual/animate/Direction.sec
|
| Type:         int
|
| Default:      .symbol index KANIMATE_DIRECTION_STOP
|
| Legal Values: .symbol index KANIMATE_DIRECTION_STOP
|		.symbol index KANIMATE_DIRECTION_PREVIOUS
|		.symbol index KANIMATE_DIRECTION_NEXT
|		.symbol index KANIMATE_DIRECTION_REVERSE
|		.symbol index KANIMATE_DIRECTION_FORWARD
|
| Resource:	animateDirection
------------------------------------------------------------------------*/
#define  XVW_ANIMATE_DIRECTION	     "animateDirection"

/*------------------------------------------------------------------------
| Attribute:    XVW_ANIMATE_CALLBACK
|
| Description:  If desired, a callback may be installed on the animate object 
|               that will be fired each time a new image in the sequence is 
|               displayed.  The frame number will be passed in as the 
|               call_data;  cast this parameter to an integer 
|		before using, as in:
|               .br
|               \f(CWint frame_number = (int) call_data;\fP
|
| Type:         kfunc_void
|
| Default:      NULL
|
| Legal Values:	.begin code
|		void callback_function
|		  xvobject object,
|		  kaddr client_data,
|		  kaddr call_data)
|		.end code
|
| Resource:	N/A
------------------------------------------------------------------------*/
#define  XVW_ANIMATE_CALLBACK	     "animateCallback"

/*
 *  Values for the controlling how the animation will playback its
 *  images.  We use this when we come to the either end of the image
 *  list.
 */
#define KANIMATE_CONTROL_LOOP         1
#define KANIMATE_CONTROL_SINGLE       2
#define KANIMATE_CONTROL_AUTOREVERSE  3

/*
 *  Values for the direction in which the animation will playback its
 *  images.  We use this when we come to the either end of the image
 *  list.
 */
#define KANIMATE_DIRECTION_STOP	     1
#define KANIMATE_DIRECTION_PREVIOUS  2
#define KANIMATE_DIRECTION_NEXT	     3
#define KANIMATE_DIRECTION_REVERSE   4
#define KANIMATE_DIRECTION_FORWARD   5

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Animate Object by.
 */
#define AnimateWidgetClass	xvwAnimateWidgetClass

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for Animate Visual Object
 */
xvobject xvw_create_animate  PROTO((xvobject, char *));


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration AnimateWidgetClass
 */
extern   WidgetClass	AnimateWidgetClass;


#endif /* _xvisual_Animate_h_ */
/* Don't add after this point */
