 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>       Purpose: contains routine declarations that are    <<<<
   >>>>                private to the xvforms library, but used  <<<<
   >>>>                by exceptions such as cantata, conductor, <<<<
   >>>>                ghostwriter, and conductor-generated code <<<<
   >>>>                                                          <<<<
   >>>>    Written By: Danielle Argiro                           <<<<
   >>>>                                                          <<<<
   >>>>          Date: Jan 12, 1993                              <<<<
   >>>>                                                          <<<<
   >>>> Modifications:                                           <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvforms_xvformsP_h_
#define _xvforms_xvformsP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

/*
 *   The xvf_callback_info structure is used to keep track of
 *   callbacks and client_data that are installed on buttons
 *   by the application with the use of xvf_add_extra_call(),
 *   and to keep track of callbacks and client_data that are
 *   installed on GUI items with the use of xvf_add_gui_callback().
 */

typedef struct _xvf_callback_info {

kfunc_void routine;		        /* routine for the extra call         */
char 	   *client_data;	        /* client data to pass to extra call  */
int	   call_location;	        /* XVF_CALL_FIRST or XVF_CALL_LAST    */
struct _kform_struct *back_kformstruct; /* back pointer to the kformstruct    */

}  xvf_callback_info;


/*
 *  The simple glyph structure is used by cantata
 */
typedef struct _xvf_simple_glyph {

xvobject   toplevel;	     /*  toplevel object                             */
xvobject   do_form;	     /*  	                                     */
char     *label_str;         /*  label for simple glyph                      */

} xvf_simple_glyph;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
        |       macros
        ---------------------------------------*/

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/
/*
 *  guise, preview, and the xvlang library break our conventions in that
 *  they call private xvforms routines.  those private routines 
 *  used by guise, preview,  and xvlang are prototyped here.
 */

/* callbacks.c */
void xvf_guide_cb   PROTO((xvobject, kaddr, kaddr));
void xvf_subform_cb PROTO((xvobject, kaddr, kaddr));
void xvf_displaylist_val_cb PROTO((xvobject, kaddr, kaddr));

/* collect.c */
int  xvf_collect_check_data PROTO((kform *));

/* createwid.c */
xvobject xvf_create_backplane         PROTO((kaddr, int, xvobject, int));
xvobject xvf_create_guide_sel         PROTO((kguide *, xvobject));
xvobject xvf_create_subform_sel       PROTO((ksubform *, xvobject));

/* createform.c */
int xvf_create_subform   PROTO((ksubform *, int, int, int));
int xvf_create_selection PROTO((kselection *, xvobject, int));
int xvf_create_pane      PROTO((kcontrol *, int));
int xvf_create_submenu   PROTO((kform_struct *, int));

/* create_util.c */
void xvf_highlight_toggle  PROTO((kselection *));

/* geometry.c */
void xvf_form_geometry    PROTO((kform *, int *, int *, int *, int *));
void xvf_subform_geometry PROTO((ksubform *, int *, int *, int *, int *));

/* manip.c */
int       xvf_delete_selection     PROTO((kselection *));
kguide   *xvf_create_new_guide     PROTO((char *, char *));
ksubform *xvf_create_new_subform   PROTO((char *, char *));

/* mapform.c */
void xvf_map_form          PROTO((kform *));
void xvf_map_subform       PROTO((ksubform *));
void xvf_map_kformstruct   PROTO((kform_struct *));
void xvf_unmap_form        PROTO((kform *));
void xvf_unmap_subform     PROTO((ksubform *));
void xvf_unmap_kformstruct PROTO((kform_struct *));

/* utilities.c */
int xvf_check_modified          PROTO((kselection *));
int xvf_clear_modified          PROTO((kselection *));
int xvf_modify_form_from_cmd    PROTO((kform *, char *));
float xvf_calculate_y_position  PROTO((kcontrol *));

#endif /* _xvforms_xvformsP_h_ */
/* Don't add after this line */
