#include <xvinclude.h>

/*
 *  This program demonstrates creation of a button, installing a 
 *  callback on the button that passes a structure as the client_data.
 *
 *  It creates a button in a background color, labelled with the color
 *  of the background.  On each button click, it changes the color of
 *  the background and the label accordingly. 
 */

typedef struct _ButtonInfo {
	
	char **colors;
	int  *count;

} ButtonInfo;

void oval_callback PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject   manager;
	xvobject   oval_button;
	int        i;
	ButtonInfo *button_info;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane */
	manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
	      XVW_WIDTH,           200,   /* 200 pixels wide */
	      XVW_HEIGHT,          100,   /* 100 pixels high */
	      NULL);


	/* 
	 * a single oval button on the manager (if widget set supports oval,
         * note that Motif doesn't), label it "yellow", make the background
         * yellow,  want a width of 10, and center it in the middle of parent
         */
	oval_button = xvw_create_button(manager, "oval button");
	xvw_set_attributes(oval_button,
	      XVW_LABEL,            "Yellow", /* label says yellow  */
	      XVW_BACKGROUND_COLOR, "yellow", /* yellow color       */
	      XVW_BUTTON_SHAPE,     KBUTTON_SHAPE_OVAL, /* oval  */
	      XVW_CHAR_WIDTH,       10.0,     /* 5 chars wide        */
	      XVW_CHAR_HEIGHT,      1.0,     /* 1 char  high        */
              XVW_LEFT_OF,          NULL,
              XVW_ABOVE,            NULL,
              XVW_RIGHT_OF,         NULL,
              XVW_BELOW,            NULL,
	      NULL);

	/* allocate structure which will be sent as client_data */
	button_info = (ButtonInfo *) calloc(1,  sizeof (ButtonInfo));

	/* allocate and initialize colors array */
        button_info->colors = (char **) calloc(1, 5 * sizeof (char *));
        button_info->colors[0] = kstring_copy("yellow", NULL); 
        button_info->colors[1] = kstring_copy("red", NULL);
        button_info->colors[2] = kstring_copy("blue", NULL);
        button_info->colors[3] = kstring_copy("green", NULL);
        button_info->colors[4] = kstring_copy("pink", NULL);

	/* allocate and initialize count array */
	button_info->count = (int *) malloc(5*sizeof(int));
	for (i = 0; i < 5; i++)
	    button_info->count[i] = 0;

	/* add the callback to button, sending button_info as client_data */
	xvw_add_callback(oval_button, XVW_BUTTON_SELECT, 
		         oval_callback, button_info);

	/*
	 * display & run program
	 */
	xvf_run_form();
}

static  int  callback_count = 1;

/*
 * here's the callback for the button
 */
void oval_callback(
    xvobject object, 
    kaddr    client_data, 
    kaddr    call_data)
{
	int          index;
	ButtonInfo   *button_info = (ButtonInfo *) client_data;

	/*
	 *  want to cycle through the colors, changing the label and the
         *  color according to the number of times the callback has fired
	 */
	index = callback_count % 5;
	xvw_set_attributes(object, 
		XVW_BACKGROUND_COLOR, button_info->colors[index],
		XVW_LABEL,            button_info->colors[index],
		NULL);

	(button_info->count[index])++;
	kfprintf(kstderr, "Displaying %s, repetition %d\n", 
	        button_info->colors[index], button_info->count[index]);  

	callback_count++;
}
